/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import ml.alternet.scan.Constraint;
import ml.alternet.scan.Scanner;

public interface StringConstraint
extends Constraint {
    public boolean stopCondition(int var1, int var2, Scanner var3) throws IOException;

    public int append(int var1, int var2, Scanner var3, StringBuilder var4) throws IOException;

    public static class ReadUntilSingleChar
    implements StringConstraint {
        char stopChar;

        public ReadUntilSingleChar(char stopChar) {
            this.stopChar = stopChar;
        }

        @Override
        public int append(int sourceIndex, int targetLength, Scanner scanner, StringBuilder buf) throws IOException {
            int c = scanner.lookAhead();
            buf.append(Character.toChars(c));
            return 1;
        }

        @Override
        public boolean stopCondition(int sourceIndex, int targetLength, Scanner scanner) throws IOException {
            return scanner.hasNextChar(this.stopChar, false);
        }
    }

    public static class ReadLength
    implements StringConstraint {
        int length;

        public ReadLength(int length) {
            this.length = length;
        }

        @Override
        public boolean stopCondition(int sourceIndex, int targetLength, Scanner scanner) throws IOException {
            return this.length-- <= 0;
        }

        @Override
        public int append(int sourceIndex, int targetLength, Scanner scanner, StringBuilder buf) throws IOException {
            int c = scanner.lookAhead();
            buf.append(Character.toChars(c));
            return 1;
        }
    }

    public static class ReadUntilChar
    implements StringConstraint {
        String stopChars;

        public ReadUntilChar(String stopChars) {
            this.stopChars = stopChars;
        }

        @Override
        public int append(int sourceIndex, int targetLength, Scanner scanner, StringBuilder buf) throws IOException {
            int c = scanner.lookAhead();
            buf.append(Character.toChars(c));
            return 1;
        }

        @Override
        public boolean stopCondition(int sourceIndex, int targetLength, Scanner scanner) throws IOException {
            return scanner.hasNextChar(this.stopChars, false);
        }
    }

    public static class ReadUntilString
    implements StringConstraint {
        String stopString;

        public ReadUntilString(String stopString) {
            this.stopString = stopString;
        }

        @Override
        public int append(int sourceIndex, int targetLength, Scanner scanner, StringBuilder buf) throws IOException {
            int c = scanner.lookAhead();
            buf.append(Character.toChars(c));
            return 1;
        }

        @Override
        public boolean stopCondition(int sourceIndex, int targetLength, Scanner scanner) throws IOException {
            return scanner.hasNextString(this.stopString, false);
        }
    }
}

