/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import ml.alternet.misc.Thrower;
import ml.alternet.scan.Scanner;

public class StringScanner
extends Scanner {
    private final String sequence;

    public StringScanner(CharSequence sequence) throws IOException {
        this.sequence = sequence.toString();
        if (this.sequence == null) {
            this.state.end = true;
            this.state.next = -1;
        } else {
            this.state.source.read();
        }
    }

    @Override
    public void read() {
        if (this.state.cursor == this.sequence.length()) {
            this.state.end = true;
            this.state.next = -1;
        } else {
            this.state.next = this.sequence.codePointAt(this.state.cursor++);
            this.state.end = false;
            if (Character.isSupplementaryCodePoint(this.state.next)) {
                ++this.state.cursor;
            }
        }
    }

    @Override
    public void mark() {
        this.state.source.push(this.state.cursor - (this.state.end ? 0 : 1));
    }

    @Override
    public void cancel() throws IllegalStateException {
        if (this.state.cursors.isEmpty()) {
            throw new IllegalStateException("Can't cancel the reading since no position was marked.");
        }
        this.state.cursor = this.state.source.pop();
        Thrower.safeCall(this.state.source::read);
    }

    @Override
    public void consume() throws IllegalStateException {
        if (this.state.cursors.isEmpty()) {
            throw new IllegalStateException("Can't consume characters since no position was marked.");
        }
        this.state.source.pop();
    }

    @Override
    public Optional<Reader> getRemainder() {
        Optional<String> remainder = this.getRemainderString();
        if (remainder.isPresent()) {
            return Optional.of(new StringReader(remainder.get()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getRemainderString() {
        if (this.state.end) {
            return Optional.empty();
        }
        int[] codepoints = this.sequence.codePoints().skip(this.state.cursor - Character.charCount(this.state.next)).toArray();
        String remainder = new String(codepoints, 0, codepoints.length);
        this.state.cursor = this.sequence.length();
        this.read();
        return Optional.of(remainder);
    }

    public String toString() {
        return this.sequence + '\n' + this.state;
    }
}

