/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.scan;

import java.io.IOException;
import java.io.Reader;
import java.util.Optional;
import ml.alternet.facet.Trackable;
import ml.alternet.scan.Scanner;

public class TrackableScanner
extends Scanner
implements Trackable {
    private Position position = new Position();
    private Scanner scanner;

    public TrackableScanner(Scanner scanner) throws IOException {
        this.scanner = scanner;
        this.state = scanner.state;
        this.state.source = this;
        this.setNextLocation();
    }

    private void setNextLocation() {
        if (this.hasNext()) {
            char c = (char)this.lookAhead();
            if (c == '\r') {
                this.position.nextLine++;
                this.position.nextColumn = 0L;
                this.position.previsousWasReturnChar = true;
            } else {
                if (c == '\n') {
                    if (!this.position.previsousWasReturnChar) {
                        this.position.nextLine++;
                        this.position.nextColumn = 0L;
                    }
                } else {
                    this.position.nextColumn++;
                }
                this.position.previsousWasReturnChar = false;
            }
        }
    }

    public TrackableScanner(Scanner scanner, long line, long column, long offset) throws IOException {
        this(scanner);
        this.position.line = line;
        this.position.column = column;
        this.position.offset = offset;
    }

    @Override
    public Optional<ml.alternet.misc.Position> getPosition() {
        return Optional.of(ml.alternet.misc.Position.$((long)this.position.column, (long)this.position.line, (long)this.position.offset));
    }

    @Override
    public void read() throws IOException {
        this.position.line = this.position.nextLine;
        this.position.column = this.position.nextColumn;
        this.scanner.read();
        if (this.hasNext()) {
            this.position.offset++;
        }
        this.setNextLocation();
    }

    @Override
    public void mark() {
        this.scanner.mark();
    }

    @Override
    public void cancel() throws IllegalStateException {
        if (this.state.cursors.isEmpty()) {
            throw new IllegalStateException("Can't cancel the reading since no position was marked.");
        }
        this.position = (Position)this.state.cursors.peek();
        this.scanner.cancel();
    }

    @Override
    public void consume() {
        this.scanner.consume();
    }

    @Override
    protected void push(int cursor) {
        Position pos = new Position(cursor, this.position);
        this.state.cursors.push(pos);
    }

    @Override
    public Optional<Reader> getRemainder() throws IOException {
        return this.scanner.getRemainder();
    }

    @Override
    public Optional<String> getRemainderString() throws IOException {
        return this.scanner.getRemainderString();
    }

    static class Position
    extends Scanner.Cursor {
        private long line = 1L;
        private long column = 0L;
        private long offset = 0L;
        private long nextLine = 1L;
        private long nextColumn = 0L;
        private boolean previsousWasReturnChar = false;

        Position(int cursor, Position position) {
            super(cursor);
            this.line = position.line;
            this.column = position.column;
            this.offset = position.offset;
            this.nextLine = position.nextLine;
            this.nextColumn = position.nextColumn;
            this.previsousWasReturnChar = position.previsousWasReturnChar;
        }

        Position() {
            super(-1);
        }
    }
}

