/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.tomcat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.auth.Credentials;
import ml.alternet.security.web.Passwords;
import ml.alternet.security.web.server.AuthenticationMethod;
import ml.alternet.security.web.server.BasicAuthorizationBuffer;
import ml.alternet.security.web.server.CaptureContext;
import ml.alternet.security.web.server.DebugLevel;
import ml.alternet.security.web.server.FormFieldConfiguration;
import ml.alternet.security.web.server.FormLimit;
import ml.alternet.security.web.server.FormReader;
import ml.alternet.security.web.server.PasswordFieldMatcher;
import ml.alternet.security.web.tomcat.AltProtocolHandler;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Response;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;

public class AltCoyoteAdapter
extends CoyoteAdapter {
    FormLimit formLimit;
    DebugLevel debugLevel;
    PasswordManager pm;

    public AltCoyoteAdapter(final Connector connector, DebugLevel debugLevel, PasswordManager pm) {
        super(connector);
        this.debugLevel = debugLevel;
        this.pm = pm;
        this.formLimit = new FormLimit(){

            public int getMaxFormKeys() {
                return connector.getMaxParameterCount();
            }

            public int getMaxFormContentSize() {
                return connector.getMaxPostSize();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean postParseRequest(org.apache.coyote.Request req, Request request, Response res, org.apache.catalina.connector.Response response) throws IOException, ServletException {
        MessageBytes auth;
        boolean bl;
        try {
            bl = super.postParseRequest(req, request, res, response);
        }
        catch (Throwable throwable) {
            MessageBytes auth2;
            PasswordFieldMatcher pfm = new PasswordFieldMatcher(request){
                ServletContext scontext;
                final /* synthetic */ Request val$request;
                {
                    this.val$request = request;
                    this.scontext = this.val$request.getServletContext();
                }

                public Optional<List<String>> matches(HttpServletRequest request) {
                    return FormFieldConfiguration.matches((ServletContext)this.scontext, (HttpServletRequest)request);
                }

                public AuthenticationMethod getAuthenticationMethod(ServletRequest request) {
                    return AuthenticationMethod.extract((ServletContext)this.scontext);
                }
            };
            if (pfm.getAuthenticationMethod(null) == AuthenticationMethod.Basic && (auth2 = req.getMimeHeaders().getValue("authorization")) != null) {
                ByteChunk byteChunk = auth2.getByteChunk();
                byte[] buffer = byteChunk.getBuffer();
                BasicAuthorizationBuffer authBuf = new BasicAuthorizationBuffer(BasicAuthorizationBuffer.Scope.AuthorizationHeaderValue, byteChunk.getStart(), byteChunk.getEnd(), buffer){
                    final /* synthetic */ byte[] val$buffer;
                    {
                        this.val$buffer = byArray;
                        super(x0, x1, x2);
                    }

                    public void set(int i, byte b) {
                        this.val$buffer[i] = b;
                    }

                    public byte get(int i) {
                        return this.val$buffer[i];
                    }

                    public void debug(String msg) {
                        if (AltCoyoteAdapter.this.debugLevel.isAllowingUnsercureTrace()) {
                            AltProtocolHandler.LOG.debug((Object)(msg + " :\n" + new String(this.val$buffer, Charset.forName("ISO-8859-1"))));
                        }
                    }
                };
                if (authBuf.findCredentialsBoundaries()) {
                    Credentials credentials = authBuf.replace(this.pm);
                    req.setAttribute(Passwords.BASIC_AUTH_ATTRIBUTE_KEY, (Object)credentials);
                }
            }
            pfm.matches((HttpServletRequest)request).ifPresent(fields -> {
                final CaptureContext cc = new CaptureContext(fields);
                final InputBuffer in = req.getInputBuffer();
                req.setInputBuffer(new InputBuffer(){
                    FormReader fr;
                    {
                        this.fr = new FormReader(AltCoyoteAdapter.this.formLimit, AltCoyoteAdapter.this.pm){

                            public int readItem(byte[] buf, int i) {
                                byte b = ((ByteBuffer)cc.writableInputBuffer).get();
                                if (this.replace && !((ByteBuffer)cc.writableInputBuffer).isReadOnly()) {
                                    buf[i] = 42;
                                    ((ByteBuffer)cc.writableInputBuffer).put(((ByteBuffer)cc.writableInputBuffer).position() - 1, (byte)42);
                                } else {
                                    buf[i] = b;
                                }
                                return b & 0xFF;
                            }

                            public void log(Exception exception) {
                                AltProtocolHandler.LOG.debug((Object)exception.toString(), (Throwable)exception);
                            }

                            public CaptureContext<ByteBuffer> getCurrentCaptureContext() {
                                return cc;
                            }
                        };
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public int doRead(ByteChunk chunk, org.apache.coyote.Request request) throws IOException {
                        try {
                            int n = in.doRead(chunk, request);
                            return n;
                        }
                        finally {
                            int size = chunk.getLength();
                            cc.writableInputBuffer = ByteBuffer.wrap(chunk.getBytes(), chunk.getStart(), chunk.getLength());
                            this.fr.get(size, chunk.getBytes(), chunk.getStart(), chunk.getLength());
                            Passwords pwd = cc.asPasswords();
                            request.setAttribute(Passwords.ATTRIBUTE_KEY, (Object)pwd);
                        }
                    }
                });
            });
            throw throwable;
        }
        PasswordFieldMatcher pfm = new /* invalid duplicate definition of identical inner class */;
        if (pfm.getAuthenticationMethod(null) == AuthenticationMethod.Basic && (auth = req.getMimeHeaders().getValue("authorization")) != null) {
            ByteChunk byteChunk = auth.getByteChunk();
            byte[] buffer = byteChunk.getBuffer();
            BasicAuthorizationBuffer authBuf = new /* invalid duplicate definition of identical inner class */;
            if (authBuf.findCredentialsBoundaries()) {
                Credentials credentials = authBuf.replace(this.pm);
                req.setAttribute(Passwords.BASIC_AUTH_ATTRIBUTE_KEY, (Object)credentials);
            }
        }
        pfm.matches((HttpServletRequest)request).ifPresent(fields -> {
            final CaptureContext cc = new CaptureContext(fields);
            final InputBuffer in = req.getInputBuffer();
            req.setInputBuffer(new /* invalid duplicate definition of identical inner class */);
        });
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(org.apache.coyote.Request coyoteRequest, Response res) throws Exception {
        try {
            super.service(coyoteRequest, res);
        }
        finally {
            Credentials credentials = (Credentials)coyoteRequest.getAttributes().get(Passwords.BASIC_AUTH_ATTRIBUTE_KEY);
            if (credentials != null) {
                credentials.destroy();
                coyoteRequest.getAttributes().remove(Passwords.BASIC_AUTH_ATTRIBUTE_KEY);
            }
        }
    }
}

