/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.tomcat;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import ml.alternet.misc.Thrower;
import ml.alternet.security.auth.Credentials;
import ml.alternet.security.auth.Hasher;
import ml.alternet.security.auth.formats.ModularCryptFormat;
import ml.alternet.security.web.server.AuthenticationMethod;
import ml.alternet.security.web.tomcat.AltProtocolHandler;
import org.apache.catalina.CredentialHandler;

public class AltCredentialHandler
implements CredentialHandler {
    private Hasher hasher;

    public boolean matches(String inputCredentials, String storedCredentials) {
        if (storedCredentials == null) {
            return false;
        }
        ServletRequest request = (ServletRequest)AltProtocolHandler.request.get();
        AuthenticationMethod am = AuthenticationMethod.extract((ServletContext)request.getServletContext());
        Credentials credentials = am.getCredentials(request);
        return this.getHasher().check(credentials, storedCredentials);
    }

    public String mutate(String inputCredentials) {
        return inputCredentials;
    }

    public void setHasher(Hasher hasher) {
        this.hasher = hasher;
    }

    public Hasher getHasher() {
        if (this.hasher == null) {
            this.hasher = ModularCryptFormat.Hashers.$2$.get();
        }
        return this.hasher;
    }

    public void setHasher(String hasher) {
        try {
            this.hasher = (Hasher)Class.forName(hasher).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Thrower.doThrow((Exception)e);
        }
    }
}

