/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.tomcat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import ml.alternet.misc.Invoker;
import ml.alternet.misc.Thrower;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.PasswordManagerFactory;
import ml.alternet.security.web.server.DebugLevel;
import ml.alternet.security.web.tomcat.AltCoyoteAdapter;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.CoyoteAdapter;
import org.apache.catalina.connector.Request;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.IntrospectionUtils;

public class AltProtocolHandler
implements ProtocolHandler,
DebugLevel.Debuggable {
    static final Log LOG = LogFactory.getLog(AltProtocolHandler.class);
    static ThreadLocal<Request> request = new ThreadLocal();
    private ProtocolHandler ph;
    private DebugLevel debugLevel = new DebugLevel();
    private PasswordManager pm;
    private Map<String, String> props = new HashMap<String, String>();

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    public void setPasswordManager(String passwordManager) {
        try {
            this.pm = (PasswordManager)Class.forName(passwordManager).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Thrower.doThrow((Exception)e);
        }
    }

    public PasswordManager getPasswordManager() {
        if (this.pm == null) {
            this.pm = PasswordManagerFactory.getStrongPasswordManager();
        }
        return this.pm;
    }

    public void setAllowUnsecureTrace(String value) {
        if ("true".equalsIgnoreCase(value)) {
            this.debugLevel.allowUnsecureTrace();
        } else {
            this.debugLevel.disallowUnsecureTrace();
        }
    }

    private void setProtocolHandler(String phClass) {
        try {
            this.ph = (ProtocolHandler)Class.forName(phClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Thrower.doThrow((Exception)e);
        }
    }

    public boolean setProperty(String name, String value) {
        if ("tomcatProtocol".equals(name)) {
            if (AprLifecycleListener.isAprAvailable()) {
                if ("HTTP/1.1".equals(value)) {
                    this.setProtocolHandler("org.apache.coyote.http11.Http11AprProtocol");
                } else if ("AJP/1.3".equals(value)) {
                    this.setProtocolHandler("org.apache.coyote.ajp.AjpAprProtocol");
                } else if (value != null) {
                    this.setProtocolHandler(value);
                } else {
                    this.setProtocolHandler("org.apache.coyote.http11.Http11AprProtocol");
                }
            } else if ("HTTP/1.1".equals(value)) {
                this.setProtocolHandler("org.apache.coyote.http11.Http11NioProtocol");
            } else if ("AJP/1.3".equals(value)) {
                this.setProtocolHandler("org.apache.coyote.ajp.AjpNioProtocol");
            } else if (value != null) {
                this.setProtocolHandler(value);
            }
        } else {
            if (this.ph == null) {
                this.props.put(name, value);
                return true;
            }
            return IntrospectionUtils.setProperty((Object)this.ph, (String)name, (String)value);
        }
        if (this.ph != null && this.props != null) {
            this.props.forEach((n, v) -> IntrospectionUtils.setProperty((Object)this.ph, (String)n, (String)v));
            this.props = null;
        }
        return true;
    }

    public void setAdapter(Adapter adapter) {
        try {
            CoyoteAdapter ca = (CoyoteAdapter)adapter;
            Connector connector = (Connector)Invoker.get((Object)ca, (String)"connector");
            adapter = new AltCoyoteAdapter(connector, this.getDebugLevel(), this.pm);
            this.ph.setAdapter(adapter);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Thrower.doThrow((Exception)e);
        }
    }

    public Adapter getAdapter() {
        return this.ph.getAdapter();
    }

    public Executor getExecutor() {
        return this.ph.getExecutor();
    }

    public void init() throws Exception {
        this.ph.init();
    }

    public void start() throws Exception {
        this.ph.start();
    }

    public void pause() throws Exception {
        this.ph.pause();
    }

    public void resume() throws Exception {
        this.ph.resume();
    }

    public void stop() throws Exception {
        this.ph.stop();
    }

    public void destroy() throws Exception {
        this.ph.destroy();
    }

    public boolean isAprRequired() {
        return this.ph.isAprRequired();
    }

    public boolean isCometSupported() {
        return this.ph.isCometSupported();
    }

    public boolean isCometTimeoutSupported() {
        return this.ph.isCometTimeoutSupported();
    }

    public boolean isSendfileSupported() {
        return this.ph.isSendfileSupported();
    }
}

