/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import ml.alternet.security.EmptyPassword;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.PasswordManagerFactory;
import ml.alternet.security.PasswordState;
import ml.alternet.security.impl.AbstractPassword;
import ml.alternet.security.impl.StandardPasswordManager;
import ml.alternet.util.BytesUtil;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class PasswordTest {
    @Test
    public void defaultManager_ShouldBe_StandardPasswordManager() {
        PasswordManager defaultPM = PasswordManagerFactory.getDefaultPasswordManager();
        defaultPM.newPassword("password".toCharArray());
        defaultPM = PasswordManagerFactory.getDefaultPasswordManager();
        Assertions.assertThat((Object)defaultPM).isInstanceOf(StandardPasswordManager.class);
    }

    @Test
    public void charArrayPassword_ShouldBe_Unset() {
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        char[] pwd = "password".toCharArray();
        pm.newPassword(pwd);
        Assertions.assertThat((char[])pwd).containsOnly(new char[]{'\u0000'});
    }

    @Test
    public void clearCharArrayPassword_ShouldBe_Unset() {
        char[] clearPwd;
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        char[] pwd = "the password".toCharArray();
        Password password = pm.newPassword(pwd);
        Throwable throwable = null;
        Object var6_6 = null;
        try (Password.Clear clear = password.getClearCopy();){
            clearPwd = clear.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertThat((char[])clearPwd).containsOnly(new char[]{'\u0000'});
    }

    @Test
    public void gettingSeveralClearWeakPasswords_ShouldNot_BreakThePassword() {
        PasswordManager pm = PasswordManagerFactory.getWeakPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        int i = 0;
        while (i < 10) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Password.Clear clear = password.getClearCopy();){
                Assertions.assertThat((char[])clear.get()).isEqualTo((Object)pwd.toCharArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
    }

    @Test
    public void gettingSeveralClearStandardPasswords_ShouldNot_BreakThePassword() {
        PasswordManager pm = PasswordManagerFactory.getStandardPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        int i = 0;
        while (i < 10) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Password.Clear clear = password.getClearCopy();){
                Assertions.assertThat((char[])clear.get()).isEqualTo((Object)pwd.toCharArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
    }

    @Test
    public void gettingSeveralClearStrongPasswords_ShouldNot_BreakThePassword() {
        PasswordManager pm = PasswordManagerFactory.getStrongPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        int i = 0;
        while (i < 10) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Password.Clear clear = password.getClearCopy();){
                Assertions.assertThat((char[])clear.get()).isEqualTo((Object)pwd.toCharArray());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++i;
        }
    }

    @Test
    public void nullPassword_Should_ReturnEmptyPassword() {
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        char[] pwd = null;
        Password password = pm.newPassword(pwd);
        Assertions.assertThat((Object)password).isSameAs((Object)EmptyPassword.SINGLETON);
    }

    @Test
    public void voidPassword_Should_ReturnEmptyPassword() {
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        char[] pwd = "".toCharArray();
        Password password = pm.newPassword(pwd);
        Assertions.assertThat((Object)password).isSameAs((Object)EmptyPassword.SINGLETON);
    }

    @Test
    public void emptyPassword_ShouldHave_TheEmptyState() {
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        Password password = pm.newPassword(null);
        Assertions.assertThat((Comparable)password.state()).isSameAs((Object)PasswordState.Empty);
    }

    @Test
    public void newPassword_ShouldBe_Valid() {
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        char[] pwd = "the password".toCharArray();
        Password password = pm.newPassword(pwd);
        Assertions.assertThat((Comparable)password.state()).isSameAs((Object)PasswordState.Valid);
    }

    @Test
    public void invalidatedPassword_ShouldHave_TheInvalidState() {
        PasswordManager pm = PasswordManagerFactory.getDefaultPasswordManager();
        char[] pwd = "the password".toCharArray();
        Password password = pm.newPassword(pwd);
        password.destroy();
        Assertions.assertThat((Comparable)password.state()).isSameAs((Object)PasswordState.Invalid);
    }

    @Test
    public void clearStandardPassword_ShouldBe_TheSame() {
        PasswordManager pm = PasswordManagerFactory.getStandardPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Password.Clear clear = password.getClearCopy();){
            Assertions.assertThat((char[])clear.get()).isEqualTo((Object)pwd.toCharArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void clearWeakPassword_ShouldBe_TheSame() {
        PasswordManager pm = PasswordManagerFactory.getWeakPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Password.Clear clear = password.getClearCopy();){
            Assertions.assertThat((char[])clear.get()).isEqualTo((Object)pwd.toCharArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void clearStrongPassword_ShouldBe_TheSame() {
        PasswordManager pm = PasswordManagerFactory.getStrongPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        Throwable throwable = null;
        Object var5_6 = null;
        try (Password.Clear clear = password.getClearCopy();){
            Assertions.assertThat((char[])clear.get()).isEqualTo((Object)pwd.toCharArray());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void invalidatedClearPassword_Should_ThrowException() {
        PasswordManager pm = PasswordManagerFactory.getStandardPasswordManager();
        char[] pwd = "the password".toCharArray();
        Password password = pm.newPassword(pwd);
        Throwable throwable = null;
        Object var5_6 = null;
        try (Password.Clear clear = password.getClearCopy();){
            password.destroy();
            clear.get();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void invalidatedPassword_Should_ThrowException() {
        PasswordManager pm = PasswordManagerFactory.getStandardPasswordManager();
        char[] pwd = "the password".toCharArray();
        Password password = pm.newPassword(pwd);
        password.destroy();
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            Password.Clear clear = password.getClearCopy();
            if (clear != null) {
                clear.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void privateStandardPassword_ShouldNotBe_TheSame() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PasswordManager pm = PasswordManagerFactory.getStandardPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        Method method = AbstractPassword.class.getDeclaredMethod("getPrivatePassword", new Class[0]);
        method.setAccessible(true);
        byte[] priv = (byte[])method.invoke((Object)password, new Object[0]);
        char[] cpriv = new char[priv.length];
        int i = 0;
        while (i < priv.length) {
            cpriv[i] = (char)priv[i];
            ++i;
        }
        Assertions.assertThat((char[])pwd.toCharArray()).isNotEqualTo((Object)cpriv);
    }

    @Test
    public void privateStrongPassword_ShouldNotBe_TheSame() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PasswordManager pm = PasswordManagerFactory.getStrongPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        Method method = AbstractPassword.class.getDeclaredMethod("getPrivatePassword", new Class[0]);
        method.setAccessible(true);
        byte[] priv = (byte[])method.invoke((Object)password, new Object[0]);
        char[] cpriv = new char[priv.length];
        int i = 0;
        while (i < priv.length) {
            cpriv[i] = (char)priv[i];
            ++i;
        }
        Assertions.assertThat((char[])pwd.toCharArray()).isNotEqualTo((Object)cpriv);
    }

    @Test
    public void privateWeakPassword_ShouldBe_TheSame_BecauseItsManagerIsWeak() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PasswordManager pm = PasswordManagerFactory.getWeakPasswordManager();
        String pwd = "the password";
        Password password = pm.newPassword(pwd.toCharArray());
        Method method = AbstractPassword.class.getDeclaredMethod("getPrivatePassword", new Class[0]);
        method.setAccessible(true);
        byte[] priv = (byte[])method.invoke((Object)password, new Object[0]);
        char[] cpriv = BytesUtil.cast((byte[])priv);
        Assertions.assertThat((char[])pwd.toCharArray()).isEqualTo((Object)cpriv);
    }
}

