/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security.web;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import javax.xml.bind.DatatypeConverter;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManagerFactory;
import ml.alternet.security.auth.Credentials;
import ml.alternet.security.web.server.BasicAuthorizationBuffer;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class BasicAuthBufferTest {
    String unsafePwd = "da_AcTu@| P@zzm0R|)";
    String cred = "john:" + this.unsafePwd;
    String b64Cred = DatatypeConverter.printBase64Binary((byte[])this.cred.getBytes());
    String basic = "Basic " + this.b64Cred;
    String auth = "Authorization: " + this.basic;
    String firsHttpHeaders = "Host: localhost:8675\r\nConnection: keep-alive\r\nCache-Control: max-age=0\r\n";
    String lastHttpHeaders = "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8\r\nUser-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.111 Safari/537.36\r\nAccept-Encoding: gzip, deflate, sdch\r\nAccept-Language: fr-FR,fr;q=0.8,en-US;q=0.6,en;q=0.4";
    String httpHeaders = this.firsHttpHeaders + this.auth + "\r\n" + this.lastHttpHeaders;

    @Test
    public void password_ShouldBe_extractedFromHttpHeaders() {
        BasicAuthorizationBuffer authBuf = this.createBuffer(this.httpHeaders, BasicAuthorizationBuffer.Scope.Headers);
        this.check(authBuf);
    }

    @Test
    public void password_ShouldBe_extractedFromHttpHeadersEndingWithCRLF() {
        BasicAuthorizationBuffer authBuf = this.createBuffer(this.httpHeaders + "\r\n", BasicAuthorizationBuffer.Scope.Headers);
        this.check(authBuf);
    }

    @Test
    public void password_ShouldBe_extractedFromSingleHttpHeader() {
        BasicAuthorizationBuffer authBuf = this.createBuffer(this.auth, BasicAuthorizationBuffer.Scope.AuthorizationHeader);
        this.check(authBuf);
    }

    @Test
    public void password_ShouldBe_extractedFromBasicCredential() {
        BasicAuthorizationBuffer authBuf = this.createBuffer(this.basic, BasicAuthorizationBuffer.Scope.AuthorizationHeaderValue);
        this.check(authBuf);
    }

    @Test
    public void credentials_ShouldNotBe_foundInOtherHttpHeader() {
        BasicAuthorizationBuffer authBuf = this.createBuffer("Cache-Control: max-age=0", BasicAuthorizationBuffer.Scope.AuthorizationHeader);
        Assertions.assertThat((boolean)authBuf.findCredentialsBoundaries()).isFalse();
    }

    @Test
    public void credentials_ShouldNotBe_foundInHttpHeadersWithoutAuthorizationHeader() {
        String httpHeadersWithoutAuthorizationHeader = this.firsHttpHeaders + this.lastHttpHeaders;
        BasicAuthorizationBuffer authBuf = this.createBuffer(httpHeadersWithoutAuthorizationHeader, BasicAuthorizationBuffer.Scope.Headers);
        Assertions.assertThat((boolean)authBuf.findCredentialsBoundaries()).isFalse();
    }

    @Test
    public void credentials_ShouldBe_unreachable() {
        String httpHeadersWithoutAuthorizationHeader = this.firsHttpHeaders + "\r\n" + this.auth + "\r\n" + this.lastHttpHeaders;
        BasicAuthorizationBuffer authBuf = this.createBuffer(httpHeadersWithoutAuthorizationHeader, BasicAuthorizationBuffer.Scope.Headers);
        Assertions.assertThat((boolean)authBuf.findCredentialsBoundaries()).isFalse();
    }

    public BasicAuthorizationBuffer createBuffer(String string, BasicAuthorizationBuffer.Scope scope) {
        byte[] bytes = string.getBytes(Charset.forName("ISO-8859-1"));
        final ByteBuffer buf = ByteBuffer.wrap(bytes);
        BasicAuthorizationBuffer authBuf = new BasicAuthorizationBuffer(scope, buf.position(), buf.limit()){

            public void set(int i, byte b) {
                buf.put(i, b);
            }

            public byte get(int i) {
                return buf.get(i);
            }

            public void debug(String msg) {
            }
        };
        return authBuf;
    }

    public void check(BasicAuthorizationBuffer authBuf) {
        char[] clearPwd;
        Assertions.assertThat((boolean)authBuf.findCredentialsBoundaries()).isTrue();
        Credentials credentials = authBuf.replace(PasswordManagerFactory.getStrongPasswordManager());
        try (Password.Clear clear = credentials.getPassword().getClearCopy();){
            clearPwd = clear.get();
            Assertions.assertThat((char[])clearPwd).isEqualTo((Object)this.unsafePwd.toCharArray());
        }
        credentials = authBuf.replace(PasswordManagerFactory.getStrongPasswordManager());
        clear = credentials.getPassword().getClearCopy();
        var5_4 = null;
        try {
            clearPwd = clear.get();
            Assertions.assertThat((int)clearPwd.length).isEqualTo(this.unsafePwd.length());
            Assertions.assertThat((char[])clearPwd).containsOnly(new char[]{'*'});
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (clear != null) {
                if (var5_4 != null) {
                    try {
                        clear.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    clear.close();
                }
            }
        }
    }
}

