/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Entity;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import ml.alternet.security.EmptyPassword;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManagerFactory;
import ml.alternet.security.PasswordState;
import ml.alternet.security.web.PasswordConverterProvider;
import ml.alternet.security.web.PasswordParam;
import ml.alternet.security.web.Passwords;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.JerseyTestNg;
import org.glassfish.jersey.test.ServletDeploymentContext;
import org.glassfish.jersey.test.grizzly.GrizzlyWebTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainerFactory;
import org.testng.annotations.Test;

public class PasswordConverterTest
extends JerseyTestNg.ContainerPerClassTest {
    static final String PASSWORD_FIELD = "password";
    static final String PASSWORD = "Da_actu@L pazzw0r|) !";
    static final String PASSWORD_CHECK = "Da actuaL password !";
    static PasswordConverterTest that;
    ConcurrentLinkedQueue<Runnable> tests = new ConcurrentLinkedQueue();
    static String classes;

    public PasswordConverterTest() {
        that = this;
    }

    @Test
    public void passwordsSentByPOST_ShouldBe_convertedToPasswordParamClass() throws Exception {
        Form form = new Form();
        form.param(PASSWORD_FIELD, PASSWORD);
        form.param(PASSWORD_FIELD, PASSWORD_CHECK);
        Response response = this.target("sendPassword/post").request().post(Entity.form((Form)form));
        this.checkNow();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        Assertions.assertThat((String)((String)response.readEntity(String.class))).isEqualTo((Object)PASSWORD);
    }

    @Test
    public void noPasswordSentByPOST_ShouldBe_empty() throws Exception {
        Response response = this.target("sendPassword/postNoForm").request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.checkNow();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        Assertions.assertThat((String)((String)response.readEntity(String.class))).isEmpty();
    }

    @Test
    public void passwordsSentByGET_ShouldNotBe_converted() throws Exception {
        Response response = this.target("sendPassword/get").queryParam(PASSWORD_FIELD, new Object[]{PASSWORD, PASSWORD_CHECK}).request().get();
        this.checkNow();
        Assertions.assertThat((int)response.getStatus()).isEqualTo(200);
        Assertions.assertThat((String)((String)response.readEntity(String.class))).isEmpty();
    }

    public void checkLater(Runnable test) {
        this.tests.add(test);
    }

    public void checkNow() {
        Runnable r = this.tests.poll();
        while (r != null) {
            r.run();
            r = this.tests.poll();
        }
    }

    protected Application configure() {
        ResourceConfig app = new ResourceConfig();
        return app;
    }

    protected DeploymentContext configureDeployment() {
        return ServletDeploymentContext.builder((Application)this.configure()).initParam("jersey.config.server.provider.classnames", classes).build();
    }

    protected TestContainerFactory getTestContainerFactory() {
        return new GrizzlyWebTestContainerFactory();
    }

    static {
        classes = PasswordResource.class.getName() + " " + WebContainerFilter.class.getName() + " " + TolerantPasswordConverterProvider.class.getName();
    }

    static class TolerantPasswordConverterProvider
    extends PasswordConverterProvider {
        TolerantPasswordConverterProvider() {
        }

        protected void processQueryParam(QueryParam passwordFieldAnnotation) throws SecurityException {
        }
    }

    @Provider
    private static class WebContainerFilter
    implements ContainerRequestFilter {
        @Context
        HttpServletRequest req;

        private WebContainerFilter() {
        }

        public void filter(ContainerRequestContext requestContext) throws IOException {
            final ArrayList<Password> pwdList = new ArrayList<Password>();
            pwdList.add(PasswordManagerFactory.getWeakPasswordManager().newPassword(PasswordConverterTest.PASSWORD.toCharArray()));
            pwdList.add(PasswordManagerFactory.getWeakPasswordManager().newPassword(PasswordConverterTest.PASSWORD_CHECK.toCharArray()));
            Passwords pwd = new Passwords(){

                protected PasswordParam getPasswords(String name) {
                    if (PasswordConverterTest.PASSWORD_FIELD.equals(name)) {
                        return new PasswordParam(pwdList.iterator());
                    }
                    return new PasswordParam((Password)EmptyPassword.SINGLETON);
                }
            };
            this.req.setAttribute(Passwords.ATTRIBUTE_KEY, (Object)pwd);
        }
    }

    @Path(value="sendPassword")
    public static class PasswordResource {
        @POST
        @Path(value="post")
        public String processPassword(@FormParam(value="password") PasswordParam pwd) {
            that.checkLater(() -> {
                IterableAssert cfr_ignored_0 = (IterableAssert)((IterableAssert)Assertions.assertThat((Iterable)pwd).as("No passwords found", new Object[0])).isNotNull();
            });
            String clearPwd = new String(pwd.getClearCopy().get());
            that.checkLater(() -> {
                AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)((AbstractCharSequenceAssert)Assertions.assertThat((String)clearPwd).as("1st password \"%s\" has not the value expected", new Object[]{clearPwd})).isEqualTo((Object)PasswordConverterTest.PASSWORD);
            });
            boolean hasNext = pwd.hasNext();
            that.checkLater(() -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)hasNext).as("2nd password \"%s\" should NOT be the last", new Object[]{clearPwd})).isTrue());
            PasswordParam pwdCheck = pwd.next();
            String clearPwdCheck = new String(pwdCheck.getClearCopy().get());
            that.checkLater(() -> {
                AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)((AbstractCharSequenceAssert)Assertions.assertThat((String)clearPwdCheck).as("2nd password \"%s\" has not the value expected", new Object[]{clearPwdCheck})).isEqualTo((Object)PasswordConverterTest.PASSWORD_CHECK);
            });
            that.checkLater(() -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)pwdCheck.hasNext()).as("2nd password \"%s\" should be the last", new Object[]{clearPwdCheck})).isFalse());
            return clearPwd;
        }

        @POST
        @Path(value="postNoForm")
        public String processNoPassword(@FormParam(value="password") PasswordParam pwd) {
            that.checkLater(() -> ((IterableAssert)Assertions.assertThat((Iterable)pwd).as("Unexpected password found", new Object[0])).isNull());
            return "";
        }

        @GET
        @Path(value="get")
        public String wrongProcessPassword(@QueryParam(value="password") PasswordParam pwd) {
            that.checkLater(() -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)pwd.state()).as("@QueryParam should not capture the password", new Object[0])).isEqualTo((Object)PasswordState.Empty);
            });
            return new String(pwd.getClearCopy().get());
        }
    }
}

