/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security.web;

import java.util.Arrays;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManagerFactory;
import ml.alternet.security.PasswordState;
import ml.alternet.security.web.PasswordParam;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class PasswordParamTest {
    @Test
    public void defaultSequence_Should_containEmptyPassword() {
        PasswordParam pp = new PasswordParam();
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Empty);
        Assertions.assertThat((boolean)pp.hasNext()).isFalse();
    }

    @Test
    public void singleSequence_Should_containWrapPassword() {
        String unsafePwd = "da P@zzW0r|)";
        Password pwd = PasswordManagerFactory.getWeakPasswordManager().newPassword(unsafePwd.toCharArray());
        PasswordParam pp = new PasswordParam(pwd);
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Valid);
        Assertions.assertThat((char[])pp.getClearCopy().get()).isEqualTo((Object)unsafePwd.toCharArray());
        pp.destroy();
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Invalid);
        Assertions.assertThat((boolean)pp.hasNext()).isFalse();
    }

    @Test
    public void fullSequence_Should_containWrapPasswords() {
        String unsafePwd1 = "da P@zzW0r|)";
        Password pwd1 = PasswordManagerFactory.getWeakPasswordManager().newPassword(unsafePwd1.toCharArray());
        String unsafePwd2 = "sesame";
        Password pwd2 = PasswordManagerFactory.getWeakPasswordManager().newPassword(unsafePwd2.toCharArray());
        String unsafePwd3 = "azERTY";
        Password pwd3 = PasswordManagerFactory.getWeakPasswordManager().newPassword(unsafePwd3.toCharArray());
        PasswordParam pp = new PasswordParam(Arrays.asList(pwd1, pwd2, pwd3).iterator());
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Valid);
        Assertions.assertThat((char[])pp.getClearCopy().get()).isEqualTo((Object)unsafePwd1.toCharArray());
        Assertions.assertThat((boolean)pp.hasNext()).isTrue();
        pp.next();
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Valid);
        Assertions.assertThat((char[])pp.getClearCopy().get()).isEqualTo((Object)unsafePwd2.toCharArray());
        Assertions.assertThat((boolean)pp.hasNext()).isTrue();
        pp.destroy();
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Invalid);
        pp.next();
        Assertions.assertThat((Comparable)pp.state()).isEqualTo((Object)PasswordState.Valid);
        Assertions.assertThat((char[])pp.getClearCopy().get()).isEqualTo((Object)unsafePwd3.toCharArray());
        Assertions.assertThat((boolean)pp.hasNext()).isFalse();
    }
}

