/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security.web.server;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;
import jodd.methref.Methref;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordState;
import ml.alternet.security.auth.Credentials;
import ml.alternet.security.web.Passwords;
import ml.alternet.test.security.web.server.Data;
import ml.alternet.test.security.web.server.ServerTestHarness;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.testng.annotations.Test;

public abstract class BasicAuthServerTestHarness<T>
extends ServerTestHarness<T> {
    protected static Methref<? extends BasicAuthServerTestHarness<?>> name;
    public String contextPath = "/test";

    @Test(priority=1)
    public void authPassword_ShouldBe_capturedByServer() throws Exception {
        String uri = "http://localhost:" + this.port + this.contextPath + "/Test";
        Client client = ClientBuilder.newClient();
        String unsafeCred = this.userName + ":" + this.unsafePwd;
        Response response = client.target(uri).request().header("Authorization", (Object)("Basic " + DatatypeConverter.printBase64Binary((byte[])unsafeCred.getBytes("UTF-8")))).get();
        Data data = (Data)response.readEntity(Data.class);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)data.pwd).as("REST client : password header should be filled with '*'", new Object[0])).matches((CharSequence)"^\\*+$");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)data.user).as("REST client : user should be the same", new Object[0])).isEqualTo((Object)"who");
        Map newCookies = response.getCookies();
        NewCookie session = (NewCookie)newCookies.get("JSESSIONID");
        Assertions.assertThat((Object)session).isNotNull();
    }

    @Test(priority=10)
    public void HTTPAuthenticationMissing() {
        ((BasicAuthServerTestHarness)name.to()).HTTPAuthenticationMissing();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void HTTPBasicAuthenticationMissing() {
        ((BasicAuthServerTestHarness)name.to()).HTTPBasicAuthenticationMissing();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void credential_Should_containTheRightUserName() {
        ((BasicAuthServerTestHarness)name.to()).credential_Should_containTheRightUserName();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void passwordHeader_ShouldBe_FilledWithStars() {
        ((BasicAuthServerTestHarness)name.to()).passwordHeader_ShouldBe_FilledWithStars();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void request_Should_SupplyPassword() {
        ((BasicAuthServerTestHarness)name.to()).request_Should_SupplyPassword();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void request_Should_SupplyValidPassword() {
        ((BasicAuthServerTestHarness)name.to()).request_Should_SupplyValidPassword();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void password_Should_HaveTheRigthValue() {
        ((BasicAuthServerTestHarness)name.to()).password_Should_HaveTheRigthValue();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void user_ShouldHave_AdminRole() {
        ((BasicAuthServerTestHarness)name.to()).user_ShouldHave_AdminRole();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void user_ShouldNotHave_CustomerRole() {
        ((BasicAuthServerTestHarness)name.to()).user_ShouldNotHave_CustomerRole();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Path(value="/")
    public static class ExampleRequest {
        @Path(value="{example}")
        @GET
        @Produces(value={"application/xml"})
        public Data example(@PathParam(value="example") String example, @Context HttpHeaders httpHeaders, @Context HttpServletRequest req) throws UnsupportedEncodingException {
            BasicAuthServerTestHarness that = (BasicAuthServerTestHarness)req.getServletContext().getAttribute(BasicAuthServerTestHarness.class.getName());
            List authHeaders = httpHeaders.getRequestHeader("Authorization");
            ((BasicAuthServerTestHarness)name.to()).HTTPAuthenticationMissing();
            that.serverTests.put(name.ref(), () -> {
                AbstractIntegerAssert cfr_ignored_0 = (AbstractIntegerAssert)((AbstractIntegerAssert)Assertions.assertThat((int)authHeaders.size()).isNotNull()).as("REST server : HTTP Authentication missing", new Object[0]);
            });
            String authHeader = (String)authHeaders.get(0);
            ((BasicAuthServerTestHarness)name.to()).HTTPBasicAuthenticationMissing();
            that.serverTests.put(name.ref(), () -> {
                AbstractBooleanAssert cfr_ignored_0 = (AbstractBooleanAssert)((AbstractBooleanAssert)Assertions.assertThat((boolean)authHeader.startsWith("Basic ")).isNotNull()).as("REST server : HTTP Basic Authentication missing", new Object[0]);
            });
            String[] cred = new String(DatatypeConverter.parseBase64Binary((String)authHeader.substring("Basic ".length())), "ISO-8859-1").split(":");
            Data data = new Data(cred[0], cred[1]);
            ((BasicAuthServerTestHarness)name.to()).credential_Should_containTheRightUserName();
            that.serverTests.put(name.ref(), () -> {
                AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)((AbstractCharSequenceAssert)Assertions.assertThat((String)cred[0]).isEqualTo((Object)"who")).as("REST server : credential should contain the right user name", new Object[0]);
            });
            ((BasicAuthServerTestHarness)name.to()).passwordHeader_ShouldBe_FilledWithStars();
            that.serverTests.put(name.ref(), () -> ((AbstractCharSequenceAssert)Assertions.assertThat((String)cred[1]).as("REST server : password header should be filled with '*'", new Object[0])).matches((CharSequence)"^\\*+$"));
            boolean uira = req.isUserInRole("admin");
            ((BasicAuthServerTestHarness)name.to()).user_ShouldHave_AdminRole();
            that.serverTests.put(name.ref(), () -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)uira).as("REST server : user should have \"admin\" role", new Object[0])).isTrue());
            boolean uirc = req.isUserInRole("customer");
            ((BasicAuthServerTestHarness)name.to()).user_ShouldNotHave_CustomerRole();
            that.serverTests.put(name.ref(), () -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)uirc).as("REST server : user should not have \"customer\" role", new Object[0])).isFalse());
            Credentials credentials = (Credentials)req.getAttribute(Passwords.BASIC_AUTH_ATTRIBUTE_KEY);
            ((BasicAuthServerTestHarness)name.to()).request_Should_SupplyPassword();
            that.serverTests.put(name.ref(), () -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)credentials).as("REST server : request should supply password", new Object[0])).isNotNull();
            });
            Password pwd = credentials.getPassword();
            PasswordState state = pwd.state();
            ((BasicAuthServerTestHarness)name.to()).request_Should_SupplyValidPassword();
            that.serverTests.put(name.ref(), () -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)state).as("REST server : request should supply valid password", new Object[0])).isSameAs((Object)PasswordState.Valid);
            });
            char[] clearPwd = pwd.getClearCopy().get();
            ((BasicAuthServerTestHarness)name.to()).password_Should_HaveTheRigthValue();
            that.serverTests.put(name.ref(), () -> {
                AbstractCharArrayAssert cfr_ignored_0 = (AbstractCharArrayAssert)((AbstractCharArrayAssert)Assertions.assertThat((char[])clearPwd).as("REST server : password should have the rigth value", new Object[0])).isEqualTo((Object)that.unsafePwd.toCharArray());
            });
            return data;
        }
    }
}

