/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security.web.server;

import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import jodd.methref.Methref;
import ml.alternet.test.security.web.server.Data;
import ml.alternet.test.security.web.server.ServerTestHarness;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.glassfish.jersey.client.ClientConfig;
import org.testng.annotations.Test;

public abstract class FormAuthServerTestHarness<T>
extends ServerTestHarness<T> {
    protected static Methref<? extends FormAuthServerTestHarness<?>> name;
    public String contextPath = "/test";

    public abstract String checkSession(HttpServletRequest var1);

    @Test(priority=1)
    public void authPassword_ShouldBe_capturedByWebServer() throws Exception {
        ClientConfig conf = new ClientConfig();
        conf.property("jersey.config.client.followRedirects", (Object)"false");
        Client client = ClientBuilder.newClient((Configuration)conf);
        String uri = "http://localhost:" + this.port + this.contextPath + "/protected/test.html";
        Response response = client.target(uri).request().get();
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatus()).as("REST client : protected resource should be redirected to login form", new Object[0])).isIn(new Object[]{303, 302, 200});
        MultivaluedMap headers = response.getHeaders();
        String loginUri = "http://localhost:" + this.port + this.contextPath + "/login.html";
        if (response.getStatus() == 303 || response.getStatus() == 302) {
            Assertions.assertThat((String)headers.getFirst((Object)"Location").toString()).startsWith((CharSequence)loginUri);
        }
        Map newCookies = response.getCookies();
        NewCookie session = (NewCookie)newCookies.get("JSESSIONID");
        Assertions.assertThat((Object)session).isNotNull();
        Form form = new Form();
        form.param("j_username", this.userName);
        form.param("j_password", this.unsafePwd);
        String doLoginUri = "http://localhost:" + this.port + this.contextPath + "/j_security_check";
        Invocation.Builder builder = client.target(doLoginUri).request();
        builder.cookie((Cookie)session);
        response = builder.post(Entity.form((Form)form));
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatus()).as("REST client : login form should redirect to original URL", new Object[0])).isEqualTo(303);
        headers = response.getHeaders();
        Assertions.assertThat((String)uri).endsWith((CharSequence)headers.getFirst((Object)"Location").toString());
        newCookies = response.getCookies();
        if (newCookies.get("JSESSIONID") != null) {
            session = (NewCookie)newCookies.get("JSESSIONID");
        }
        response = client.target(uri).request().cookie((Cookie)session).get();
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.getStatus()).as("REST client : protected resource should be read", new Object[0])).isEqualTo(200);
        Data data = (Data)response.readEntity(Data.class);
        if (data.pwd != null) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)data.pwd).as("REST client : password header should be filled with '*'", new Object[0])).matches((CharSequence)"^\\*+$");
        }
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)data.user).as("REST client : user should be the same", new Object[0])).isEqualTo((Object)this.userName);
    }

    @Test(priority=10)
    public void user_ShouldBe_Authentified() {
        ((FormAuthServerTestHarness)name.to()).user_ShouldBe_Authentified();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void userName_ShouldBe_Defined() {
        ((FormAuthServerTestHarness)name.to()).userName_ShouldBe_Defined();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void user_ShouldHave_AdminRole() {
        ((FormAuthServerTestHarness)name.to()).user_ShouldHave_AdminRole();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void user_ShouldNotHave_CustomerRole() {
        ((FormAuthServerTestHarness)name.to()).user_ShouldNotHave_CustomerRole();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void sessionAuthentication_ShouldBe_Define() {
        ((FormAuthServerTestHarness)name.to()).sessionAuthentication_ShouldBe_Define();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void passwordSession_ShouldBe_FilledWithStarsOrUnavailable() {
        ((FormAuthServerTestHarness)name.to()).passwordSession_ShouldBe_FilledWithStarsOrUnavailable();
        this.serverTests.getOrDefault(name.ref(), () -> {}).run();
    }

    @Path(value="/")
    public static class ExampleRequest {
        @Path(value="/test.html")
        @GET
        @Produces(value={"application/xml"})
        public Data example(@Context HttpServletRequest req) throws UnsupportedEncodingException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
            FormAuthServerTestHarness that = (FormAuthServerTestHarness)req.getServletContext().getAttribute(FormAuthServerTestHarness.class.getName());
            Principal user = req.getUserPrincipal();
            ((FormAuthServerTestHarness)name.to()).user_ShouldBe_Authentified();
            that.serverTests.put(name.ref(), () -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)user).as("REST server : user should be authentified", new Object[0])).isNotNull();
            });
            String userName = user.getName();
            ((FormAuthServerTestHarness)name.to()).userName_ShouldBe_Defined();
            that.serverTests.put(name.ref(), () -> {
                AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)((AbstractCharSequenceAssert)Assertions.assertThat((String)userName).as("REST server : user should be authentified", new Object[0])).isEqualTo((Object)that.userName);
            });
            boolean uira = req.isUserInRole("admin");
            ((FormAuthServerTestHarness)name.to()).user_ShouldHave_AdminRole();
            that.serverTests.put(name.ref(), () -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)uira).as("REST server : user should have \"admin\" role", new Object[0])).isTrue());
            boolean uirc = req.isUserInRole("customer");
            ((FormAuthServerTestHarness)name.to()).user_ShouldNotHave_CustomerRole();
            that.serverTests.put(name.ref(), () -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)uirc).as("REST server : user should not have \"customer\" role", new Object[0])).isFalse());
            String credentials = that.checkSession(req);
            ((FormAuthServerTestHarness)name.to()).passwordSession_ShouldBe_FilledWithStarsOrUnavailable();
            if (credentials != null) {
                that.serverTests.put(name.ref(), () -> ((AbstractCharSequenceAssert)Assertions.assertThat((String)credentials).as("REST server : password header should be filled with '*'", new Object[0])).matches((CharSequence)"^\\*+$"));
            }
            Data data = new Data(userName, credentials);
            return data;
        }
    }
}

