/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.test.security.web.server;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import jodd.methref.Methref;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordState;
import ml.alternet.security.web.PasswordConverterProvider;
import ml.alternet.security.web.Passwords;
import ml.alternet.test.security.web.server.Data;
import ml.alternet.test.security.web.server.ServerTestHarness;
import org.assertj.core.api.AbstractCharArrayAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.glassfish.jersey.server.ResourceConfig;
import org.testng.annotations.Test;

public abstract class RESTServerTestHarness<T>
extends ServerTestHarness<T> {
    protected static Methref<? extends RESTServerTestHarness<?>> name;
    public String contextPath = "/test";

    @Test(priority=1)
    public void passwords_ShouldBe_capturedByServer() throws Exception {
        String uri = "http://localhost:" + this.port + this.contextPath + "/Test";
        Client client = ClientBuilder.newClient();
        String unsafePwd = "da_AcTu@| P@zzm0R|)";
        Form form = new Form();
        form.param("who", "azerty");
        form.param("pwd", unsafePwd);
        Response response = client.target(uri).request().post(Entity.form((Form)form));
        Data data = (Data)response.readEntity(Data.class);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)data.pwd).as("REST client : raw value should be filled with '*'", new Object[0])).matches((CharSequence)"^\\*+$");
        ((AbstractIntegerAssert)Assertions.assertThat((int)data.pwd.length()).as("REST client : raw value and password should have the same length", new Object[0])).isEqualTo(URLEncoder.encode(unsafePwd, "UTF-8").length());
        ((AbstractCharArrayAssert)Assertions.assertThat((char[])data.clearValue).as("REST client : clear value and password should be the same", new Object[0])).isEqualTo((Object)unsafePwd.toCharArray());
    }

    @Test(priority=10)
    public void RESTPasswordConverter_Should_SupplyPassword() {
        ((RESTServerTestHarness)name.to()).RESTPasswordConverter_Should_SupplyPassword();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void RESTPasswordConverter_Should_SupplyValidPassword() {
        ((RESTServerTestHarness)name.to()).RESTPasswordConverter_Should_SupplyValidPassword();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void RESTPasswordConverter_Should_ConvertRequestPassword() {
        ((RESTServerTestHarness)name.to()).RESTPasswordConverter_Should_ConvertRequestPassword();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void unrelatedFields_ShouldNot_BeCaptured() {
        ((RESTServerTestHarness)name.to()).unrelatedFields_ShouldNot_BeCaptured();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void unrelatedFields_Should_HaveTheirValueUnchanged() {
        ((RESTServerTestHarness)name.to()).unrelatedFields_Should_HaveTheirValueUnchanged();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void rawValue_ShouldBe_FilledWithStars() {
        ((RESTServerTestHarness)name.to()).rawValue_ShouldBe_FilledWithStars();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Test(priority=10)
    public void rawValueAndPassword_Should_HaveTheSameLength() {
        ((RESTServerTestHarness)name.to()).rawValueAndPassword_Should_HaveTheSameLength();
        ((Runnable)this.serverTests.get(name.ref())).run();
    }

    @Path(value="/")
    public static class ExampleRequest {
        @Path(value="{example}")
        @POST
        @Produces(value={"application/xml"})
        public Data example(@PathParam(value="example") String example, @FormParam(value="pwd") Password pwd, @FormParam(value="pwd") String rawValue, @FormParam(value="who") String whoValue, @Context HttpServletRequest req) {
            RESTServerTestHarness that = (RESTServerTestHarness)req.getServletContext().getAttribute(RESTServerTestHarness.class.getName());
            Data data = new Data(pwd, rawValue);
            ((RESTServerTestHarness)name.to()).RESTPasswordConverter_Should_SupplyPassword();
            that.serverTests.put(name.ref(), () -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)pwd).as("REST server : REST password converter should supply password", new Object[0])).isNotNull();
            });
            PasswordState state = pwd.state();
            ((RESTServerTestHarness)name.to()).RESTPasswordConverter_Should_SupplyValidPassword();
            that.serverTests.put(name.ref(), () -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)state).as("REST server : REST password converter should supply valid password", new Object[0])).isSameAs((Object)PasswordState.Valid);
            });
            char[] clearPwd = pwd.getClearCopy().get();
            char[] reqPwd = Passwords.getPasswords((ServletRequest)req, (String)"pwd").getClearCopy().get();
            ((RESTServerTestHarness)name.to()).RESTPasswordConverter_Should_ConvertRequestPassword();
            that.serverTests.put(name.ref(), () -> {
                AbstractCharArrayAssert cfr_ignored_0 = (AbstractCharArrayAssert)((AbstractCharArrayAssert)Assertions.assertThat((char[])clearPwd).as("REST server : REST password converter should convert request password", new Object[0])).isEqualTo((Object)reqPwd);
            });
            PasswordState who = Passwords.getPasswords((ServletRequest)req, (String)"who").state();
            ((RESTServerTestHarness)name.to()).unrelatedFields_ShouldNot_BeCaptured();
            that.serverTests.put(name.ref(), () -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)who).as("REST server : unrelated fields should not be captured", new Object[0])).isSameAs((Object)PasswordState.Empty);
            });
            ((RESTServerTestHarness)name.to()).unrelatedFields_Should_HaveTheirValueUnchanged();
            that.serverTests.put(name.ref(), () -> {
                AbstractCharSequenceAssert cfr_ignored_0 = (AbstractCharSequenceAssert)((AbstractCharSequenceAssert)Assertions.assertThat((String)whoValue).as("REST server : unrelated fields should have their value unchanged", new Object[0])).isEqualTo((Object)"azerty");
            });
            ((RESTServerTestHarness)name.to()).rawValue_ShouldBe_FilledWithStars();
            that.serverTests.put(name.ref(), () -> ((AbstractCharSequenceAssert)Assertions.assertThat((String)rawValue).as("REST server : raw value should be filled with '*'", new Object[0])).matches((CharSequence)"^\\*+$"));
            try {
                String clearUnsafePwd = URLEncoder.encode(new String(clearPwd), "UTF-8");
                ((RESTServerTestHarness)name.to()).rawValueAndPassword_Should_HaveTheSameLength();
                that.serverTests.put(name.ref(), () -> ((AbstractIntegerAssert)Assertions.assertThat((int)rawValue.length()).as("REST server : raw value and password should have the same length", new Object[0])).isEqualTo(clearUnsafePwd.length()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return data;
        }
    }

    public static class RestApp
    extends ResourceConfig {
        public RestApp() {
            this.register(PasswordConverterProvider.class);
        }
    }
}

