/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security;

import javax.security.auth.Destroyable;
import ml.alternet.security.PasswordManagerFactory;
import ml.alternet.security.PasswordState;
import ml.alternet.security.SensitiveData;

@SensitiveData
public interface Password
extends Destroyable {
    public static Password newPassword(char[] password) {
        return PasswordManagerFactory.getDefaultPasswordManager().newPassword(password);
    }

    @Override
    default public boolean isDestroyed() {
        return this.state() == PasswordState.Invalid;
    }

    @Override
    public void destroy();

    public PasswordState state();

    public Clear getClearCopy() throws IllegalStateException;

    public static interface Clear
    extends AutoCloseable {
        public char[] get();

        @Override
        public void close();
    }
}

