/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security;

import ml.alternet.discover.DiscoveryService;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.impl.StandardPasswordManager;
import ml.alternet.security.impl.StrongPasswordManager;
import ml.alternet.security.impl.WeakPasswordManager;

public final class PasswordManagerFactory {
    private static PasswordManager DEFAULT_PASSWORD_MANAGER = new DelegatePasswordManager(){

        @Override
        PasswordManager getPasswordManager() {
            try {
                DEFAULT_PASSWORD_MANAGER = (PasswordManager)DiscoveryService.lookupSingleton(PasswordManager.class);
                return DEFAULT_PASSWORD_MANAGER;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    };
    private static PasswordManager WEAK_PASSWORD_MANAGER = new WeakPasswordManager();
    private static PasswordManager STANDARD_PASSWORD_MANAGER = new StandardPasswordManager();
    private static PasswordManager STRONG_PASSWORD_MANAGER = new DelegatePasswordManager(){

        @Override
        PasswordManager getPasswordManager() {
            STRONG_PASSWORD_MANAGER = new StrongPasswordManager();
            return STRONG_PASSWORD_MANAGER;
        }
    };

    public static PasswordManager getDefaultPasswordManager() {
        return DEFAULT_PASSWORD_MANAGER;
    }

    public static PasswordManager getWeakPasswordManager() {
        return WEAK_PASSWORD_MANAGER;
    }

    public static PasswordManager getStandardPasswordManager() {
        return STANDARD_PASSWORD_MANAGER;
    }

    public static PasswordManager getStrongPasswordManager() {
        return STRONG_PASSWORD_MANAGER;
    }

    private static abstract class DelegatePasswordManager
    implements PasswordManager {
        PasswordManager pm;

        private DelegatePasswordManager() {
        }

        @Override
        public Password newPassword(char[] password) {
            if (this.pm == null) {
                this.pm = this.getPasswordManager();
            }
            return this.pm.newPassword(password);
        }

        abstract PasswordManager getPasswordManager();
    }
}

