/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.auth;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Destroyable;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManagerFactory;

public class Credentials
implements Destroyable {
    String username;
    Password password;
    String realm;
    Map<String, Object> fields;

    public static Credentials fromPassword(Password password) {
        return new Credentials().withPassword(password);
    }

    public static Credentials fromPassword(char[] password) {
        return new Credentials().withPassword(password);
    }

    public static Credentials fromUserPassword(String username, Password password) {
        return new Credentials().withUser(username).withPassword(password);
    }

    public static Credentials fromUserPassword(String username, char[] password) {
        return new Credentials().withUser(username).withPassword(password);
    }

    public Credentials withUser(String username) {
        this.username = username;
        return this;
    }

    public Credentials withPassword(Password password) {
        this.password = password;
        return this;
    }

    public Credentials withPassword(char[] password) {
        this.password = PasswordManagerFactory.getStrongPasswordManager().newPassword(password);
        return this;
    }

    public Credentials withRealm(String realm) {
        this.realm = realm;
        return this;
    }

    public Credentials withField(String field, Object data) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        this.fields.put(field, data);
        return this;
    }

    public String getUserName() {
        return this.username;
    }

    public Password getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public <T> T get(String field) {
        if (this.fields == null) {
            return null;
        }
        return (T)this.fields.get(field);
    }

    @Override
    public void destroy() {
        if (this.password != null) {
            this.password.destroy();
        }
    }

    @Override
    public boolean isDestroyed() {
        if (this.password != null) {
            return this.password.isDestroyed();
        }
        return false;
    }

    public static interface Checker {
        public boolean check(Credentials var1, String var2);

        public void reportError(String var1, String var2, Exception var3);
    }
}

