/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.impl;

import java.util.Arrays;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordState;

public abstract class AbstractPassword
implements Password {
    PasswordState state = PasswordState.Valid;

    public String toString() {
        return "*****";
    }

    @Override
    public PasswordState state() {
        return this.state;
    }

    @Override
    public final void destroy() {
        this.state = PasswordState.Invalid;
        byte[] pwd = this.getPrivatePassword();
        Arrays.fill(pwd, (byte)0);
    }

    @Override
    public final Password.Clear getClearCopy() {
        if (this.state() == PasswordState.Invalid) {
            throw new IllegalStateException("This password has been invalidated");
        }
        return this.getClearValidPassword();
    }

    protected abstract Password.Clear getClearValidPassword();

    protected abstract byte[] getPrivatePassword();
}

