/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.impl;

import java.util.Arrays;
import java.util.Base64;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.PasswordState;
import ml.alternet.security.impl.AbstractClearPassword;
import ml.alternet.security.impl.AbstractPassword;
import ml.alternet.security.impl.AbstractPasswordManager;
import ml.alternet.util.BytesUtil;

public class StandardPasswordManager
extends AbstractPasswordManager
implements PasswordManager {
    @Override
    public Password newValidPassword(char[] password) {
        byte[] clearBytes = BytesUtil.cast((char[])password);
        final byte[] obfuscate = Base64.getEncoder().encode(clearBytes);
        Arrays.fill(clearBytes, (byte)0);
        return new AbstractPassword(){

            @Override
            public Password.Clear getClearValidPassword() {
                return new AbstractClearPassword(){

                    @Override
                    protected char[] getClearCopy() {
                        byte[] clearBytes = Base64.getDecoder().decode(obfuscate);
                        char[] clearChars = BytesUtil.cast((byte[])clearBytes);
                        Arrays.fill(clearBytes, (byte)0);
                        return clearChars;
                    }

                    @Override
                    protected boolean isDestroyed() {
                        return this.state() == PasswordState.Invalid;
                    }
                };
            }

            @Override
            protected byte[] getPrivatePassword() {
                return obfuscate;
            }
        };
    }
}

