/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import ml.alternet.misc.WtfException;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.PasswordState;
import ml.alternet.security.impl.AbstractClearPassword;
import ml.alternet.security.impl.AbstractPassword;
import ml.alternet.security.impl.AbstractPasswordManager;
import ml.alternet.util.BytesUtil;

public class StrongPasswordManager
extends AbstractPasswordManager
implements PasswordManager {
    private static final SecureRandom RANDOM = new SecureRandom();
    private final SecretKey secret;

    public StrongPasswordManager() {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES");
            kg.init(128);
            this.secret = kg.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw WtfException.throwException((Throwable)e);
        }
    }

    @Override
    public Password newValidPassword(char[] password) {
        byte[] obfuscate;
        final byte[] iv = new byte[16];
        RANDOM.nextBytes(iv);
        try {
            Cipher jcaCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            jcaCipher.init(1, (Key)this.secret, new IvParameterSpec(iv));
            byte[] clearBytes = BytesUtil.cast((char[])password);
            obfuscate = jcaCipher.doFinal(clearBytes);
            Arrays.fill(clearBytes, (byte)0);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw WtfException.throwException((Throwable)e);
        }
        return new AbstractPassword(){

            @Override
            public Password.Clear getClearValidPassword() {
                return new AbstractClearPassword(){

                    @Override
                    protected char[] getClearCopy() {
                        try {
                            Cipher jcaCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                            jcaCipher.init(2, (Key)StrongPasswordManager.this.secret, new IvParameterSpec(iv));
                            byte[] clearBytes = jcaCipher.doFinal(obfuscate);
                            char[] clearChars = BytesUtil.cast((byte[])clearBytes);
                            Arrays.fill(clearBytes, (byte)0);
                            return clearChars;
                        }
                        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                            throw WtfException.throwException((Throwable)e);
                        }
                    }

                    @Override
                    protected boolean isDestroyed() {
                        return this.state() == PasswordState.Invalid;
                    }
                };
            }

            @Override
            protected byte[] getPrivatePassword() {
                return obfuscate;
            }
        };
    }
}

