/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import ml.alternet.security.Password;
import ml.alternet.security.web.PasswordParam;
import ml.alternet.security.web.Passwords;

@Provider
public class PasswordConverterProvider
implements ParamConverterProvider {
    static final Logger LOGGER = Logger.getLogger(PasswordConverterProvider.class.getName());
    @Context
    HttpServletRequest httpServletRequest;
    private static final String SECURITY_ERROR_MSG = "Webapp design error (security flaw) :a password field must not be annotated with @QueryParam.";

    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Password.class.equals(rawType) || PasswordParam.class.equals(rawType)) {
            if (this.httpServletRequest == null) {
                LOGGER.warning("Unable to inject HttpServletRequest ; please check your JAX-RS engine capabilities and Web server configuration.");
            }
            String fieldName = null;
            for (Annotation ann : annotations) {
                if (ann.annotationType().equals(FormParam.class)) {
                    FormParam fp = (FormParam)ann;
                    fieldName = fp.value();
                    break;
                }
                if (ann.annotationType().equals(HeaderParam.class)) {
                    HeaderParam hp = (HeaderParam)ann;
                    fieldName = hp.value();
                    break;
                }
                if (!ann.annotationType().equals(QueryParam.class)) continue;
                this.processQueryParam((QueryParam)ann);
            }
            return new PasswordConverter(this.httpServletRequest, fieldName);
        }
        return null;
    }

    protected void processQueryParam(QueryParam passwordFieldAnnotation) throws SecurityException {
        throw new SecurityException(SECURITY_ERROR_MSG);
    }

    private static final class PasswordConverter
    implements ParamConverter<PasswordParam> {
        static final Logger LOGGER = Logger.getLogger(PasswordConverter.class.getName());
        private final String name;
        private final HttpServletRequest httpServletRequest;

        private PasswordConverter(HttpServletRequest httpServletRequest, String name) {
            this.name = name;
            this.httpServletRequest = httpServletRequest;
        }

        public PasswordParam fromString(String value) {
            if (this.name == null) {
                LOGGER.warning(PasswordConverterProvider.SECURITY_ERROR_MSG);
            }
            PasswordParam pp = Passwords.getPasswords((ServletRequest)this.httpServletRequest, this.name);
            LOGGER.info("Password parameter \"" + this.name + "\" filtered safely");
            return pp;
        }

        public String toString(PasswordParam value) {
            return value.toString();
        }
    }
}

