/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.server;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import ml.alternet.security.auth.Credentials;
import ml.alternet.security.web.Config;
import ml.alternet.security.web.PasswordParam;
import ml.alternet.security.web.Passwords;

public enum AuthenticationMethod {
    Basic{

        @Override
        public Credentials getCredentials(ServletRequest request) {
            Credentials credentials = (Credentials)request.getAttribute(Passwords.BASIC_AUTH_ATTRIBUTE_KEY);
            return credentials;
        }
    }
    ,
    Form{

        @Override
        public Credentials getCredentials(ServletRequest request) {
            String username = request.getParameter("j_username");
            PasswordParam pwd = Passwords.getPasswords(request, "j_password");
            return Credentials.fromUserPassword(username, pwd);
        }
    }
    ,
    Other,
    None;


    public Credentials getCredentials(ServletRequest request) {
        return new Credentials();
    }

    public static AuthenticationMethod extract(ServletContext webapp) {
        AuthenticationMethod authMethod = (AuthenticationMethod)((Object)webapp.getAttribute(AuthenticationMethod.class.getName()));
        if (authMethod == null) {
            String initParam = webapp.getInitParameter(Config.AUTH_METHOD_INIT_PARAM);
            if (initParam != null && initParam.length() > 0) {
                char[] chars = initParam.toLowerCase().toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                initParam = new String(chars);
                try {
                    authMethod = AuthenticationMethod.valueOf(initParam);
                }
                catch (IllegalArgumentException e) {
                    authMethod = Other;
                }
                webapp.setAttribute(AuthenticationMethod.class.getName(), (Object)authMethod);
            } else {
                authMethod = None;
            }
        }
        return authMethod;
    }

    public static void reset(ServletContext webapp) {
        webapp.removeAttribute(AuthenticationMethod.class.getName());
    }
}

