/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.server;

import java.util.Arrays;
import java.util.stream.IntStream;
import ml.alternet.encode.BytesEncoder;
import ml.alternet.security.Password;
import ml.alternet.security.PasswordManager;
import ml.alternet.security.auth.Credentials;

public abstract class BasicAuthorizationBuffer {
    int position;
    int limit;
    Scope scope;
    static final int READ_AUTH = 0;
    static final int READ_UNTIL_CRLF = 1;
    static final int READ_OWS_BASIC = 2;
    static final int READ_BASIC = 3;
    static final int READ_CRED = 4;
    static final int READ_LF = 5;
    static final int READ_LAST_LF = 6;
    static final String AUTHORIZATION = "authorization:";
    static final String BASIC = "basic ";
    int auth = 0;
    int basicPos = 0;
    int state = 0;
    int credStart = -1;
    int credEnd = -1;

    public BasicAuthorizationBuffer(Scope scope, int position, int limit) {
        this.position = position;
        this.limit = limit;
        this.scope = scope;
    }

    public abstract byte get(int var1);

    public abstract void set(int var1, byte var2);

    public abstract void debug(String var1);

    /*
     * Enabled aggressive block sorting
     */
    public boolean findCredentialsBoundaries() {
        int pos;
        if (this.scope == Scope.AuthorizationHeaderValue) {
            this.state = 3;
        }
        block9: for (pos = this.position; pos < this.limit; ++pos) {
            char c = (char)(this.get(pos) & 0x7F);
            c = Character.toLowerCase(c);
            switch (this.state) {
                case 0: {
                    if (c == AUTHORIZATION.charAt(this.auth)) {
                        ++this.auth;
                        if (this.auth != AUTHORIZATION.length()) break;
                        this.state = 2;
                        break;
                    }
                    if (this.scope == Scope.AuthorizationHeaderValue) return false;
                    if (this.scope == Scope.AuthorizationHeader) {
                        return false;
                    }
                    if (c == '\r') {
                        this.auth = 0;
                        this.state = 6;
                        break;
                    }
                    this.auth = 0;
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (c != '\r') break;
                    this.state = 5;
                    break;
                }
                case 2: {
                    if (c == ' ') break;
                    this.state = 3;
                }
                case 3: {
                    if (c == BASIC.charAt(this.basicPos)) {
                        ++this.basicPos;
                        if (this.basicPos != BASIC.length()) break;
                        this.state = 4;
                        this.credStart = pos + 1;
                        break;
                    }
                    if (this.scope == Scope.AuthorizationHeaderValue) return false;
                    if (this.scope == Scope.AuthorizationHeader) {
                        return false;
                    }
                    this.basicPos = 0;
                    this.state = 1;
                    break;
                }
                case 4: {
                    if (c == ' ') {
                        this.credEnd = pos;
                        break block9;
                    }
                    if (c != '\r') break;
                    this.credEnd = pos;
                    this.state = 5;
                    break;
                }
                case 5: {
                    if (c != '\n') {
                        this.credEnd = -1;
                        break block9;
                    }
                    if (this.credEnd > 0) break block9;
                    this.state = 0;
                    break;
                }
                case 6: {
                    if (c == '\n') break block9;
                    this.credEnd = -1;
                    break block9;
                }
            }
        }
        if (this.scope == Scope.AuthorizationHeaderValue || this.scope == Scope.AuthorizationHeader) {
            this.credEnd = pos;
            return true;
        }
        if (this.credEnd == -1) return false;
        return true;
    }

    public Credentials replace(PasswordManager passwordManager) {
        Object pwd;
        class State {
            int i = 0;
            int p = 0;
            int outi = 0;
            StringBuffer user = new StringBuffer();
            char[] password;

            State() {
            }
        }
        State s = new State();
        BytesEncoder.base64.encode(BytesEncoder.base64.decode(IntStream.generate(() -> this.get(this.credStart + s.i++)).mapToObj(c -> Character.valueOf((char)(c & 0xFF))).limit(this.credEnd - this.credStart)).map(c -> {
            if (s.password == null) {
                if (c == 58) {
                    s.password = new char[this.credEnd - this.credStart - s.i];
                } else {
                    s.user.append((char)c);
                }
                return c;
            }
            s.password[s.p++] = (char)c;
            return 42;
        })).forEach(c -> this.set(this.credStart + s.outi++, (byte)c.charValue()));
        while (this.credStart + s.outi < this.credEnd) {
            this.set(this.credStart + s.outi++, (byte)32);
        }
        if (s.password.length > s.p) {
            pwd = Arrays.copyOf(s.password, s.p);
            Arrays.fill(s.password, ' ');
            s.password = pwd;
        }
        this.debug("HTTP Headers successfully parsed");
        pwd = passwordManager.newPassword(s.password);
        Credentials credentials = Credentials.fromUserPassword(s.user.toString(), (Password)pwd);
        return credentials;
    }

    public static enum Scope {
        Headers,
        AuthorizationHeader,
        AuthorizationHeaderValue;

    }
}

