/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Destroyable;
import ml.alternet.security.EmptyPassword;
import ml.alternet.security.Password;
import ml.alternet.security.web.PasswordParam;
import ml.alternet.security.web.Passwords;

public class CaptureContext<T>
implements Destroyable {
    List<String> fields;
    private Map<String, List<Password>> passwords = new HashMap<String, List<Password>>();
    public T writableInputBuffer;

    public CaptureContext(List<String> fields) {
        this.fields = fields;
    }

    @Override
    public void destroy() {
        if (this.passwords != null) {
            this.passwords.values().forEach(list -> list.forEach(pwd -> pwd.destroy()));
            this.passwords = null;
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.passwords == null;
    }

    public void add(String name, Password newPassword) {
        List<Password> pwds = this.passwords.get(name);
        if (pwds == null) {
            pwds = new ArrayList<Password>(2);
            this.passwords.put(name, pwds);
        }
        pwds.add(newPassword);
    }

    public Passwords asPasswords() {
        Passwords pwd = new Passwords(){

            @Override
            protected PasswordParam getPasswords(String name) {
                List list = (List)CaptureContext.this.passwords.get(name);
                if (list == null || list.isEmpty()) {
                    return new PasswordParam(EmptyPassword.SINGLETON);
                }
                return new PasswordParam(list.iterator());
            }
        };
        return pwd;
    }
}

