/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.server;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import ml.alternet.security.web.Config;
import ml.alternet.security.web.server.AuthenticationMethod;

public class FormFieldConfiguration {
    public static final String J_SECURITY_CHECK = "/j_security_check";
    public static final String J_USERNAME = "j_username";
    public static final String J_PASSWORD = "j_password";
    protected String ctxtPath;
    protected Map<String, List<String>> fields = new HashMap<String, List<String>>();

    protected void extract(ServletContext webapp) {
        String initParam = webapp.getInitParameter(Config.FORM_FIELDS_INIT_PARAM);
        if (initParam != null) {
            String[] conf;
            for (String c : conf = initParam.split("\\s*,\\s*")) {
                String[] parts = c.split("\\?");
                String[] formFields = parts[1].split("&");
                this.addValues(parts[0], formFields);
            }
        }
    }

    protected void addLoginFormValue(ServletContext webapp) {
        AuthenticationMethod method = AuthenticationMethod.extract(webapp);
        if (method == AuthenticationMethod.Form) {
            this.addValues(J_SECURITY_CHECK, J_PASSWORD);
        }
    }

    protected void addValues(String path, String ... formFields) {
        path = this.ctxtPath + path;
        this.fields.put(path, Arrays.asList(formFields));
    }

    protected List<String> get(String path) {
        return this.fields.get(path);
    }

    public static Optional<List<String>> matches(ServletContext webapp, HttpServletRequest request) {
        return FormFieldConfiguration.matches(webapp, request, FormFieldConfiguration::new);
    }

    public static Optional<List<String>> matches(ServletContext webapp, HttpServletRequest request, Supplier<FormFieldConfiguration> factory) {
        String ctxtPath = webapp.getContextPath();
        String target = request.getRequestURI();
        if (target.startsWith(ctxtPath)) {
            FormFieldConfiguration forms = (FormFieldConfiguration)webapp.getAttribute(FormFieldConfiguration.class.getName());
            if (forms == null) {
                forms = factory.get();
                forms.ctxtPath = ctxtPath;
                forms.extract(webapp);
                forms.addLoginFormValue(webapp);
                webapp.setAttribute(FormFieldConfiguration.class.getName(), (Object)forms);
            }
            List<String> fields = forms.get(target);
            return Optional.ofNullable(fields);
        }
        return Optional.empty();
    }

    public static void reset(ServletContext webapp) {
        webapp.removeAttribute(FormFieldConfiguration.class.getName());
    }
}

