/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.server;

import ml.alternet.security.PasswordManager;
import ml.alternet.security.web.server.CaptureContext;
import ml.alternet.security.web.server.FormLimit;
import ml.alternet.security.web.server.Utf8Appendable;
import ml.alternet.security.web.server.Utf8StringBuilder;

public abstract class FormReader {
    int maxLength;
    int maxKeys;
    String key = null;
    char[] value = null;
    protected boolean replace = false;
    PasswordManager pm;

    public FormReader(FormLimit formLimit, PasswordManager pm) {
        this.maxLength = formLimit.getMaxFormContentSize();
        this.maxKeys = formLimit.getMaxFormKeys();
        this.pm = pm;
    }

    public void reset() {
        this.key = null;
        this.value = null;
        this.replace = false;
    }

    public int get(int size, byte[] buf, int offset, int length) {
        if ((offset | length | offset + length | buf.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Utf8StringBuilder buffer = new Utf8StringBuilder();
        int mapSize = 0;
        int totalLength = 0;
        int end = offset + size;
        int i = offset;
        while (i < end) {
            int b = this.readItem(buf, i++);
            try {
                switch ((char)b) {
                    case '&': {
                        this.value = buffer.toChars();
                        if (this.key != null) {
                            this.capture(this.key, this.value);
                            ++mapSize;
                            this.endValue();
                            buffer.clear();
                        } else if (this.value != null && this.value.length > 0) {
                            this.capture(new String(this.value), new char[0]);
                            ++mapSize;
                        }
                        buffer.reset();
                        this.key = null;
                        this.value = null;
                        if (this.maxKeys > 0 && mapSize > this.maxKeys) {
                            throw new IllegalStateException("Form too many keys");
                        }
                        break;
                    }
                    case '=': {
                        if (this.key != null) {
                            buffer.append((byte)b);
                            break;
                        }
                        this.key = buffer.toReplacedString();
                        this.startValue();
                        buffer.reset();
                        break;
                    }
                    case '+': {
                        buffer.append((byte)32);
                        break;
                    }
                    case '%': {
                        int code1;
                        int code0 = this.readItem(buf, i++);
                        boolean decoded = false;
                        if (117 == code0) {
                            int code3;
                            int code2;
                            if ((code0 = this.readItem(buf, i++)) >= 0 && (code1 = this.readItem(buf, i++)) >= 0 && (code2 = this.readItem(buf, i++)) >= 0 && (code3 = this.readItem(buf, i++)) >= 0) {
                                buffer.append(Character.toChars((FormReader.convertHexDigit(code0) << 12) + (FormReader.convertHexDigit(code1) << 8) + (FormReader.convertHexDigit(code2) << 4) + FormReader.convertHexDigit(code3)));
                                decoded = true;
                            }
                        } else if (code0 >= 0 && (code1 = this.readItem(buf, i++)) >= 0) {
                            buffer.append((byte)((FormReader.convertHexDigit(code0) << 4) + FormReader.convertHexDigit(code1)));
                            decoded = true;
                        }
                        if (!decoded) {
                            buffer.append('\ufffd');
                        }
                        break;
                    }
                    default: {
                        buffer.append((byte)b);
                        break;
                    }
                }
            }
            catch (Utf8Appendable.NotUtf8Exception e) {
                this.log(e);
            }
            catch (NumberFormatException e) {
                buffer.append(Utf8Appendable.REPLACEMENT_UTF8, 0, 3);
                this.log(e);
            }
            if (this.maxLength < 0 || ++totalLength <= this.maxLength) continue;
            throw new IllegalStateException("Form too large");
        }
        if (this.key != null) {
            this.value = buffer.toChars();
            this.capture(this.key, this.value);
            ++mapSize;
            this.endValue();
            buffer.clear();
            buffer.reset();
        } else if (buffer.length() > 0) {
            this.capture(buffer.toReplacedString(), new char[0]);
            ++mapSize;
        }
        return size;
    }

    public abstract int readItem(byte[] var1, int var2);

    public abstract CaptureContext<?> getCurrentCaptureContext();

    public abstract void log(Exception var1);

    void startValue() {
        CaptureContext<?> cc = this.getCurrentCaptureContext();
        if (this.key != null && cc != null && cc.fields.contains(this.key)) {
            this.replace = true;
        }
    }

    void endValue() {
        this.replace = false;
    }

    void capture(String name, char[] value) {
        CaptureContext<?> cc = this.getCurrentCaptureContext();
        if (cc != null && cc.fields.contains(name)) {
            cc.add(name, this.pm.newPassword(value));
        }
    }

    public static int convertHexDigit(int c) {
        int d = (c & 0x1F) + (c >> 6) * 25 - 16;
        if (d < 0 || d > 15) {
            throw new NumberFormatException("!hex " + c);
        }
        return d;
    }
}

