/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.security.web.server;

import java.util.Arrays;
import ml.alternet.security.web.server.Utf8Appendable;

public class Utf8StringBuilder
extends Utf8Appendable {
    public Utf8StringBuilder() {
        super(new SafeAppendable());
    }

    public Utf8StringBuilder(int capacity) {
        super(new SafeAppendable(capacity));
    }

    public char[] toChars() {
        this.checkState();
        return ((SafeAppendable)this._appendable).toChars();
    }

    public void clear() {
        ((SafeAppendable)this._appendable).clear();
    }

    @Override
    public int length() {
        return ((SafeAppendable)this._appendable).length();
    }

    @Override
    public void reset() {
        super.reset();
        ((SafeAppendable)this._appendable).reset();
    }

    public String toString() {
        this.checkState();
        return ((SafeAppendable)this._appendable).toString();
    }

    public void append(char[] chars) {
        ((SafeAppendable)this._appendable).append(chars);
    }

    public void append(char c) {
        ((SafeAppendable)this._appendable).append(c);
    }

    static class SafeAppendable
    implements Appendable {
        char[] c;
        int len = 0;

        SafeAppendable(int capacity) {
            this.c = new char[Math.max(capacity, 32)];
        }

        SafeAppendable() {
            this(32);
        }

        @Override
        public Appendable append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) {
            this.ensureCapacity(end - start);
            csq.chars().forEach(ch -> {
                this.c[this.len++] = (char)ch;
            });
            return this;
        }

        @Override
        public Appendable append(char ch) {
            this.ensureCapacity(1);
            this.c[this.len++] = ch;
            return this;
        }

        public Appendable append(char[] chars) {
            this.ensureCapacity(chars.length);
            for (int i = 0; i < chars.length; ++i) {
                this.c[this.len++] = chars[i];
            }
            return this;
        }

        public int length() {
            return this.len;
        }

        public void reset() {
            Arrays.fill(this.c, '\u0000');
            this.len = 0;
        }

        public void clear() {
            Arrays.fill(this.c, '\u0000');
        }

        public char[] toChars() {
            if (this.len != this.c.length) {
                char[] chars = new char[this.len];
                System.arraycopy(this.c, 0, chars, 0, this.len);
                return chars;
            }
            return this.c;
        }

        void ensureCapacity(int size) {
            if (this.len + size > this.c.length) {
                char[] chars = new char[Math.min(Math.max(this.c.length * 2, this.len + size), 0x7FFFFFFA)];
                System.arraycopy(this.c, 0, chars, 0, this.len);
                this.clear();
                this.c = chars;
            }
        }

        public String toString() {
            return new String(this.toChars());
        }
    }
}

