/*
 * Decompiled with CFR 0.152.
 */
package ml.alternet.util.gen;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import ml.alternet.util.gen.ByteCodeSpec;
import ml.alternet.util.gen.jvm.Assembler;
import ml.alternet.util.gen.jvm.HexDumper;
import org.isk.jvmhardcore.pjba.builder.ClassFileBuilder;
import org.isk.jvmhardcore.pjba.structure.ClassFile;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ByteCodeFactoryGenerator
extends AbstractProcessor {
    static Set<String> TYPES = new HashSet<String>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return TYPES;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            this.processAnnotations(annotations, roundEnv);
        }
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, ByteCodeFactoryGenerator.class.getCanonicalName() + " : end");
        return true;
    }

    public void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements eltUtils = this.processingEnv.getElementUtils();
        TypeElement elementLookup = eltUtils.getTypeElement(ByteCodeSpec.class.getCanonicalName());
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(elementLookup);
        for (Element element : elements) {
            ByteCodeSpec bc = element.getAnnotation(ByteCodeSpec.class);
            if (bc == null) continue;
            this.processAnnotation(element, bc);
        }
    }

    public void processAnnotation(Element element, ByteCodeSpec byteCode) {
        String pkg = byteCode.factoryPkg();
        String className = byteCode.factoryClassName();
        String parentClass = "";
        try {
            byteCode.parentClass();
        }
        catch (MirroredTypeException mte) {
            TypeMirror tm = mte.getTypeMirror();
            parentClass = ByteCodeFactoryGenerator.getClassName(tm);
        }
        String parentClassName = parentClass.replace('.', '/');
        String singletonName = byteCode.singletonName();
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "GENERATE " + pkg + '.' + className);
        String code = this.getCode();
        Filer filer = this.processingEnv.getFiler();
        try {
            FileObject file = filer.createResource(StandardLocation.SOURCE_OUTPUT, pkg, className + ".java", new Element[0]);
            messager.printMessage(Diagnostic.Kind.NOTE, file.toUri().toString());
            PrintWriter writer = new PrintWriter(file.openWriter());
            BufferedReader reader = new BufferedReader(new InputStreamReader(ByteCodeFactoryGenerator.class.getResourceAsStream(byteCode.template()), "UTF8"));
            reader.lines().map(s -> s.replaceAll("\\{factoryPkg\\}", this.escapeDollar(pkg))).map(s -> s.replaceAll("\\{factoryClassName\\}", this.escapeDollar(className))).map(s -> s.replaceAll("\\{code\\}", this.escapeDollar(code))).map(s -> s.replaceAll("\\{parentClassName\\}", this.escapeDollar(parentClassName))).map(s -> s.replaceAll("\\{singletonName\\}", this.escapeDollar(singletonName))).forEach(writer::println);
            writer.close();
        }
        catch (IOException ioe) {
            messager.printMessage(Diagnostic.Kind.ERROR, ioe.getMessage());
        }
    }

    String escapeDollar(String string) {
        return string.replaceAll("\\$", "\\\\\\$");
    }

    public static String getClassName(TypeMirror tm) {
        if (tm.getKind().equals((Object)TypeKind.DECLARED)) {
            TypeElement el = (TypeElement)((DeclaredType)tm).asElement();
            return ByteCodeFactoryGenerator.getClassName(el);
        }
        return tm.toString();
    }

    public static String getClassName(TypeElement el) {
        if (el.getNestingKind() == NestingKind.TOP_LEVEL) {
            return el.getQualifiedName().toString();
        }
        return ByteCodeFactoryGenerator.getClassName((TypeElement)el.getEnclosingElement()) + "$" + el.getSimpleName();
    }

    public String getCode() {
        ClassFileBuilder classFileBuilder = new ClassFileBuilder(33, "className", "parentClassName").newInterface("interfaceName").newField(25, "singletonName", "interfaceType");
        classFileBuilder.newMethod(8, "<clinit>", "()V").new_("className").dup().invokespecial("className", "<init>", "()V").putstatic("className", "singletonName", "interfaceType").return_();
        classFileBuilder.newMethod(1, "<init>", "()V").aload_0().invokespecial("parentClassName", "<init>", "()V").return_();
        ClassFile cf = classFileBuilder.build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        DataOutputStream bytecode = new DataOutputStream(baos);
        final StringBuffer buf = new StringBuffer();
        Assembler a = new Assembler(cf, bytecode){

            public void start() {
                buf.append("\n            // === START GENERATED CODE ===\n");
            }

            public void end() {
                buf.append("            // === END GENERATED CODE ===\n");
            }

            public void write(String method, Object data) {
                if ("\"className\"".equals(data)) {
                    data = "className";
                } else if ("\"parentClassName\"".equals(data)) {
                    data = "parentClassName";
                } else if ("\"interfaceName\"".equals(data)) {
                    data = "interfaceName";
                } else if ("\"interfaceType\"".equals(data)) {
                    data = "interfaceType";
                } else if ("\"singletonName\"".equals(data)) {
                    data = "singletonName";
                }
                buf.append("            bytecode." + method + "(" + data + ");\n");
            }
        };
        a.assemble();
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, new HexDumper(cf).dump());
        return buf.toString();
    }

    static {
        TYPES.add(ByteCodeSpec.class.getCanonicalName());
    }
}

