/*
 * Decompiled with CFR 0.152.
 */
package com.calumma.backend.web.repository.core;

import com.calumma.backend.model.entity.CalummaEntity;
import com.calumma.backend.model.request.ParsedRequest;
import com.calumma.backend.web.repository.core.aggregation.CoreEntityGrouper;
import com.calumma.backend.web.repository.core.aggregation.CoreEntityHaving;
import com.calumma.backend.web.repository.core.projections.CoreEntityProjectionBuilder;
import com.calumma.backend.web.repository.core.symbol.ProjectionField;
import com.calumma.backend.web.repository.core.symbol.ResponseParser;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.stereotype.Repository;

@Repository
public class DynamicQueryRepository<Entity extends CalummaEntity> {
    private EntityManager entityManager;
    private final CriteriaBuilder criteriaBuilder;

    @Autowired
    public DynamicQueryRepository(EntityManager entityManager) {
        this.criteriaBuilder = entityManager.getCriteriaBuilder();
        this.entityManager = entityManager;
    }

    public Page queryBy(Class<Entity> entityClass, Specification filters, ParsedRequest parsedRequest) throws NoSuchFieldException, ParseException, IllegalAccessException {
        CriteriaQuery query = this.criteriaBuilder.createQuery();
        Root root = query.from(entityClass);
        Page response = null;
        CoreEntityGrouper coreEntityGrouper = new CoreEntityGrouper(root, entityClass);
        CoreEntityHaving coreEntityHaving = new CoreEntityHaving(root, entityClass, this.criteriaBuilder);
        CoreEntityProjectionBuilder projectionBuilder = new CoreEntityProjectionBuilder(root, entityClass, this.criteriaBuilder);
        query = this.applyRestrictionConditions(root, filters, query);
        query = this.applySelectionFields(projectionBuilder, entityClass, root, parsedRequest.getProjections(), query);
        query.orderBy(QueryUtils.toOrders((Sort)parsedRequest.getPageable().getSort(), (From)root, (CriteriaBuilder)this.criteriaBuilder));
        query = coreEntityGrouper.getGroupByClause(parsedRequest.getGroupBy(), query);
        query = coreEntityHaving.getHavingClause(parsedRequest.getAggregationFilters(), query);
        List result = this.entityManager.createQuery(query).setMaxResults(parsedRequest.getPageable().getPageSize()).setFirstResult((int)parsedRequest.getPageable().getOffset()).getResultList();
        ResponseParser parser = new ResponseParser(parsedRequest.getNotEagerProjections(), result);
        List<Map<String, Object>> responseMap = parser.getFormattedResponseDictionary().getResponse();
        parser.setResponse(this.queryEagerAttributes(entityClass, projectionBuilder.getEagerSelections(), responseMap));
        response = parser.getFormattedResponse(parsedRequest.getPageable(), this.countQuery(entityClass, filters));
        return response;
    }

    public List<Map<String, Object>> queryEagerAttributes(Class<Entity> entityClass, List<ProjectionField> eagerQueries, List<Map<String, Object>> response) throws NoSuchFieldException, IllegalAccessException {
        List rootIds = response.stream().map(x -> (Long)x.get("id")).collect(Collectors.toList());
        for (ProjectionField eagerQueryProjections : eagerQueries) {
            CriteriaQuery eagerQuery = this.criteriaBuilder.createQuery();
            Root root = eagerQuery.from(entityClass);
            root.get("id").in((Collection)rootIds.stream().map(x -> x).collect(Collectors.toList()));
            CoreEntityProjectionBuilder projectionBuilder = new CoreEntityProjectionBuilder(root, entityClass, this.criteriaBuilder);
            eagerQuery = this.applySelectionFields(projectionBuilder, entityClass, root, this.getEagerQueryProjections(eagerQueryProjections.getNameField()), eagerQuery);
            List result = this.entityManager.createQuery(eagerQuery).getResultList();
            ResponseParser parser = new ResponseParser(this.getEagerQueryProjections(eagerQueryProjections.getNameField()), result);
            List<Map<String, Object>> responseMap = parser.getFormattedResponseDictionary().getResponse();
            for (Map<String, Object> globalResponse : response) {
                Long id = (Long)globalResponse.get("id");
                globalResponse.put(eagerQueryProjections.getAlias(), new ArrayList());
                for (Map<String, Object> localResponse : responseMap) {
                    Long localId = (Long)localResponse.get("id");
                    if (localId == null || !localId.equals(id)) continue;
                    List local = (List)globalResponse.get(eagerQueryProjections.getAlias());
                    localResponse.remove("id");
                    local.add(localResponse);
                }
            }
        }
        return response;
    }

    private CriteriaQuery applySelectionFields(CoreEntityProjectionBuilder projectionBuilder, Class<Entity> entityClass, Root root, List<ProjectionField> projections, CriteriaQuery query) throws NoSuchFieldException, IllegalAccessException {
        if (projections != null && projections.size() > 0) {
            projections.forEach(projectionBuilder::with);
            List<Selection> selects = projectionBuilder.build();
            if (!selects.isEmpty()) {
                query.multiselect(selects.toArray(new Selection[0]));
            } else {
                query.multiselect(new Selection[]{root});
            }
        } else {
            query.multiselect(new Selection[]{root});
        }
        return query;
    }

    private CriteriaQuery applyRestrictionConditions(Root root, Specification filters, CriteriaQuery query) {
        if (filters != null) {
            Predicate[] predicates = new Predicate[]{filters.toPredicate(root, query, this.criteriaBuilder)};
            query.where(predicates);
        }
        return query;
    }

    private long countQuery(Class<Entity> entityClass, Specification filters) throws NoSuchFieldException {
        CriteriaQuery query = this.criteriaBuilder.createQuery(Long.class);
        Root root = query.from(entityClass);
        query.select((Selection)this.criteriaBuilder.count((Expression)root));
        query = this.applyRestrictionConditions(root, filters, query);
        Object response = this.entityManager.createQuery(query).getSingleResult();
        return (Long)response;
    }

    private List<ProjectionField> getEagerQueryProjections(String eager) {
        String[] projections = (eager.replaceAll(";", ",") + ",id").split(",");
        ArrayList<ProjectionField> result = new ArrayList<ProjectionField>();
        Arrays.stream(projections).forEach(x -> {
            if (x.contains(".")) {
                String[] fields = x.split("\\.");
                String alias = fields[fields.length - 1];
                result.add(new ProjectionField((String)x, alias));
            } else {
                result.add(new ProjectionField((String)x, (String)x));
            }
        });
        return result;
    }
}

