/*
 * Decompiled with CFR 0.152.
 */
package com.calumma.backend.web.repository.core.aggregation;

import com.calumma.backend.model.entity.CalummaEntity;
import com.calumma.backend.web.repository.core.symbol.FieldParser;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;

public class CoreEntityGrouper<Entity extends CalummaEntity> {
    private Root<Entity> root;
    private Class entityType;

    public CoreEntityGrouper(Root<Entity> root, Class entityType) {
        this.root = root;
        this.entityType = entityType;
    }

    private List<Expression> toSelection(List<String> groupBy) throws NoSuchFieldException {
        ArrayList<Expression> groupExpressions = new ArrayList<Expression>();
        for (String groupField : groupBy) {
            From query = FieldParser.joinOrGetJoinedExpression(this.root, this.entityType, groupField);
            Path expression = query.get(FieldParser.getColumnName(groupField));
            expression.alias(groupField);
            groupExpressions.add((Expression)expression);
        }
        return groupExpressions;
    }

    public CriteriaQuery getGroupByClause(List<String> groupBy, CriteriaQuery query) throws NoSuchFieldException {
        if (groupBy != null) {
            List<Expression> groupByClauseExpression = this.toSelection(groupBy);
            return query.groupBy(groupByClauseExpression);
        }
        return query;
    }
}

