/*
 * Decompiled with CFR 0.152.
 */
package com.calumma.backend.web.service;

import com.calumma.backend.exception.ForbiddenException;
import com.calumma.backend.model.entity.CalummaEntity;
import com.calumma.backend.model.request.ParsedRequest;
import com.calumma.backend.web.repository.BaseRepository;
import com.calumma.backend.web.repository.core.DynamicQueryRepository;
import com.calumma.backend.web.repository.core.restrictions.CoreEntitySpecificationBuilder;
import com.calumma.backend.web.repository.core.symbol.SearchCriteria;
import com.calumma.backend.web.repository.core.symbol.SearchOperation;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.jpa.domain.Specification;

public abstract class BaseService<Entity extends CalummaEntity, T> {
    private DynamicQueryRepository dynamicQueryRepository;

    protected abstract BaseRepository<Entity, T> getRepository();

    protected abstract Class getBaseEntityType();

    protected abstract boolean userHasAccessToData(Entity var1);

    protected abstract Entity setUserSignature(Entity var1);

    protected abstract SearchCriteria getFilterUserRestriction();

    protected abstract boolean userNeedsReadPermission();

    public Entity getById(Long id) throws Throwable {
        CalummaEntity entity = (CalummaEntity)this.getRepository().findByIdAndIsDeletedFalse(id).orElseThrow(() -> new RuntimeException("No entity found with id: " + id));
        if (this.userHasAccessToData(entity) || !this.userNeedsReadPermission()) {
            return (Entity)entity;
        }
        throw new ForbiddenException();
    }

    public Entity insert(Entity entity) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        System.out.println(objectMapper.writeValueAsString(entity));
        ((CalummaEntity)entity).setInsertDate(Calendar.getInstance());
        entity = this.setUserSignature(entity);
        return (Entity)((CalummaEntity)this.getRepository().save(entity));
    }

    public Entity update(Entity entity) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        this.getRepository().flush();
        CalummaEntity dbEntity = (CalummaEntity)this.getRepository().findById(((CalummaEntity)entity).getId()).get();
        if (this.userHasAccessToData(entity)) {
            ObjectReader updater = objectMapper.readerForUpdating((Object)dbEntity);
            CalummaEntity merged = (CalummaEntity)updater.readValue(objectMapper.writeValueAsString(entity));
            return (Entity)((CalummaEntity)this.getRepository().save(merged));
        }
        throw new ForbiddenException();
    }

    public void delete(T id) throws ForbiddenException {
        CalummaEntity toDelete = (CalummaEntity)this.getRepository().getOne(id);
        if (!this.userHasAccessToData(toDelete)) {
            throw new ForbiddenException();
        }
        toDelete.setDeletionDate(Calendar.getInstance());
        toDelete.setDeleted(true);
        this.getRepository().save(toDelete);
    }

    public Page<Entity> list(ParsedRequest parsedRequest) {
        Specification<Entity> specifications = this.parseUrlToExpressions(parsedRequest.getFilters());
        return this.getRepository().findAll(specifications, parsedRequest.getPageable());
    }

    public Page<Entity> query(ParsedRequest parsedRequest) throws NoSuchFieldException, ParseException, IllegalAccessException {
        Specification<Entity> specifications = this.parseUrlToExpressions(parsedRequest.getFilters());
        return this.dynamicQueryRepository.queryBy(this.getBaseEntityType(), specifications, parsedRequest);
    }

    private Specification<Entity> parseUrlToExpressions(List<SearchCriteria> filters) {
        CoreEntitySpecificationBuilder skeepEntitySpecificationBuilder = new CoreEntitySpecificationBuilder(this.getBaseEntityType());
        if (filters != null && !filters.isEmpty()) {
            filters.forEach(skeepEntitySpecificationBuilder::with);
        }
        skeepEntitySpecificationBuilder.with(new SearchCriteria<Boolean>("isDeleted", false, SearchOperation.EQUALITY));
        if (this.userNeedsReadPermission()) {
            skeepEntitySpecificationBuilder.with(this.getFilterUserRestriction());
        }
        return skeepEntitySpecificationBuilder.build();
    }

    @Autowired
    public void setDynamicQueryRepository(DynamicQueryRepository dynamicQueryRepository) {
        this.dynamicQueryRepository = dynamicQueryRepository;
    }
}

