/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.rest.repository.core.symbol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import ml.calumma.rest.repository.core.symbol.ProjectionField;
import ml.calumma.rest.repository.core.symbol.SearchOperation;

public class SearchCriteria<T extends Comparable<T>> {
    private ProjectionField key;
    private T value;
    private SearchOperation operation;

    public SearchCriteria(String filter) {
        String[] filters = filter.split("__");
        if (filters.length != 3) {
            throw new RuntimeException("Filter with bad formation => " + filter);
        }
        this.key = new ProjectionField(filters[0]);
        this.operation = SearchOperation.getSimpleOperation(filters[1]);
        this.value = filters[2];
    }

    public SearchCriteria(String key, T value, SearchOperation operation) {
        this.key = new ProjectionField(key);
        this.value = value;
        this.operation = operation;
    }

    public SearchCriteria(ProjectionField key, String value, SearchOperation operation) {
        this.key = key;
        this.value = value;
        this.operation = operation;
    }

    public T getValueGeneric(Object type) {
        return null;
    }

    public String getKeyName() {
        return this.key.getNameField();
    }

    @JsonIgnore
    public ProjectionField getKey() {
        return this.key;
    }

    public void setKey(ProjectionField key) {
        this.key = key;
    }

    public T getValue() {
        return this.value;
    }

    public Comparable getParsedValue(String typeOfColumn) throws ParseException {
        SimpleDateFormat formatFullDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        SimpleDateFormat formatWithoutHour = new SimpleDateFormat("yyyy-MM-dd");
        switch (typeOfColumn) {
            case "long": {
                return Float.valueOf(Float.parseFloat((String)this.value));
            }
            case "int": {
                return Integer.valueOf(Integer.parseInt((String)this.value));
            }
            case "boolean": {
                return Boolean.valueOf("true".equals(this.value));
            }
            case "Date": {
                try {
                    return formatFullDate.parse((String)this.value);
                }
                catch (Exception e) {
                    return formatWithoutHour.parse((String)this.value);
                }
            }
            case "java.util.Calendar": {
                Calendar calendar = Calendar.getInstance();
                try {
                    calendar.setTime(formatFullDate.parse((String)this.value));
                    return calendar;
                }
                catch (Exception e) {
                    calendar.setTime(formatWithoutHour.parse((String)this.value));
                    return calendar;
                }
            }
        }
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public SearchOperation getOperation() {
        return this.operation;
    }

    public void setOperation(SearchOperation operation) {
        this.operation = operation;
    }
}

