/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.rest.repository.core.symbol;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import ml.calumma.rest.repository.core.symbol.ParsedField;

public class FieldParser {
    public static ParsedField parseField(Class actualLayer, String fieldName) throws NoSuchFieldException {
        return new ParsedField(FieldParser.getColumnName(fieldName), FieldParser.getTypeOfColumn(actualLayer, fieldName));
    }

    public static Type getTypeOfColumn(Class actualLayer, String fieldName) throws NoSuchFieldException {
        String[] joins = FieldParser.getJoinTables(fieldName);
        String columnName = FieldParser.getColumnName(fieldName);
        String[] present_fields = (String[])Arrays.stream(actualLayer.getDeclaredFields()).map(Field::getName).toArray(String[]::new);
        if (joins != null) {
            for (String join : joins) {
                Field potentialLayer = null;
                potentialLayer = Arrays.asList(present_fields).contains(join) ? actualLayer.getDeclaredField(join) : (FieldParser.getSuperClassField(actualLayer, join) != null ? FieldParser.getSuperClassField(actualLayer, join) : FieldParser.getSuperClassField(actualLayer, columnName));
                if (potentialLayer.getType().getTypeName().equals("java.util.List")) {
                    ParameterizedType stringListType = (ParameterizedType)potentialLayer.getGenericType();
                    actualLayer = (Class)stringListType.getActualTypeArguments()[0];
                } else if (potentialLayer.getType().getAnnotation(Entity.class) != null) {
                    actualLayer = potentialLayer.getType();
                }
                present_fields = (String[])Arrays.stream(actualLayer.getDeclaredFields()).map(Field::getName).toArray(String[]::new);
            }
        }
        if (!Arrays.stream(present_fields).anyMatch(columnName::equals)) {
            return FieldParser.getSuperClassField(actualLayer, columnName).getType();
        }
        if (actualLayer.getDeclaredField(columnName).getType().getTypeName().equals("java.util.List")) {
            ParameterizedType stringListType = (ParameterizedType)actualLayer.getDeclaredField(columnName).getGenericType();
            return (Class)stringListType.getActualTypeArguments()[0];
        }
        return actualLayer.getDeclaredField(columnName).getType();
    }

    private static Field getSuperClassField(Class actualLayer, String columnName) throws NoSuchFieldException {
        Class nextLayer = actualLayer;
        String[] present_fields = (String[])Arrays.stream(actualLayer.getDeclaredFields()).map(x -> x.getName()).toArray(String[]::new);
        while (nextLayer != null) {
            if (Arrays.stream(present_fields).anyMatch(columnName::equals)) break;
            if ((nextLayer = nextLayer.getSuperclass()) != Object.class) {
                actualLayer = nextLayer;
            }
            present_fields = (String[])Arrays.stream(actualLayer.getDeclaredFields()).map(x -> x.getName()).toArray(String[]::new);
        }
        return actualLayer.getDeclaredField(columnName);
    }

    public static From joinOrGetJoinedExpression(Root root, Class rootEntity, String fieldPath) throws NoSuchFieldException {
        Root query = root;
        Set joinSet = root.getJoins();
        String[] joinTables = FieldParser.getJoinTables(fieldPath);
        String columnName = FieldParser.getColumnName(fieldPath);
        boolean canAlreadyBeJoined = true;
        Class layerEntity = rootEntity;
        if (joinTables != null && joinTables.length > 0) {
            for (String join : joinTables) {
                Class potentialJoin = FieldParser.getFieldType(layerEntity, join);
                if (canAlreadyBeJoined) {
                    From potentialQuery = FieldParser.getJoinedFromIfExists(joinSet, potentialJoin, join);
                    if (potentialQuery == null) {
                        canAlreadyBeJoined = false;
                    } else {
                        query = potentialQuery;
                        layerEntity = potentialJoin;
                        joinSet = query.getJoins();
                    }
                }
                if (canAlreadyBeJoined) continue;
                query = query.join(join, JoinType.LEFT);
                query.alias(join);
                layerEntity = potentialJoin;
            }
        }
        return query;
    }

    private static Class getFieldType(Class layerEntity, String join) throws NoSuchFieldException {
        String[] present_fields = (String[])Arrays.stream(layerEntity.getDeclaredFields()).map(x -> x.getName()).toArray(String[]::new);
        Field potentialJoin = null;
        potentialJoin = Arrays.stream(present_fields).anyMatch(join::equals) ? layerEntity.getDeclaredField(join) : FieldParser.getSuperClassField(layerEntity, join);
        Class potentialJoinClass = potentialJoin.getType();
        if (potentialJoin.getType().getTypeName().equals("java.util.List")) {
            ParameterizedType stringListType = (ParameterizedType)potentialJoin.getGenericType();
            potentialJoinClass = (Class)stringListType.getActualTypeArguments()[0];
        }
        return potentialJoinClass;
    }

    private static From getJoinedFromIfExists(Set<Join> joinSet, Class potentialJoin, String columnName) {
        Join query = null;
        for (Join joinedTable : joinSet) {
            if (!joinedTable.getJavaType().equals(potentialJoin) || !joinedTable.getAlias().equals(columnName)) continue;
            query = joinedTable;
        }
        return query;
    }

    public static String getColumnName(String name) {
        String[] pathToColumnName = name.split("\\.");
        return pathToColumnName[pathToColumnName.length - 1];
    }

    public static String[] getJoinTables(String name) {
        String[] pathToColumnName = name.split("\\.");
        if (pathToColumnName.length < 2) {
            return null;
        }
        return Arrays.copyOf(pathToColumnName, pathToColumnName.length - 1);
    }
}

