/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.web.model.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import ml.calumma.web.exception.NotAcceptableParametersException;
import ml.calumma.web.model.request.ClientRequest;
import ml.calumma.web.model.request.RequestError;
import ml.calumma.web.model.request.RequestQueryConfig;
import ml.calumma.web.web.repository.core.symbol.ProjectionField;
import ml.calumma.web.web.repository.core.symbol.ProjectionType;
import ml.calumma.web.web.repository.core.symbol.SearchCriteria;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class ParsedRequest {
    @JsonIgnore
    private List<RequestQueryConfig> requestQueryConfigs;
    private List<ProjectionField> projections;
    private List<SearchCriteria> filters;
    private List<String> groupBy;
    private Pageable pageable;

    public ParsedRequest(List<ProjectionField> projections, List<SearchCriteria> filters) {
        this.projections = projections;
        this.filters = filters;
    }

    public ParsedRequest(List<RequestQueryConfig> requestQueryConfigs) {
        this.groupBy = new ArrayList<String>();
        this.filters = new ArrayList<SearchCriteria>();
        this.projections = new ArrayList<ProjectionField>();
        this.requestQueryConfigs = requestQueryConfigs;
    }

    private String findFieldNameByAlias(String alias) {
        Optional<String> potentialField = this.requestQueryConfigs.stream().filter(x -> x.getProjection().equals(alias)).map(RequestQueryConfig::getFieldName).findFirst();
        if (potentialField.isPresent()) {
            return potentialField.get();
        }
        return alias;
    }

    public void buildRequest(String projections, String filters, Pageable pageable) throws NotAcceptableParametersException {
        ParsedRequest potentialErrors;
        this.pageable = pageable;
        if (projections != null && !projections.isEmpty() && !projections.isBlank()) {
            Arrays.asList(projections.split(",")).forEach(projection -> {
                ProjectionField projectionField = new ProjectionField(this.findFieldNameByAlias((String)projection), (String)projection);
                this.projections.add(projectionField);
                if (projectionField.getProjectionType() == ProjectionType.SIMPLE) {
                    this.groupBy.add(projectionField.getNameField());
                }
            });
        }
        if (filters != null && !filters.isEmpty() && !filters.isBlank()) {
            for (String filter : filters.split(" and ")) {
                SearchCriteria searchCriteria = new SearchCriteria(filter);
                ProjectionField field = searchCriteria.getKey();
                field.setAlias(field.getNameField());
                field.setNameField(this.findFieldNameByAlias(field.getNameField()));
                searchCriteria.setKey(field);
                this.filters.add(searchCriteria);
            }
        }
        if ((potentialErrors = this.findRequestErrors()) != null && (potentialErrors.projections.size() > 0 || potentialErrors.filters.size() > 0)) {
            throw new NotAcceptableParametersException(new RequestError(potentialErrors.projections, potentialErrors.filters));
        }
    }

    public void buildRequest(ClientRequest clientRequest) {
        this.projections = new ArrayList<ProjectionField>();
        if (clientRequest.getFilters() != null) {
            this.filters = clientRequest.getFilters().stream().map(x -> new SearchCriteria(new ProjectionField(this.findFieldNameByAlias(x.getField()), x.getField()), x.getValue(), x.getOperation())).collect(Collectors.toList());
        }
        if (clientRequest.getProjections() != null) {
            clientRequest.getProjections().forEach(projection -> this.projections.add(new ProjectionField(this.findFieldNameByAlias((String)projection), (String)projection)));
        }
        this.pageable = clientRequest.getPageRequest() != null ? clientRequest.getPageRequest() : PageRequest.of((int)0, (int)20);
    }

    public void buildRequest(String filters, Pageable pageable) {
        this.pageable = pageable;
        if (filters != null && !filters.isEmpty() && !filters.isBlank()) {
            this.filters = new ArrayList<SearchCriteria>();
            Arrays.stream(filters.split(" and ")).filter(filter -> !ProjectionField.isAggregation(filter)).forEach(filter -> this.filters.add(new SearchCriteria((String)filter)));
        }
    }

    public ParsedRequest findRequestErrors() {
        List invalidFilters = new ArrayList<SearchCriteria>();
        List<ProjectionField> invalidProjections = new ArrayList<ProjectionField>();
        if (this.projections != null) {
            invalidProjections = this.projections.stream().filter(projectionField -> this.requestQueryConfigs.stream().map(RequestQueryConfig::getProjection).noneMatch(x -> x.equals(projectionField.getAlias()))).collect(Collectors.toList());
        }
        if (this.filters != null) {
            invalidFilters = this.filters.stream().filter(searchCriteria -> this.requestQueryConfigs.stream().noneMatch(config -> config.getAllowedOperations().contains((Object)searchCriteria.getOperation()) && config.getProjection().equals(searchCriteria.getKey().getAlias()))).collect(Collectors.toList());
        }
        if (invalidFilters.size() > 0 || invalidProjections.size() > 0) {
            return new ParsedRequest(invalidProjections, invalidFilters);
        }
        return null;
    }

    public List<ProjectionField> getProjections() {
        return this.projections;
    }

    public List<ProjectionField> getNotEagerProjections() {
        return this.projections.stream().filter(x -> !x.getProjectionType().equals((Object)ProjectionType.EAGER)).collect(Collectors.toList());
    }

    public ParsedRequest setProjections(List<ProjectionField> projections) {
        this.projections = projections;
        return this;
    }

    public List<SearchCriteria> getFilters() {
        if (this.filters == null) {
            return null;
        }
        return this.filters.stream().filter(filter -> filter.getKey().getProjectionType() == ProjectionType.SIMPLE).collect(Collectors.toList());
    }

    public ParsedRequest setFilters(List<SearchCriteria> filters) {
        this.filters = filters;
        return this;
    }

    @JsonIgnore
    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public ParsedRequest setGroupBy(List<String> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @JsonIgnore
    public Pageable getPageable() {
        return this.pageable;
    }

    public ParsedRequest setPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public List<SearchCriteria> getAggregationFilters() {
        if (this.filters == null) {
            return null;
        }
        return this.filters.stream().filter(filter -> filter.getKey().getProjectionType() != ProjectionType.SIMPLE).collect(Collectors.toList());
    }
}

