/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.web.web.controller;

import java.util.List;
import ml.calumma.web.exception.ForbiddenException;
import ml.calumma.web.model.entity.CalummaEntity;
import ml.calumma.web.model.request.ClientRequest;
import ml.calumma.web.model.request.ParsedRequest;
import ml.calumma.web.model.request.RequestQueryConfig;
import ml.calumma.web.web.service.BaseService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public abstract class BaseController<Entity extends CalummaEntity, T> {
    public abstract BaseService<Entity, T> getService();

    public abstract List<RequestQueryConfig> getQueryRequestConfiguration();

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Entity getById(@PathVariable(value="id") Long id) throws Throwable {
        return this.getService().getById(id);
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Page<Entity> getList(@RequestParam(required=false) String filters, Pageable pageInfo) {
        ParsedRequest parsedRequest = new ParsedRequest(this.getQueryRequestConfiguration());
        parsedRequest.buildRequest(filters, pageInfo);
        return this.getService().list(parsedRequest);
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.GET})
    public Page<Entity> queryEntity(@RequestParam(required=false) String filters, @RequestParam(required=false) String projection, Pageable pageInfo) throws Throwable {
        ParsedRequest parsedRequest = new ParsedRequest(this.getQueryRequestConfiguration());
        parsedRequest.buildRequest(projection, filters, pageInfo);
        return this.getService().query(parsedRequest);
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    public Page<Entity> queryEntityPost(@RequestBody ClientRequest clientRequest) throws Throwable {
        ParsedRequest parsedRequest = new ParsedRequest(this.getQueryRequestConfiguration());
        parsedRequest.buildRequest(clientRequest);
        return this.getService().query(parsedRequest);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST})
    public Entity create(@RequestBody Entity entity) throws Exception {
        return this.getService().insert(entity);
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT})
    public Entity update(@RequestBody Entity entity) throws Exception {
        return this.getService().update(entity);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable(value="id") T id) throws ForbiddenException {
        this.getService().delete(id);
    }
}

