/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.web.web.repository.core.aggregation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import ml.calumma.web.model.entity.CalummaEntity;
import ml.calumma.web.web.repository.core.symbol.FieldParser;
import ml.calumma.web.web.repository.core.symbol.ParsedField;
import ml.calumma.web.web.repository.core.symbol.ProjectionField;
import ml.calumma.web.web.repository.core.symbol.ProjectionType;
import ml.calumma.web.web.repository.core.symbol.SearchCriteria;

public class CoreEntityHaving<Entity extends CalummaEntity> {
    private Root<Entity> root;
    private Class entityType;
    private final CriteriaBuilder criteriaBuilder;

    public CoreEntityHaving(Root<Entity> root, Class entityType, CriteriaBuilder criteriaBuilder) {
        this.root = root;
        this.entityType = entityType;
        this.criteriaBuilder = criteriaBuilder;
    }

    private List<Predicate> toSelection(List<SearchCriteria> aggregationFilters) throws NoSuchFieldException, ParseException {
        ArrayList<Predicate> groupExpressions = new ArrayList<Predicate>();
        block6: for (SearchCriteria searchCriteria : aggregationFilters) {
            ParsedField field = FieldParser.parseField(this.entityType, searchCriteria.getKey().getNameField());
            switch (searchCriteria.getOperation()) {
                case EQUALITY: {
                    groupExpressions.add(this.criteriaBuilder.equal(this.getAggregateExpression(searchCriteria.getKey()), (Object)searchCriteria.getParsedValue(field.getFieldTypeName())));
                    continue block6;
                }
                case NEGATION: {
                    groupExpressions.add(this.criteriaBuilder.notEqual(this.getAggregateExpression(searchCriteria.getKey()), (Object)searchCriteria.getParsedValue(field.getFieldTypeName())));
                    continue block6;
                }
                case GREATER_THAN: {
                    groupExpressions.add(this.criteriaBuilder.greaterThan(this.getAggregateExpression(searchCriteria.getKey()), searchCriteria.getParsedValue(field.getFieldTypeName())));
                    continue block6;
                }
                case LESS_THAN: {
                    groupExpressions.add(this.criteriaBuilder.lessThan(this.getAggregateExpression(searchCriteria.getKey()), searchCriteria.getParsedValue(field.getFieldTypeName())));
                    continue block6;
                }
            }
            throw new RuntimeException("Comparator not allowed");
        }
        return groupExpressions;
    }

    public Expression getAggregateExpression(ProjectionField projection) throws NoSuchFieldException {
        ParsedField filter = FieldParser.parseField(this.entityType, projection.getNameField());
        From query = FieldParser.joinOrGetJoinedExpression(this.root, this.entityType, projection.getNameField());
        Path expression = query.get(filter.getFieldName());
        expression.alias(projection.getNameField());
        if (projection.getProjectionType() == ProjectionType.AVERAGE) {
            expression = this.criteriaBuilder.avg((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.SUM) {
            expression = this.criteriaBuilder.sum((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.COUNT) {
            expression = this.criteriaBuilder.count((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.DISTINCT_COUNT) {
            expression = this.criteriaBuilder.countDistinct((Expression)expression);
        }
        return expression;
    }

    public CriteriaQuery getHavingClause(List<SearchCriteria> filters, CriteriaQuery query) throws NoSuchFieldException, ParseException {
        if (filters != null && filters.size() > 0) {
            List<Predicate> havingClausePredicates = this.toSelection(filters);
            havingClausePredicates.forEach(arg_0 -> ((CriteriaQuery)query).having(arg_0));
            return query;
        }
        return query;
    }
}

