/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.web.web.repository.core.projections;

import java.lang.reflect.Type;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import ml.calumma.web.model.entity.CalummaEntity;
import ml.calumma.web.web.repository.core.symbol.FieldParser;
import ml.calumma.web.web.repository.core.symbol.ParsedField;
import ml.calumma.web.web.repository.core.symbol.ProjectionField;
import ml.calumma.web.web.repository.core.symbol.ProjectionType;

public class CoreEntityProjection<Entity extends CalummaEntity> {
    private Class rootEntity;
    private Root<Entity> root;
    private CriteriaBuilder criteriaBuilder;

    CoreEntityProjection(Root<Entity> root, Class rootEntity, CriteriaBuilder criteriaBuilder) {
        this.root = root;
        this.rootEntity = rootEntity;
        this.criteriaBuilder = criteriaBuilder;
    }

    public Expression toSelection(ProjectionField projection) throws NoSuchFieldException {
        ParsedField filter = FieldParser.parseField(this.rootEntity, projection.getNameField());
        From query = FieldParser.joinOrGetJoinedExpression(this.root, this.rootEntity, projection.getNameField());
        Type field = FieldParser.getTypeOfColumn(this.rootEntity, projection.getNameField());
        Path expression = query.get(filter.getFieldName());
        if (CalummaEntity.class.isAssignableFrom((Class)field)) {
            expression = query.join(filter.getFieldName(), JoinType.LEFT);
        }
        if (CalummaEntity.class.isAssignableFrom((Class)FieldParser.getTypeOfColumn(this.rootEntity, projection.getNameField()))) {
            expression = query.join(filter.getFieldName());
        }
        if (projection.getProjectionType() == ProjectionType.AVERAGE) {
            expression = this.criteriaBuilder.avg((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.SUM) {
            expression = this.criteriaBuilder.sum((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.COUNT) {
            expression = this.criteriaBuilder.count((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.DISTINCT_COUNT) {
            expression = this.criteriaBuilder.countDistinct((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.MAX) {
            expression = this.criteriaBuilder.max((Expression)expression);
        }
        if (projection.getProjectionType() == ProjectionType.MIN) {
            expression = this.criteriaBuilder.min((Expression)expression);
        }
        return expression;
    }
}

