/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.web.web.repository.core.restrictions;

import java.text.ParseException;
import java.util.Calendar;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import ml.calumma.web.model.entity.CalummaEntity;
import ml.calumma.web.web.repository.core.symbol.FieldParser;
import ml.calumma.web.web.repository.core.symbol.ParsedField;
import ml.calumma.web.web.repository.core.symbol.SearchCriteria;
import org.springframework.data.jpa.domain.Specification;

public class CoreEntitySpecification<Entity extends CalummaEntity>
implements Specification<Entity> {
    private SearchCriteria searchCriteria;
    private Class rootEntity;

    CoreEntitySpecification(SearchCriteria searchCriteria, Class rootEntity) {
        this.searchCriteria = searchCriteria;
        this.rootEntity = rootEntity;
    }

    public Predicate toPredicate(Root<Entity> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        try {
            ParsedField field = FieldParser.parseField(this.rootEntity, this.searchCriteria.getKey().getNameField());
            String columnName = field.getFieldName();
            From query = FieldParser.joinOrGetJoinedExpression(root, this.rootEntity, this.searchCriteria.getKey().getNameField());
            String typeOfColumn = field.getFieldTypeName();
            switch (this.searchCriteria.getOperation()) {
                case EQUALITY: {
                    return criteriaBuilder.equal((Expression)query.get(columnName), (Object)this.searchCriteria.getParsedValue(typeOfColumn));
                }
                case NEGATION: {
                    return criteriaBuilder.notEqual((Expression)query.get(columnName), (Object)this.searchCriteria.getParsedValue(typeOfColumn));
                }
                case GREATER_THAN: {
                    return criteriaBuilder.greaterThan((Expression)query.get(columnName), this.searchCriteria.getParsedValue(typeOfColumn));
                }
                case LESS_THAN: {
                    return criteriaBuilder.lessThan((Expression)query.get(columnName), this.searchCriteria.getParsedValue(typeOfColumn));
                }
                case LIKE: {
                    Comparable likeField = this.searchCriteria.getParsedValue(typeOfColumn);
                    if (likeField instanceof Calendar) {
                        Calendar startOfDay = (Calendar)this.searchCriteria.getParsedValue(typeOfColumn);
                        Calendar endOfDay = Calendar.getInstance();
                        endOfDay.setTime(startOfDay.getTime());
                        endOfDay.set(11, 23);
                        endOfDay.set(12, 59);
                        endOfDay.set(13, 59);
                        endOfDay.set(14, 999);
                        return criteriaBuilder.between((Expression)query.get(columnName), (Comparable)startOfDay, (Comparable)endOfDay);
                    }
                    return criteriaBuilder.like(criteriaBuilder.lower((Expression)query.get(columnName)), String.format("%%%s%%", this.searchCriteria.getValue()).toLowerCase());
                }
                case IN: {
                    return query.get(columnName).in(new Object[]{this.searchCriteria.getValue()});
                }
            }
            throw new RuntimeException("Comparator not allowed");
        }
        catch (NoSuchFieldException | ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("ERROR");
        }
    }
}

