/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.web.web.repository.core.symbol;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ml.calumma.web.web.repository.core.symbol.ProjectionType;

public class ProjectionField {
    private String nameField;
    private ProjectionType projectionType;
    private String alias;

    public ProjectionField(String field, String alias) {
        this.alias = alias;
        this.initProjection(field);
    }

    public ProjectionField(String field) {
        this.initProjection(field);
    }

    private void initProjection(String field) {
        Matcher patternAvg = Pattern.compile("avg\\((.*?)\\)").matcher(field);
        Matcher patternSum = Pattern.compile("sum\\((.*?)\\)").matcher(field);
        Matcher patternCount = Pattern.compile("count\\((.*?)\\)").matcher(field);
        Matcher patternDistinctCount = Pattern.compile("distinct_count\\((.*?)\\)").matcher(field);
        Matcher min = Pattern.compile("min\\((.*?)\\)").matcher(field);
        Matcher max = Pattern.compile("max\\((.*?)\\)").matcher(field);
        Matcher eager = Pattern.compile("eager\\((.*?)\\)").matcher(field);
        if (patternAvg.find()) {
            this.nameField = patternAvg.group(1);
            this.projectionType = ProjectionType.AVERAGE;
        } else if (patternSum.find()) {
            this.nameField = patternSum.group(1);
            this.projectionType = ProjectionType.SUM;
        } else if (patternDistinctCount.find()) {
            this.nameField = patternDistinctCount.group(1);
            this.projectionType = ProjectionType.DISTINCT_COUNT;
        } else if (patternCount.find()) {
            this.nameField = patternCount.group(1);
            this.projectionType = ProjectionType.COUNT;
        } else if (eager.find()) {
            this.nameField = eager.group(1);
            this.projectionType = ProjectionType.EAGER;
        } else if (min.find()) {
            this.nameField = min.group(1);
            this.projectionType = ProjectionType.MIN;
        } else if (max.find()) {
            this.nameField = max.group(1);
            this.projectionType = ProjectionType.MAX;
        } else {
            this.nameField = field;
            this.projectionType = ProjectionType.SIMPLE;
        }
    }

    public static boolean isAggregation(String field) {
        Matcher patternAvg = Pattern.compile("avg\\((.*?)\\)").matcher(field);
        Matcher patternSum = Pattern.compile("sum\\((.*?)\\)").matcher(field);
        Matcher patternCount = Pattern.compile("count\\((.*?)\\)").matcher(field);
        Matcher patternDistinctCount = Pattern.compile("distinct_count\\((.*?)\\)").matcher(field);
        return patternAvg.find() || patternSum.find() || patternCount.find() || patternDistinctCount.find();
    }

    public String getNameField() {
        return this.nameField;
    }

    @JsonIgnore
    public ProjectionType getProjectionType() {
        return this.projectionType;
    }

    public void setNameField(String nameField) {
        this.nameField = nameField;
    }

    public void setProjectionType(ProjectionType projectionType) {
        this.projectionType = projectionType;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

