/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.rest.repository.core.restrictions;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.Calendar;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import ml.calumma.model.entity.CalummaEntity;
import ml.calumma.rest.repository.core.symbol.FieldParser;
import ml.calumma.rest.repository.core.symbol.ParsedField;
import ml.calumma.rest.repository.core.symbol.SearchCriteria;
import org.springframework.data.jpa.domain.Specification;

public class CoreEntitySpecification<Entity extends CalummaEntity>
implements Specification<Entity> {
    private SearchCriteria searchCriteria;
    private Class rootEntity;

    CoreEntitySpecification(SearchCriteria searchCriteria, Class rootEntity) {
        this.searchCriteria = searchCriteria;
        this.rootEntity = rootEntity;
    }

    public Predicate toPredicate(Root<Entity> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        try {
            ParsedField field = FieldParser.parseField(this.rootEntity, this.searchCriteria.getKey().getNameField());
            String columnName = field.getFieldName();
            From query = FieldParser.joinOrGetJoinedExpression(root, this.rootEntity, this.searchCriteria.getKey().getNameField());
            String typeOfColumn = field.getFieldTypeName();
            Type type = field.getFieldType();
            switch (this.searchCriteria.getOperation()) {
                case EQUALITY: {
                    return criteriaBuilder.equal((Expression)query.get(columnName), (Object)this.searchCriteria.getParsedValue(type));
                }
                case NEGATION: {
                    return criteriaBuilder.notEqual((Expression)query.get(columnName), (Object)this.searchCriteria.getParsedValue(type));
                }
                case GREATER_THAN: {
                    return criteriaBuilder.greaterThan((Expression)query.get(columnName), this.searchCriteria.getParsedValue(type));
                }
                case LESS_THAN: {
                    return criteriaBuilder.lessThan((Expression)query.get(columnName), this.searchCriteria.getParsedValue(type));
                }
                case LIKE: {
                    Comparable likeField = this.searchCriteria.getParsedValue(type);
                    if (likeField instanceof Calendar) {
                        Calendar startOfDay = (Calendar)this.searchCriteria.getParsedValue(type);
                        Calendar endOfDay = Calendar.getInstance();
                        endOfDay.setTime(startOfDay.getTime());
                        endOfDay.set(11, 23);
                        endOfDay.set(12, 59);
                        endOfDay.set(13, 59);
                        endOfDay.set(14, 999);
                        return criteriaBuilder.between((Expression)query.get(columnName), (Comparable)startOfDay, (Comparable)endOfDay);
                    }
                    return criteriaBuilder.like(criteriaBuilder.lower((Expression)query.get(columnName)), String.format("%%%s%%", this.searchCriteria.getValue()).toLowerCase());
                }
                case IN: {
                    return query.get(columnName).in((Object[])this.searchCriteria.getValue().toString().split(","));
                }
            }
            throw new RuntimeException("Comparator not allowed");
        }
        catch (NoSuchFieldException | ParseException e) {
            e.printStackTrace();
            throw new RuntimeException("ERROR");
        }
    }
}

