/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.rest.repository.core.projections;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import ml.calumma.model.entity.CalummaEntity;
import ml.calumma.rest.repository.core.projections.CoreEntityProjection;
import ml.calumma.rest.repository.core.symbol.ProjectionField;
import ml.calumma.rest.repository.core.symbol.ProjectionType;

public class CoreEntityProjectionBuilder<Entity extends CalummaEntity> {
    private final List<ProjectionField> projections = new ArrayList<ProjectionField>();
    private final Class rootEntity;
    private final CriteriaBuilder criteriaBuilder;
    private Root<Entity> root;

    public CoreEntityProjectionBuilder(Root<Entity> root, Class rootEntity, CriteriaBuilder criteriaBuilder) {
        this.rootEntity = rootEntity;
        this.root = root;
        this.criteriaBuilder = criteriaBuilder;
    }

    public final CoreEntityProjectionBuilder<Entity> with(ProjectionField projectionField) {
        this.projections.add(projectionField);
        return this;
    }

    public List<Selection> build() throws NoSuchFieldException, IllegalAccessException {
        ArrayList<Selection> selections = new ArrayList<Selection>();
        CoreEntityProjection<Entity> projectionMaker = new CoreEntityProjection<Entity>(this.root, this.rootEntity, this.criteriaBuilder);
        List notEagerProjections = this.projections.stream().filter(x -> x.getProjectionType() != ProjectionType.EAGER).collect(Collectors.toList());
        if (notEagerProjections.size() > 0) {
            for (ProjectionField projection : notEagerProjections) {
                selections.add((Selection)projectionMaker.toSelection(projection));
            }
        }
        return selections;
    }

    public List<ProjectionField> getEagerSelections() throws NoSuchFieldException {
        return this.projections.stream().filter(x -> x.getProjectionType() == ProjectionType.EAGER).collect(Collectors.toList());
    }
}

