/*
 * Decompiled with CFR 0.152.
 */
package ml.calumma.rest.repository.core.symbol;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ml.calumma.rest.repository.core.symbol.ProjectionField;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class ResponseParser {
    private List<String> projectionFields;
    private final List<Object> rows;
    private List<Map<String, Object>> response;

    public ResponseParser(List<ProjectionField> projectionFields, List<Object> rows) {
        if (projectionFields != null && projectionFields.size() > 0) {
            this.projectionFields = new ArrayList<String>();
            projectionFields.forEach(projection -> this.projectionFields.add(projection.getAlias()));
        } else {
            this.projectionFields = null;
        }
        this.rows = rows;
        this.response = new ArrayList<Map<String, Object>>();
    }

    public Page getFormattedResponse(Pageable pageable, long total) {
        if (this.projectionFields == null) {
            return this.getFormattedResponseWithoutProjections(pageable, total);
        }
        return this.getFormattedResponseWithProjections(pageable, total);
    }

    public ResponseParser getFormattedResponseDictionary() {
        for (Object row : this.rows) {
            HashMap<String, Object> parsedRow = new HashMap<String, Object>();
            if (this.projectionFields.size() > 1) {
                for (int i = 0; i < this.projectionFields.size(); ++i) {
                    parsedRow.put(this.projectionFields.get(i), ((Object[])row)[i]);
                }
            } else {
                parsedRow.put(this.projectionFields.get(0), row);
            }
            this.response.add(parsedRow);
        }
        return this;
    }

    private Page getFormattedResponseWithProjections(Pageable pageable, long total) {
        PageImpl pagedResponse = new PageImpl(this.response, pageable, total);
        return pagedResponse;
    }

    private Page getFormattedResponseWithoutProjections(Pageable pageable, long total) {
        return new PageImpl(this.rows, pageable, total);
    }

    public List<Map<String, Object>> getResponse() {
        return this.response;
    }

    public void setResponse(List<Map<String, Object>> response) {
        this.response = response;
    }
}

