/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.bundle.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class FileUtil$ {
    public static FileUtil$ MODULE$;
    private final int bufferSize;

    static {
        new FileUtil$();
    }

    private int bufferSize() {
        return this.bufferSize;
    }

    public void rmRf(Path path) {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Tuple2<String, Object>[] rmRF(Path toRemove) {
        if (Files.isDirectory(toRemove, new LinkOption[0])) {
            return (Tuple2[])Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Files.walk(toRemove, new FileVisitOption[0]), (Function1 & Serializable & scala.Serializable)paths -> (Tuple2[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)paths.sorted(Comparator.reverseOrder()).collect(Collectors.toList())).asScala()).map((Function1 & Serializable & scala.Serializable)path -> FileUtil$.removeElement$1(path), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        }
        return (Tuple2[])((Object[])new Tuple2[]{FileUtil$.removeElement$1(toRemove)});
    }

    public void extract(Path source, Path dest) {
        Files.createDirectories(dest, new FileAttribute[0]);
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ZipInputStream(Files.newInputStream(source, new OpenOption[0])), (Function1 & Serializable & scala.Serializable)in -> {
            FileUtil$.MODULE$.extract(in, dest);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void extract(ZipInputStream in, Path dest) {
        Files.createDirectories(dest, new FileAttribute[0]);
        ZipEntry entry = in.getNextEntry();
        while (entry != null) {
            Path path;
            Path filePath = dest.resolve(entry.getName());
            if (entry.isDirectory()) {
                path = Files.createDirectories(filePath, new FileAttribute[0]);
            } else {
                Path destCanonical = dest.toRealPath(new LinkOption[0]);
                Path entryCanonical = filePath.toAbsolutePath().normalize();
                if (!entryCanonical.startsWith(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)destCanonical), FileSystems.getDefault().getSeparator()))) {
                    throw new Exception(new StringBuilder(36).append("Entry is outside of the target dir: ").append(entry.getName()).toString());
                }
                path = Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Files.newOutputStream(filePath, new OpenOption[0]), (Function1 & Serializable & scala.Serializable)out -> {
                    FileUtil$.MODULE$.writeData(in, out);
                    return BoxedUnit.UNIT;
                }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            }
            entry = in.getNextEntry();
        }
    }

    public void zip(Path source, Path dest) {
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new ZipOutputStream(Files.newOutputStream(dest, new OpenOption[0])), (Function1 & Serializable & scala.Serializable)out -> {
            FileUtil$.MODULE$.zip(source, out);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public void zip(Path source, ZipOutputStream dest) {
        this.zip(source, source, dest);
    }

    public void zip(Path base, Path source, ZipOutputStream dest) {
        Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Files.walk(source, new FileVisitOption[0]), (Function1 & Serializable & scala.Serializable)paths -> {
            paths.forEachOrdered(path -> {
                String name = ((Object)base$1.relativize((Path)path)).toString();
                if (!Files.isDirectory(path, new LinkOption[0])) {
                    dest$3.putNextEntry(new ZipEntry(name));
                    Using$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Files.newInputStream(path, new OpenOption[0]), (Function1 & Serializable & scala.Serializable)in -> {
                        FileUtil$.MODULE$.writeData(in, dest$3);
                        return BoxedUnit.UNIT;
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    return;
                }
                dest$3.putNextEntry(new ZipEntry(new StringBuilder(1).append(name).append("/").toString()));
                FileUtil$.MODULE$.zip(base$1, (Path)path, dest$3);
            });
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private void writeData(InputStream in, OutputStream out) {
        byte[] buffer = new byte[this.bufferSize()];
        int len = in.read(buffer);
        while (len > 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
    }

    private static final Tuple2 removeElement$1(Path path) {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> Files.deleteIfExists(path));
        if (try_ instanceof Failure) {
            bl = false;
        } else if (try_ instanceof Success) {
            boolean value;
            Success success = (Success)try_;
            bl = value = BoxesRunTime.unboxToBoolean((Object)success.value());
        } else {
            throw new MatchError((Object)try_);
        }
        boolean result = bl;
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((Object)path.toAbsolutePath()).toString()), (Object)BoxesRunTime.boxToBoolean((boolean)result));
    }

    private FileUtil$() {
        MODULE$ = this;
        this.bufferSize = 0x100000;
    }
}

