/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.avro;

import java.io.Serializable;
import java.nio.charset.Charset;
import ml.combust.mleap.core.types.BasicType;
import ml.combust.mleap.core.types.DataType;
import ml.combust.mleap.core.types.ListType;
import ml.combust.mleap.core.types.ListType$;
import ml.combust.mleap.core.types.ScalarType;
import ml.combust.mleap.core.types.ScalarType$;
import ml.combust.mleap.core.types.StructField;
import ml.combust.mleap.core.types.StructType;
import ml.combust.mleap.core.types.StructType$;
import ml.combust.mleap.core.types.TensorType;
import ml.combust.mleap.core.types.TensorType$;
import ml.combust.mleap.runtime.MleapContext;
import ml.combust.mleap.runtime.MleapContext$;
import ml.combust.mleap.tensor.ByteString;
import ml.combust.mleap.tensor.Tensor$;
import org.apache.avro.Schema;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public final class SchemaConverter$ {
    public static SchemaConverter$ MODULE$;
    private final Schema booleanTensorSchema;
    private final Schema byteTensorSchema;
    private final Schema shortTensorSchema;
    private final Schema integerTensorSchema;
    private final Schema longTensorSchema;
    private final Schema floatTensorSchema;
    private final Schema doubleTensorSchema;
    private final Schema stringTensorSchema;
    private final Schema byteStringTensorSchema;
    private final Charset bytesCharset;
    private final int tensorSchemaDimensionsIndex;
    private final int tensorSchemaValuesIndex;
    private final int tensorSchemaIndicesIndex;
    private final int customSchemaIndex;

    static {
        new SchemaConverter$();
    }

    public <T> Schema tensorSchema(ClassTag<T> evidence$1) {
        Try r = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2;
            Class clazz = package$.MODULE$.classTag(evidence$1).runtimeClass();
            Class clazz2 = Tensor$.MODULE$.BooleanClass();
            Class clazz3 = clazz;
            if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                tuple2 = new Tuple2((Object)"Boolean", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.BOOLEAN)));
            } else {
                Class clazz4 = Tensor$.MODULE$.ByteClass();
                Class clazz5 = clazz;
                if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                    tuple2 = new Tuple2((Object)"Byte", (Object)Schema.create((Schema.Type)Schema.Type.BYTES));
                } else {
                    Class clazz6 = Tensor$.MODULE$.ShortClass();
                    Class clazz7 = clazz;
                    if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                        tuple2 = new Tuple2((Object)"Short", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)));
                    } else {
                        Class clazz8 = Tensor$.MODULE$.IntClass();
                        Class clazz9 = clazz;
                        if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                            tuple2 = new Tuple2((Object)"Int", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)));
                        } else {
                            Class clazz10 = Tensor$.MODULE$.LongClass();
                            Class clazz11 = clazz;
                            if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                                tuple2 = new Tuple2((Object)"Long", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.LONG)));
                            } else {
                                Class clazz12 = Tensor$.MODULE$.FloatClass();
                                Class clazz13 = clazz;
                                if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                                    tuple2 = new Tuple2((Object)"Float", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.FLOAT)));
                                } else {
                                    Class clazz14 = Tensor$.MODULE$.DoubleClass();
                                    Class clazz15 = clazz;
                                    if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                                        tuple2 = new Tuple2((Object)"Double", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.DOUBLE)));
                                    } else {
                                        Class clazz16 = Tensor$.MODULE$.StringClass();
                                        Class clazz17 = clazz;
                                        if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
                                            tuple2 = new Tuple2((Object)"String", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.STRING)));
                                        } else {
                                            Class clazz18 = Tensor$.MODULE$.ByteStringClass();
                                            Class clazz19 = clazz;
                                            if (!(clazz18 != null ? !clazz18.equals(clazz19) : clazz19 != null)) {
                                                tuple2 = new Tuple2((Object)"ByteString", (Object)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.BYTES)));
                                            } else {
                                                throw new IllegalArgumentException(new StringBuilder(13).append("invalid base ").append(package$.MODULE$.classTag(evidence$1).runtimeClass().getName()).toString());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String name = (String)tuple22._1();
            Schema valuesSchema = (Schema)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)name, (Object)valuesSchema);
            Tuple2 tuple24 = tuple23;
            String name2 = (String)tuple24._1();
            Schema valuesSchema2 = (Schema)tuple24._2();
            Schema indicesSchema = Schema.createUnion((Schema[])new Schema[]{Schema.createArray((Schema)Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT))), Schema.create((Schema.Type)Schema.Type.NULL)});
            return Schema.createRecord((String)new StringBuilder(6).append(name2).append("Tensor").toString(), (String)"", (String)"ml.combust.mleap.avro", (boolean)false, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Schema.Field("dimensions", Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)), "", null), (List)new .colon.colon((Object)new Schema.Field("values", valuesSchema2, "", null), (List)new .colon.colon((Object)new Schema.Field("indices", indicesSchema, "", null), (List)Nil$.MODULE$)))).asJava()));
        });
        return (Schema)r.get();
    }

    private Schema booleanTensorSchema() {
        return this.booleanTensorSchema;
    }

    private Schema byteTensorSchema() {
        return this.byteTensorSchema;
    }

    private Schema shortTensorSchema() {
        return this.shortTensorSchema;
    }

    private Schema integerTensorSchema() {
        return this.integerTensorSchema;
    }

    private Schema longTensorSchema() {
        return this.longTensorSchema;
    }

    private Schema floatTensorSchema() {
        return this.floatTensorSchema;
    }

    private Schema doubleTensorSchema() {
        return this.doubleTensorSchema;
    }

    private Schema stringTensorSchema() {
        return this.stringTensorSchema;
    }

    private Schema byteStringTensorSchema() {
        return this.byteStringTensorSchema;
    }

    public Charset bytesCharset() {
        return this.bytesCharset;
    }

    public int tensorSchemaDimensionsIndex() {
        return this.tensorSchemaDimensionsIndex;
    }

    public int tensorSchemaValuesIndex() {
        return this.tensorSchemaValuesIndex;
    }

    public int tensorSchemaIndicesIndex() {
        return this.tensorSchemaIndicesIndex;
    }

    public int customSchemaIndex() {
        return this.customSchemaIndex;
    }

    public Schema mleapToAvro(StructType schema) {
        java.util.List fields = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)schema.fields().map((Function1 & Serializable & scala.Serializable)field -> MODULE$.mleapToAvroField((StructField)field), Seq$.MODULE$.canBuildFrom())).asJava();
        return Schema.createRecord((String)"LeapFrame", (String)"", (String)"ml.combust.mleap.avro", (boolean)false, (java.util.List)fields);
    }

    public Schema.Field mleapToAvroField(StructField field) {
        return new Schema.Field(field.name(), this.mleapToAvroType(field.dataType()), "", null);
    }

    public Schema maybeNullableAvroType(Schema base, boolean isNullable) {
        return isNullable ? Schema.createUnion((Schema[])new Schema[]{base, Schema.create((Schema.Type)Schema.Type.NULL)}) : base;
    }

    public Schema mleapBasicToAvroType(BasicType basicType) {
        Schema schema;
        BasicType basicType2 = basicType;
        if (BasicType.Boolean$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        } else if (BasicType.Byte$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.INT);
        } else if (BasicType.Short$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.INT);
        } else if (BasicType.Int$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.INT);
        } else if (BasicType.Long$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.LONG);
        } else if (BasicType.Float$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.FLOAT);
        } else if (BasicType.Double$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        } else if (BasicType.String$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.STRING);
        } else if (BasicType.ByteString$.MODULE$.equals(basicType2)) {
            schema = Schema.create((Schema.Type)Schema.Type.BYTES);
        } else {
            throw new MatchError((Object)basicType2);
        }
        return schema;
    }

    public Schema mleapToAvroType(DataType dataType) {
        Schema schema;
        DataType dataType2 = dataType;
        if (dataType2 instanceof ScalarType) {
            ScalarType scalarType = (ScalarType)dataType2;
            schema = this.maybeNullableAvroType(this.mleapBasicToAvroType(scalarType.base()), scalarType.isNullable());
        } else if (dataType2 instanceof ListType) {
            ListType listType = (ListType)dataType2;
            schema = this.maybeNullableAvroType(Schema.createArray((Schema)this.mleapBasicToAvroType(listType.base())), listType.isNullable());
        } else if (dataType2 instanceof TensorType) {
            Schema schema2;
            TensorType tensorType = (TensorType)dataType2;
            BasicType basicType = tensorType.base();
            if (BasicType.Boolean$.MODULE$.equals(basicType)) {
                schema2 = this.booleanTensorSchema();
            } else if (BasicType.Byte$.MODULE$.equals(basicType)) {
                schema2 = this.byteTensorSchema();
            } else if (BasicType.Short$.MODULE$.equals(basicType)) {
                schema2 = this.shortTensorSchema();
            } else if (BasicType.Int$.MODULE$.equals(basicType)) {
                schema2 = this.integerTensorSchema();
            } else if (BasicType.Long$.MODULE$.equals(basicType)) {
                schema2 = this.longTensorSchema();
            } else if (BasicType.Float$.MODULE$.equals(basicType)) {
                schema2 = this.floatTensorSchema();
            } else if (BasicType.Double$.MODULE$.equals(basicType)) {
                schema2 = this.doubleTensorSchema();
            } else if (BasicType.String$.MODULE$.equals(basicType)) {
                schema2 = this.stringTensorSchema();
            } else if (BasicType.ByteString$.MODULE$.equals(basicType)) {
                schema2 = this.byteStringTensorSchema();
            } else {
                throw new IllegalArgumentException(new StringBuilder(13).append("invalid type ").append(tensorType.base()).toString());
            }
            schema = schema2;
        } else {
            throw new IllegalArgumentException(new StringBuilder(19).append("invalid data type: ").append(dataType).toString());
        }
        return schema;
    }

    public StructType avroToMleap(Schema schema, MleapContext context) {
        Schema.Type type = schema.getType();
        if (!Schema.Type.RECORD.equals(type)) {
            throw new IllegalArgumentException("invalid avro record type");
        }
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> MODULE$.avroToMleapField((Schema.Field)field, context), Buffer$.MODULE$.canBuildFrom());
        StructType structType = (StructType)StructType$.MODULE$.apply((Seq)fields).get();
        return structType;
    }

    public StructField avroToMleapField(Schema.Field field, MleapContext context) {
        return new StructField(field.name(), this.avroToMleapType(field.schema(), context));
    }

    public DataType maybeNullableMleapType(Schema schema2) {
        Buffer types = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getTypes()).asScala();
        Predef$.MODULE$.assert(types.size() == 2, (Function0 & Serializable & scala.Serializable)() -> "only nullable unions supported (2 type unions)");
        return ((DataType)types.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverter$.$anonfun$maybeNullableMleapType$2(x$2))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> types.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SchemaConverter$.$anonfun$maybeNullableMleapType$4(x$4)))).map((Function1 & Serializable & scala.Serializable)schema -> MODULE$.avroToMleapType((Schema)schema, MleapContext$.MODULE$.defaultContext())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(20).append("unsupported schema: ").append(schema2).toString());
        })).asNullable();
    }

    public BasicType avroToMleapBasicType(Schema.Type base) {
        BasicType.Boolean$ boolean$;
        Schema.Type type = base;
        if (Schema.Type.BOOLEAN.equals(type)) {
            boolean$ = BasicType.Boolean$.MODULE$;
        } else if (Schema.Type.INT.equals(type)) {
            boolean$ = BasicType.Int$.MODULE$;
        } else if (Schema.Type.LONG.equals(type)) {
            boolean$ = BasicType.Long$.MODULE$;
        } else if (Schema.Type.FLOAT.equals(type)) {
            boolean$ = BasicType.Float$.MODULE$;
        } else if (Schema.Type.DOUBLE.equals(type)) {
            boolean$ = BasicType.Double$.MODULE$;
        } else if (Schema.Type.STRING.equals(type)) {
            boolean$ = BasicType.String$.MODULE$;
        } else if (Schema.Type.BYTES.equals(type)) {
            boolean$ = BasicType.ByteString$.MODULE$;
        } else {
            throw new IllegalArgumentException("invalid basic type");
        }
        return boolean$;
    }

    public DataType avroToMleapType(Schema schema, MleapContext context) {
        ScalarType scalarType;
        Schema.Type type = schema.getType();
        if (Schema.Type.BOOLEAN.equals(type)) {
            scalarType = ScalarType$.MODULE$.Boolean();
        } else if (Schema.Type.INT.equals(type)) {
            scalarType = ScalarType$.MODULE$.Int();
        } else if (Schema.Type.LONG.equals(type)) {
            scalarType = ScalarType$.MODULE$.Long();
        } else if (Schema.Type.FLOAT.equals(type)) {
            scalarType = ScalarType$.MODULE$.Float();
        } else if (Schema.Type.DOUBLE.equals(type)) {
            scalarType = ScalarType$.MODULE$.Double();
        } else if (Schema.Type.STRING.equals(type)) {
            scalarType = ScalarType$.MODULE$.String();
        } else if (Schema.Type.BYTES.equals(type)) {
            scalarType = ScalarType$.MODULE$.ByteString();
        } else if (Schema.Type.ARRAY.equals(type)) {
            scalarType = new ListType(this.avroToMleapBasicType(schema.getElementType().getType()), ListType$.MODULE$.apply$default$2());
        } else if (Schema.Type.UNION.equals(type)) {
            scalarType = this.maybeNullableMleapType(schema);
        } else if (Schema.Type.RECORD.equals(type)) {
            TensorType tensorType;
            String string = schema.getName();
            if ("BooleanTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Boolean$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("ByteTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Byte$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("ShortTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Short$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("IntTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Int$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("LongTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Long$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("FloatTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Float$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("DoubleTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.Double$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("StringTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.String$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else if ("ByteStringTensor".equals(string)) {
                tensorType = new TensorType((BasicType)BasicType.ByteString$.MODULE$, TensorType$.MODULE$.apply$default$2(), TensorType$.MODULE$.apply$default$3());
            } else {
                throw new IllegalArgumentException("invalid avro record");
            }
            scalarType = tensorType;
        } else {
            throw new IllegalArgumentException("invalid avro record");
        }
        return scalarType;
    }

    public static final /* synthetic */ boolean $anonfun$maybeNullableMleapType$2(Schema x$2) {
        Schema.Type type = x$2.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$maybeNullableMleapType$4(Schema x$4) {
        Schema.Type type = x$4.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private SchemaConverter$() {
        MODULE$ = this;
        this.booleanTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Boolean());
        this.byteTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Byte());
        this.shortTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Short());
        this.integerTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Int());
        this.longTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Long());
        this.floatTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Float());
        this.doubleTensorSchema = this.tensorSchema(ClassTag$.MODULE$.Double());
        this.stringTensorSchema = this.tensorSchema(ClassTag$.MODULE$.apply(String.class));
        this.byteStringTensorSchema = this.tensorSchema(ClassTag$.MODULE$.apply(ByteString.class));
        this.bytesCharset = Charset.forName("UTF-8");
        this.tensorSchemaDimensionsIndex = 0;
        this.tensorSchemaValuesIndex = 1;
        this.tensorSchemaIndicesIndex = 2;
        this.customSchemaIndex = 0;
    }
}

