/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.feature;

import ml.combust.mleap.core.Model;
import ml.combust.mleap.core.annotation.SparkCode;
import ml.combust.mleap.core.feature.PolynomialExpansionModel$;
import ml.combust.mleap.core.types.DataType;
import ml.combust.mleap.core.types.StructField;
import ml.combust.mleap.core.types.StructField$;
import ml.combust.mleap.core.types.StructType;
import ml.combust.mleap.core.types.StructType$;
import ml.combust.mleap.core.types.TensorType$;
import ml.combust.mleap.shaded.org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@SparkCode(uri="https://github.com/apache/spark/blob/master/mllib/src/main/scala/org/apache/spark/ml/feature/PolynomialExpansion.scala")
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u00016\u0011\u0001\u0004U8ms:|W.[1m\u000bb\u0004\u0018M\\:j_:lu\u000eZ3m\u0015\t\u0019A!A\u0004gK\u0006$XO]3\u000b\u0005\u00151\u0011\u0001B2pe\u0016T!a\u0002\u0005\u0002\u000b5dW-\u00199\u000b\u0005%Q\u0011aB2p[\n,8\u000f\u001e\u0006\u0002\u0017\u0005\u0011Q\u000e\\\u0002\u0001'\u0015\u0001a\u0002\u0006\r\u001c!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\t%\u0011q\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003\u001feI!A\u0007\t\u0003\u000fA\u0013x\u000eZ;diB\u0011q\u0002H\u0005\u0003;A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\b\u0001\u0003\u0016\u0004%\t\u0001I\u0001\u0007I\u0016<'/Z3\u0016\u0003\u0005\u0002\"a\u0004\u0012\n\u0005\r\u0002\"aA%oi\"AQ\u0005\u0001B\tB\u0003%\u0011%A\u0004eK\u001e\u0014X-\u001a\u0011\t\u0011\u001d\u0002!Q3A\u0005\u0002\u0001\n\u0011\"\u001b8qkR\u001c\u0016N_3\t\u0011%\u0002!\u0011#Q\u0001\n\u0005\n!\"\u001b8qkR\u001c\u0016N_3!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0019a\u0014N\\5u}Q\u0019Qf\f\u0019\u0011\u00059\u0002Q\"\u0001\u0002\t\u000b}Q\u0003\u0019A\u0011\t\u000b\u001dR\u0003\u0019A\u0011\t\u000fI\u0002!\u0019!C\u0001A\u0005A\u0001o\u001c7z'&TX\r\u0003\u00045\u0001\u0001\u0006I!I\u0001\na>d\u0017pU5{K\u0002BQA\u000e\u0001\u0005\u0002]\nQ!\u00199qYf$\"\u0001O#\u0011\u0005e\u001aU\"\u0001\u001e\u000b\u0005mb\u0014A\u00027j]\u0006dwM\u0003\u0002\f{)\u0011ahP\u0001\u0006gB\f'o\u001b\u0006\u0003\u0001\u0006\u000ba!\u00199bG\",'\"\u0001\"\u0002\u0007=\u0014x-\u0003\u0002Eu\t1a+Z2u_JDQAR\u001bA\u0002a\naA^3di>\u0014\b\"\u0002%\u0001\t\u0003I\u0015AB3ya\u0006tG\rF\u0002K\u001b>\u0003\"!O&\n\u00051S$a\u0003#f]N,g+Z2u_JDQAT$A\u0002)\u000b1\u0002Z3og\u00164Vm\u0019;pe\")qd\u0012a\u0001C!)\u0001\n\u0001C\u0001#R\u0019!+V,\u0011\u0005e\u001a\u0016B\u0001+;\u00051\u0019\u0006/\u0019:tKZ+7\r^8s\u0011\u00151\u0006\u000b1\u0001S\u00031\u0019\b/\u0019:tKZ+7\r^8s\u0011\u0015y\u0002\u000b1\u0001\"\u0011\u0015I\u0006\u0001\"\u0001[\u0003-9W\r\u001e)pYf\u001c\u0016N_3\u0015\u0007\u0005ZV\fC\u0003]1\u0002\u0007\u0011%A\u0006ok64U-\u0019;ve\u0016\u001c\b\"B\u0010Y\u0001\u0004\t\u0003\"B0\u0001\t\u0013\u0001\u0017aC3ya\u0006tG\rR3og\u0016$r!I1jW2t\u0007\u000fC\u0003c=\u0002\u00071-\u0001\u0004wC2,Xm\u001d\t\u0004\u001f\u00114\u0017BA3\u0011\u0005\u0015\t%O]1z!\tyq-\u0003\u0002i!\t1Ai\\;cY\u0016DQA\u001b0A\u0002\u0005\nq\u0001\\1ti&#\u0007\u0010C\u0003 =\u0002\u0007\u0011\u0005C\u0003n=\u0002\u0007a-\u0001\u0006nk2$\u0018\u000e\u001d7jKJDQa\u001c0A\u0002\r\f!\u0002]8msZ\u000bG.^3t\u0011\u0015\th\f1\u0001\"\u0003)\u0019WO\u001d)pYfLE\r\u001f\u0005\u0006g\u0002!I\u0001^\u0001\rKb\u0004\u0018M\u001c3Ta\u0006\u00148/\u001a\u000b\rCUD\u0018P\u001f?~}\u0006E\u0011Q\u0003\u0005\u0006mJ\u0004\ra^\u0001\bS:$\u0017nY3t!\ryA-\t\u0005\u0006EJ\u0004\ra\u0019\u0005\u0006UJ\u0004\r!\t\u0005\u0006wJ\u0004\r!I\u0001\u000fY\u0006\u001cHOR3biV\u0014X-\u00133y\u0011\u0015y\"\u000f1\u0001\"\u0011\u0015i'\u000f1\u0001g\u0011\u0019y(\u000f1\u0001\u0002\u0002\u0005Y\u0001o\u001c7z\u0013:$\u0017nY3t!\u0015\t\u0019!!\u0004\"\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017\u0001\u0012AC2pY2,7\r^5p]&!\u0011qBA\u0003\u00051\t%O]1z\u0005VLG\u000eZ3s\u0011\u0019y'\u000f1\u0001\u0002\u0014A)\u00111AA\u0007M\")\u0011O\u001da\u0001C!9\u0011\u0011\u0004\u0001\u0005B\u0005m\u0011aC5oaV$8k\u00195f[\u0006,\"!!\b\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t\u0005\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9#!\t\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002,\u0001!\t%a\u0007\u0002\u0019=,H\u000f];u'\u000eDW-\\1\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0012\u0001B2paf$R!LA\u001a\u0003kA\u0001bHA\u0017!\u0003\u0005\r!\t\u0005\tO\u00055\u0002\u0013!a\u0001C!I\u0011\u0011\b\u0001\u0012\u0002\u0013\u0005\u00111H\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiDK\u0002\"\u0003\u007fY#!!\u0011\u0011\t\u0005\r\u0013QJ\u0007\u0003\u0003\u000bRA!a\u0012\u0002J\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0017\u0002\u0012AC1o]>$\u0018\r^5p]&!\u0011qJA#\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003'\u0002\u0011\u0013!C\u0001\u0003w\tabY8qs\u0012\"WMZ1vYR$#\u0007C\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t)'\u0001\u0003kCZ\f\u0017\u0002BA5\u0003?\u0012aa\u0015;sS:<\u0007\u0002CA7\u0001\u0005\u0005I\u0011\u0001\u0011\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005E\u0004!!A\u0005\u0002\u0005M\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\nY\bE\u0002\u0010\u0003oJ1!!\u001f\u0011\u0005\r\te.\u001f\u0005\n\u0003{\ny'!AA\u0002\u0005\n1\u0001\u001f\u00132\u0011%\t\t\tAA\u0001\n\u0003\n\u0019)A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\t\u0005\u0004\u0002\b\u0006%\u0015QO\u0007\u0003\u0003\u0013IA!a#\u0002\n\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0010\u0002\t\t\u0011\"\u0001\u0002\u0012\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0014\u0006e\u0005cA\b\u0002\u0016&\u0019\u0011q\u0013\t\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QPAG\u0003\u0003\u0005\r!!\u001e\t\u0013\u0005u\u0005!!A\u0005B\u0005}\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\u0005B\u0011\"a)\u0001\u0003\u0003%\t%!*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0017\t\u0013\u0005%\u0006!!A\u0005B\u0005-\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0014\u00065\u0006BCA?\u0003O\u000b\t\u00111\u0001\u0002v!:\u0001!!-\u0002<\u0006u\u0006\u0003BAZ\u0003ok!!!.\u000b\u0007\u0005-C!\u0003\u0003\u0002:\u0006U&!C*qCJ\\7i\u001c3f\u0003\r)(/[\u0011\u0003\u0003\u007f\u000ba\u000f\u001b;uaNTtfL4ji\",(ML2p[>\n\u0007/Y2iK>\u001a\b/\u0019:l_\tdwNY\u0018nCN$XM]\u0018nY2L'mL:sG>j\u0017-\u001b80g\u000e\fG.Y\u0018pe\u001e|\u0013\r]1dQ\u0016|3\u000f]1sW>jGn\f4fCR,(/Z\u0018Q_2Lhn\\7jC2,\u0005\u0010]1og&|gNL:dC2\fw!CAb\u0005\u0005\u0005\t\u0012AAc\u0003a\u0001v\u000e\\=o_6L\u0017\r\\#ya\u0006t7/[8o\u001b>$W\r\u001c\t\u0004]\u0005\u001dg\u0001C\u0001\u0003\u0003\u0003E\t!!3\u0014\u000b\u0005\u001d\u00171Z\u000e\u0011\u000f\u00055\u00171[\u0011\"[5\u0011\u0011q\u001a\u0006\u0004\u0003#\u0004\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003+\fyMA\tBEN$(/Y2u\rVt7\r^5p]JBqaKAd\t\u0003\tI\u000e\u0006\u0002\u0002F\"Q\u00111UAd\u0003\u0003%)%!*\t\u0013Y\n9-!A\u0005\u0002\u0006}G#B\u0017\u0002b\u0006\r\bBB\u0010\u0002^\u0002\u0007\u0011\u0005\u0003\u0004(\u0003;\u0004\r!\t\u0005\u000b\u0003O\f9-!A\u0005\u0002\u0006%\u0018aB;oCB\u0004H.\u001f\u000b\u0005\u0003W\f9\u0010E\u0003\u0010\u0003[\f\t0C\u0002\u0002pB\u0011aa\u00149uS>t\u0007#B\b\u0002t\u0006\n\u0013bAA{!\t1A+\u001e9mKJB\u0011\"!?\u0002f\u0006\u0005\t\u0019A\u0017\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002~\u0006\u001d\u0017\u0011!C\u0005\u0003\u007f\f1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0001\t\u0005\u0003;\u0012\u0019!\u0003\u0003\u0003\u0006\u0005}#AB(cU\u0016\u001cG\u000f")
public class PolynomialExpansionModel
implements Model,
Product,
Serializable {
    private final int degree;
    private final int inputSize;
    private final int polySize;

    public static Option<Tuple2<Object, Object>> unapply(PolynomialExpansionModel polynomialExpansionModel) {
        return PolynomialExpansionModel$.MODULE$.unapply(polynomialExpansionModel);
    }

    public static Function1<Tuple2<Object, Object>, PolynomialExpansionModel> tupled() {
        return PolynomialExpansionModel$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<Object, PolynomialExpansionModel>> curried() {
        return PolynomialExpansionModel$.MODULE$.curried();
    }

    public int degree() {
        return this.degree;
    }

    public int inputSize() {
        return this.inputSize;
    }

    public int polySize() {
        return this.polySize;
    }

    public Vector apply(Vector vector) {
        block4: {
            DenseVector denseVector;
            block3: {
                Vector vector2;
                block2: {
                    vector2 = vector;
                    if (!(vector2 instanceof DenseVector)) break block2;
                    DenseVector denseVector2 = (DenseVector)vector2;
                    denseVector = this.expand(denseVector2, this.degree());
                    break block3;
                }
                if (!(vector2 instanceof SparseVector)) break block4;
                SparseVector sparseVector = (SparseVector)vector2;
                denseVector = this.expand(sparseVector, this.degree());
            }
            return denseVector;
        }
        throw new IllegalArgumentException();
    }

    public DenseVector expand(DenseVector denseVector, int degree) {
        int n2 = denseVector.size();
        double[] polyValues = new double[this.polySize() - 1];
        this.expandDense(denseVector.values(), n2 - 1, degree, 1.0, polyValues, -1);
        return new DenseVector(polyValues);
    }

    public SparseVector expand(SparseVector sparseVector, int degree) {
        int polySize = this.getPolySize(sparseVector.size(), degree);
        int nnz = sparseVector.values().length;
        int nnzPolySize = this.getPolySize(nnz, degree);
        ArrayBuilder polyIndices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        polyIndices.sizeHint(nnzPolySize - 1);
        ArrayBuilder polyValues = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        polyValues.sizeHint(nnzPolySize - 1);
        this.expandSparse(sparseVector.indices(), sparseVector.values(), nnz - 1, sparseVector.size() - 1, degree, 1.0, (ArrayBuilder<Object>)polyIndices, (ArrayBuilder<Object>)polyValues, -1);
        return new SparseVector(polySize - 1, (int[])polyIndices.result(), (double[])polyValues.result());
    }

    public int getPolySize(int numFeatures, int degree) {
        long n2 = CombinatoricsUtils.binomialCoefficient((int)(numFeatures + degree), (int)degree);
        Predef$.MODULE$.require(n2 <= Integer.MAX_VALUE);
        return (int)n2;
    }

    private int expandDense(double[] values2, int lastIdx, int degree, double multiplier, double[] polyValues, int curPolyIdx) {
        if (multiplier != 0.0) {
            if (degree == 0 || lastIdx < 0) {
                if (curPolyIdx >= 0) {
                    polyValues[curPolyIdx] = multiplier;
                }
            } else {
                double v2 = values2[lastIdx];
                int lastIdx1 = lastIdx - 1;
                double alpha = multiplier;
                int curStart = curPolyIdx;
                for (int i2 = 0; i2 <= degree && alpha != 0.0; ++i2, alpha *= v2) {
                    curStart = this.expandDense(values2, lastIdx1, degree - i2, alpha, polyValues, curStart);
                }
            }
        }
        return curPolyIdx + this.getPolySize(lastIdx + 1, degree);
    }

    private int expandSparse(int[] indices, double[] values2, int lastIdx, int lastFeatureIdx, int degree, double multiplier, ArrayBuilder<Object> polyIndices, ArrayBuilder<Object> polyValues, int curPolyIdx) {
        BoxedUnit boxedUnit;
        if (multiplier == 0.0) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (degree == 0 || lastIdx < 0) {
            if (curPolyIdx >= 0) {
                polyIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)curPolyIdx));
                boxedUnit = polyValues.$plus$eq((Object)BoxesRunTime.boxToDouble((double)multiplier));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            double v2 = values2[lastIdx];
            int lastIdx1 = lastIdx - 1;
            int lastFeatureIdx1 = indices[lastIdx] - 1;
            double alpha = multiplier;
            int curStart = curPolyIdx;
            for (int i2 = 0; i2 <= degree && alpha != 0.0; ++i2, alpha *= v2) {
                curStart = this.expandSparse(indices, values2, lastIdx1, lastFeatureIdx1, degree - i2, alpha, polyIndices, polyValues, curStart);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return curPolyIdx + this.getPolySize(lastFeatureIdx + 1, degree);
    }

    @Override
    public StructType inputSchema() {
        return (StructType)StructType$.MODULE$.apply(StructField$.MODULE$.apply((Tuple2<String, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)TensorType$.MODULE$.Double((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.inputSize()})))), (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])new StructField[0])).get();
    }

    @Override
    public StructType outputSchema() {
        return (StructType)StructType$.MODULE$.apply(StructField$.MODULE$.apply((Tuple2<String, DataType>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"output"), (Object)TensorType$.MODULE$.Double((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{this.polySize() - 1})))), (Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])new StructField[0])).get();
    }

    public PolynomialExpansionModel copy(int degree, int inputSize) {
        return new PolynomialExpansionModel(degree, inputSize);
    }

    public int copy$default$1() {
        return this.degree();
    }

    public int copy$default$2() {
        return this.inputSize();
    }

    public String productPrefix() {
        return "PolynomialExpansionModel";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Integer n2;
        int n3 = x$1;
        switch (n3) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                n2 = BoxesRunTime.boxToInteger((int)this.inputSize());
                break;
            }
            case 0: {
                n2 = BoxesRunTime.boxToInteger((int)this.degree());
            }
        }
        return n2;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof PolynomialExpansionModel;
    }

    public int hashCode() {
        int n2 = -889275714;
        n2 = Statics.mix((int)n2, (int)this.degree());
        n2 = Statics.mix((int)n2, (int)this.inputSize());
        return Statics.finalizeHash((int)n2, (int)2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PolynomialExpansionModel)) return false;
        boolean bl = true;
        if (!bl) return false;
        PolynomialExpansionModel polynomialExpansionModel = (PolynomialExpansionModel)x$1;
        if (this.degree() != polynomialExpansionModel.degree()) return false;
        if (this.inputSize() != polynomialExpansionModel.inputSize()) return false;
        if (!polynomialExpansionModel.canEqual(this)) return false;
        return true;
    }

    public PolynomialExpansionModel(int degree, int inputSize) {
        this.degree = degree;
        this.inputSize = inputSize;
        Product.class.$init$((Product)this);
        this.polySize = this.getPolySize(inputSize, degree);
    }
}

