/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst;

import java.util.concurrent.Future;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dst.DoubleDST_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;

public class DoubleDST_2D {
    private int rows;
    private int columns;
    private double[] t;
    private DoubleDST_1D dstColumns;
    private DoubleDST_1D dstRows;
    private int oldNthreads;
    private int nt;
    private boolean isPowerOfTwo = false;
    private boolean useThreads = false;

    public DoubleDST_2D(int rows, int columns) {
        if (rows <= 1 || columns <= 1) {
            throw new IllegalArgumentException("rows and columns must be greater than 1");
        }
        this.rows = rows;
        this.columns = columns;
        if (rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            this.useThreads = true;
        }
        if (ConcurrencyUtils.isPowerOf2(rows) && ConcurrencyUtils.isPowerOf2(columns)) {
            this.isPowerOfTwo = true;
            this.oldNthreads = ConcurrencyUtils.getNumberOfThreads();
            this.nt = 4 * this.oldNthreads * rows;
            if (columns == 2 * this.oldNthreads) {
                this.nt >>= 1;
            } else if (columns < 2 * this.oldNthreads) {
                this.nt >>= 2;
            }
            this.t = new double[this.nt];
        }
        this.dstColumns = new DoubleDST_1D(columns);
        this.dstRows = columns == rows ? this.dstColumns : new DoubleDST_1D(rows);
    }

    public void forward(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, scale);
                this.ddxt2d0_subth(-1, a, scale);
            } else {
                this.ddxt2d_sub(-1, a, scale);
                int i2 = 0;
                while (i2 < this.rows) {
                    this.dstColumns.forward(a, i2 * this.columns, scale);
                    ++i2;
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            DoubleDST_2D.this.dstColumns.forward(a, i2 * DoubleDST_2D.this.columns, scale);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                temp[r] = a[r * DoubleDST_2D.this.columns + c];
                                ++r;
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                a[r * ((DoubleDST_2D)DoubleDST_2D.this).columns + c] = temp[r];
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 0;
            while (i3 < this.rows) {
                this.dstColumns.forward(a, i3 * this.columns, scale);
                ++i3;
            }
            double[] temp = new double[this.rows];
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    temp[r] = a[r * this.columns + c];
                    ++r;
                }
                this.dstRows.forward(temp, scale);
                r = 0;
                while (r < this.rows) {
                    a[r * this.columns + c] = temp[r];
                    ++r;
                }
                ++c;
            }
        }
    }

    public void forward(final double[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(-1, a, scale);
                this.ddxt2d0_subth(-1, a, scale);
            } else {
                this.ddxt2d_sub(-1, a, scale);
                int i2 = 0;
                while (i2 < this.rows) {
                    this.dstColumns.forward(a[i2], scale);
                    ++i2;
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            DoubleDST_2D.this.dstColumns.forward(a[i2], scale);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                temp[r] = a[r][c];
                                ++r;
                            }
                            DoubleDST_2D.this.dstRows.forward(temp, scale);
                            r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                a[r][c] = temp[r];
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 0;
            while (i3 < this.rows) {
                this.dstColumns.forward(a[i3], scale);
                ++i3;
            }
            double[] temp = new double[this.rows];
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    temp[r] = a[r][c];
                    ++r;
                }
                this.dstRows.forward(temp, scale);
                r = 0;
                while (r < this.rows) {
                    a[r][c] = temp[r];
                    ++r;
                }
                ++c;
            }
        }
    }

    public void inverse(final double[] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                int i2 = 0;
                while (i2 < this.rows) {
                    this.dstColumns.inverse(a, i2 * this.columns, scale);
                    ++i2;
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            DoubleDST_2D.this.dstColumns.inverse(a, i2 * DoubleDST_2D.this.columns, scale);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                temp[r] = a[r * DoubleDST_2D.this.columns + c];
                                ++r;
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                a[r * ((DoubleDST_2D)DoubleDST_2D.this).columns + c] = temp[r];
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 0;
            while (i3 < this.rows) {
                this.dstColumns.inverse(a, i3 * this.columns, scale);
                ++i3;
            }
            double[] temp = new double[this.rows];
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    temp[r] = a[r * this.columns + c];
                    ++r;
                }
                this.dstRows.inverse(temp, scale);
                r = 0;
                while (r < this.rows) {
                    a[r * this.columns + c] = temp[r];
                    ++r;
                }
                ++c;
            }
        }
    }

    public void inverse(final double[][] a, final boolean scale) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (this.isPowerOfTwo) {
            if (nthreads != this.oldNthreads) {
                this.nt = 4 * nthreads * this.rows;
                if (this.columns == 2 * nthreads) {
                    this.nt >>= 1;
                } else if (this.columns < 2 * nthreads) {
                    this.nt >>= 2;
                }
                this.t = new double[this.nt];
                this.oldNthreads = nthreads;
            }
            if (nthreads > 1 && this.useThreads) {
                this.ddxt2d_subth(1, a, scale);
                this.ddxt2d0_subth(1, a, scale);
            } else {
                this.ddxt2d_sub(1, a, scale);
                int i2 = 0;
                while (i2 < this.rows) {
                    this.dstColumns.inverse(a[i2], scale);
                    ++i2;
                }
            }
        } else if (nthreads > 1 && this.useThreads && this.rows >= nthreads && this.columns >= nthreads) {
            Future[] futures = new Future[nthreads];
            int p = this.rows / nthreads;
            int l2 = 0;
            while (l2 < nthreads) {
                final int firstRow = l2 * p;
                final int lastRow = l2 == nthreads - 1 ? this.rows : firstRow + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstRow;
                        while (i2 < lastRow) {
                            DoubleDST_2D.this.dstColumns.inverse(a[i2], scale);
                            ++i2;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            p = this.columns / nthreads;
            l2 = 0;
            while (l2 < nthreads) {
                final int firstColumn = l2 * p;
                final int lastColumn = l2 == nthreads - 1 ? this.columns : firstColumn + p;
                futures[l2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] temp = new double[DoubleDST_2D.this.rows];
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                temp[r] = a[r][c];
                                ++r;
                            }
                            DoubleDST_2D.this.dstRows.inverse(temp, scale);
                            r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                a[r][c] = temp[r];
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++l2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 0;
            while (i3 < this.rows) {
                this.dstColumns.inverse(a[i3], scale);
                ++i3;
            }
            double[] temp = new double[this.rows];
            int c = 0;
            while (c < this.columns) {
                int r = 0;
                while (r < this.rows) {
                    temp[r] = a[r][c];
                    ++r;
                }
                this.dstRows.inverse(temp, scale);
                r = 0;
                while (r < this.rows) {
                    a[r][c] = temp[r];
                    ++r;
                }
                ++c;
            }
        }
    }

    private void ddxt2d_subth(final int isgn, final double[] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            final int startt = nt * i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block17: {
                        block18: {
                            int idx2;
                            int idx1;
                            block16: {
                                if (DoubleDST_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    int c = 4 * n0;
                                    while (c < DoubleDST_2D.this.columns) {
                                        int idx22;
                                        int idx12;
                                        int r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx12 = r * DoubleDST_2D.this.columns + c;
                                            idx22 = startt + DoubleDST_2D.this.rows + r;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[idx12];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22] = a[idx12 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx12 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx12 + 3];
                                            ++r;
                                        }
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx12 = r * DoubleDST_2D.this.columns + c;
                                            idx22 = startt + DoubleDST_2D.this.rows + r;
                                            a[idx12] = DoubleDST_2D.this.t[startt + r];
                                            a[idx12 + 1] = DoubleDST_2D.this.t[idx22];
                                            a[idx12 + 2] = DoubleDST_2D.this.t[idx22 + DoubleDST_2D.this.rows];
                                            a[idx12 + 3] = DoubleDST_2D.this.t[idx22 + 2 * DoubleDST_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                } else {
                                    int c = 4 * n0;
                                    while (c < DoubleDST_2D.this.columns) {
                                        int idx23;
                                        int idx13;
                                        int r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx13 = r * DoubleDST_2D.this.columns + c;
                                            idx23 = startt + DoubleDST_2D.this.rows + r;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[idx13];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23] = a[idx13 + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx13 + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx13 + 3];
                                            ++r;
                                        }
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx13 = r * DoubleDST_2D.this.columns + c;
                                            idx23 = startt + DoubleDST_2D.this.rows + r;
                                            a[idx13] = DoubleDST_2D.this.t[startt + r];
                                            a[idx13 + 1] = DoubleDST_2D.this.t[idx23];
                                            a[idx13 + 2] = DoubleDST_2D.this.t[idx23 + DoubleDST_2D.this.rows];
                                            a[idx13 + 3] = DoubleDST_2D.this.t[idx23 + 2 * DoubleDST_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.columns != 2 * nthreads) break block18;
                            int r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                idx1 = r * DoubleDST_2D.this.columns + 2 * n0;
                                idx2 = startt + r;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2] = a[idx1];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[idx1 + 1];
                                ++r;
                            }
                            if (isgn == -1) {
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            } else {
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            }
                            r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                idx1 = r * DoubleDST_2D.this.columns + 2 * n0;
                                idx2 = startt + r;
                                a[idx1] = DoubleDST_2D.this.t[idx2];
                                a[idx1 + 1] = DoubleDST_2D.this.t[idx2 + DoubleDST_2D.this.rows];
                                ++r;
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.columns != nthreads) break block17;
                        int r = 0;
                        while (r < DoubleDST_2D.this.rows) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[r * DoubleDST_2D.this.columns + n0];
                            ++r;
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                        }
                        r = 0;
                        while (r < DoubleDST_2D.this.rows) {
                            a[r * ((DoubleDST_2D)DoubleDST_2D.this).columns + n0] = DoubleDST_2D.this.t[startt + r];
                            ++r;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_subth(final int isgn, final double[][] a, final boolean scale) {
        int nthread = ConcurrencyUtils.getNumberOfThreads();
        int nt = 4 * this.rows;
        if (this.columns == 2 * nthread) {
            nt >>= 1;
        } else if (this.columns < 2 * nthread) {
            nthread = this.columns;
            nt >>= 2;
        }
        final int nthreads = nthread;
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            final int startt = nt * i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    block17: {
                        block18: {
                            int idx2;
                            block16: {
                                if (DoubleDST_2D.this.columns <= 2 * nthreads) break block16;
                                if (isgn == -1) {
                                    int c = 4 * n0;
                                    while (c < DoubleDST_2D.this.columns) {
                                        int idx22;
                                        int r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx22 = startt + DoubleDST_2D.this.rows + r;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[r][c];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22] = a[r][c + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r][c + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx22 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r][c + 3];
                                            ++r;
                                        }
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx22 = startt + DoubleDST_2D.this.rows + r;
                                            a[r][c] = DoubleDST_2D.this.t[startt + r];
                                            a[r][c + 1] = DoubleDST_2D.this.t[idx22];
                                            a[r][c + 2] = DoubleDST_2D.this.t[idx22 + DoubleDST_2D.this.rows];
                                            a[r][c + 3] = DoubleDST_2D.this.t[idx22 + 2 * DoubleDST_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                } else {
                                    int c = 4 * n0;
                                    while (c < DoubleDST_2D.this.columns) {
                                        int idx23;
                                        int r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx23 = startt + DoubleDST_2D.this.rows + r;
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[r][c];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23] = a[r][c + 1];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r][c + 2];
                                            ((DoubleDST_2D)DoubleDST_2D.this).t[idx23 + 2 * ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r][c + 3];
                                            ++r;
                                        }
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 2 * DoubleDST_2D.this.rows, scale);
                                        DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + 3 * DoubleDST_2D.this.rows, scale);
                                        r = 0;
                                        while (r < DoubleDST_2D.this.rows) {
                                            idx23 = startt + DoubleDST_2D.this.rows + r;
                                            a[r][c] = DoubleDST_2D.this.t[startt + r];
                                            a[r][c + 1] = DoubleDST_2D.this.t[idx23];
                                            a[r][c + 2] = DoubleDST_2D.this.t[idx23 + DoubleDST_2D.this.rows];
                                            a[r][c + 3] = DoubleDST_2D.this.t[idx23 + 2 * DoubleDST_2D.this.rows];
                                            ++r;
                                        }
                                        c += 4 * nthreads;
                                    }
                                }
                                break block17;
                            }
                            if (DoubleDST_2D.this.columns != 2 * nthreads) break block18;
                            int r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                idx2 = startt + r;
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2] = a[r][2 * n0];
                                ((DoubleDST_2D)DoubleDST_2D.this).t[idx2 + ((DoubleDST_2D)DoubleDST_2D.this).rows] = a[r][2 * n0 + 1];
                                ++r;
                            }
                            if (isgn == -1) {
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            } else {
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                                DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt + DoubleDST_2D.this.rows, scale);
                            }
                            r = 0;
                            while (r < DoubleDST_2D.this.rows) {
                                idx2 = startt + r;
                                a[r][2 * n0] = DoubleDST_2D.this.t[idx2];
                                a[r][2 * n0 + 1] = DoubleDST_2D.this.t[idx2 + DoubleDST_2D.this.rows];
                                ++r;
                            }
                            break block17;
                        }
                        if (DoubleDST_2D.this.columns != nthreads) break block17;
                        int r = 0;
                        while (r < DoubleDST_2D.this.rows) {
                            ((DoubleDST_2D)DoubleDST_2D.this).t[startt + r] = a[r][n0];
                            ++r;
                        }
                        if (isgn == -1) {
                            DoubleDST_2D.this.dstRows.forward(DoubleDST_2D.this.t, startt, scale);
                        } else {
                            DoubleDST_2D.this.dstRows.inverse(DoubleDST_2D.this.t, startt, scale);
                        }
                        r = 0;
                        while (r < DoubleDST_2D.this.rows) {
                            a[r][n0] = DoubleDST_2D.this.t[startt + r];
                            ++r;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final double[] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int r = n0;
                        while (r < DoubleDST_2D.this.rows) {
                            DoubleDST_2D.this.dstColumns.forward(a, r * DoubleDST_2D.this.columns, scale);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < DoubleDST_2D.this.rows) {
                            DoubleDST_2D.this.dstColumns.inverse(a, r * DoubleDST_2D.this.columns, scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d0_subth(final int isgn, final double[][] a, final boolean scale) {
        final int nthreads = ConcurrencyUtils.getNumberOfThreads() > this.rows ? this.rows : ConcurrencyUtils.getNumberOfThreads();
        Future[] futures = new Future[nthreads];
        int i2 = 0;
        while (i2 < nthreads) {
            final int n0 = i2;
            futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    if (isgn == -1) {
                        int r = n0;
                        while (r < DoubleDST_2D.this.rows) {
                            DoubleDST_2D.this.dstColumns.forward(a[r], scale);
                            r += nthreads;
                        }
                    } else {
                        int r = n0;
                        while (r < DoubleDST_2D.this.rows) {
                            DoubleDST_2D.this.dstColumns.inverse(a[r], scale);
                            r += nthreads;
                        }
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void ddxt2d_sub(int isgn, double[] a, boolean scale) {
        block13: {
            int idx1;
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int idx12;
                        int r = 0;
                        while (r < this.rows) {
                            idx12 = r * this.columns + c;
                            idx2 = this.rows + r;
                            this.t[r] = a[idx12];
                            this.t[idx2] = a[idx12 + 1];
                            this.t[idx2 + this.rows] = a[idx12 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx12 + 3];
                            ++r;
                        }
                        this.dstRows.forward(this.t, 0, scale);
                        this.dstRows.forward(this.t, this.rows, scale);
                        this.dstRows.forward(this.t, 2 * this.rows, scale);
                        this.dstRows.forward(this.t, 3 * this.rows, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx12 = r * this.columns + c;
                            idx2 = this.rows + r;
                            a[idx12] = this.t[r];
                            a[idx12 + 1] = this.t[idx2];
                            a[idx12 + 2] = this.t[idx2 + this.rows];
                            a[idx12 + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                } else {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int idx13;
                        int r = 0;
                        while (r < this.rows) {
                            idx13 = r * this.columns + c;
                            idx2 = this.rows + r;
                            this.t[r] = a[idx13];
                            this.t[idx2] = a[idx13 + 1];
                            this.t[idx2 + this.rows] = a[idx13 + 2];
                            this.t[idx2 + 2 * this.rows] = a[idx13 + 3];
                            ++r;
                        }
                        this.dstRows.inverse(this.t, 0, scale);
                        this.dstRows.inverse(this.t, this.rows, scale);
                        this.dstRows.inverse(this.t, 2 * this.rows, scale);
                        this.dstRows.inverse(this.t, 3 * this.rows, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx13 = r * this.columns + c;
                            idx2 = this.rows + r;
                            a[idx13] = this.t[r];
                            a[idx13 + 1] = this.t[idx2];
                            a[idx13 + 2] = this.t[idx2 + this.rows];
                            a[idx13 + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            int r = 0;
            while (r < this.rows) {
                idx1 = r * this.columns;
                this.t[r] = a[idx1];
                this.t[this.rows + r] = a[idx1 + 1];
                ++r;
            }
            if (isgn == -1) {
                this.dstRows.forward(this.t, 0, scale);
                this.dstRows.forward(this.t, this.rows, scale);
            } else {
                this.dstRows.inverse(this.t, 0, scale);
                this.dstRows.inverse(this.t, this.rows, scale);
            }
            r = 0;
            while (r < this.rows) {
                idx1 = r * this.columns;
                a[idx1] = this.t[r];
                a[idx1 + 1] = this.t[this.rows + r];
                ++r;
            }
        }
    }

    private void ddxt2d_sub(int isgn, double[][] a, boolean scale) {
        block13: {
            block12: {
                if (this.columns <= 2) break block12;
                if (isgn == -1) {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            this.t[r] = a[r][c];
                            this.t[idx2] = a[r][c + 1];
                            this.t[idx2 + this.rows] = a[r][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r][c + 3];
                            ++r;
                        }
                        this.dstRows.forward(this.t, 0, scale);
                        this.dstRows.forward(this.t, this.rows, scale);
                        this.dstRows.forward(this.t, 2 * this.rows, scale);
                        this.dstRows.forward(this.t, 3 * this.rows, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            a[r][c] = this.t[r];
                            a[r][c + 1] = this.t[idx2];
                            a[r][c + 2] = this.t[idx2 + this.rows];
                            a[r][c + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                } else {
                    int c = 0;
                    while (c < this.columns) {
                        int idx2;
                        int r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            this.t[r] = a[r][c];
                            this.t[idx2] = a[r][c + 1];
                            this.t[idx2 + this.rows] = a[r][c + 2];
                            this.t[idx2 + 2 * this.rows] = a[r][c + 3];
                            ++r;
                        }
                        this.dstRows.inverse(this.t, 0, scale);
                        this.dstRows.inverse(this.t, this.rows, scale);
                        this.dstRows.inverse(this.t, 2 * this.rows, scale);
                        this.dstRows.inverse(this.t, 3 * this.rows, scale);
                        r = 0;
                        while (r < this.rows) {
                            idx2 = this.rows + r;
                            a[r][c] = this.t[r];
                            a[r][c + 1] = this.t[idx2];
                            a[r][c + 2] = this.t[idx2 + this.rows];
                            a[r][c + 3] = this.t[idx2 + 2 * this.rows];
                            ++r;
                        }
                        c += 4;
                    }
                }
                break block13;
            }
            if (this.columns != 2) break block13;
            int r = 0;
            while (r < this.rows) {
                this.t[r] = a[r][0];
                this.t[this.rows + r] = a[r][1];
                ++r;
            }
            if (isgn == -1) {
                this.dstRows.forward(this.t, 0, scale);
                this.dstRows.forward(this.t, this.rows, scale);
            } else {
                this.dstRows.inverse(this.t, 0, scale);
                this.dstRows.inverse(this.t, this.rows, scale);
            }
            r = 0;
            while (r < this.rows) {
                a[r][0] = this.t[r];
                a[r][1] = this.t[this.rows + r];
                ++r;
            }
        }
    }
}

