/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.core.util;

import ml.combust.mleap.core.util.Platform;

public final class Murmur3_x86_32 {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;

    public Murmur3_x86_32(int n2) {
        this.seed = n2;
    }

    public String toString() {
        return "Murmur3_32(seed=" + this.seed + ")";
    }

    public int hashInt(int n2) {
        return Murmur3_x86_32.hashInt(n2, this.seed);
    }

    public static int hashInt(int n2, int n3) {
        int n4 = Murmur3_x86_32.mixK1(n2);
        int n5 = Murmur3_x86_32.mixH1(n3, n4);
        return Murmur3_x86_32.fmix(n5, 4);
    }

    public int hashUnsafeWords(Object object, long l2, int n2) {
        return Murmur3_x86_32.hashUnsafeWords(object, l2, n2, this.seed);
    }

    public static int hashUnsafeWords(Object object, long l2, int n2, int n3) {
        assert (n2 % 8 == 0) : "lengthInBytes must be a multiple of 8 (word-aligned)";
        int n4 = Murmur3_x86_32.hashBytesByInt(object, l2, n2, n3);
        return Murmur3_x86_32.fmix(n4, n2);
    }

    public static int hashUnsafeBytes(Object object, long l2, int n2, int n3) {
        assert (n2 >= 0) : "lengthInBytes cannot be negative";
        int n4 = n2 - n2 % 4;
        int n5 = Murmur3_x86_32.hashBytesByInt(object, l2, n4, n3);
        for (int j = n4; j < n2; ++j) {
            byte by = Platform.getByte(object, l2 + (long)j);
            int n6 = Murmur3_x86_32.mixK1(by);
            n5 = Murmur3_x86_32.mixH1(n5, n6);
        }
        return Murmur3_x86_32.fmix(n5, n2);
    }

    public static int hashUnsafeBytes2(Object object, long l2, int n2, int n3) {
        assert (n2 >= 0) : "lengthInBytes cannot be negative";
        int n4 = n2 - n2 % 4;
        int n5 = Murmur3_x86_32.hashBytesByInt(object, l2, n4, n3);
        int n6 = 0;
        int n7 = n4;
        int n8 = 0;
        while (n7 < n2) {
            n6 ^= (Platform.getByte(object, l2 + (long)n7) & 0xFF) << n8;
            ++n7;
            n8 += 8;
        }
        return Murmur3_x86_32.fmix(n5 ^= Murmur3_x86_32.mixK1(n6), n2);
    }

    private static int hashBytesByInt(Object object, long l2, int n2, int n3) {
        assert (n2 % 4 == 0);
        int n4 = n3;
        for (int j = 0; j < n2; j += 4) {
            int n5 = Platform.getInt(object, l2 + (long)j);
            int n6 = Murmur3_x86_32.mixK1(n5);
            n4 = Murmur3_x86_32.mixH1(n4, n6);
        }
        return n4;
    }

    public int hashLong(long l2) {
        return Murmur3_x86_32.hashLong(l2, this.seed);
    }

    public static int hashLong(long l2, int n2) {
        int n3 = (int)l2;
        int n4 = (int)(l2 >>> 32);
        int n5 = Murmur3_x86_32.mixK1(n3);
        int n6 = Murmur3_x86_32.mixH1(n2, n5);
        n5 = Murmur3_x86_32.mixK1(n4);
        n6 = Murmur3_x86_32.mixH1(n6, n5);
        return Murmur3_x86_32.fmix(n6, 8);
    }

    private static int mixK1(int n2) {
        n2 *= -862048943;
        n2 = Integer.rotateLeft(n2, 15);
        return n2 *= 461845907;
    }

    private static int mixH1(int n2, int n3) {
        n2 ^= n3;
        n2 = Integer.rotateLeft(n2, 13);
        n2 = n2 * 5 + -430675100;
        return n2;
    }

    private static int fmix(int n2, int n3) {
        n2 ^= n3;
        n2 ^= n2 >>> 16;
        n2 *= -2048144789;
        n2 ^= n2 >>> 13;
        n2 *= -1028477387;
        n2 ^= n2 >>> 16;
        return n2;
    }
}

