/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.runtime.javadsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ml.combust.mleap.core.types.BasicType;
import ml.combust.mleap.core.types.DataType;
import ml.combust.mleap.core.types.ListType;
import ml.combust.mleap.core.types.ScalarType;
import ml.combust.mleap.core.types.StructField;
import ml.combust.mleap.core.types.StructType;
import ml.combust.mleap.core.types.StructType$;
import ml.combust.mleap.core.types.TensorType;
import ml.combust.mleap.runtime.frame.DefaultLeapFrame;
import ml.combust.mleap.runtime.frame.Row;
import ml.combust.mleap.runtime.javadsl.LeapFrameBuilderSupport;

public class LeapFrameBuilder {
    private LeapFrameBuilderSupport support = new LeapFrameBuilderSupport();

    public DefaultLeapFrame createFrame(StructType structType, Iterable<Row> iterable) {
        return new DefaultLeapFrame(structType, iterable);
    }

    public StructType createSchema(Iterable<StructField> iterable) {
        return (StructType)StructType$.MODULE$.apply(iterable).get();
    }

    public StructField createField(String string, DataType dataType2) {
        return new StructField(string, dataType2);
    }

    public Row createRow(Object object, Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1 + objectArray.length);
        arrayList.add(object);
        arrayList.addAll(Arrays.asList(objectArray));
        return this.createRowFromIterable(arrayList);
    }

    public Row createRowFromIterable(Iterable<Object> iterable) {
        return this.support.createRowFromIterable(iterable);
    }

    public BasicType createBasicBoolean() {
        return this.support.createBoolean();
    }

    public BasicType createBasicByte() {
        return this.support.createByte();
    }

    public BasicType createBasicShort() {
        return this.support.createShort();
    }

    public BasicType createBasicInt() {
        return this.support.createInt();
    }

    public BasicType createBasicLong() {
        return this.support.createLong();
    }

    public BasicType createBasicFloat() {
        return this.support.createFloat();
    }

    public BasicType createBasicDouble() {
        return this.support.createDouble();
    }

    public BasicType createBasicString() {
        return this.support.createString();
    }

    public BasicType createBasicByteString() {
        return this.support.createByteString();
    }

    public ScalarType createBoolean() {
        return this.createBoolean(true);
    }

    public ScalarType createBoolean(boolean bl) {
        return new ScalarType(this.support.createBoolean(), bl);
    }

    public ScalarType createByte() {
        return this.createByte(true);
    }

    public ScalarType createByte(boolean bl) {
        return new ScalarType(this.support.createByte(), bl);
    }

    public ScalarType createShort() {
        return this.createShort(true);
    }

    public ScalarType createShort(boolean bl) {
        return new ScalarType(this.support.createShort(), bl);
    }

    public ScalarType createInt() {
        return this.createInt(true);
    }

    public ScalarType createInt(boolean bl) {
        return new ScalarType(this.support.createInt(), bl);
    }

    public ScalarType createLong() {
        return this.createLong(true);
    }

    public ScalarType createLong(boolean bl) {
        return new ScalarType(this.support.createLong(), bl);
    }

    public ScalarType createFloat() {
        return this.createFloat(true);
    }

    public ScalarType createFloat(boolean bl) {
        return new ScalarType(this.support.createFloat(), bl);
    }

    public ScalarType createDouble() {
        return this.createDouble(true);
    }

    public ScalarType createDouble(boolean bl) {
        return new ScalarType(this.support.createDouble(), bl);
    }

    public ScalarType createString() {
        return this.createString(true);
    }

    public ScalarType createString(boolean bl) {
        return new ScalarType(this.support.createString(), bl);
    }

    public ScalarType createByteString() {
        return this.createByteString(true);
    }

    public ScalarType createByteString(boolean bl) {
        return new ScalarType(this.support.createByteString(), bl);
    }

    public TensorType createTensor(BasicType basicType) {
        return this.createTensor(basicType, true);
    }

    public TensorType createTensor(BasicType basicType, boolean bl) {
        return new TensorType(basicType, bl);
    }

    public TensorType createTensor(BasicType basicType, List<Integer> list2, boolean bl) {
        return new TensorType(basicType, this.support.createTensorDimensions(list2), bl);
    }

    public ListType createList(BasicType basicType) {
        return this.createList(basicType, true);
    }

    public ListType createList(BasicType basicType, boolean bl) {
        return new ListType(basicType, bl);
    }
}

