/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.com.typesafe.config.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigException;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigObject;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigOrigin;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigRenderOptions;
import ml.combust.mleap.shaded.com.typesafe.config.ConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigObject;
import ml.combust.mleap.shaded.com.typesafe.config.impl.AbstractConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Container;
import ml.combust.mleap.shaded.com.typesafe.config.impl.Path;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveContext;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveResult;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveSource;
import ml.combust.mleap.shaded.com.typesafe.config.impl.ResolveStatus;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SerializedConfigValue;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SimpleConfig;
import ml.combust.mleap.shaded.com.typesafe.config.impl.SimpleConfigOrigin;

final class SimpleConfigObject
extends AbstractConfigObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Map<String, AbstractConfigValue> value;
    private final boolean resolved;
    private final boolean ignoresFallbacks;
    private static final String EMPTY_NAME = "empty config";
    private static final SimpleConfigObject emptyInstance = SimpleConfigObject.empty(SimpleConfigOrigin.newSimple("empty config"));

    SimpleConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value2, ResolveStatus status, boolean ignoresFallbacks) {
        super(origin);
        if (value2 == null) {
            throw new ConfigException.BugOrBroken("creating config object with null map");
        }
        this.value = value2;
        this.resolved = status == ResolveStatus.RESOLVED;
        this.ignoresFallbacks = ignoresFallbacks;
        if (status != ResolveStatus.fromValues(value2.values())) {
            throw new ConfigException.BugOrBroken("Wrong resolved status on " + this);
        }
    }

    SimpleConfigObject(ConfigOrigin origin, Map<String, AbstractConfigValue> value2) {
        this(origin, value2, ResolveStatus.fromValues(value2.values()), false);
    }

    @Override
    public SimpleConfigObject withOnlyKey(String key2) {
        return this.withOnlyPath(Path.newKey(key2));
    }

    @Override
    public SimpleConfigObject withoutKey(String key2) {
        return this.withoutPath(Path.newKey(key2));
    }

    @Override
    protected SimpleConfigObject withOnlyPathOrNull(Path path2) {
        String key2 = path2.first();
        Path next = path2.remainder();
        AbstractConfigValue v2 = this.value.get(key2);
        if (next != null) {
            v2 = v2 != null && v2 instanceof AbstractConfigObject ? ((AbstractConfigObject)v2).withOnlyPathOrNull(next) : null;
        }
        if (v2 == null) {
            return null;
        }
        return new SimpleConfigObject(this.origin(), Collections.singletonMap(key2, v2), v2.resolveStatus(), this.ignoresFallbacks);
    }

    @Override
    SimpleConfigObject withOnlyPath(Path path2) {
        SimpleConfigObject o = this.withOnlyPathOrNull(path2);
        if (o == null) {
            return new SimpleConfigObject(this.origin(), Collections.emptyMap(), ResolveStatus.RESOLVED, this.ignoresFallbacks);
        }
        return o;
    }

    @Override
    SimpleConfigObject withoutPath(Path path2) {
        String key2 = path2.first();
        Path next = path2.remainder();
        AbstractConfigValue v2 = this.value.get(key2);
        if (v2 != null && next != null && v2 instanceof AbstractConfigObject) {
            v2 = ((AbstractConfigObject)v2).withoutPath(next);
            HashMap<String, AbstractConfigValue> updated = new HashMap<String, AbstractConfigValue>(this.value);
            updated.put(key2, v2);
            return new SimpleConfigObject(this.origin(), updated, ResolveStatus.fromValues(updated.values()), this.ignoresFallbacks);
        }
        if (next != null || v2 == null) {
            return this;
        }
        HashMap<String, AbstractConfigValue> smaller = new HashMap<String, AbstractConfigValue>(this.value.size() - 1);
        for (Map.Entry<String, AbstractConfigValue> old : this.value.entrySet()) {
            if (old.getKey().equals(key2)) continue;
            smaller.put(old.getKey(), old.getValue());
        }
        return new SimpleConfigObject(this.origin(), smaller, ResolveStatus.fromValues(smaller.values()), this.ignoresFallbacks);
    }

    @Override
    public SimpleConfigObject withValue(String key2, ConfigValue v2) {
        Map<String, AbstractConfigValue> newMap;
        if (v2 == null) {
            throw new ConfigException.BugOrBroken("Trying to store null ConfigValue in a ConfigObject");
        }
        if (this.value.isEmpty()) {
            newMap = Collections.singletonMap(key2, (AbstractConfigValue)v2);
        } else {
            newMap = new HashMap<String, AbstractConfigValue>(this.value);
            newMap.put(key2, (AbstractConfigValue)v2);
        }
        return new SimpleConfigObject(this.origin(), newMap, ResolveStatus.fromValues(newMap.values()), this.ignoresFallbacks);
    }

    @Override
    SimpleConfigObject withValue(Path path2, ConfigValue v2) {
        String key2 = path2.first();
        Path next = path2.remainder();
        if (next == null) {
            return this.withValue(key2, v2);
        }
        AbstractConfigValue child = this.value.get(key2);
        if (child != null && child instanceof AbstractConfigObject) {
            return this.withValue(key2, (ConfigValue)((AbstractConfigObject)child).withValue(next, v2));
        }
        SimpleConfig subtree = ((AbstractConfigValue)v2).atPath(SimpleConfigOrigin.newSimple("withValue(" + next.render() + ")"), next);
        return this.withValue(key2, (ConfigValue)subtree.root());
    }

    @Override
    protected AbstractConfigValue attemptPeekWithPartialResolve(String key2) {
        return this.value.get(key2);
    }

    private SimpleConfigObject newCopy(ResolveStatus newStatus, ConfigOrigin newOrigin, boolean newIgnoresFallbacks) {
        return new SimpleConfigObject(newOrigin, this.value, newStatus, newIgnoresFallbacks);
    }

    @Override
    protected SimpleConfigObject newCopy(ResolveStatus newStatus, ConfigOrigin newOrigin) {
        return this.newCopy(newStatus, newOrigin, this.ignoresFallbacks);
    }

    @Override
    protected SimpleConfigObject withFallbacksIgnored() {
        if (this.ignoresFallbacks) {
            return this;
        }
        return this.newCopy(this.resolveStatus(), this.origin(), true);
    }

    @Override
    ResolveStatus resolveStatus() {
        return ResolveStatus.fromBoolean(this.resolved);
    }

    @Override
    public SimpleConfigObject replaceChild(AbstractConfigValue child, AbstractConfigValue replacement) {
        HashMap<String, AbstractConfigValue> newChildren = new HashMap<String, AbstractConfigValue>(this.value);
        for (Map.Entry<String, AbstractConfigValue> old : newChildren.entrySet()) {
            if (old.getValue() != child) continue;
            if (replacement != null) {
                old.setValue(replacement);
            } else {
                newChildren.remove(old.getKey());
            }
            return new SimpleConfigObject(this.origin(), newChildren, ResolveStatus.fromValues(newChildren.values()), this.ignoresFallbacks);
        }
        throw new ConfigException.BugOrBroken("SimpleConfigObject.replaceChild did not find " + child + " in " + this);
    }

    @Override
    public boolean hasDescendant(AbstractConfigValue descendant) {
        for (AbstractConfigValue child : this.value.values()) {
            if (child != descendant) continue;
            return true;
        }
        for (AbstractConfigValue child : this.value.values()) {
            if (!(child instanceof Container) || !((Container)((Object)child)).hasDescendant(descendant)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean ignoresFallbacks() {
        return this.ignoresFallbacks;
    }

    @Override
    public Map<String, Object> unwrapped() {
        HashMap<String, Object> m2 = new HashMap<String, Object>();
        for (Map.Entry<String, AbstractConfigValue> e : this.value.entrySet()) {
            m2.put(e.getKey(), e.getValue().unwrapped());
        }
        return m2;
    }

    @Override
    protected SimpleConfigObject mergedWithObject(AbstractConfigObject abstractFallback) {
        this.requireNotIgnoringFallbacks();
        if (!(abstractFallback instanceof SimpleConfigObject)) {
            throw new ConfigException.BugOrBroken("should not be reached (merging non-SimpleConfigObject)");
        }
        SimpleConfigObject fallback = (SimpleConfigObject)abstractFallback;
        boolean changed = false;
        boolean allResolved = true;
        HashMap<String, AbstractConfigValue> merged = new HashMap<String, AbstractConfigValue>();
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(this.keySet());
        allKeys.addAll(fallback.keySet());
        for (String key2 : allKeys) {
            AbstractConfigValue first = this.value.get(key2);
            AbstractConfigValue second = fallback.value.get(key2);
            AbstractConfigValue kept = first == null ? second : (second == null ? first : first.withFallback(second));
            merged.put(key2, kept);
            if (first != kept) {
                changed = true;
            }
            if (kept.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
            allResolved = false;
        }
        ResolveStatus newResolveStatus = ResolveStatus.fromBoolean(allResolved);
        boolean newIgnoresFallbacks = fallback.ignoresFallbacks();
        if (changed) {
            return new SimpleConfigObject(SimpleConfigObject.mergeOrigins(this, fallback), merged, newResolveStatus, newIgnoresFallbacks);
        }
        if (newResolveStatus != this.resolveStatus() || newIgnoresFallbacks != this.ignoresFallbacks()) {
            return this.newCopy(newResolveStatus, this.origin(), newIgnoresFallbacks);
        }
        return this;
    }

    private SimpleConfigObject modify(AbstractConfigValue.NoExceptionsModifier modifier) {
        try {
            return this.modifyMayThrow(modifier);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", e);
        }
    }

    private SimpleConfigObject modifyMayThrow(AbstractConfigValue.Modifier modifier) throws Exception {
        HashMap<String, AbstractConfigValue> changes = null;
        for (String k : this.keySet()) {
            AbstractConfigValue v2;
            AbstractConfigValue modified = modifier.modifyChildMayThrow(k, v2 = this.value.get(k));
            if (modified == v2) continue;
            if (changes == null) {
                changes = new HashMap<String, AbstractConfigValue>();
            }
            changes.put(k, modified);
        }
        if (changes == null) {
            return this;
        }
        HashMap<String, AbstractConfigValue> modified = new HashMap<String, AbstractConfigValue>();
        boolean sawUnresolved = false;
        for (String k : this.keySet()) {
            AbstractConfigValue newValue;
            if (changes.containsKey(k)) {
                newValue = (AbstractConfigValue)changes.get(k);
                if (newValue == null) continue;
                modified.put(k, newValue);
                if (newValue.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
                sawUnresolved = true;
                continue;
            }
            newValue = this.value.get(k);
            modified.put(k, newValue);
            if (newValue.resolveStatus() != ResolveStatus.UNRESOLVED) continue;
            sawUnresolved = true;
        }
        return new SimpleConfigObject(this.origin(), modified, sawUnresolved ? ResolveStatus.UNRESOLVED : ResolveStatus.RESOLVED, this.ignoresFallbacks());
    }

    @Override
    ResolveResult<? extends AbstractConfigObject> resolveSubstitutions(ResolveContext context, ResolveSource source) throws AbstractConfigValue.NotPossibleToResolve {
        if (this.resolveStatus() == ResolveStatus.RESOLVED) {
            return ResolveResult.make(context, this);
        }
        ResolveSource sourceWithParent = source.pushParent(this);
        try {
            ResolveModifier modifier = new ResolveModifier(context, sourceWithParent);
            SimpleConfigObject value2 = this.modifyMayThrow(modifier);
            return ResolveResult.make(modifier.context, value2).asObjectResult();
        }
        catch (AbstractConfigValue.NotPossibleToResolve e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigException.BugOrBroken("unexpected checked exception", e);
        }
    }

    @Override
    SimpleConfigObject relativized(final Path prefix) {
        return this.modify(new AbstractConfigValue.NoExceptionsModifier(){

            @Override
            public AbstractConfigValue modifyChild(String key2, AbstractConfigValue v2) {
                return v2.relativized(prefix);
            }
        });
    }

    @Override
    protected void render(StringBuilder sb, int indent, boolean atRoot, ConfigRenderOptions options2) {
        if (this.isEmpty()) {
            sb.append("{}");
        } else {
            int innerIndent;
            boolean outerBraces;
            boolean bl = outerBraces = options2.getJson() || !atRoot;
            if (outerBraces) {
                innerIndent = indent + 1;
                sb.append("{");
                if (options2.getFormatted()) {
                    sb.append('\n');
                }
            } else {
                innerIndent = indent;
            }
            int separatorCount = 0;
            String[] keys = this.keySet().toArray(new String[this.size()]);
            Arrays.sort(keys, new RenderComparator());
            for (String k : keys) {
                AbstractConfigValue v2 = this.value.get(k);
                if (options2.getOriginComments()) {
                    String[] lines;
                    for (String l2 : lines = v2.origin().description().split("\n")) {
                        SimpleConfigObject.indent(sb, indent + 1, options2);
                        sb.append('#');
                        if (!l2.isEmpty()) {
                            sb.append(' ');
                        }
                        sb.append(l2);
                        sb.append("\n");
                    }
                }
                if (options2.getComments()) {
                    for (String comment : v2.origin().comments()) {
                        SimpleConfigObject.indent(sb, innerIndent, options2);
                        sb.append("#");
                        if (!comment.startsWith(" ")) {
                            sb.append(' ');
                        }
                        sb.append(comment);
                        sb.append("\n");
                    }
                }
                SimpleConfigObject.indent(sb, innerIndent, options2);
                v2.render(sb, innerIndent, false, k, options2);
                if (options2.getFormatted()) {
                    if (options2.getJson()) {
                        sb.append(",");
                        separatorCount = 2;
                    } else {
                        separatorCount = 1;
                    }
                    sb.append('\n');
                    continue;
                }
                sb.append(",");
                separatorCount = 1;
            }
            sb.setLength(sb.length() - separatorCount);
            if (outerBraces) {
                if (options2.getFormatted()) {
                    sb.append('\n');
                    if (outerBraces) {
                        SimpleConfigObject.indent(sb, indent, options2);
                    }
                }
                sb.append("}");
            }
        }
        if (atRoot && options2.getFormatted()) {
            sb.append('\n');
        }
    }

    @Override
    public AbstractConfigValue get(Object key2) {
        return this.value.get(key2);
    }

    private static boolean mapEquals(Map<String, ConfigValue> a, Map<String, ConfigValue> b2) {
        Set<String> bKeys;
        if (a == b2) {
            return true;
        }
        Set<String> aKeys = a.keySet();
        if (!aKeys.equals(bKeys = b2.keySet())) {
            return false;
        }
        for (String key2 : aKeys) {
            if (a.get(key2).equals(b2.get(key2))) continue;
            return false;
        }
        return true;
    }

    private static int mapHash(Map<String, ConfigValue> m2) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(m2.keySet());
        Collections.sort(keys);
        int valuesHash = 0;
        for (String k : keys) {
            valuesHash += m2.get(k).hashCode();
        }
        return 41 * (41 + keys.hashCode()) + valuesHash;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ConfigObject;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConfigObject) {
            return this.canEqual(other) && SimpleConfigObject.mapEquals(this, (ConfigObject)other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return SimpleConfigObject.mapHash(this);
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.value.containsKey(key2);
    }

    @Override
    public Set<String> keySet() {
        return this.value.keySet();
    }

    @Override
    public boolean containsValue(Object v2) {
        return this.value.containsValue(v2);
    }

    @Override
    public Set<Map.Entry<String, ConfigValue>> entrySet() {
        HashSet<Map.Entry<String, ConfigValue>> entries = new HashSet<Map.Entry<String, ConfigValue>>();
        for (Map.Entry<String, AbstractConfigValue> e : this.value.entrySet()) {
            entries.add(new AbstractMap.SimpleImmutableEntry<String, AbstractConfigValue>(e.getKey(), e.getValue()));
        }
        return entries;
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    @Override
    public int size() {
        return this.value.size();
    }

    @Override
    public Collection<ConfigValue> values() {
        return new HashSet<ConfigValue>(this.value.values());
    }

    static final SimpleConfigObject empty() {
        return emptyInstance;
    }

    static final SimpleConfigObject empty(ConfigOrigin origin) {
        if (origin == null) {
            return SimpleConfigObject.empty();
        }
        return new SimpleConfigObject(origin, Collections.emptyMap());
    }

    static final SimpleConfigObject emptyMissing(ConfigOrigin baseOrigin) {
        return new SimpleConfigObject(SimpleConfigOrigin.newSimple(baseOrigin.description() + " (not found)"), Collections.emptyMap());
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedConfigValue(this);
    }

    private static final class RenderComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RenderComparator() {
        }

        private static boolean isAllDigits(String s2) {
            int length = s2.length();
            if (length == 0) {
                return false;
            }
            for (int i2 = 0; i2 < length; ++i2) {
                char c = s2.charAt(i2);
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int compare(String a, String b2) {
            boolean aDigits = RenderComparator.isAllDigits(a);
            boolean bDigits = RenderComparator.isAllDigits(b2);
            if (aDigits && bDigits) {
                return Integer.compare(Integer.parseInt(a), Integer.parseInt(b2));
            }
            if (aDigits) {
                return -1;
            }
            if (bDigits) {
                return 1;
            }
            return a.compareTo(b2);
        }
    }

    private static final class ResolveModifier
    implements AbstractConfigValue.Modifier {
        final Path originalRestrict;
        ResolveContext context;
        final ResolveSource source;

        ResolveModifier(ResolveContext context, ResolveSource source) {
            this.context = context;
            this.source = source;
            this.originalRestrict = context.restrictToChild();
        }

        @Override
        public AbstractConfigValue modifyChildMayThrow(String key2, AbstractConfigValue v2) throws AbstractConfigValue.NotPossibleToResolve {
            if (this.context.isRestrictedToChild()) {
                if (key2.equals(this.context.restrictToChild().first())) {
                    Path remainder = this.context.restrictToChild().remainder();
                    if (remainder != null) {
                        ResolveResult<? extends AbstractConfigValue> result2 = this.context.restrict(remainder).resolve(v2, this.source);
                        this.context = result2.context.unrestricted().restrict(this.originalRestrict);
                        return result2.value;
                    }
                    return v2;
                }
                return v2;
            }
            ResolveResult<? extends AbstractConfigValue> result3 = this.context.unrestricted().resolve(v2, this.source);
            this.context = result3.context.unrestricted().restrict(this.originalRestrict);
            return result3.value;
        }
    }
}

