/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.dht;

import java.util.concurrent.Future;
import ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;

public class DoubleDHT_1D {
    private int n;
    private DoubleFFT_1D fft;

    public DoubleDHT_1D(int n2) {
        this.n = n2;
        this.fft = new DoubleFFT_1D(n2);
    }

    public void forward(double[] a) {
        this.forward(a, 0);
    }

    public void forward(final double[] a, final int offa) {
        if (this.n == 1) {
            return;
        }
        this.fft.realForward(a, offa);
        final double[] b2 = new double[this.n];
        System.arraycopy(a, offa, b2, 0, this.n);
        int nd2 = this.n / 2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && nd2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k1 = nd2 / nthreads;
            Future[] futures = new Future[nthreads];
            int i2 = 0;
            while (i2 < nthreads) {
                final int firstIdx = 1 + i2 * k1;
                final int lastIdx = i2 == nthreads - 1 ? nd2 : firstIdx + k1;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            a[offa + i2] = b2[idx1] - b2[idx2];
                            a[offa + ((DoubleDHT_1D)DoubleDHT_1D.this).n - i2] = b2[idx1] + b2[idx2];
                            ++i2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 1;
            while (i3 < nd2) {
                int idx1 = 2 * i3;
                int idx2 = idx1 + 1;
                a[offa + i3] = b2[idx1] - b2[idx2];
                a[offa + this.n - i3] = b2[idx1] + b2[idx2];
                ++i3;
            }
        }
        if (this.n % 2 == 0) {
            a[offa + nd2] = b2[1];
        } else {
            a[offa + nd2] = b2[this.n - 1] - b2[1];
            a[offa + nd2 + 1] = b2[this.n - 1] + b2[1];
        }
    }

    public void inverse(double[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(double[] a, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        this.forward(a, offa);
        if (scale) {
            this.scale(this.n, a, offa);
        }
    }

    private void scale(double m2, final double[] a, int offa) {
        final double norm2 = 1.0 / m2;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.n >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            nthreads = 2;
            int k = this.n / nthreads;
            Future[] futures = new Future[nthreads];
            int i2 = 0;
            while (i2 < nthreads) {
                final int firstIdx = offa + i2 * k;
                final int lastIdx = i2 == nthreads - 1 ? offa + this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int n2 = i2++;
                            a[n2] = a[n2] * norm2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int lastIdx = offa + this.n;
            int i3 = offa;
            while (i3 < lastIdx) {
                int n2 = i3++;
                a[n2] = a[n2] * norm2;
            }
        }
    }
}

