/*
 * Decompiled with CFR 0.152.
 */
package ml.combust.mleap.shaded.edu.emory.mathcs.jtransforms.fft;

import java.util.concurrent.Future;
import ml.combust.mleap.shaded.edu.emory.mathcs.utils.ConcurrencyUtils;

public class DoubleFFT_1D {
    private int n;
    private int nBluestein;
    private int[] ip;
    private double[] w;
    private int nw;
    private int nc;
    private double[] wtable;
    private double[] wtable_r;
    private double[] bk1;
    private double[] bk2;
    private Plans plan;
    private static final int[] factors = new int[]{4, 2, 3, 5};
    private static final double PI = Math.PI;
    private static final double TWO_PI = Math.PI * 2;

    public DoubleFFT_1D(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.n = n2;
        if (!ConcurrencyUtils.isPowerOf2(n2)) {
            if (DoubleFFT_1D.getReminder(n2, factors) >= 211) {
                this.plan = Plans.BLUESTEIN;
                this.nBluestein = ConcurrencyUtils.nextPow2(n2 * 2 - 1);
                this.bk1 = new double[2 * this.nBluestein];
                this.bk2 = new double[2 * this.nBluestein];
                this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)this.nBluestein + 0.5) / Math.log(2.0)) / 2))];
                this.w = new double[this.nBluestein];
                int twon = 2 * this.nBluestein;
                this.nw = this.ip[0];
                if (twon > this.nw << 2) {
                    this.nw = twon >> 2;
                    this.makewt(this.nw);
                }
                this.nc = this.ip[1];
                if (this.nBluestein > this.nc << 2) {
                    this.nc = this.nBluestein >> 2;
                    this.makect(this.nc, this.w, this.nw);
                }
                this.bluesteini();
            } else {
                this.plan = Plans.MIXED_RADIX;
                this.wtable = new double[4 * n2 + 15];
                this.wtable_r = new double[2 * n2 + 15];
                this.cffti();
                this.rffti();
            }
        } else {
            this.plan = Plans.SPLIT_RADIX;
            this.ip = new int[2 + (int)Math.ceil(2 + (1 << (int)(Math.log((double)n2 + 0.5) / Math.log(2.0)) / 2))];
            this.w = new double[n2];
            int twon = 2 * n2;
            this.nw = this.ip[0];
            if (twon > this.nw << 2) {
                this.nw = twon >> 2;
                this.makewt(this.nw);
            }
            this.nc = this.ip[1];
            if (n2 > this.nc << 2) {
                this.nc = n2 >> 2;
                this.makect(this.nc, this.w, this.nw);
            }
        }
    }

    public void complexForward(double[] a) {
        this.complexForward(a, 0);
    }

    public void complexForward(double[] a, int offa) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.cftbsub(2 * this.n, a, offa, this.ip, this.nw, this.w);
                break;
            }
            case MIXED_RADIX: {
                this.cfftf(a, offa, -1);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_complex(a, offa, -1);
            }
        }
    }

    public void complexInverse(double[] a, boolean scale) {
        this.complexInverse(a, 0, scale);
    }

    public void complexInverse(double[] a, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.cftfsub(2 * this.n, a, offa, this.ip, this.nw, this.w);
                break;
            }
            case MIXED_RADIX: {
                this.cfftf(a, offa, 1);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_complex(a, offa, 1);
            }
        }
        if (scale) {
            this.scale(this.n, a, offa, true);
        }
    }

    public void realForward(double[] a) {
        this.realForward(a, 0);
    }

    public void realForward(double[] a, int offa) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.n > 4) {
                    this.cftfsub(this.n, a, offa, this.ip, this.nw, this.w);
                    this.rftfsub(this.n, a, offa, this.nc, this.w, this.nw);
                } else if (this.n == 4) {
                    this.cftx020(a, offa);
                }
                double xi = a[offa] - a[offa + 1];
                int n2 = offa;
                a[n2] = a[n2] + a[offa + 1];
                a[offa + 1] = xi;
                break;
            }
            case MIXED_RADIX: {
                this.rfftf(a, offa);
                int k = this.n - 1;
                while (k >= 2) {
                    int idx = offa + k;
                    double tmp = a[idx];
                    a[idx] = a[idx - 1];
                    a[idx - 1] = tmp;
                    --k;
                }
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_forward(a, offa);
            }
        }
    }

    public void realForwardFull(double[] a) {
        this.realForwardFull(a, 0);
    }

    public void realForwardFull(final double[] a, final int offa) {
        final int twon = 2 * this.n;
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.realForward(a, offa);
                int nthreads = ConcurrencyUtils.getNumberOfThreads();
                if (nthreads > 1 && this.n / 2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    Future[] futures = new Future[nthreads];
                    int k = this.n / 2 / nthreads;
                    int i2 = 0;
                    while (i2 < nthreads) {
                        final int firstIdx = i2 * k;
                        final int lastIdx = i2 == nthreads - 1 ? this.n / 2 : firstIdx + k;
                        futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                            public void run() {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int idx1 = 2 * k;
                                    int idx2 = offa + (twon - idx1) % twon;
                                    a[idx2] = a[offa + idx1];
                                    a[idx2 + 1] = -a[offa + idx1 + 1];
                                    ++k;
                                }
                            }
                        });
                        ++i2;
                    }
                    ConcurrencyUtils.waitForCompletion(futures);
                } else {
                    int k = 0;
                    while (k < this.n / 2) {
                        int idx1 = 2 * k;
                        int idx2 = offa + (twon - idx1) % twon;
                        a[idx2] = a[offa + idx1];
                        a[idx2 + 1] = -a[offa + idx1 + 1];
                        ++k;
                    }
                }
                a[offa + this.n] = -a[offa + 1];
                a[offa + 1] = 0.0;
                break;
            }
            case MIXED_RADIX: {
                this.rfftf(a, offa);
                int m2 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                int k = 1;
                while (k < m2) {
                    int idx1 = offa + twon - 2 * k;
                    int idx2 = offa + 2 * k;
                    a[idx1 + 1] = -a[idx2];
                    a[idx1] = a[idx2 - 1];
                    ++k;
                }
                k = 1;
                while (k < this.n) {
                    int idx = offa + this.n - k;
                    double tmp = a[idx + 1];
                    a[idx + 1] = a[idx];
                    a[idx] = tmp;
                    ++k;
                }
                a[offa + 1] = 0.0;
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_full(a, offa, -1);
            }
        }
    }

    public void realInverse(double[] a, boolean scale) {
        this.realInverse(a, 0, scale);
    }

    public void realInverse(double[] a, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                a[offa + 1] = 0.5 * (a[offa] - a[offa + 1]);
                int n2 = offa;
                a[n2] = a[n2] - a[offa + 1];
                if (this.n > 4) {
                    this.rftfsub(this.n, a, offa, this.nc, this.w, this.nw);
                    this.cftbsub(this.n, a, offa, this.ip, this.nw, this.w);
                } else if (this.n == 4) {
                    this.cftxc020(a, offa);
                }
                if (!scale) break;
                this.scale(this.n / 2, a, offa, false);
                break;
            }
            case MIXED_RADIX: {
                int k = 2;
                while (k < this.n) {
                    int idx = offa + k;
                    double tmp = a[idx - 1];
                    a[idx - 1] = a[idx];
                    a[idx] = tmp;
                    ++k;
                }
                this.rfftb(a, offa);
                if (!scale) break;
                this.scale(this.n, a, offa, false);
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse(a, offa);
                if (!scale) break;
                this.scale(this.n, a, offa, false);
            }
        }
    }

    public void realInverseFull(double[] a, boolean scale) {
        this.realInverseFull(a, 0, scale);
    }

    public void realInverseFull(final double[] a, final int offa, boolean scale) {
        final int twon = 2 * this.n;
        switch (this.plan) {
            case SPLIT_RADIX: {
                this.realInverse2(a, offa, scale);
                int nthreads = ConcurrencyUtils.getNumberOfThreads();
                if (nthreads > 1 && this.n / 2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    Future[] futures = new Future[nthreads];
                    int k = this.n / 2 / nthreads;
                    int i2 = 0;
                    while (i2 < nthreads) {
                        final int firstIdx = i2 * k;
                        final int lastIdx = i2 == nthreads - 1 ? this.n / 2 : firstIdx + k;
                        futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                            public void run() {
                                int k = firstIdx;
                                while (k < lastIdx) {
                                    int idx1 = 2 * k;
                                    int idx2 = offa + (twon - idx1) % twon;
                                    a[idx2] = a[offa + idx1];
                                    a[idx2 + 1] = -a[offa + idx1 + 1];
                                    ++k;
                                }
                            }
                        });
                        ++i2;
                    }
                    ConcurrencyUtils.waitForCompletion(futures);
                } else {
                    int k = 0;
                    while (k < this.n / 2) {
                        int idx1 = 2 * k;
                        int idx2 = offa + (twon - idx1) % twon;
                        a[idx2] = a[offa + idx1];
                        a[idx2 + 1] = -a[offa + idx1 + 1];
                        ++k;
                    }
                }
                a[offa + this.n] = -a[offa + 1];
                a[offa + 1] = 0.0;
                break;
            }
            case MIXED_RADIX: {
                this.rfftf(a, offa);
                if (scale) {
                    this.scale(this.n, a, offa, false);
                }
                int m2 = this.n % 2 == 0 ? this.n / 2 : (this.n + 1) / 2;
                int k = 1;
                while (k < m2) {
                    int idx1 = offa + 2 * k;
                    int idx2 = offa + twon - 2 * k;
                    a[idx1] = -a[idx1];
                    a[idx2 + 1] = -a[idx1];
                    a[idx2] = a[idx1 - 1];
                    ++k;
                }
                k = 1;
                while (k < this.n) {
                    int idx = offa + this.n - k;
                    double tmp = a[idx + 1];
                    a[idx + 1] = a[idx];
                    a[idx] = tmp;
                    ++k;
                }
                a[offa + 1] = 0.0;
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_full(a, offa, 1);
                if (!scale) break;
                this.scale(this.n, a, offa, true);
            }
        }
    }

    protected void realInverse2(double[] a, int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        switch (this.plan) {
            case SPLIT_RADIX: {
                if (this.n > 4) {
                    this.cftfsub(this.n, a, offa, this.ip, this.nw, this.w);
                    this.rftbsub(this.n, a, offa, this.nc, this.w, this.nw);
                } else if (this.n == 4) {
                    this.cftbsub(this.n, a, offa, this.ip, this.nw, this.w);
                }
                double xi = a[offa] - a[offa + 1];
                int n2 = offa;
                a[n2] = a[n2] + a[offa + 1];
                a[offa + 1] = xi;
                if (!scale) break;
                this.scale(this.n, a, offa, false);
                break;
            }
            case MIXED_RADIX: {
                int i2;
                int m2;
                this.rfftf(a, offa);
                int k = this.n - 1;
                while (k >= 2) {
                    int idx = offa + k;
                    double tmp = a[idx];
                    a[idx] = a[idx - 1];
                    a[idx - 1] = tmp;
                    --k;
                }
                if (scale) {
                    this.scale(this.n, a, offa, false);
                }
                if (this.n % 2 == 0) {
                    m2 = this.n / 2;
                    i2 = 1;
                    while (i2 < m2) {
                        int idx = offa + 2 * i2 + 1;
                        a[idx] = -a[idx];
                        ++i2;
                    }
                } else {
                    m2 = (this.n - 1) / 2;
                    i2 = 0;
                    while (i2 < m2) {
                        int idx = offa + 2 * i2 + 1;
                        a[idx] = -a[idx];
                        ++i2;
                    }
                }
                break;
            }
            case BLUESTEIN: {
                this.bluestein_real_inverse2(a, offa);
                if (!scale) break;
                this.scale(this.n, a, offa, false);
            }
        }
    }

    private static int getReminder(int n2, int[] factors) {
        int reminder = n2;
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive integer");
        }
        int i2 = 0;
        while (i2 < factors.length && reminder != 1) {
            int factor = factors[i2];
            while (reminder % factor == 0) {
                reminder /= factor;
            }
            ++i2;
        }
        return reminder;
    }

    void cffti(int n2, int offw) {
        int idx;
        int i2;
        if (n2 == 1) {
            return;
        }
        int twon = 2 * n2;
        int fourn = 4 * n2;
        int ntry = 0;
        int nl = n2;
        int nf = 0;
        int j = 0;
        block0: while (true) {
            ntry = ++j <= 4 ? factors[j - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nl - ntry * (nq = nl / ntry)) != 0) continue block0;
                this.wtable[offw + ++nf + 1 + fourn] = ntry;
                nl = nq;
                if (ntry != 2 || nf == 1) continue;
                i2 = 2;
                while (i2 <= nf) {
                    int ib = nf - i2 + 2;
                    idx = ib + fourn;
                    this.wtable[offw + idx + 1] = this.wtable[offw + idx];
                    ++i2;
                }
                this.wtable[offw + 2 + fourn] = 2.0;
            } while (nl != 1);
            break;
        }
        this.wtable[offw + fourn] = n2;
        this.wtable[offw + 1 + fourn] = nf;
        double argh = Math.PI * 2 / (double)n2;
        i2 = 1;
        int l1 = 1;
        int k1 = 1;
        while (k1 <= nf) {
            int ip = (int)this.wtable[offw + k1 + 1 + fourn];
            int ld = 0;
            int l2 = l1 * ip;
            int ido = n2 / l2;
            int idot = ido + ido + 2;
            int ipm = ip - 1;
            j = 1;
            while (j <= ipm) {
                int i1 = i2;
                this.wtable[offw + i2 - 1 + twon] = 1.0;
                this.wtable[offw + i2 + twon] = 0.0;
                double fi = 0.0;
                double argld = (double)(ld += l1) * argh;
                int ii = 4;
                while (ii <= idot) {
                    double arg = (fi += 1.0) * argld;
                    idx = (i2 += 2) + twon;
                    this.wtable[offw + idx - 1] = Math.cos(arg);
                    this.wtable[offw + idx] = Math.sin(arg);
                    ii += 2;
                }
                if (ip > 5) {
                    int idx1 = i1 + twon;
                    int idx2 = i2 + twon;
                    this.wtable[offw + idx1 - 1] = this.wtable[offw + idx2 - 1];
                    this.wtable[offw + idx1] = this.wtable[offw + idx2];
                }
                ++j;
            }
            l1 = l2;
            ++k1;
        }
    }

    void cffti() {
        int idx;
        int i2;
        if (this.n == 1) {
            return;
        }
        int twon = 2 * this.n;
        int fourn = 4 * this.n;
        int ntry = 0;
        int nl = this.n;
        int nf = 0;
        int j = 0;
        block0: while (true) {
            ntry = ++j <= 4 ? factors[j - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nl - ntry * (nq = nl / ntry)) != 0) continue block0;
                this.wtable[++nf + 1 + fourn] = ntry;
                nl = nq;
                if (ntry != 2 || nf == 1) continue;
                i2 = 2;
                while (i2 <= nf) {
                    int ib = nf - i2 + 2;
                    idx = ib + fourn;
                    this.wtable[idx + 1] = this.wtable[idx];
                    ++i2;
                }
                this.wtable[2 + fourn] = 2.0;
            } while (nl != 1);
            break;
        }
        this.wtable[fourn] = this.n;
        this.wtable[1 + fourn] = nf;
        double argh = Math.PI * 2 / (double)this.n;
        i2 = 1;
        int l1 = 1;
        int k1 = 1;
        while (k1 <= nf) {
            int ip = (int)this.wtable[k1 + 1 + fourn];
            int ld = 0;
            int l2 = l1 * ip;
            int ido = this.n / l2;
            int idot = ido + ido + 2;
            int ipm = ip - 1;
            j = 1;
            while (j <= ipm) {
                int i1 = i2;
                this.wtable[i2 - 1 + twon] = 1.0;
                this.wtable[i2 + twon] = 0.0;
                double fi = 0.0;
                double argld = (double)(ld += l1) * argh;
                int ii = 4;
                while (ii <= idot) {
                    double arg = (fi += 1.0) * argld;
                    idx = (i2 += 2) + twon;
                    this.wtable[idx - 1] = Math.cos(arg);
                    this.wtable[idx] = Math.sin(arg);
                    ii += 2;
                }
                if (ip > 5) {
                    int idx1 = i1 + twon;
                    int idx2 = i2 + twon;
                    this.wtable[idx1 - 1] = this.wtable[idx2 - 1];
                    this.wtable[idx1] = this.wtable[idx2];
                }
                ++j;
            }
            l1 = l2;
            ++k1;
        }
    }

    void rffti() {
        int idx;
        int i2;
        if (this.n == 1) {
            return;
        }
        int twon = 2 * this.n;
        int ntry = 0;
        int nl = this.n;
        int nf = 0;
        int j = 0;
        block0: while (true) {
            ntry = ++j <= 4 ? factors[j - 1] : (ntry += 2);
            do {
                int nq;
                int nr;
                if ((nr = nl - ntry * (nq = nl / ntry)) != 0) continue block0;
                this.wtable_r[++nf + 1 + twon] = ntry;
                nl = nq;
                if (ntry != 2 || nf == 1) continue;
                i2 = 2;
                while (i2 <= nf) {
                    int ib = nf - i2 + 2;
                    idx = ib + twon;
                    this.wtable_r[idx + 1] = this.wtable_r[idx];
                    ++i2;
                }
                this.wtable_r[2 + twon] = 2.0;
            } while (nl != 1);
            break;
        }
        this.wtable_r[twon] = this.n;
        this.wtable_r[1 + twon] = nf;
        double argh = Math.PI * 2 / (double)this.n;
        int is = 0;
        int nfm1 = nf - 1;
        int l1 = 1;
        if (nfm1 == 0) {
            return;
        }
        int k1 = 1;
        while (k1 <= nfm1) {
            int ip = (int)this.wtable_r[k1 + 1 + twon];
            int ld = 0;
            int l2 = l1 * ip;
            int ido = this.n / l2;
            int ipm = ip - 1;
            j = 1;
            while (j <= ipm) {
                i2 = is;
                double argld = (double)(ld += l1) * argh;
                double fi = 0.0;
                int ii = 3;
                while (ii <= ido) {
                    double arg = (fi += 1.0) * argld;
                    idx = (i2 += 2) + this.n;
                    this.wtable_r[idx - 2] = Math.cos(arg);
                    this.wtable_r[idx - 1] = Math.sin(arg);
                    ii += 2;
                }
                is += ido;
                ++j;
            }
            l1 = l2;
            ++k1;
        }
    }

    private void bluesteini() {
        int k = 0;
        double pi_n = Math.PI / (double)this.n;
        this.bk1[0] = 1.0;
        this.bk1[1] = 0.0;
        int i2 = 1;
        while (i2 < this.n) {
            if ((k += 2 * i2 - 1) >= 2 * this.n) {
                k -= 2 * this.n;
            }
            double arg = pi_n * (double)k;
            this.bk1[2 * i2] = Math.cos(arg);
            this.bk1[2 * i2 + 1] = Math.sin(arg);
            ++i2;
        }
        double scale = 1.0 / (double)this.nBluestein;
        this.bk2[0] = this.bk1[0] * scale;
        this.bk2[1] = this.bk1[1] * scale;
        int i3 = 2;
        while (i3 < 2 * this.n) {
            this.bk2[i3] = this.bk1[i3] * scale;
            this.bk2[i3 + 1] = this.bk1[i3 + 1] * scale;
            this.bk2[2 * this.nBluestein - i3] = this.bk2[i3];
            this.bk2[2 * this.nBluestein - i3 + 1] = this.bk2[i3 + 1];
            i3 += 2;
        }
        this.cftbsub(2 * this.nBluestein, this.bk2, 0, this.ip, this.nw, this.w);
    }

    private void makewt(int nw) {
        this.ip[0] = nw;
        this.ip[1] = 1;
        if (nw > 2) {
            int j;
            int nwh = nw >> 1;
            double delta = 0.7853981633974483 / (double)nwh;
            double delta2 = delta * 2.0;
            double wn4r = Math.cos(delta * (double)nwh);
            this.w[0] = 1.0;
            this.w[1] = wn4r;
            if (nwh == 4) {
                this.w[2] = Math.cos(delta2);
                this.w[3] = Math.sin(delta2);
            } else if (nwh > 4) {
                this.makeipt(nw);
                this.w[2] = 0.5 / Math.cos(delta2);
                this.w[3] = 0.5 / Math.cos(delta * 6.0);
                j = 4;
                while (j < nwh) {
                    double deltaj = delta * (double)j;
                    double deltaj3 = 3.0 * deltaj;
                    this.w[j] = Math.cos(deltaj);
                    this.w[j + 1] = Math.sin(deltaj);
                    this.w[j + 2] = Math.cos(deltaj3);
                    this.w[j + 3] = -Math.sin(deltaj3);
                    j += 4;
                }
            }
            int nw0 = 0;
            while (nwh > 2) {
                double wk1i;
                double wk1r;
                int nw1 = nw0 + nwh;
                this.w[nw1] = 1.0;
                this.w[nw1 + 1] = wn4r;
                if ((nwh >>= 1) == 4) {
                    wk1r = this.w[nw0 + 4];
                    wk1i = this.w[nw0 + 5];
                    this.w[nw1 + 2] = wk1r;
                    this.w[nw1 + 3] = wk1i;
                } else if (nwh > 4) {
                    wk1r = this.w[nw0 + 4];
                    double wk3r = this.w[nw0 + 6];
                    this.w[nw1 + 2] = 0.5 / wk1r;
                    this.w[nw1 + 3] = 0.5 / wk3r;
                    j = 4;
                    while (j < nwh) {
                        int idx1 = nw0 + 2 * j;
                        int idx2 = nw1 + j;
                        wk1r = this.w[idx1];
                        wk1i = this.w[idx1 + 1];
                        wk3r = this.w[idx1 + 2];
                        double wk3i = this.w[idx1 + 3];
                        this.w[idx2] = wk1r;
                        this.w[idx2 + 1] = wk1i;
                        this.w[idx2 + 2] = wk3r;
                        this.w[idx2 + 3] = wk3i;
                        j += 4;
                    }
                }
                nw0 = nw1;
            }
        }
    }

    private void makeipt(int nw) {
        this.ip[2] = 0;
        this.ip[3] = 16;
        int m2 = 2;
        int l2 = nw;
        while (l2 > 32) {
            int m22 = m2 << 1;
            int q = m22 << 3;
            int j = m2;
            while (j < m22) {
                int p;
                this.ip[m2 + j] = p = this.ip[j] << 2;
                this.ip[m22 + j] = p + q;
                ++j;
            }
            m2 = m22;
            l2 >>= 2;
        }
    }

    private void makect(int nc, double[] c, int startc) {
        this.ip[1] = nc;
        if (nc > 1) {
            int nch = nc >> 1;
            double delta = 0.7853981633974483 / (double)nch;
            c[startc] = Math.cos(delta * (double)nch);
            c[startc + nch] = 0.5 * c[startc];
            int j = 1;
            while (j < nch) {
                double deltaj = delta * (double)j;
                c[startc + j] = 0.5 * Math.cos(deltaj);
                c[startc + nc - j] = 0.5 * Math.sin(deltaj);
                ++j;
            }
        }
    }

    private void bluestein_complex(final double[] a, final int offa, final int isign) {
        final double[] ak = new double[2 * this.nBluestein];
        int nthreads = 1;
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            nthreads = 2;
            if (threads >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k = this.n / nthreads;
            int i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (isign > 0) {
                            int i2 = firstIdx;
                            while (i2 < lastIdx) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                ak[idx1] = a[idx3] * DoubleFFT_1D.this.bk1[idx1] - a[idx4] * DoubleFFT_1D.this.bk1[idx2];
                                ak[idx2] = a[idx3] * DoubleFFT_1D.this.bk1[idx2] + a[idx4] * DoubleFFT_1D.this.bk1[idx1];
                                ++i2;
                            }
                        } else {
                            int i3 = firstIdx;
                            while (i3 < lastIdx) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                ak[idx1] = a[idx3] * DoubleFFT_1D.this.bk1[idx1] + a[idx4] * DoubleFFT_1D.this.bk1[idx2];
                                ak[idx2] = -a[idx3] * DoubleFFT_1D.this.bk1[idx2] + a[idx4] * DoubleFFT_1D.this.bk1[idx1];
                                ++i3;
                            }
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.nBluestein / nthreads;
            i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.nBluestein : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (isign > 0) {
                            int i2 = firstIdx;
                            while (i2 < lastIdx) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                double im = -ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] + ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                                ++i2;
                            }
                        } else {
                            int i3 = firstIdx;
                            while (i3 < lastIdx) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                double im = ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] - ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                                ++i3;
                            }
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.n / nthreads;
            i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (isign > 0) {
                            int i2 = firstIdx;
                            while (i2 < lastIdx) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                a[idx3] = DoubleFFT_1D.this.bk1[idx1] * ak[idx1] - DoubleFFT_1D.this.bk1[idx2] * ak[idx2];
                                a[idx4] = DoubleFFT_1D.this.bk1[idx2] * ak[idx1] + DoubleFFT_1D.this.bk1[idx1] * ak[idx2];
                                ++i2;
                            }
                        } else {
                            int i3 = firstIdx;
                            while (i3 < lastIdx) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + idx1;
                                int idx4 = offa + idx2;
                                a[idx3] = DoubleFFT_1D.this.bk1[idx1] * ak[idx1] + DoubleFFT_1D.this.bk1[idx2] * ak[idx2];
                                a[idx4] = -DoubleFFT_1D.this.bk1[idx2] * ak[idx1] + DoubleFFT_1D.this.bk1[idx1] * ak[idx2];
                                ++i3;
                            }
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx4;
            int idx3;
            int idx2;
            int idx1;
            int i3;
            if (isign > 0) {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    idx3 = offa + idx1;
                    idx4 = offa + idx2;
                    ak[idx1] = a[idx3] * this.bk1[idx1] - a[idx4] * this.bk1[idx2];
                    ak[idx2] = a[idx3] * this.bk1[idx2] + a[idx4] * this.bk1[idx1];
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    idx3 = offa + idx1;
                    idx4 = offa + idx2;
                    ak[idx1] = a[idx3] * this.bk1[idx1] + a[idx4] * this.bk1[idx2];
                    ak[idx2] = -a[idx3] * this.bk1[idx2] + a[idx4] * this.bk1[idx1];
                    ++i3;
                }
            }
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                i3 = 0;
                while (i3 < this.nBluestein) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    double im = -ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] + ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < this.nBluestein) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    double im = ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] - ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                    ++i3;
                }
            }
            this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    int idx32 = offa + idx1;
                    idx4 = offa + idx2;
                    a[idx32] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                    a[idx4] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    int idx33 = offa + idx1;
                    idx4 = offa + idx2;
                    a[idx33] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                    a[idx4] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                    ++i3;
                }
            }
        }
    }

    private void bluestein_real_full(final double[] a, final int offa, final int isign) {
        final double[] ak = new double[2 * this.nBluestein];
        int nthreads = 1;
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            nthreads = 2;
            if (threads >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k = this.n / nthreads;
            int i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (isign > 0) {
                            int i2 = firstIdx;
                            while (i2 < lastIdx) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + i2;
                                ak[idx1] = a[idx3] * DoubleFFT_1D.this.bk1[idx1];
                                ak[idx2] = a[idx3] * DoubleFFT_1D.this.bk1[idx2];
                                ++i2;
                            }
                        } else {
                            int i3 = firstIdx;
                            while (i3 < lastIdx) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                int idx3 = offa + i3;
                                ak[idx1] = a[idx3] * DoubleFFT_1D.this.bk1[idx1];
                                ak[idx2] = -a[idx3] * DoubleFFT_1D.this.bk1[idx2];
                                ++i3;
                            }
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.nBluestein / nthreads;
            i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.nBluestein : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (isign > 0) {
                            int i2 = firstIdx;
                            while (i2 < lastIdx) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                double im = -ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] + ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                                ++i2;
                            }
                        } else {
                            int i3 = firstIdx;
                            while (i3 < lastIdx) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                double im = ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                                ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] - ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                                ak[idx2] = im;
                                ++i3;
                            }
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.n / nthreads;
            i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        if (isign > 0) {
                            int i2 = firstIdx;
                            while (i2 < lastIdx) {
                                int idx1 = 2 * i2;
                                int idx2 = idx1 + 1;
                                a[offa + idx1] = DoubleFFT_1D.this.bk1[idx1] * ak[idx1] - DoubleFFT_1D.this.bk1[idx2] * ak[idx2];
                                a[offa + idx2] = DoubleFFT_1D.this.bk1[idx2] * ak[idx1] + DoubleFFT_1D.this.bk1[idx1] * ak[idx2];
                                ++i2;
                            }
                        } else {
                            int i3 = firstIdx;
                            while (i3 < lastIdx) {
                                int idx1 = 2 * i3;
                                int idx2 = idx1 + 1;
                                a[offa + idx1] = DoubleFFT_1D.this.bk1[idx1] * ak[idx1] + DoubleFFT_1D.this.bk1[idx2] * ak[idx2];
                                a[offa + idx2] = -DoubleFFT_1D.this.bk1[idx2] * ak[idx1] + DoubleFFT_1D.this.bk1[idx1] * ak[idx2];
                                ++i3;
                            }
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx3;
            int idx2;
            int idx1;
            int i3;
            if (isign > 0) {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    idx3 = offa + i3;
                    ak[idx1] = a[idx3] * this.bk1[idx1];
                    ak[idx2] = a[idx3] * this.bk1[idx2];
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    idx3 = offa + i3;
                    ak[idx1] = a[idx3] * this.bk1[idx1];
                    ak[idx2] = -a[idx3] * this.bk1[idx2];
                    ++i3;
                }
            }
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                i3 = 0;
                while (i3 < this.nBluestein) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    double im = -ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] + ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < this.nBluestein) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    double im = ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                    ak[idx1] = ak[idx1] * this.bk2[idx1] - ak[idx2] * this.bk2[idx2];
                    ak[idx2] = im;
                    ++i3;
                }
            }
            this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            if (isign > 0) {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    a[offa + idx1] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                    a[offa + idx2] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < this.n) {
                    idx1 = 2 * i3;
                    idx2 = idx1 + 1;
                    a[offa + idx1] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                    a[offa + idx2] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                    ++i3;
                }
            }
        }
    }

    private void bluestein_real_forward(final double[] a, final int offa) {
        int idx2;
        int idx1;
        final double[] ak = new double[2 * this.nBluestein];
        int nthreads = 1;
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            nthreads = 2;
            if (threads >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k = this.n / nthreads;
            int i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            int idx3 = offa + i2;
                            ak[idx1] = a[idx3] * DoubleFFT_1D.this.bk1[idx1];
                            ak[idx2] = -a[idx3] * DoubleFFT_1D.this.bk1[idx2];
                            ++i2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.nBluestein / nthreads;
            i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.nBluestein : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            double im = ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                            ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] - ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                            ak[idx2] = im;
                            ++i2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 0;
            while (i3 < this.n) {
                idx1 = 2 * i3;
                idx2 = idx1 + 1;
                int idx3 = offa + i3;
                ak[idx1] = a[idx3] * this.bk1[idx1];
                ak[idx2] = -a[idx3] * this.bk1[idx2];
                ++i3;
            }
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            i3 = 0;
            while (i3 < this.nBluestein) {
                idx1 = 2 * i3;
                idx2 = idx1 + 1;
                double im = ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                ak[idx1] = ak[idx1] * this.bk2[idx1] - ak[idx2] * this.bk2[idx2];
                ak[idx2] = im;
                ++i3;
            }
        }
        this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            a[offa] = this.bk1[0] * ak[0] + this.bk1[1] * ak[1];
            a[offa + 1] = this.bk1[this.n] * ak[this.n] + this.bk1[this.n + 1] * ak[this.n + 1];
            int i4 = 1;
            while (i4 < this.n / 2) {
                idx1 = 2 * i4;
                idx2 = idx1 + 1;
                a[offa + idx1] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                a[offa + idx2] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                ++i4;
            }
        } else {
            a[offa] = this.bk1[0] * ak[0] + this.bk1[1] * ak[1];
            a[offa + 1] = -this.bk1[this.n] * ak[this.n - 1] + this.bk1[this.n - 1] * ak[this.n];
            int i5 = 1;
            while (i5 < (this.n - 1) / 2) {
                idx1 = 2 * i5;
                idx2 = idx1 + 1;
                a[offa + idx1] = this.bk1[idx1] * ak[idx1] + this.bk1[idx2] * ak[idx2];
                a[offa + idx2] = -this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                ++i5;
            }
            a[offa + this.n - 1] = this.bk1[this.n - 1] * ak[this.n - 1] + this.bk1[this.n] * ak[this.n];
        }
    }

    private void bluestein_real_inverse(final double[] a, final int offa) {
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        int i2;
        final double[] ak = new double[2 * this.nBluestein];
        if (this.n % 2 == 0) {
            ak[0] = a[offa] * this.bk1[0];
            ak[1] = a[offa] * this.bk1[1];
            i2 = 1;
            while (i2 < this.n / 2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + idx1;
                idx4 = offa + idx2;
                ak[idx1] = a[idx3] * this.bk1[idx1] - a[idx4] * this.bk1[idx2];
                ak[idx2] = a[idx3] * this.bk1[idx2] + a[idx4] * this.bk1[idx1];
                ++i2;
            }
            ak[this.n] = a[offa + 1] * this.bk1[this.n];
            ak[this.n + 1] = a[offa + 1] * this.bk1[this.n + 1];
            i2 = this.n / 2 + 1;
            while (i2 < this.n) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + 2 * this.n - idx1;
                idx4 = idx3 + 1;
                ak[idx1] = a[idx3] * this.bk1[idx1] + a[idx4] * this.bk1[idx2];
                ak[idx2] = a[idx3] * this.bk1[idx2] - a[idx4] * this.bk1[idx1];
                ++i2;
            }
        } else {
            ak[0] = a[offa] * this.bk1[0];
            ak[1] = a[offa] * this.bk1[1];
            i2 = 1;
            while (i2 < (this.n - 1) / 2) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + idx1;
                idx4 = offa + idx2;
                ak[idx1] = a[idx3] * this.bk1[idx1] - a[idx4] * this.bk1[idx2];
                ak[idx2] = a[idx3] * this.bk1[idx2] + a[idx4] * this.bk1[idx1];
                ++i2;
            }
            ak[this.n - 1] = a[offa + this.n - 1] * this.bk1[this.n - 1] - a[offa + 1] * this.bk1[this.n];
            ak[this.n] = a[offa + this.n - 1] * this.bk1[this.n] + a[offa + 1] * this.bk1[this.n - 1];
            ak[this.n + 1] = a[offa + this.n - 1] * this.bk1[this.n + 1] + a[offa + 1] * this.bk1[this.n + 2];
            ak[this.n + 2] = a[offa + this.n - 1] * this.bk1[this.n + 2] - a[offa + 1] * this.bk1[this.n + 1];
            i2 = (this.n - 1) / 2 + 2;
            while (i2 < this.n) {
                idx1 = 2 * i2;
                idx2 = idx1 + 1;
                idx3 = offa + 2 * this.n - idx1;
                idx4 = idx3 + 1;
                ak[idx1] = a[idx3] * this.bk1[idx1] + a[idx4] * this.bk1[idx2];
                ak[idx2] = a[idx3] * this.bk1[idx2] - a[idx4] * this.bk1[idx1];
                ++i2;
            }
        }
        this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
        int nthreads = 1;
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            nthreads = 2;
            if (threads >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k = this.nBluestein / nthreads;
            int i3 = 0;
            while (i3 < nthreads) {
                firstIdx = i3 * k;
                lastIdx = i3 == nthreads - 1 ? this.nBluestein : firstIdx + k;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            double im = -ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                            ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] + ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                            ak[idx2] = im;
                            ++i2;
                        }
                    }
                });
                ++i3;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.n / nthreads;
            i3 = 0;
            while (i3 < nthreads) {
                firstIdx = i3 * k;
                lastIdx = i3 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i3] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            a[offa + i2] = DoubleFFT_1D.this.bk1[idx1] * ak[idx1] - DoubleFFT_1D.this.bk1[idx2] * ak[idx2];
                            ++i2;
                        }
                    }
                });
                ++i3;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx22;
            int idx12;
            int i4 = 0;
            while (i4 < this.nBluestein) {
                idx12 = 2 * i4;
                idx22 = idx12 + 1;
                double im = -ak[idx12] * this.bk2[idx22] + ak[idx22] * this.bk2[idx12];
                ak[idx12] = ak[idx12] * this.bk2[idx12] + ak[idx22] * this.bk2[idx22];
                ak[idx22] = im;
                ++i4;
            }
            this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            i4 = 0;
            while (i4 < this.n) {
                idx12 = 2 * i4;
                idx22 = idx12 + 1;
                a[offa + i4] = this.bk1[idx12] * ak[idx12] - this.bk1[idx22] * ak[idx22];
                ++i4;
            }
        }
    }

    private void bluestein_real_inverse2(final double[] a, final int offa) {
        int idx2;
        int idx1;
        final double[] ak = new double[2 * this.nBluestein];
        int nthreads = 1;
        int threads = ConcurrencyUtils.getNumberOfThreads();
        if (threads > 1 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int lastIdx;
            int firstIdx;
            nthreads = 2;
            if (threads >= 4 && this.n > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
                nthreads = 4;
            }
            Future[] futures = new Future[nthreads];
            int k = this.n / nthreads;
            int i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.n : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            int idx3 = offa + i2;
                            ak[idx1] = a[idx3] * DoubleFFT_1D.this.bk1[idx1];
                            ak[idx2] = a[idx3] * DoubleFFT_1D.this.bk1[idx2];
                            ++i2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            k = this.nBluestein / nthreads;
            i2 = 0;
            while (i2 < nthreads) {
                firstIdx = i2 * k;
                lastIdx = i2 == nthreads - 1 ? this.nBluestein : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int idx1 = 2 * i2;
                            int idx2 = idx1 + 1;
                            double im = -ak[idx1] * DoubleFFT_1D.this.bk2[idx2] + ak[idx2] * DoubleFFT_1D.this.bk2[idx1];
                            ak[idx1] = ak[idx1] * DoubleFFT_1D.this.bk2[idx1] + ak[idx2] * DoubleFFT_1D.this.bk2[idx2];
                            ak[idx2] = im;
                            ++i2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = 0;
            while (i3 < this.n) {
                idx1 = 2 * i3;
                idx2 = idx1 + 1;
                int idx3 = offa + i3;
                ak[idx1] = a[idx3] * this.bk1[idx1];
                ak[idx2] = a[idx3] * this.bk1[idx2];
                ++i3;
            }
            this.cftbsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
            i3 = 0;
            while (i3 < this.nBluestein) {
                idx1 = 2 * i3;
                idx2 = idx1 + 1;
                double im = -ak[idx1] * this.bk2[idx2] + ak[idx2] * this.bk2[idx1];
                ak[idx1] = ak[idx1] * this.bk2[idx1] + ak[idx2] * this.bk2[idx2];
                ak[idx2] = im;
                ++i3;
            }
        }
        this.cftfsub(2 * this.nBluestein, ak, 0, this.ip, this.nw, this.w);
        if (this.n % 2 == 0) {
            a[offa] = this.bk1[0] * ak[0] - this.bk1[1] * ak[1];
            a[offa + 1] = this.bk1[this.n] * ak[this.n] - this.bk1[this.n + 1] * ak[this.n + 1];
            int i4 = 1;
            while (i4 < this.n / 2) {
                idx1 = 2 * i4;
                idx2 = idx1 + 1;
                a[offa + idx1] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                a[offa + idx2] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                ++i4;
            }
        } else {
            a[offa] = this.bk1[0] * ak[0] - this.bk1[1] * ak[1];
            a[offa + 1] = this.bk1[this.n] * ak[this.n - 1] + this.bk1[this.n - 1] * ak[this.n];
            int i5 = 1;
            while (i5 < (this.n - 1) / 2) {
                idx1 = 2 * i5;
                idx2 = idx1 + 1;
                a[offa + idx1] = this.bk1[idx1] * ak[idx1] - this.bk1[idx2] * ak[idx2];
                a[offa + idx2] = this.bk1[idx2] * ak[idx1] + this.bk1[idx1] * ak[idx2];
                ++i5;
            }
            a[offa + this.n - 1] = this.bk1[this.n - 1] * ak[this.n - 1] - this.bk1[this.n] * ak[this.n];
        }
    }

    void rfftf(double[] a, int offa) {
        if (this.n == 1) {
            return;
        }
        double[] ch = new double[this.n];
        int twon = 2 * this.n;
        int nf = (int)this.wtable_r[1 + twon];
        int na = 1;
        int l2 = this.n;
        int iw = twon - 1;
        int k1 = 1;
        while (k1 <= nf) {
            int kh = nf - k1;
            int ip = (int)this.wtable_r[kh + 2 + twon];
            int l1 = l2 / ip;
            int ido = this.n / l2;
            int idl1 = ido * l1;
            iw -= (ip - 1) * ido;
            na = 1 - na;
            switch (ip) {
                case 2: {
                    if (na == 0) {
                        this.radf2(ido, l1, a, offa, ch, 0, iw);
                        break;
                    }
                    this.radf2(ido, l1, ch, 0, a, offa, iw);
                    break;
                }
                case 3: {
                    if (na == 0) {
                        this.radf3(ido, l1, a, offa, ch, 0, iw);
                        break;
                    }
                    this.radf3(ido, l1, ch, 0, a, offa, iw);
                    break;
                }
                case 4: {
                    if (na == 0) {
                        this.radf4(ido, l1, a, offa, ch, 0, iw);
                        break;
                    }
                    this.radf4(ido, l1, ch, 0, a, offa, iw);
                    break;
                }
                case 5: {
                    if (na == 0) {
                        this.radf5(ido, l1, a, offa, ch, 0, iw);
                        break;
                    }
                    this.radf5(ido, l1, ch, 0, a, offa, iw);
                    break;
                }
                default: {
                    if (ido == 1) {
                        na = 1 - na;
                    }
                    if (na == 0) {
                        this.radfg(ido, ip, l1, idl1, a, offa, ch, 0, iw);
                        na = 1;
                        break;
                    }
                    this.radfg(ido, ip, l1, idl1, ch, 0, a, offa, iw);
                    na = 0;
                }
            }
            l2 = l1;
            ++k1;
        }
        if (na == 1) {
            return;
        }
        System.arraycopy(ch, 0, a, offa, this.n);
    }

    void rfftb(double[] a, int offa) {
        if (this.n == 1) {
            return;
        }
        double[] ch = new double[this.n];
        int twon = 2 * this.n;
        int nf = (int)this.wtable_r[1 + twon];
        int na = 0;
        int l1 = 1;
        int iw = this.n;
        int k1 = 1;
        while (k1 <= nf) {
            int ip = (int)this.wtable_r[k1 + 1 + twon];
            int l2 = ip * l1;
            int ido = this.n / l2;
            int idl1 = ido * l1;
            switch (ip) {
                case 2: {
                    if (na == 0) {
                        this.radb2(ido, l1, a, offa, ch, 0, iw);
                    } else {
                        this.radb2(ido, l1, ch, 0, a, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                case 3: {
                    if (na == 0) {
                        this.radb3(ido, l1, a, offa, ch, 0, iw);
                    } else {
                        this.radb3(ido, l1, ch, 0, a, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                case 4: {
                    if (na == 0) {
                        this.radb4(ido, l1, a, offa, ch, 0, iw);
                    } else {
                        this.radb4(ido, l1, ch, 0, a, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                case 5: {
                    if (na == 0) {
                        this.radb5(ido, l1, a, offa, ch, 0, iw);
                    } else {
                        this.radb5(ido, l1, ch, 0, a, offa, iw);
                    }
                    na = 1 - na;
                    break;
                }
                default: {
                    if (na == 0) {
                        this.radbg(ido, ip, l1, idl1, a, offa, ch, 0, iw);
                    } else {
                        this.radbg(ido, ip, l1, idl1, ch, 0, a, offa, iw);
                    }
                    if (ido != 1) break;
                    na = 1 - na;
                }
            }
            l1 = l2;
            iw += (ip - 1) * ido;
            ++k1;
        }
        if (na == 0) {
            return;
        }
        System.arraycopy(ch, 0, a, offa, this.n);
    }

    void radf2(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        int idx2;
        int oidx1;
        int iw1 = offset;
        int idx0 = l1 * ido;
        int idx1 = 2 * ido;
        int k = 0;
        while (k < l1) {
            oidx1 = out_off + k * idx1;
            int oidx2 = oidx1 + idx1 - 1;
            int iidx1 = in_off + k * ido;
            int iidx2 = iidx1 + idx0;
            double i1r = in[iidx1];
            double i2r = in[iidx2];
            out[oidx1] = i1r + i2r;
            out[oidx2] = i1r - i2r;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            k = 0;
            while (k < l1) {
                idx1 = k * ido;
                idx2 = 2 * idx1;
                int idx3 = idx2 + ido;
                int idx4 = idx1 + idx0;
                int i2 = 2;
                while (i2 < ido) {
                    int ic = ido - i2;
                    int widx1 = i2 - 1 + iw1;
                    int oidx12 = out_off + i2 + idx2;
                    int oidx2 = out_off + ic + idx3;
                    int iidx1 = in_off + i2 + idx1;
                    int iidx2 = in_off + i2 + idx4;
                    double a1i = in[iidx1 - 1];
                    double a1r = in[iidx1];
                    double a2i = in[iidx2 - 1];
                    double a2r = in[iidx2];
                    double w1r = this.wtable_r[widx1 - 1];
                    double w1i = this.wtable_r[widx1];
                    double t1r = w1r * a2i + w1i * a2r;
                    double t1i = w1r * a2r - w1i * a2i;
                    out[oidx12] = a1r + t1i;
                    out[oidx12 - 1] = a1i + t1r;
                    out[oidx2] = t1i - a1r;
                    out[oidx2 - 1] = a1i - t1r;
                    i2 += 2;
                }
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        idx2 = 2 * idx1;
        k = 0;
        while (k < l1) {
            idx1 = k * ido;
            oidx1 = out_off + idx2 + ido;
            int iidx1 = in_off + ido - 1 + idx1;
            out[oidx1] = -in[iidx1 + idx0];
            out[oidx1 - 1] = in[iidx1];
            ++k;
        }
    }

    void radb2(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        int idx3;
        int idx2;
        int idx1;
        int iw1 = offset;
        int idx0 = l1 * ido;
        int k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 2 * idx1;
            idx3 = idx2 + ido;
            int oidx1 = out_off + idx1;
            int iidx1 = in_off + idx2;
            int iidx2 = in_off + ido - 1 + idx3;
            double i1r = in[iidx1];
            double i2r = in[iidx2];
            out[oidx1] = i1r + i2r;
            out[oidx1 + idx0] = i1r - i2r;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            k = 0;
            while (k < l1) {
                idx1 = k * ido;
                idx2 = 2 * idx1;
                idx3 = idx2 + ido;
                int idx4 = idx1 + idx0;
                int i2 = 2;
                while (i2 < ido) {
                    int ic = ido - i2;
                    int idx5 = i2 - 1 + iw1;
                    int idx6 = out_off + i2;
                    int idx7 = in_off + i2;
                    int idx8 = in_off + ic;
                    double w1r = this.wtable_r[idx5 - 1];
                    double w1i = this.wtable_r[idx5];
                    int iidx1 = idx7 + idx2;
                    int iidx2 = idx8 + idx3;
                    int oidx1 = idx6 + idx1;
                    int oidx2 = idx6 + idx4;
                    double t1r = in[iidx1 - 1] - in[iidx2 - 1];
                    double t1i = in[iidx1] + in[iidx2];
                    double i1i = in[iidx1];
                    double i1r = in[iidx1 - 1];
                    double i2i = in[iidx2];
                    double i2r = in[iidx2 - 1];
                    out[oidx1 - 1] = i1r + i2r;
                    out[oidx1] = i1i - i2i;
                    out[oidx2 - 1] = w1r * t1r - w1i * t1i;
                    out[oidx2] = w1r * t1i + w1i * t1r;
                    i2 += 2;
                }
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 2 * idx1;
            int oidx1 = out_off + ido - 1 + idx1;
            int iidx1 = in_off + idx2 + ido;
            out[oidx1] = 2.0 * in[iidx1 - 1];
            out[oidx1 + idx0] = -2.0 * in[iidx1];
            ++k;
        }
    }

    void radf3(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double cr2;
        double taur = -0.5;
        double taui = 0.8660254037844387;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int idx0 = l1 * ido;
        int k = 0;
        while (k < l1) {
            int idx1 = k * ido;
            int idx3 = 2 * idx0;
            int idx4 = (3 * k + 1) * ido;
            int iidx1 = in_off + idx1;
            int iidx2 = iidx1 + idx0;
            int iidx3 = iidx1 + idx3;
            double i1r = in[iidx1];
            double i2r = in[iidx2];
            double i3r = in[iidx3];
            cr2 = i2r + i3r;
            out[out_off + 3 * idx1] = i1r + cr2;
            out[out_off + idx4 + ido] = 0.8660254037844387 * (i3r - i2r);
            out[out_off + ido - 1 + idx4] = i1r + -0.5 * cr2;
            ++k;
        }
        if (ido == 1) {
            return;
        }
        k = 0;
        while (k < l1) {
            int idx3 = k * ido;
            int idx4 = 3 * idx3;
            int idx5 = idx3 + idx0;
            int idx6 = idx5 + idx0;
            int idx7 = idx4 + ido;
            int idx8 = idx7 + ido;
            int i2 = 2;
            while (i2 < ido) {
                int ic = ido - i2;
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                double w1r = this.wtable_r[widx1 - 1];
                double w1i = this.wtable_r[widx1];
                double w2r = this.wtable_r[widx2 - 1];
                double w2i = this.wtable_r[widx2];
                int idx9 = in_off + i2;
                int idx10 = out_off + i2;
                int idx11 = out_off + ic;
                int iidx1 = idx9 + idx3;
                int iidx2 = idx9 + idx5;
                int iidx3 = idx9 + idx6;
                double i1i = in[iidx1 - 1];
                double i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                double i3i = in[iidx3 - 1];
                double i3r = in[iidx3];
                double dr2 = w1r * i2i + w1i * i2r;
                double di2 = w1r * i2r - w1i * i2i;
                double dr3 = w2r * i3i + w2i * i3r;
                double di3 = w2r * i3r - w2i * i3i;
                cr2 = dr2 + dr3;
                double ci2 = di2 + di3;
                double tr2 = i1i + -0.5 * cr2;
                double ti2 = i1r + -0.5 * ci2;
                double tr3 = 0.8660254037844387 * (di2 - di3);
                double ti3 = 0.8660254037844387 * (dr3 - dr2);
                int oidx1 = idx10 + idx4;
                int oidx2 = idx11 + idx7;
                int oidx3 = idx10 + idx8;
                out[oidx1 - 1] = i1i + cr2;
                out[oidx1] = i1r + ci2;
                out[oidx2 - 1] = tr2 - tr3;
                out[oidx2] = ti3 - ti2;
                out[oidx3 - 1] = tr2 + tr3;
                out[oidx3] = ti2 + ti3;
                i2 += 2;
            }
            ++k;
        }
    }

    void radb3(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double ci3;
        double cr2;
        double tr2;
        double taur = -0.5;
        double taui = 0.8660254037844387;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int k = 0;
        while (k < l1) {
            int idx1 = k * ido;
            int iidx1 = in_off + 3 * idx1;
            int iidx2 = iidx1 + 2 * ido;
            double i1i = in[iidx1];
            tr2 = 2.0 * in[iidx2 - 1];
            cr2 = i1i + -0.5 * tr2;
            ci3 = 1.7320508075688774 * in[iidx2];
            out[out_off + idx1] = i1i + tr2;
            out[out_off + (k + l1) * ido] = cr2 - ci3;
            out[out_off + (k + 2 * l1) * ido] = cr2 + ci3;
            ++k;
        }
        if (ido == 1) {
            return;
        }
        int idx0 = l1 * ido;
        int k2 = 0;
        while (k2 < l1) {
            int idx1 = k2 * ido;
            int idx2 = 3 * idx1;
            int idx3 = idx2 + ido;
            int idx4 = idx3 + ido;
            int idx5 = idx1 + idx0;
            int idx6 = idx5 + idx0;
            int i2 = 2;
            while (i2 < ido) {
                int ic = ido - i2;
                int idx7 = in_off + i2;
                int idx8 = in_off + ic;
                int idx9 = out_off + i2;
                int iidx1 = idx7 + idx2;
                int iidx2 = idx7 + idx4;
                int iidx3 = idx8 + idx3;
                double i1i = in[iidx1 - 1];
                double i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                double i3i = in[iidx3 - 1];
                double i3r = in[iidx3];
                tr2 = i2i + i3i;
                cr2 = i1i + -0.5 * tr2;
                double ti2 = i2r - i3r;
                double ci2 = i1r + -0.5 * ti2;
                double cr3 = 0.8660254037844387 * (i2i - i3i);
                ci3 = 0.8660254037844387 * (i2r + i3r);
                double dr2 = cr2 - ci3;
                double dr3 = cr2 + ci3;
                double di2 = ci2 + cr3;
                double di3 = ci2 - cr3;
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                double w1r = this.wtable_r[widx1 - 1];
                double w1i = this.wtable_r[widx1];
                double w2r = this.wtable_r[widx2 - 1];
                double w2i = this.wtable_r[widx2];
                int oidx1 = idx9 + idx1;
                int oidx2 = idx9 + idx5;
                int oidx3 = idx9 + idx6;
                out[oidx1 - 1] = i1i + tr2;
                out[oidx1] = i1r + ti2;
                out[oidx2 - 1] = w1r * dr2 - w1i * di2;
                out[oidx2] = w1r * di2 + w1i * dr2;
                out[oidx3 - 1] = w2r * dr3 - w2i * di3;
                out[oidx3] = w2r * di3 + w2i * dr3;
                i2 += 2;
            }
            ++k2;
        }
    }

    void radf4(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double ti1;
        int idx8;
        double tr2;
        double tr1;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        double hsqt2 = 0.7071067811865476;
        int iw1 = offset;
        int iw2 = offset + ido;
        int iw3 = iw2 + ido;
        int idx0 = l1 * ido;
        int k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            double i1r = in[in_off + idx1];
            double i2r = in[in_off + idx3];
            double i3r = in[in_off + idx4];
            double i4r = in[in_off + idx5];
            tr1 = i2r + i4r;
            tr2 = i1r + i3r;
            int oidx1 = out_off + idx2;
            int oidx2 = out_off + idx6 + ido;
            out[oidx1] = tr1 + tr2;
            out[oidx2 - 1 + ido + ido] = tr2 - tr1;
            out[oidx2 - 1] = i1r - i3r;
            out[oidx2] = i4r - i2r;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            k = 0;
            while (k < l1) {
                idx1 = k * ido;
                idx2 = idx1 + idx0;
                idx3 = idx2 + idx0;
                idx4 = idx3 + idx0;
                idx5 = 4 * idx1;
                idx6 = idx5 + ido;
                int idx7 = idx6 + ido;
                idx8 = idx7 + ido;
                int i2 = 2;
                while (i2 < ido) {
                    int ic = ido - i2;
                    int widx1 = i2 - 1 + iw1;
                    int widx2 = i2 - 1 + iw2;
                    int widx3 = i2 - 1 + iw3;
                    double w1r = this.wtable_r[widx1 - 1];
                    double w1i = this.wtable_r[widx1];
                    double w2r = this.wtable_r[widx2 - 1];
                    double w2i = this.wtable_r[widx2];
                    double w3r = this.wtable_r[widx3 - 1];
                    double w3i = this.wtable_r[widx3];
                    int idx9 = in_off + i2;
                    int idx10 = out_off + i2;
                    int idx11 = out_off + ic;
                    int iidx1 = idx9 + idx1;
                    int iidx2 = idx9 + idx2;
                    int iidx3 = idx9 + idx3;
                    int iidx4 = idx9 + idx4;
                    double i1i = in[iidx1 - 1];
                    double i1r = in[iidx1];
                    double i2i = in[iidx2 - 1];
                    double i2r = in[iidx2];
                    double i3i = in[iidx3 - 1];
                    double i3r = in[iidx3];
                    double i4i = in[iidx4 - 1];
                    double i4r = in[iidx4];
                    double cr2 = w1r * i2i + w1i * i2r;
                    double ci2 = w1r * i2r - w1i * i2i;
                    double cr3 = w2r * i3i + w2i * i3r;
                    double ci3 = w2r * i3r - w2i * i3i;
                    double cr4 = w3r * i4i + w3i * i4r;
                    double ci4 = w3r * i4r - w3i * i4i;
                    tr1 = cr2 + cr4;
                    double tr4 = cr4 - cr2;
                    ti1 = ci2 + ci4;
                    double ti4 = ci2 - ci4;
                    double ti2 = i1r + ci3;
                    double ti3 = i1r - ci3;
                    tr2 = i1i + cr3;
                    double tr3 = i1i - cr3;
                    int oidx1 = idx10 + idx5;
                    int oidx2 = idx11 + idx6;
                    int oidx3 = idx10 + idx7;
                    int oidx4 = idx11 + idx8;
                    out[oidx1 - 1] = tr1 + tr2;
                    out[oidx4 - 1] = tr2 - tr1;
                    out[oidx1] = ti1 + ti2;
                    out[oidx4] = ti1 - ti2;
                    out[oidx3 - 1] = ti4 + tr3;
                    out[oidx2 - 1] = tr3 - ti4;
                    out[oidx3] = tr4 + ti3;
                    out[oidx2] = tr4 - ti3;
                    i2 += 2;
                }
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            int idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            int idx9 = in_off + ido;
            int idx10 = out_off + ido;
            double i1i = in[idx9 - 1 + idx1];
            double i2i = in[idx9 - 1 + idx3];
            double i3i = in[idx9 - 1 + idx4];
            double i4i = in[idx9 - 1 + idx5];
            ti1 = -0.7071067811865476 * (i2i + i4i);
            tr1 = 0.7071067811865476 * (i2i - i4i);
            out[idx10 - 1 + idx2] = tr1 + i1i;
            out[idx10 - 1 + idx7] = i1i - tr1;
            out[out_off + idx6] = ti1 - i3i;
            out[out_off + idx8] = ti1 + i3i;
            ++k;
        }
    }

    void radb4(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double ti2;
        double ti1;
        double tr4;
        double tr3;
        double tr2;
        double tr1;
        int idx8;
        int idx7;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        double sqrt2 = 1.4142135623730951;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int idx0 = l1 * ido;
        int k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            double i1r = in[in_off + idx2];
            double i2r = in[in_off + idx7];
            double i3r = in[in_off + ido - 1 + idx8];
            double i4r = in[in_off + ido - 1 + idx6];
            tr1 = i1r - i3r;
            tr2 = i1r + i3r;
            tr3 = i4r + i4r;
            tr4 = i2r + i2r;
            out[out_off + idx1] = tr2 + tr3;
            out[out_off + idx3] = tr1 - tr4;
            out[out_off + idx4] = tr2 - tr3;
            out[out_off + idx5] = tr1 + tr4;
            ++k;
        }
        if (ido < 2) {
            return;
        }
        if (ido != 2) {
            k = 0;
            while (k < l1) {
                idx1 = k * ido;
                idx2 = idx1 + idx0;
                idx3 = idx2 + idx0;
                idx4 = idx3 + idx0;
                idx5 = 4 * idx1;
                idx6 = idx5 + ido;
                idx7 = idx6 + ido;
                idx8 = idx7 + ido;
                int i2 = 2;
                while (i2 < ido) {
                    int ic = ido - i2;
                    int widx1 = i2 - 1 + iw1;
                    int widx2 = i2 - 1 + iw2;
                    int widx3 = i2 - 1 + iw3;
                    double w1r = this.wtable_r[widx1 - 1];
                    double w1i = this.wtable_r[widx1];
                    double w2r = this.wtable_r[widx2 - 1];
                    double w2i = this.wtable_r[widx2];
                    double w3r = this.wtable_r[widx3 - 1];
                    double w3i = this.wtable_r[widx3];
                    int idx12 = in_off + i2;
                    int idx13 = in_off + ic;
                    int idx14 = out_off + i2;
                    int iidx1 = idx12 + idx5;
                    int iidx2 = idx13 + idx6;
                    int iidx3 = idx12 + idx7;
                    int iidx4 = idx13 + idx8;
                    double i1i = in[iidx1 - 1];
                    double i1r = in[iidx1];
                    double i2i = in[iidx2 - 1];
                    double i2r = in[iidx2];
                    double i3i = in[iidx3 - 1];
                    double i3r = in[iidx3];
                    double i4i = in[iidx4 - 1];
                    double i4r = in[iidx4];
                    ti1 = i1r + i4r;
                    ti2 = i1r - i4r;
                    double ti3 = i3r - i2r;
                    tr4 = i3r + i2r;
                    tr1 = i1i - i4i;
                    tr2 = i1i + i4i;
                    double ti4 = i3i - i2i;
                    tr3 = i3i + i2i;
                    double cr3 = tr2 - tr3;
                    double ci3 = ti2 - ti3;
                    double cr2 = tr1 - tr4;
                    double cr4 = tr1 + tr4;
                    double ci2 = ti1 + ti4;
                    double ci4 = ti1 - ti4;
                    int oidx1 = idx14 + idx1;
                    int oidx2 = idx14 + idx2;
                    int oidx3 = idx14 + idx3;
                    int oidx4 = idx14 + idx4;
                    out[oidx1 - 1] = tr2 + tr3;
                    out[oidx1] = ti2 + ti3;
                    out[oidx2 - 1] = w1r * cr2 - w1i * ci2;
                    out[oidx2] = w1r * ci2 + w1i * cr2;
                    out[oidx3 - 1] = w2r * cr3 - w2i * ci3;
                    out[oidx3] = w2r * ci3 + w2i * cr3;
                    out[oidx4 - 1] = w3r * cr4 - w3i * ci4;
                    out[oidx4] = w3r * ci4 + w3i * cr4;
                    i2 += 2;
                }
                ++k;
            }
            if (ido % 2 == 1) {
                return;
            }
        }
        k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 4 * idx1;
            idx3 = idx1 + idx0;
            idx4 = idx3 + idx0;
            idx5 = idx4 + idx0;
            idx6 = idx2 + ido;
            idx7 = idx6 + ido;
            idx8 = idx7 + ido;
            int idx9 = in_off + ido;
            int idx10 = out_off + ido;
            double i1r = in[idx9 - 1 + idx2];
            double i2r = in[idx9 - 1 + idx7];
            double i3r = in[in_off + idx6];
            double i4r = in[in_off + idx8];
            ti1 = i3r + i4r;
            ti2 = i4r - i3r;
            tr1 = i1r - i2r;
            tr2 = i1r + i2r;
            out[idx10 - 1 + idx1] = tr2 + tr2;
            out[idx10 - 1 + idx3] = 1.4142135623730951 * (tr1 - ti1);
            out[idx10 - 1 + idx4] = ti2 + ti2;
            out[idx10 - 1 + idx5] = -1.4142135623730951 * (tr1 + ti1);
            ++k;
        }
    }

    void radf5(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double ci4;
        double cr3;
        double ci5;
        double cr2;
        int idx10;
        int idx9;
        int idx8;
        int idx7;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        double tr11 = 0.30901699437494745;
        double ti11 = 0.9510565162951535;
        double tr12 = -0.8090169943749473;
        double ti12 = 0.5877852522924732;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        int idx0 = l1 * ido;
        int k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            int idx11 = out_off + ido - 1;
            double i1r = in[in_off + idx1];
            double i2r = in[in_off + idx7];
            double i3r = in[in_off + idx8];
            double i4r = in[in_off + idx9];
            double i5r = in[in_off + idx10];
            cr2 = i5r + i2r;
            ci5 = i5r - i2r;
            cr3 = i4r + i3r;
            ci4 = i4r - i3r;
            out[out_off + idx2] = i1r + cr2 + cr3;
            out[idx11 + idx3] = i1r + 0.30901699437494745 * cr2 + -0.8090169943749473 * cr3;
            out[out_off + idx4] = 0.9510565162951535 * ci5 + 0.5877852522924732 * ci4;
            out[idx11 + idx5] = i1r + -0.8090169943749473 * cr2 + 0.30901699437494745 * cr3;
            out[out_off + idx6] = 0.5877852522924732 * ci5 - 0.9510565162951535 * ci4;
            ++k;
        }
        if (ido == 1) {
            return;
        }
        k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            int i2 = 2;
            while (i2 < ido) {
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                int widx3 = i2 - 1 + iw3;
                int widx4 = i2 - 1 + iw4;
                double w1r = this.wtable_r[widx1 - 1];
                double w1i = this.wtable_r[widx1];
                double w2r = this.wtable_r[widx2 - 1];
                double w2i = this.wtable_r[widx2];
                double w3r = this.wtable_r[widx3 - 1];
                double w3i = this.wtable_r[widx3];
                double w4r = this.wtable_r[widx4 - 1];
                double w4i = this.wtable_r[widx4];
                int ic = ido - i2;
                int idx15 = in_off + i2;
                int idx16 = out_off + i2;
                int idx17 = out_off + ic;
                int iidx1 = idx15 + idx1;
                int iidx2 = idx15 + idx7;
                int iidx3 = idx15 + idx8;
                int iidx4 = idx15 + idx9;
                int iidx5 = idx15 + idx10;
                double i1i = in[iidx1 - 1];
                double i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                double i3i = in[iidx3 - 1];
                double i3r = in[iidx3];
                double i4i = in[iidx4 - 1];
                double i4r = in[iidx4];
                double i5i = in[iidx5 - 1];
                double i5r = in[iidx5];
                double dr2 = w1r * i2i + w1i * i2r;
                double di2 = w1r * i2r - w1i * i2i;
                double dr3 = w2r * i3i + w2i * i3r;
                double di3 = w2r * i3r - w2i * i3i;
                double dr4 = w3r * i4i + w3i * i4r;
                double di4 = w3r * i4r - w3i * i4i;
                double dr5 = w4r * i5i + w4i * i5r;
                double di5 = w4r * i5r - w4i * i5i;
                cr2 = dr2 + dr5;
                ci5 = dr5 - dr2;
                double cr5 = di2 - di5;
                double ci2 = di2 + di5;
                cr3 = dr3 + dr4;
                ci4 = dr4 - dr3;
                double cr4 = di3 - di4;
                double ci3 = di3 + di4;
                double tr2 = i1i + 0.30901699437494745 * cr2 + -0.8090169943749473 * cr3;
                double ti2 = i1r + 0.30901699437494745 * ci2 + -0.8090169943749473 * ci3;
                double tr3 = i1i + -0.8090169943749473 * cr2 + 0.30901699437494745 * cr3;
                double ti3 = i1r + -0.8090169943749473 * ci2 + 0.30901699437494745 * ci3;
                double tr5 = 0.9510565162951535 * cr5 + 0.5877852522924732 * cr4;
                double ti5 = 0.9510565162951535 * ci5 + 0.5877852522924732 * ci4;
                double tr4 = 0.5877852522924732 * cr5 - 0.9510565162951535 * cr4;
                double ti4 = 0.5877852522924732 * ci5 - 0.9510565162951535 * ci4;
                int oidx1 = idx16 + idx2;
                int oidx2 = idx17 + idx3;
                int oidx3 = idx16 + idx4;
                int oidx4 = idx17 + idx5;
                int oidx5 = idx16 + idx6;
                out[oidx1 - 1] = i1i + cr2 + cr3;
                out[oidx1] = i1r + ci2 + ci3;
                out[oidx3 - 1] = tr2 + tr5;
                out[oidx2 - 1] = tr2 - tr5;
                out[oidx3] = ti2 + ti5;
                out[oidx2] = ti5 - ti2;
                out[oidx5 - 1] = tr3 + tr4;
                out[oidx4 - 1] = tr3 - tr4;
                out[oidx5] = ti3 + ti4;
                out[oidx4] = ti4 - ti3;
                i2 += 2;
            }
            ++k;
        }
    }

    void radb5(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double ci4;
        double ci5;
        double cr3;
        double cr2;
        double tr3;
        double tr2;
        double ti4;
        double ti5;
        int idx10;
        int idx9;
        int idx8;
        int idx7;
        int idx6;
        int idx5;
        int idx4;
        int idx3;
        int idx2;
        int idx1;
        double tr11 = 0.30901699437494745;
        double ti11 = 0.9510565162951535;
        double tr12 = -0.8090169943749473;
        double ti12 = 0.5877852522924732;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        int idx0 = l1 * ido;
        int k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            int idx11 = in_off + ido - 1;
            double i1r = in[in_off + idx2];
            ti5 = 2.0 * in[in_off + idx4];
            ti4 = 2.0 * in[in_off + idx6];
            tr2 = 2.0 * in[idx11 + idx3];
            tr3 = 2.0 * in[idx11 + idx5];
            cr2 = i1r + 0.30901699437494745 * tr2 + -0.8090169943749473 * tr3;
            cr3 = i1r + -0.8090169943749473 * tr2 + 0.30901699437494745 * tr3;
            ci5 = 0.9510565162951535 * ti5 + 0.5877852522924732 * ti4;
            ci4 = 0.5877852522924732 * ti5 - 0.9510565162951535 * ti4;
            out[out_off + idx1] = i1r + tr2 + tr3;
            out[out_off + idx7] = cr2 - ci5;
            out[out_off + idx8] = cr3 - ci4;
            out[out_off + idx9] = cr3 + ci4;
            out[out_off + idx10] = cr2 + ci5;
            ++k;
        }
        if (ido == 1) {
            return;
        }
        k = 0;
        while (k < l1) {
            idx1 = k * ido;
            idx2 = 5 * idx1;
            idx3 = idx2 + ido;
            idx4 = idx3 + ido;
            idx5 = idx4 + ido;
            idx6 = idx5 + ido;
            idx7 = idx1 + idx0;
            idx8 = idx7 + idx0;
            idx9 = idx8 + idx0;
            idx10 = idx9 + idx0;
            int i2 = 2;
            while (i2 < ido) {
                int ic = ido - i2;
                int widx1 = i2 - 1 + iw1;
                int widx2 = i2 - 1 + iw2;
                int widx3 = i2 - 1 + iw3;
                int widx4 = i2 - 1 + iw4;
                double w1r = this.wtable_r[widx1 - 1];
                double w1i = this.wtable_r[widx1];
                double w2r = this.wtable_r[widx2 - 1];
                double w2i = this.wtable_r[widx2];
                double w3r = this.wtable_r[widx3 - 1];
                double w3i = this.wtable_r[widx3];
                double w4r = this.wtable_r[widx4 - 1];
                double w4i = this.wtable_r[widx4];
                int idx15 = in_off + i2;
                int idx16 = in_off + ic;
                int idx17 = out_off + i2;
                int iidx1 = idx15 + idx2;
                int iidx2 = idx16 + idx3;
                int iidx3 = idx15 + idx4;
                int iidx4 = idx16 + idx5;
                int iidx5 = idx15 + idx6;
                double i1i = in[iidx1 - 1];
                double i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                double i3i = in[iidx3 - 1];
                double i3r = in[iidx3];
                double i4i = in[iidx4 - 1];
                double i4r = in[iidx4];
                double i5i = in[iidx5 - 1];
                double i5r = in[iidx5];
                ti5 = i3r + i2r;
                double ti2 = i3r - i2r;
                ti4 = i5r + i4r;
                double ti3 = i5r - i4r;
                double tr5 = i3i - i2i;
                tr2 = i3i + i2i;
                double tr4 = i5i - i4i;
                tr3 = i5i + i4i;
                cr2 = i1i + 0.30901699437494745 * tr2 + -0.8090169943749473 * tr3;
                double ci2 = i1r + 0.30901699437494745 * ti2 + -0.8090169943749473 * ti3;
                cr3 = i1i + -0.8090169943749473 * tr2 + 0.30901699437494745 * tr3;
                double ci3 = i1r + -0.8090169943749473 * ti2 + 0.30901699437494745 * ti3;
                double cr5 = 0.9510565162951535 * tr5 + 0.5877852522924732 * tr4;
                ci5 = 0.9510565162951535 * ti5 + 0.5877852522924732 * ti4;
                double cr4 = 0.5877852522924732 * tr5 - 0.9510565162951535 * tr4;
                ci4 = 0.5877852522924732 * ti5 - 0.9510565162951535 * ti4;
                double dr3 = cr3 - ci4;
                double dr4 = cr3 + ci4;
                double di3 = ci3 + cr4;
                double di4 = ci3 - cr4;
                double dr5 = cr2 + ci5;
                double dr2 = cr2 - ci5;
                double di5 = ci2 - cr5;
                double di2 = ci2 + cr5;
                int oidx1 = idx17 + idx1;
                int oidx2 = idx17 + idx7;
                int oidx3 = idx17 + idx8;
                int oidx4 = idx17 + idx9;
                int oidx5 = idx17 + idx10;
                out[oidx1 - 1] = i1i + tr2 + tr3;
                out[oidx1] = i1r + ti2 + ti3;
                out[oidx2 - 1] = w1r * dr2 - w1i * di2;
                out[oidx2] = w1r * di2 + w1i * dr2;
                out[oidx3 - 1] = w2r * dr3 - w2i * di3;
                out[oidx3] = w2r * di3 + w2i * dr3;
                out[oidx4 - 1] = w3r * dr4 - w3i * di4;
                out[oidx4] = w3r * di4 + w3i * dr4;
                out[oidx5 - 1] = w4r * dr5 - w4i * di5;
                out[oidx5] = w4r * di5 + w4i * dr5;
                i2 += 2;
            }
            ++k;
        }
    }

    void radfg(int ido, int ip, int l1, int idl1, double[] in, int in_off, double[] out, int out_off, int offset) {
        double o1r;
        double o1i;
        int idx4;
        int idx2;
        int j2;
        int idx1;
        int idx6;
        int idx3;
        int idx12;
        int i2;
        int idx42;
        int idx32;
        int k;
        int idx22;
        int jc;
        int oidx1;
        int i3;
        int k2;
        int idx23;
        int k3;
        int idx13;
        int j;
        int iw1 = offset;
        double arg = Math.PI * 2 / (double)ip;
        double dcp = Math.cos(arg);
        double dsp = Math.sin(arg);
        int ipph = (ip + 1) / 2;
        int nbd = (ido - 1) / 2;
        if (ido != 1) {
            double o2r;
            double o2i;
            double o1r2;
            double o1i2;
            int oidx12;
            int iidx1;
            int idx33;
            double w1i;
            double w1r;
            int idij;
            int is;
            int ik = 0;
            while (ik < idl1) {
                out[out_off + ik] = in[in_off + ik];
                ++ik;
            }
            j = 1;
            while (j < ip) {
                idx13 = j * l1 * ido;
                k3 = 0;
                while (k3 < l1) {
                    idx23 = k3 * ido + idx13;
                    out[out_off + idx23] = in[in_off + idx23];
                    ++k3;
                }
                ++j;
            }
            if (nbd <= l1) {
                is = -ido;
                j = 1;
                while (j < ip) {
                    idij = (is += ido) - 1;
                    idx13 = j * l1 * ido;
                    int i4 = 2;
                    while (i4 < ido) {
                        idx23 = (idij += 2) + iw1;
                        int idx43 = in_off + i4;
                        int idx5 = out_off + i4;
                        w1r = this.wtable_r[idx23 - 1];
                        w1i = this.wtable_r[idx23];
                        k2 = 0;
                        while (k2 < l1) {
                            idx33 = k2 * ido + idx13;
                            int oidx13 = idx5 + idx33;
                            iidx1 = idx43 + idx33;
                            double i1i = in[iidx1 - 1];
                            double i1r = in[iidx1];
                            out[oidx13 - 1] = w1r * i1i + w1i * i1r;
                            out[oidx13] = w1r * i1r - w1i * i1i;
                            ++k2;
                        }
                        i4 += 2;
                    }
                    ++j;
                }
            } else {
                is = -ido;
                j = 1;
                while (j < ip) {
                    is += ido;
                    idx13 = j * l1 * ido;
                    k3 = 0;
                    while (k3 < l1) {
                        idij = is - 1;
                        int idx34 = k3 * ido + idx13;
                        i3 = 2;
                        while (i3 < ido) {
                            int idx24 = (idij += 2) + iw1;
                            w1r = this.wtable_r[idx24 - 1];
                            w1i = this.wtable_r[idx24];
                            oidx1 = out_off + i3 + idx34;
                            int iidx12 = in_off + i3 + idx34;
                            double i1i = in[iidx12 - 1];
                            double i1r = in[iidx12];
                            out[oidx1 - 1] = w1r * i1i + w1i * i1r;
                            out[oidx1] = w1r * i1r - w1i * i1i;
                            i3 += 2;
                        }
                        ++k3;
                    }
                    ++j;
                }
            }
            if (nbd >= l1) {
                j = 1;
                while (j < ipph) {
                    jc = ip - j;
                    idx13 = j * l1 * ido;
                    idx22 = jc * l1 * ido;
                    k = 0;
                    while (k < l1) {
                        idx32 = k * ido + idx13;
                        idx42 = k * ido + idx22;
                        i2 = 2;
                        while (i2 < ido) {
                            int idx5 = in_off + i2;
                            int idx62 = out_off + i2;
                            iidx1 = idx5 + idx32;
                            int iidx2 = idx5 + idx42;
                            oidx12 = idx62 + idx32;
                            int oidx2 = idx62 + idx42;
                            o1i2 = out[oidx12 - 1];
                            o1r2 = out[oidx12];
                            o2i = out[oidx2 - 1];
                            o2r = out[oidx2];
                            in[iidx1 - 1] = o1i2 + o2i;
                            in[iidx1] = o1r2 + o2r;
                            in[iidx2 - 1] = o1r2 - o2r;
                            in[iidx2] = o2i - o1i2;
                            i2 += 2;
                        }
                        ++k;
                    }
                    ++j;
                }
            } else {
                j = 1;
                while (j < ipph) {
                    jc = ip - j;
                    idx13 = j * l1 * ido;
                    idx22 = jc * l1 * ido;
                    int i5 = 2;
                    while (i5 < ido) {
                        int idx5 = in_off + i5;
                        int idx63 = out_off + i5;
                        k2 = 0;
                        while (k2 < l1) {
                            idx33 = k2 * ido + idx13;
                            int idx44 = k2 * ido + idx22;
                            iidx1 = idx5 + idx33;
                            int iidx2 = idx5 + idx44;
                            oidx12 = idx63 + idx33;
                            int oidx2 = idx63 + idx44;
                            o1i2 = out[oidx12 - 1];
                            o1r2 = out[oidx12];
                            o2i = out[oidx2 - 1];
                            o2r = out[oidx2];
                            in[iidx1 - 1] = o1i2 + o2i;
                            in[iidx1] = o1r2 + o2r;
                            in[iidx2 - 1] = o1r2 - o2r;
                            in[iidx2] = o2i - o1i2;
                            ++k2;
                        }
                        i5 += 2;
                    }
                    ++j;
                }
            }
        } else {
            System.arraycopy(out, out_off, in, in_off, idl1);
        }
        j = 1;
        while (j < ipph) {
            jc = ip - j;
            idx13 = j * l1 * ido;
            idx22 = jc * l1 * ido;
            k = 0;
            while (k < l1) {
                idx32 = k * ido + idx13;
                idx42 = k * ido + idx22;
                oidx1 = out_off + idx32;
                int oidx2 = out_off + idx42;
                double o1r3 = out[oidx1];
                double o2r = out[oidx2];
                in[in_off + idx32] = o1r3 + o2r;
                in[in_off + idx42] = o2r - o1r3;
                ++k;
            }
            ++j;
        }
        double ar1 = 1.0;
        double ai1 = 0.0;
        int idx0 = (ip - 1) * idl1;
        int l2 = 1;
        while (l2 < ipph) {
            int idx45;
            int lc = ip - l2;
            double ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            idx12 = l2 * idl1;
            idx23 = lc * idl1;
            int ik = 0;
            while (ik < idl1) {
                idx3 = out_off + ik;
                idx45 = in_off + ik;
                out[idx3 + idx12] = in[idx45] + ar1 * in[idx45 + idl1];
                out[idx3 + idx23] = ai1 * in[idx45 + idx0];
                ++ik;
            }
            double dc2 = ar1;
            double ds2 = ai1;
            double ar2 = ar1;
            double ai2 = ai1;
            int j3 = 2;
            while (j3 < ipph) {
                jc = ip - j3;
                double ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                idx3 = j3 * idl1;
                idx45 = jc * idl1;
                int ik2 = 0;
                while (ik2 < idl1) {
                    int idx5 = out_off + ik2;
                    idx6 = in_off + ik2;
                    int n2 = idx5 + idx12;
                    out[n2] = out[n2] + ar2 * in[idx6 + idx3];
                    int n3 = idx5 + idx23;
                    out[n3] = out[n3] + ai2 * in[idx6 + idx45];
                    ++ik2;
                }
                ++j3;
            }
            ++l2;
        }
        int j4 = 1;
        while (j4 < ipph) {
            idx12 = j4 * idl1;
            int ik = 0;
            while (ik < idl1) {
                int n4 = out_off + ik;
                out[n4] = out[n4] + in[in_off + ik + idx12];
                ++ik;
            }
            ++j4;
        }
        if (ido >= l1) {
            int k4 = 0;
            while (k4 < l1) {
                idx12 = k4 * ido;
                idx23 = idx12 * ip;
                i3 = 0;
                while (i3 < ido) {
                    in[in_off + i3 + idx23] = out[out_off + i3 + idx12];
                    ++i3;
                }
                ++k4;
            }
        } else {
            int i6 = 0;
            while (i6 < ido) {
                k3 = 0;
                while (k3 < l1) {
                    idx1 = k3 * ido;
                    in[in_off + i6 + idx1 * ip] = out[out_off + i6 + idx1];
                    ++k3;
                }
                ++i6;
            }
        }
        int idx01 = ip * ido;
        int j5 = 1;
        while (j5 < ipph) {
            jc = ip - j5;
            j2 = 2 * j5;
            idx1 = j5 * l1 * ido;
            idx2 = jc * l1 * ido;
            idx3 = j2 * ido;
            k2 = 0;
            while (k2 < l1) {
                idx4 = k2 * ido;
                int idx5 = idx4 + idx1;
                idx6 = idx4 + idx2;
                int idx7 = k2 * idx01;
                in[in_off + ido - 1 + idx3 - ido + idx7] = out[out_off + idx5];
                in[in_off + idx3 + idx7] = out[out_off + idx6];
                ++k2;
            }
            ++j5;
        }
        if (ido == 1) {
            return;
        }
        if (nbd >= l1) {
            j5 = 1;
            while (j5 < ipph) {
                jc = ip - j5;
                j2 = 2 * j5;
                idx1 = j5 * l1 * ido;
                idx2 = jc * l1 * ido;
                idx3 = j2 * ido;
                k2 = 0;
                while (k2 < l1) {
                    idx4 = k2 * idx01;
                    int idx5 = k2 * ido;
                    int i7 = 2;
                    while (i7 < ido) {
                        int ic = ido - i7;
                        int idx64 = in_off + i7;
                        int idx7 = in_off + ic;
                        int idx8 = out_off + i7;
                        int iidx1 = idx64 + idx3 + idx4;
                        int iidx2 = idx7 + idx3 - ido + idx4;
                        int oidx14 = idx8 + idx5 + idx1;
                        int oidx2 = idx8 + idx5 + idx2;
                        o1i = out[oidx14 - 1];
                        o1r = out[oidx14];
                        double o2i = out[oidx2 - 1];
                        double o2r = out[oidx2];
                        in[iidx1 - 1] = o1i + o2i;
                        in[iidx2 - 1] = o1i - o2i;
                        in[iidx1] = o1r + o2r;
                        in[iidx2] = o2r - o1r;
                        i7 += 2;
                    }
                    ++k2;
                }
                ++j5;
            }
        } else {
            j5 = 1;
            while (j5 < ipph) {
                jc = ip - j5;
                j2 = 2 * j5;
                idx1 = j5 * l1 * ido;
                idx2 = jc * l1 * ido;
                idx3 = j2 * ido;
                i2 = 2;
                while (i2 < ido) {
                    int ic = ido - i2;
                    int idx65 = in_off + i2;
                    int idx7 = in_off + ic;
                    int idx8 = out_off + i2;
                    int k5 = 0;
                    while (k5 < l1) {
                        int idx46 = k5 * idx01;
                        int idx5 = k5 * ido;
                        int iidx1 = idx65 + idx3 + idx46;
                        int iidx2 = idx7 + idx3 - ido + idx46;
                        int oidx15 = idx8 + idx5 + idx1;
                        int oidx2 = idx8 + idx5 + idx2;
                        o1i = out[oidx15 - 1];
                        o1r = out[oidx15];
                        double o2i = out[oidx2 - 1];
                        double o2r = out[oidx2];
                        in[iidx1 - 1] = o1i + o2i;
                        in[iidx2 - 1] = o1i - o2i;
                        in[iidx1] = o1r + o2r;
                        in[iidx2] = o2r - o1r;
                        ++k5;
                    }
                    i2 += 2;
                }
                ++j5;
            }
        }
    }

    void radbg(int ido, int ip, int l1, int idl1, double[] in, int in_off, double[] out, int out_off, int offset) {
        int oidx1;
        int k;
        int idx3;
        int k2;
        double i2r;
        double i2i;
        int iidx2;
        int oidx2;
        int idx5;
        int idx4;
        int idx2;
        int idx32;
        int idx22;
        int idx1;
        int i2;
        double i2r2;
        double i1r;
        int iidx22;
        int iidx1;
        int idx52;
        int idx42;
        int k3;
        int idx33;
        int idx23;
        int idx12;
        int jc;
        int idx24;
        int idx13;
        int iw1 = offset;
        double arg = Math.PI * 2 / (double)ip;
        double dcp = Math.cos(arg);
        double dsp = Math.sin(arg);
        int nbd = (ido - 1) / 2;
        int ipph = (ip + 1) / 2;
        int idx0 = ip * ido;
        if (ido >= l1) {
            int k4 = 0;
            while (k4 < l1) {
                idx13 = k4 * ido;
                idx24 = k4 * idx0;
                int i3 = 0;
                while (i3 < ido) {
                    out[out_off + i3 + idx13] = in[in_off + i3 + idx24];
                    ++i3;
                }
                ++k4;
            }
        } else {
            int i4 = 0;
            while (i4 < ido) {
                idx13 = out_off + i4;
                idx24 = in_off + i4;
                int k5 = 0;
                while (k5 < l1) {
                    out[idx13 + k5 * ido] = in[idx24 + k5 * idx0];
                    ++k5;
                }
                ++i4;
            }
        }
        int iidx0 = in_off + ido - 1;
        int j = 1;
        while (j < ipph) {
            jc = ip - j;
            int j2 = 2 * j;
            idx12 = j * l1 * ido;
            idx23 = jc * l1 * ido;
            idx33 = j2 * ido;
            k3 = 0;
            while (k3 < l1) {
                idx42 = k3 * ido;
                idx52 = idx42 * ip;
                iidx1 = iidx0 + idx33 + idx52 - ido;
                iidx22 = in_off + idx33 + idx52;
                i1r = in[iidx1];
                i2r2 = in[iidx22];
                out[out_off + idx42 + idx12] = i1r + i1r;
                out[out_off + idx42 + idx23] = i2r2 + i2r2;
                ++k3;
            }
            ++j;
        }
        if (ido != 1) {
            double a2r;
            double a2i;
            double a1r;
            double a1i;
            int iidx23;
            int iidx12;
            int oidx22;
            int oidx12;
            int ic;
            if (nbd >= l1) {
                j = 1;
                while (j < ipph) {
                    jc = ip - j;
                    idx12 = j * l1 * ido;
                    idx23 = jc * l1 * ido;
                    idx33 = 2 * j * ido;
                    k3 = 0;
                    while (k3 < l1) {
                        idx42 = k3 * ido + idx12;
                        idx52 = k3 * ido + idx23;
                        int idx6 = k3 * ip * ido + idx33;
                        int i5 = 2;
                        while (i5 < ido) {
                            ic = ido - i5;
                            int idx7 = out_off + i5;
                            int idx8 = in_off + ic;
                            int idx9 = in_off + i5;
                            oidx12 = idx7 + idx42;
                            oidx22 = idx7 + idx52;
                            iidx12 = idx9 + idx6;
                            iidx23 = idx8 + idx6 - ido;
                            a1i = in[iidx12 - 1];
                            a1r = in[iidx12];
                            a2i = in[iidx23 - 1];
                            a2r = in[iidx23];
                            out[oidx12 - 1] = a1i + a2i;
                            out[oidx22 - 1] = a1i - a2i;
                            out[oidx12] = a1r - a2r;
                            out[oidx22] = a1r + a2r;
                            i5 += 2;
                        }
                        ++k3;
                    }
                    ++j;
                }
            } else {
                j = 1;
                while (j < ipph) {
                    jc = ip - j;
                    idx12 = j * l1 * ido;
                    idx23 = jc * l1 * ido;
                    idx33 = 2 * j * ido;
                    i2 = 2;
                    while (i2 < ido) {
                        ic = ido - i2;
                        int idx7 = out_off + i2;
                        int idx8 = in_off + ic;
                        int idx9 = in_off + i2;
                        int k6 = 0;
                        while (k6 < l1) {
                            int idx43 = k6 * ido + idx12;
                            int idx53 = k6 * ido + idx23;
                            int idx6 = k6 * ip * ido + idx33;
                            oidx12 = idx7 + idx43;
                            oidx22 = idx7 + idx53;
                            iidx12 = idx9 + idx6;
                            iidx23 = idx8 + idx6 - ido;
                            a1i = in[iidx12 - 1];
                            a1r = in[iidx12];
                            a2i = in[iidx23 - 1];
                            a2r = in[iidx23];
                            out[oidx12 - 1] = a1i + a2i;
                            out[oidx22 - 1] = a1i - a2i;
                            out[oidx12] = a1r - a2r;
                            out[oidx22] = a1r + a2r;
                            ++k6;
                        }
                        i2 += 2;
                    }
                    ++j;
                }
            }
        }
        double ar1 = 1.0;
        double ai1 = 0.0;
        int idx01 = (ip - 1) * idl1;
        int l2 = 1;
        while (l2 < ipph) {
            int lc = ip - l2;
            double ar1h = dcp * ar1 - dsp * ai1;
            ai1 = dcp * ai1 + dsp * ar1;
            ar1 = ar1h;
            idx1 = l2 * idl1;
            idx22 = lc * idl1;
            int ik = 0;
            while (ik < idl1) {
                idx32 = in_off + ik;
                int idx44 = out_off + ik;
                in[idx32 + idx1] = out[idx44] + ar1 * out[idx44 + idl1];
                in[idx32 + idx22] = ai1 * out[idx44 + idx01];
                ++ik;
            }
            double dc2 = ar1;
            double ds2 = ai1;
            double ar2 = ar1;
            double ai2 = ai1;
            int j2 = 2;
            while (j2 < ipph) {
                jc = ip - j2;
                double ar2h = dc2 * ar2 - ds2 * ai2;
                ai2 = dc2 * ai2 + ds2 * ar2;
                ar2 = ar2h;
                int idx54 = j2 * idl1;
                int idx6 = jc * idl1;
                int ik2 = 0;
                while (ik2 < idl1) {
                    int idx7 = in_off + ik2;
                    int idx8 = out_off + ik2;
                    int n2 = idx7 + idx1;
                    in[n2] = in[n2] + ar2 * out[idx8 + idx54];
                    int n3 = idx7 + idx22;
                    in[n3] = in[n3] + ai2 * out[idx8 + idx6];
                    ++ik2;
                }
                ++j2;
            }
            ++l2;
        }
        int j3 = 1;
        while (j3 < ipph) {
            idx1 = j3 * idl1;
            int ik = 0;
            while (ik < idl1) {
                int n4 = idx2 = out_off + ik;
                out[n4] = out[n4] + out[idx2 + idx1];
                ++ik;
            }
            ++j3;
        }
        j3 = 1;
        while (j3 < ipph) {
            jc = ip - j3;
            idx1 = j3 * l1 * ido;
            idx22 = jc * l1 * ido;
            k3 = 0;
            while (k3 < l1) {
                idx32 = k3 * ido;
                int oidx13 = out_off + idx32;
                iidx1 = in_off + idx32 + idx1;
                iidx22 = in_off + idx32 + idx22;
                i1r = in[iidx1];
                i2r2 = in[iidx22];
                out[oidx13 + idx1] = i1r - i2r2;
                out[oidx13 + idx22] = i1r + i2r2;
                ++k3;
            }
            ++j3;
        }
        if (ido == 1) {
            return;
        }
        if (nbd >= l1) {
            j3 = 1;
            while (j3 < ipph) {
                jc = ip - j3;
                idx1 = j3 * l1 * ido;
                idx22 = jc * l1 * ido;
                k3 = 0;
                while (k3 < l1) {
                    idx32 = k3 * ido;
                    int i6 = 2;
                    while (i6 < ido) {
                        idx4 = out_off + i6;
                        idx5 = in_off + i6;
                        int oidx14 = idx4 + idx32 + idx1;
                        oidx2 = idx4 + idx32 + idx22;
                        int iidx13 = idx5 + idx32 + idx1;
                        iidx2 = idx5 + idx32 + idx22;
                        double i1i = in[iidx13 - 1];
                        double i1r2 = in[iidx13];
                        i2i = in[iidx2 - 1];
                        i2r = in[iidx2];
                        out[oidx14 - 1] = i1i - i2r;
                        out[oidx2 - 1] = i1i + i2r;
                        out[oidx14] = i1r2 + i2i;
                        out[oidx2] = i1r2 - i2i;
                        i6 += 2;
                    }
                    ++k3;
                }
                ++j3;
            }
        } else {
            j3 = 1;
            while (j3 < ipph) {
                jc = ip - j3;
                idx1 = j3 * l1 * ido;
                idx22 = jc * l1 * ido;
                i2 = 2;
                while (i2 < ido) {
                    idx42 = out_off + i2;
                    idx52 = in_off + i2;
                    k2 = 0;
                    while (k2 < l1) {
                        idx3 = k2 * ido;
                        int oidx15 = idx42 + idx3 + idx1;
                        oidx2 = idx42 + idx3 + idx22;
                        int iidx14 = idx52 + idx3 + idx1;
                        iidx2 = idx52 + idx3 + idx22;
                        double i1i = in[iidx14 - 1];
                        double i1r3 = in[iidx14];
                        i2i = in[iidx2 - 1];
                        i2r = in[iidx2];
                        out[oidx15 - 1] = i1i - i2r;
                        out[oidx2 - 1] = i1i + i2r;
                        out[oidx15] = i1r3 + i2i;
                        out[oidx2] = i1r3 - i2i;
                        ++k2;
                    }
                    i2 += 2;
                }
                ++j3;
            }
        }
        System.arraycopy(out, out_off, in, in_off, idl1);
        j3 = 1;
        while (j3 < ip) {
            idx1 = j3 * l1 * ido;
            k = 0;
            while (k < l1) {
                idx2 = k * ido + idx1;
                in[in_off + idx2] = out[out_off + idx2];
                ++k;
            }
            ++j3;
        }
        if (nbd <= l1) {
            int is = -ido;
            j3 = 1;
            while (j3 < ip) {
                int idij = (is += ido) - 1;
                idx1 = j3 * l1 * ido;
                int i7 = 2;
                while (i7 < ido) {
                    idx2 = (idij += 2) + iw1;
                    double w1r = this.wtable_r[idx2 - 1];
                    double w1i = this.wtable_r[idx2];
                    idx42 = in_off + i7;
                    idx52 = out_off + i7;
                    k2 = 0;
                    while (k2 < l1) {
                        idx3 = k2 * ido + idx1;
                        int iidx15 = idx42 + idx3;
                        oidx1 = idx52 + idx3;
                        double o1i = out[oidx1 - 1];
                        double o1r = out[oidx1];
                        in[iidx15 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx15] = w1r * o1r + w1i * o1i;
                        ++k2;
                    }
                    i7 += 2;
                }
                ++j3;
            }
        } else {
            int is = -ido;
            j3 = 1;
            while (j3 < ip) {
                is += ido;
                idx1 = j3 * l1 * ido;
                k = 0;
                while (k < l1) {
                    int idij = is - 1;
                    int idx34 = k * ido + idx1;
                    int i8 = 2;
                    while (i8 < ido) {
                        int idx25 = (idij += 2) + iw1;
                        double w1r = this.wtable_r[idx25 - 1];
                        double w1i = this.wtable_r[idx25];
                        idx4 = in_off + i8;
                        idx5 = out_off + i8;
                        int iidx16 = idx4 + idx34;
                        oidx1 = idx5 + idx34;
                        double o1i = out[oidx1 - 1];
                        double o1r = out[oidx1];
                        in[iidx16 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx16] = w1r * o1r + w1i * o1i;
                        i8 += 2;
                    }
                    ++k;
                }
                ++j3;
            }
        }
    }

    void cfftf(double[] a, int offa, int isign) {
        int[] nac = new int[1];
        int twon = 2 * this.n;
        double[] ch = new double[twon];
        int iw1 = twon;
        int iw2 = 4 * this.n;
        nac[0] = 0;
        int nf = (int)this.wtable[1 + iw2];
        int na = 0;
        int l1 = 1;
        int iw = iw1;
        int k1 = 2;
        while (k1 <= nf + 1) {
            int ip = (int)this.wtable[k1 + iw2];
            int l2 = ip * l1;
            int ido = this.n / l2;
            int idot = ido + ido;
            int idl1 = idot * l1;
            switch (ip) {
                case 4: {
                    if (na == 0) {
                        this.passf4(idot, l1, a, offa, ch, 0, iw, isign);
                    } else {
                        this.passf4(idot, l1, ch, 0, a, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                case 2: {
                    if (na == 0) {
                        this.passf2(idot, l1, a, offa, ch, 0, iw, isign);
                    } else {
                        this.passf2(idot, l1, ch, 0, a, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                case 3: {
                    if (na == 0) {
                        this.passf3(idot, l1, a, offa, ch, 0, iw, isign);
                    } else {
                        this.passf3(idot, l1, ch, 0, a, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                case 5: {
                    if (na == 0) {
                        this.passf5(idot, l1, a, offa, ch, 0, iw, isign);
                    } else {
                        this.passf5(idot, l1, ch, 0, a, offa, iw, isign);
                    }
                    na = 1 - na;
                    break;
                }
                default: {
                    if (na == 0) {
                        this.passfg(nac, idot, ip, l1, idl1, a, offa, ch, 0, iw, isign);
                    } else {
                        this.passfg(nac, idot, ip, l1, idl1, ch, 0, a, offa, iw, isign);
                    }
                    if (nac[0] == 0) break;
                    na = 1 - na;
                }
            }
            l1 = l2;
            iw += (ip - 1) * idot;
            ++k1;
        }
        if (na == 0) {
            return;
        }
        System.arraycopy(ch, 0, a, offa, twon);
    }

    void passf2(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset, int isign) {
        int iw1 = offset;
        int idx = ido * l1;
        if (ido <= 2) {
            int k = 0;
            while (k < l1) {
                int idx0 = k * ido;
                int iidx1 = in_off + 2 * idx0;
                int iidx2 = iidx1 + ido;
                double a1r = in[iidx1];
                double a1i = in[iidx1 + 1];
                double a2r = in[iidx2];
                double a2i = in[iidx2 + 1];
                int oidx1 = out_off + idx0;
                int oidx2 = oidx1 + idx;
                out[oidx1] = a1r + a2r;
                out[oidx1 + 1] = a1i + a2i;
                out[oidx2] = a1r - a2r;
                out[oidx2 + 1] = a1i - a2i;
                ++k;
            }
        } else {
            int k = 0;
            while (k < l1) {
                int i2 = 0;
                while (i2 < ido - 1) {
                    int idx0 = k * ido;
                    int iidx1 = in_off + i2 + 2 * idx0;
                    int iidx2 = iidx1 + ido;
                    double i1r = in[iidx1];
                    double i1i = in[iidx1 + 1];
                    double i2r = in[iidx2];
                    double i2i = in[iidx2 + 1];
                    int widx1 = i2 + iw1;
                    double w1r = this.wtable[widx1];
                    double w1i = (double)isign * this.wtable[widx1 + 1];
                    double t1r = i1r - i2r;
                    double t1i = i1i - i2i;
                    int oidx1 = out_off + i2 + idx0;
                    int oidx2 = oidx1 + idx;
                    out[oidx1] = i1r + i2r;
                    out[oidx1 + 1] = i1i + i2i;
                    out[oidx2] = w1r * t1r - w1i * t1i;
                    out[oidx2 + 1] = w1r * t1i + w1i * t1r;
                    i2 += 2;
                }
                ++k;
            }
        }
    }

    void passf3(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset, int isign) {
        double taur = -0.5;
        double taui = 0.8660254037844387;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int idxt = l1 * ido;
        if (ido == 2) {
            int k = 1;
            while (k <= l1) {
                int iidx1 = in_off + (3 * k - 2) * ido;
                int iidx2 = iidx1 + ido;
                int iidx3 = iidx1 - ido;
                double i1r = in[iidx1];
                double i1i = in[iidx1 + 1];
                double i2r = in[iidx2];
                double i2i = in[iidx2 + 1];
                double i3r = in[iidx3];
                double i3i = in[iidx3 + 1];
                double tr2 = i1r + i2r;
                double cr2 = i3r + -0.5 * tr2;
                double ti2 = i1i + i2i;
                double ci2 = i3i + -0.5 * ti2;
                double cr3 = (double)isign * 0.8660254037844387 * (i1r - i2r);
                double ci3 = (double)isign * 0.8660254037844387 * (i1i - i2i);
                int oidx1 = out_off + (k - 1) * ido;
                int oidx2 = oidx1 + idxt;
                int oidx3 = oidx2 + idxt;
                out[oidx1] = in[iidx3] + tr2;
                out[oidx1 + 1] = i3i + ti2;
                out[oidx2] = cr2 - ci3;
                out[oidx2 + 1] = ci2 + cr3;
                out[oidx3] = cr2 + ci3;
                out[oidx3 + 1] = ci2 - cr3;
                ++k;
            }
        } else {
            int k = 1;
            while (k <= l1) {
                int idx1 = in_off + (3 * k - 2) * ido;
                int idx2 = out_off + (k - 1) * ido;
                int i2 = 0;
                while (i2 < ido - 1) {
                    int iidx1 = i2 + idx1;
                    int iidx2 = iidx1 + ido;
                    int iidx3 = iidx1 - ido;
                    double a1r = in[iidx1];
                    double a1i = in[iidx1 + 1];
                    double a2r = in[iidx2];
                    double a2i = in[iidx2 + 1];
                    double a3r = in[iidx3];
                    double a3i = in[iidx3 + 1];
                    double tr2 = a1r + a2r;
                    double cr2 = a3r + -0.5 * tr2;
                    double ti2 = a1i + a2i;
                    double ci2 = a3i + -0.5 * ti2;
                    double cr3 = (double)isign * 0.8660254037844387 * (a1r - a2r);
                    double ci3 = (double)isign * 0.8660254037844387 * (a1i - a2i);
                    double dr2 = cr2 - ci3;
                    double dr3 = cr2 + ci3;
                    double di2 = ci2 + cr3;
                    double di3 = ci2 - cr3;
                    int widx1 = i2 + iw1;
                    int widx2 = i2 + iw2;
                    double w1r = this.wtable[widx1];
                    double w1i = (double)isign * this.wtable[widx1 + 1];
                    double w2r = this.wtable[widx2];
                    double w2i = (double)isign * this.wtable[widx2 + 1];
                    int oidx1 = i2 + idx2;
                    int oidx2 = oidx1 + idxt;
                    int oidx3 = oidx2 + idxt;
                    out[oidx1] = a3r + tr2;
                    out[oidx1 + 1] = a3i + ti2;
                    out[oidx2] = w1r * dr2 - w1i * di2;
                    out[oidx2 + 1] = w1r * di2 + w1i * dr2;
                    out[oidx3] = w2r * dr3 - w2i * di3;
                    out[oidx3 + 1] = w2r * di3 + w2i * dr3;
                    i2 += 2;
                }
                ++k;
            }
        }
    }

    void passf4(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset, int isign) {
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int idx0 = l1 * ido;
        if (ido == 2) {
            int k = 0;
            while (k < l1) {
                int idxt1 = k * ido;
                int iidx1 = in_off + 4 * idxt1 + 1;
                int iidx2 = iidx1 + ido;
                int iidx3 = iidx2 + ido;
                int iidx4 = iidx3 + ido;
                double i1i = in[iidx1 - 1];
                double i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                double i3i = in[iidx3 - 1];
                double i3r = in[iidx3];
                double i4i = in[iidx4 - 1];
                double i4r = in[iidx4];
                double ti1 = i1r - i3r;
                double ti2 = i1r + i3r;
                double tr4 = i4r - i2r;
                double ti3 = i2r + i4r;
                double tr1 = i1i - i3i;
                double tr2 = i1i + i3i;
                double ti4 = i2i - i4i;
                double tr3 = i2i + i4i;
                int oidx1 = out_off + idxt1;
                int oidx2 = oidx1 + idx0;
                int oidx3 = oidx2 + idx0;
                int oidx4 = oidx3 + idx0;
                out[oidx1] = tr2 + tr3;
                out[oidx1 + 1] = ti2 + ti3;
                out[oidx2] = tr1 + (double)isign * tr4;
                out[oidx2 + 1] = ti1 + (double)isign * ti4;
                out[oidx3] = tr2 - tr3;
                out[oidx3 + 1] = ti2 - ti3;
                out[oidx4] = tr1 - (double)isign * tr4;
                out[oidx4 + 1] = ti1 - (double)isign * ti4;
                ++k;
            }
        } else {
            int k = 0;
            while (k < l1) {
                int idx1 = k * ido;
                int idx2 = in_off + 1 + 4 * idx1;
                int i2 = 0;
                while (i2 < ido - 1) {
                    int iidx1 = i2 + idx2;
                    int iidx2 = iidx1 + ido;
                    int iidx3 = iidx2 + ido;
                    int iidx4 = iidx3 + ido;
                    double i1i = in[iidx1 - 1];
                    double i1r = in[iidx1];
                    double i2i = in[iidx2 - 1];
                    double i2r = in[iidx2];
                    double i3i = in[iidx3 - 1];
                    double i3r = in[iidx3];
                    double i4i = in[iidx4 - 1];
                    double i4r = in[iidx4];
                    double ti1 = i1r - i3r;
                    double ti2 = i1r + i3r;
                    double ti3 = i2r + i4r;
                    double tr4 = i4r - i2r;
                    double tr1 = i1i - i3i;
                    double tr2 = i1i + i3i;
                    double ti4 = i2i - i4i;
                    double tr3 = i2i + i4i;
                    double cr3 = tr2 - tr3;
                    double ci3 = ti2 - ti3;
                    double cr2 = tr1 + (double)isign * tr4;
                    double cr4 = tr1 - (double)isign * tr4;
                    double ci2 = ti1 + (double)isign * ti4;
                    double ci4 = ti1 - (double)isign * ti4;
                    int widx1 = i2 + iw1;
                    int widx2 = i2 + iw2;
                    int widx3 = i2 + iw3;
                    double w1r = this.wtable[widx1];
                    double w1i = (double)isign * this.wtable[widx1 + 1];
                    double w2r = this.wtable[widx2];
                    double w2i = (double)isign * this.wtable[widx2 + 1];
                    double w3r = this.wtable[widx3];
                    double w3i = (double)isign * this.wtable[widx3 + 1];
                    int oidx1 = out_off + i2 + idx1;
                    int oidx2 = oidx1 + idx0;
                    int oidx3 = oidx2 + idx0;
                    int oidx4 = oidx3 + idx0;
                    out[oidx1] = tr2 + tr3;
                    out[oidx1 + 1] = ti2 + ti3;
                    out[oidx2] = w1r * cr2 - w1i * ci2;
                    out[oidx2 + 1] = w1r * ci2 + w1i * cr2;
                    out[oidx3] = w2r * cr3 - w2i * ci3;
                    out[oidx3 + 1] = w2r * ci3 + w2i * cr3;
                    out[oidx4] = w3r * cr4 - w3i * ci4;
                    out[oidx4 + 1] = w3r * ci4 + w3i * cr4;
                    i2 += 2;
                }
                ++k;
            }
        }
    }

    void passf5(int ido, int l1, double[] in, int in_off, double[] out, int out_off, int offset, int isign) {
        double tr11 = 0.30901699437494745;
        double ti11 = 0.9510565162951535;
        double tr12 = -0.8090169943749473;
        double ti12 = 0.5877852522924732;
        int iw1 = offset;
        int iw2 = iw1 + ido;
        int iw3 = iw2 + ido;
        int iw4 = iw3 + ido;
        int idx0 = l1 * ido;
        if (ido == 2) {
            int k = 1;
            while (k <= l1) {
                int iidx1 = in_off + (5 * k - 4) * ido + 1;
                int iidx2 = iidx1 + ido;
                int iidx3 = iidx1 - ido;
                int iidx4 = iidx2 + ido;
                int iidx5 = iidx4 + ido;
                double i1i = in[iidx1 - 1];
                double i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                double i3i = in[iidx3 - 1];
                double i3r = in[iidx3];
                double i4i = in[iidx4 - 1];
                double i4r = in[iidx4];
                double i5i = in[iidx5 - 1];
                double i5r = in[iidx5];
                double ti5 = i1r - i5r;
                double ti2 = i1r + i5r;
                double ti4 = i2r - i4r;
                double ti3 = i2r + i4r;
                double tr5 = i1i - i5i;
                double tr2 = i1i + i5i;
                double tr4 = i2i - i4i;
                double tr3 = i2i + i4i;
                double cr2 = i3i + 0.30901699437494745 * tr2 + -0.8090169943749473 * tr3;
                double ci2 = i3r + 0.30901699437494745 * ti2 + -0.8090169943749473 * ti3;
                double cr3 = i3i + -0.8090169943749473 * tr2 + 0.30901699437494745 * tr3;
                double ci3 = i3r + -0.8090169943749473 * ti2 + 0.30901699437494745 * ti3;
                double cr5 = (double)isign * (0.9510565162951535 * tr5 + 0.5877852522924732 * tr4);
                double ci5 = (double)isign * (0.9510565162951535 * ti5 + 0.5877852522924732 * ti4);
                double cr4 = (double)isign * (0.5877852522924732 * tr5 - 0.9510565162951535 * tr4);
                double ci4 = (double)isign * (0.5877852522924732 * ti5 - 0.9510565162951535 * ti4);
                int oidx1 = out_off + (k - 1) * ido;
                int oidx2 = oidx1 + idx0;
                int oidx3 = oidx2 + idx0;
                int oidx4 = oidx3 + idx0;
                int oidx5 = oidx4 + idx0;
                out[oidx1] = i3i + tr2 + tr3;
                out[oidx1 + 1] = i3r + ti2 + ti3;
                out[oidx2] = cr2 - ci5;
                out[oidx2 + 1] = ci2 + cr5;
                out[oidx3] = cr3 - ci4;
                out[oidx3 + 1] = ci3 + cr4;
                out[oidx4] = cr3 + ci4;
                out[oidx4 + 1] = ci3 - cr4;
                out[oidx5] = cr2 + ci5;
                out[oidx5 + 1] = ci2 - cr5;
                ++k;
            }
        } else {
            int k = 1;
            while (k <= l1) {
                int idx1 = in_off + 1 + (k * 5 - 4) * ido;
                int idx2 = out_off + (k - 1) * ido;
                int i2 = 0;
                while (i2 < ido - 1) {
                    int iidx1 = i2 + idx1;
                    int iidx2 = iidx1 + ido;
                    int iidx3 = iidx1 - ido;
                    int iidx4 = iidx2 + ido;
                    int iidx5 = iidx4 + ido;
                    double i1i = in[iidx1 - 1];
                    double i1r = in[iidx1];
                    double i2i = in[iidx2 - 1];
                    double i2r = in[iidx2];
                    double i3i = in[iidx3 - 1];
                    double i3r = in[iidx3];
                    double i4i = in[iidx4 - 1];
                    double i4r = in[iidx4];
                    double i5i = in[iidx5 - 1];
                    double i5r = in[iidx5];
                    double ti5 = i1r - i5r;
                    double ti2 = i1r + i5r;
                    double ti4 = i2r - i4r;
                    double ti3 = i2r + i4r;
                    double tr5 = i1i - i5i;
                    double tr2 = i1i + i5i;
                    double tr4 = i2i - i4i;
                    double tr3 = i2i + i4i;
                    double cr2 = i3i + 0.30901699437494745 * tr2 + -0.8090169943749473 * tr3;
                    double ci2 = i3r + 0.30901699437494745 * ti2 + -0.8090169943749473 * ti3;
                    double cr3 = i3i + -0.8090169943749473 * tr2 + 0.30901699437494745 * tr3;
                    double ci3 = i3r + -0.8090169943749473 * ti2 + 0.30901699437494745 * ti3;
                    double cr5 = (double)isign * (0.9510565162951535 * tr5 + 0.5877852522924732 * tr4);
                    double ci5 = (double)isign * (0.9510565162951535 * ti5 + 0.5877852522924732 * ti4);
                    double cr4 = (double)isign * (0.5877852522924732 * tr5 - 0.9510565162951535 * tr4);
                    double ci4 = (double)isign * (0.5877852522924732 * ti5 - 0.9510565162951535 * ti4);
                    double dr3 = cr3 - ci4;
                    double dr4 = cr3 + ci4;
                    double di3 = ci3 + cr4;
                    double di4 = ci3 - cr4;
                    double dr5 = cr2 + ci5;
                    double dr2 = cr2 - ci5;
                    double di5 = ci2 - cr5;
                    double di2 = ci2 + cr5;
                    int widx1 = i2 + iw1;
                    int widx2 = i2 + iw2;
                    int widx3 = i2 + iw3;
                    int widx4 = i2 + iw4;
                    double w1r = this.wtable[widx1];
                    double w1i = (double)isign * this.wtable[widx1 + 1];
                    double w2r = this.wtable[widx2];
                    double w2i = (double)isign * this.wtable[widx2 + 1];
                    double w3r = this.wtable[widx3];
                    double w3i = (double)isign * this.wtable[widx3 + 1];
                    double w4r = this.wtable[widx4];
                    double w4i = (double)isign * this.wtable[widx4 + 1];
                    int oidx1 = i2 + idx2;
                    int oidx2 = oidx1 + idx0;
                    int oidx3 = oidx2 + idx0;
                    int oidx4 = oidx3 + idx0;
                    int oidx5 = oidx4 + idx0;
                    out[oidx1] = i3i + tr2 + tr3;
                    out[oidx1 + 1] = i3r + ti2 + ti3;
                    out[oidx2] = w1r * dr2 - w1i * di2;
                    out[oidx2 + 1] = w1r * di2 + w1i * dr2;
                    out[oidx3] = w2r * dr3 - w2i * di3;
                    out[oidx3 + 1] = w2r * di3 + w2i * dr3;
                    out[oidx4] = w3r * dr4 - w3i * di4;
                    out[oidx4 + 1] = w3r * di4 + w3i * dr4;
                    out[oidx5] = w4r * dr5 - w4i * di5;
                    out[oidx5 + 1] = w4r * di5 + w4i * dr5;
                    i2 += 2;
                }
                ++k;
            }
        }
    }

    void passfg(int[] nac, int ido, int ip, int l1, int idl1, double[] in, int in_off, double[] out, int out_off, int offset, int isign) {
        int idx2;
        int k;
        int idx1;
        int iidx1;
        int idx3;
        int ik;
        double w1i;
        double w1r;
        int idx12;
        double i1r;
        int idxt3;
        int idxt2;
        int idxt1;
        int jc;
        int j;
        int iw1 = offset;
        int idot = ido / 2;
        int ipph = (ip + 1) / 2;
        int idp = ip * ido;
        if (ido >= l1) {
            j = 1;
            while (j < ipph) {
                jc = ip - j;
                int idx13 = j * ido;
                int idx22 = jc * ido;
                int k2 = 0;
                while (k2 < l1) {
                    int idx32 = k2 * ido;
                    int idx4 = idx32 + idx13 * l1;
                    int idx5 = idx32 + idx22 * l1;
                    int idx6 = idx32 * ip;
                    int i2 = 0;
                    while (i2 < ido) {
                        int oidx1 = out_off + i2;
                        double i1r2 = in[in_off + i2 + idx13 + idx6];
                        double i2r = in[in_off + i2 + idx22 + idx6];
                        out[oidx1 + idx4] = i1r2 + i2r;
                        out[oidx1 + idx5] = i1r2 - i2r;
                        ++i2;
                    }
                    ++k2;
                }
                ++j;
            }
            int k3 = 0;
            while (k3 < l1) {
                idxt1 = k3 * ido;
                idxt2 = idxt1 * ip;
                int i3 = 0;
                while (i3 < ido) {
                    out[out_off + i3 + idxt1] = in[in_off + i3 + idxt2];
                    ++i3;
                }
                ++k3;
            }
        } else {
            j = 1;
            while (j < ipph) {
                jc = ip - j;
                idxt1 = j * l1 * ido;
                idxt2 = jc * l1 * ido;
                idxt3 = j * ido;
                int idxt4 = jc * ido;
                int i4 = 0;
                while (i4 < ido) {
                    int k4 = 0;
                    while (k4 < l1) {
                        int idx14 = k4 * ido;
                        int idx23 = idx14 * ip;
                        int idx33 = out_off + i4;
                        int idx4 = in_off + i4;
                        i1r = in[idx4 + idxt3 + idx23];
                        double i2r = in[idx4 + idxt4 + idx23];
                        out[idx33 + idx14 + idxt1] = i1r + i2r;
                        out[idx33 + idx14 + idxt2] = i1r - i2r;
                        ++k4;
                    }
                    ++i4;
                }
                ++j;
            }
            int i5 = 0;
            while (i5 < ido) {
                int k5 = 0;
                while (k5 < l1) {
                    idx12 = k5 * ido;
                    out[out_off + i5 + idx12] = in[in_off + i5 + idx12 * ip];
                    ++k5;
                }
                ++i5;
            }
        }
        int idl = 2 - ido;
        int inc = 0;
        int idxt0 = (ip - 1) * idl1;
        int l2 = 1;
        while (l2 < ipph) {
            int lc = ip - l2;
            idxt1 = l2 * idl1;
            idxt2 = lc * idl1;
            idxt3 = (idl += ido) + iw1;
            w1r = this.wtable[idxt3 - 2];
            w1i = (double)isign * this.wtable[idxt3 - 1];
            ik = 0;
            while (ik < idl1) {
                int idx15 = in_off + ik;
                int idx24 = out_off + ik;
                in[idx15 + idxt1] = out[idx24] + w1r * out[idx24 + idl1];
                in[idx15 + idxt2] = w1i * out[idx24 + idxt0];
                ++ik;
            }
            int idlj = idl;
            inc += ido;
            int j2 = 2;
            while (j2 < ipph) {
                jc = ip - j2;
                if ((idlj += inc) > idp) {
                    idlj -= idp;
                }
                int idxt4 = idlj + iw1;
                double w2r = this.wtable[idxt4 - 2];
                double w2i = (double)isign * this.wtable[idxt4 - 1];
                int idxt5 = j2 * idl1;
                int idxt6 = jc * idl1;
                int ik2 = 0;
                while (ik2 < idl1) {
                    int idx16 = in_off + ik2;
                    int idx25 = out_off + ik2;
                    int n2 = idx16 + idxt1;
                    in[n2] = in[n2] + w2r * out[idx25 + idxt5];
                    int n3 = idx16 + idxt2;
                    in[n3] = in[n3] + w2i * out[idx25 + idxt6];
                    ++ik2;
                }
                ++j2;
            }
            ++l2;
        }
        int j3 = 1;
        while (j3 < ipph) {
            int idxt12 = j3 * idl1;
            int ik3 = 0;
            while (ik3 < idl1) {
                int idx17;
                int n4 = idx17 = out_off + ik3;
                out[n4] = out[n4] + out[idx17 + idxt12];
                ++ik3;
            }
            ++j3;
        }
        j3 = 1;
        while (j3 < ipph) {
            jc = ip - j3;
            idx12 = j3 * idl1;
            int idx26 = jc * idl1;
            ik = 1;
            while (ik < idl1) {
                idx3 = out_off + ik;
                int idx4 = in_off + ik;
                iidx1 = idx4 + idx12;
                int iidx2 = idx4 + idx26;
                double i1i = in[iidx1 - 1];
                i1r = in[iidx1];
                double i2i = in[iidx2 - 1];
                double i2r = in[iidx2];
                int oidx1 = idx3 + idx12;
                int oidx2 = idx3 + idx26;
                out[oidx1 - 1] = i1i - i2r;
                out[oidx2 - 1] = i1i + i2r;
                out[oidx1] = i1r + i2i;
                out[oidx2] = i1r - i2i;
                ik += 2;
            }
            ++j3;
        }
        nac[0] = 1;
        if (ido == 2) {
            return;
        }
        nac[0] = 0;
        System.arraycopy(out, out_off, in, in_off, idl1);
        int idx0 = l1 * ido;
        int j4 = 1;
        while (j4 < ip) {
            idx1 = j4 * idx0;
            k = 0;
            while (k < l1) {
                idx2 = k * ido;
                int oidx1 = out_off + idx2 + idx1;
                iidx1 = in_off + idx2 + idx1;
                in[iidx1] = out[oidx1];
                in[iidx1 + 1] = out[oidx1 + 1];
                ++k;
            }
            ++j4;
        }
        if (idot <= l1) {
            int idij = 0;
            j4 = 1;
            while (j4 < ip) {
                idij += 2;
                idx1 = j4 * l1 * ido;
                int i6 = 3;
                while (i6 < ido) {
                    idx2 = (idij += 2) + iw1 - 1;
                    w1r = this.wtable[idx2 - 1];
                    w1i = (double)isign * this.wtable[idx2];
                    int idx34 = in_off + i6;
                    int idx4 = out_off + i6;
                    int k6 = 0;
                    while (k6 < l1) {
                        int idx5 = k6 * ido + idx1;
                        int iidx12 = idx34 + idx5;
                        int oidx1 = idx4 + idx5;
                        double o1i = out[oidx1 - 1];
                        double o1r = out[oidx1];
                        in[iidx12 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx12] = w1r * o1r + w1i * o1i;
                        ++k6;
                    }
                    i6 += 2;
                }
                ++j4;
            }
        } else {
            int idj = 2 - ido;
            j4 = 1;
            while (j4 < ip) {
                idj += ido;
                idx1 = j4 * l1 * ido;
                k = 0;
                while (k < l1) {
                    int idij = idj;
                    idx3 = k * ido + idx1;
                    int i7 = 3;
                    while (i7 < ido) {
                        int idx27 = (idij += 2) - 1 + iw1;
                        w1r = this.wtable[idx27 - 1];
                        w1i = (double)isign * this.wtable[idx27];
                        int iidx13 = in_off + i7 + idx3;
                        int oidx1 = out_off + i7 + idx3;
                        double o1i = out[oidx1 - 1];
                        double o1r = out[oidx1];
                        in[iidx13 - 1] = w1r * o1i - w1i * o1r;
                        in[iidx13] = w1r * o1r + w1i * o1i;
                        i7 += 2;
                    }
                    ++k;
                }
                ++j4;
            }
        }
    }

    private void cftfsub(int n2, double[] a, int offa, int[] ip, int nw, double[] w) {
        if (n2 > 8) {
            if (n2 > 32) {
                this.cftf1st(n2, a, offa, w, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n2, a, offa, nw, w);
                } else if (n2 > 512) {
                    this.cftrec4(n2, a, offa, nw, w);
                } else if (n2 > 128) {
                    this.cftleaf(n2, 1, a, offa, nw, w);
                } else {
                    this.cftfx41(n2, a, offa, nw, w);
                }
                this.bitrv2(n2, ip, a, offa);
            } else if (n2 == 32) {
                this.cftf161(a, offa, w, nw - 8);
                this.bitrv216(a, offa);
            } else {
                this.cftf081(a, offa, w, 0);
                this.bitrv208(a, offa);
            }
        } else if (n2 == 8) {
            this.cftf040(a, offa);
        } else if (n2 == 4) {
            this.cftxb020(a, offa);
        }
    }

    private void cftbsub(int n2, double[] a, int offa, int[] ip, int nw, double[] w) {
        if (n2 > 8) {
            if (n2 > 32) {
                this.cftb1st(n2, a, offa, w, nw - (n2 >> 2));
                if (ConcurrencyUtils.getNumberOfThreads() > 1 && n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                    this.cftrec4_th(n2, a, offa, nw, w);
                } else if (n2 > 512) {
                    this.cftrec4(n2, a, offa, nw, w);
                } else if (n2 > 128) {
                    this.cftleaf(n2, 1, a, offa, nw, w);
                } else {
                    this.cftfx41(n2, a, offa, nw, w);
                }
                this.bitrv2conj(n2, ip, a, offa);
            } else if (n2 == 32) {
                this.cftf161(a, offa, w, nw - 8);
                this.bitrv216neg(a, offa);
            } else {
                this.cftf081(a, offa, w, 0);
                this.bitrv208neg(a, offa);
            }
        } else if (n2 == 8) {
            this.cftb040(a, offa);
        } else if (n2 == 4) {
            this.cftxb020(a, offa);
        }
    }

    private void bitrv2(int n2, int[] ip, double[] a, int offa) {
        int m2 = 1;
        int l2 = n2 >> 2;
        while (l2 > 8) {
            m2 <<= 1;
            l2 >>= 2;
        }
        int nh = n2 >> 1;
        int nm = 4 * m2;
        if (l2 == 8) {
            int k = 0;
            while (k < m2) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k;
                int j = 0;
                while (j < k) {
                    j1 = 4 * j + 2 * ip[m2 + k];
                    k1 = idx0 + 2 * ip[m2 + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    ++j;
                }
                k1 = idx0 + 2 * ip[m2 + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                ++k;
            }
        } else {
            int k = 0;
            while (k < m2) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k;
                int j = 0;
                while (j < k) {
                    j1 = 4 * j + ip[m2 + k];
                    k1 = idx0 + ip[m2 + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = a[idx1 + 1];
                    yr = a[idx2];
                    yi = a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    ++j;
                }
                k1 = idx0 + ip[m2 + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                xr = a[idx1];
                xi = a[idx1 + 1];
                yr = a[idx2];
                yi = a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                ++k;
            }
        }
    }

    private void bitrv2conj(int n2, int[] ip, double[] a, int offa) {
        int m2 = 1;
        int l2 = n2 >> 2;
        while (l2 > 8) {
            m2 <<= 1;
            l2 >>= 2;
        }
        int nh = n2 >> 1;
        int nm = 4 * m2;
        if (l2 == 8) {
            int k = 0;
            while (k < m2) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k;
                int j = 0;
                while (j < k) {
                    j1 = 4 * j + 2 * ip[m2 + k];
                    k1 = idx0 + 2 * ip[m2 + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= 2 * nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    ++j;
                }
                k1 = idx0 + 2 * ip[m2 + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += 2 * nm);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 -= nm);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= 2);
                idx2 = offa + (k1 -= nh);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 += nh + 2);
                idx2 = offa + (k1 += nh + 2);
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                idx1 = offa + (j1 -= nh - nm);
                idx2 = offa + (k1 += 2 * nm - 2);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
                ++k;
            }
        } else {
            int k = 0;
            while (k < m2) {
                double yi;
                double yr;
                double xi;
                double xr;
                int idx2;
                int idx1;
                int k1;
                int j1;
                int idx0 = 4 * k;
                int j = 0;
                while (j < k) {
                    j1 = 4 * j + ip[m2 + k];
                    k1 = idx0 + ip[m2 + j];
                    idx1 = offa + j1;
                    idx2 = offa + k1;
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nh);
                    idx2 = offa + (k1 += 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += 2);
                    idx2 = offa + (k1 += nh);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 += nm);
                    idx2 = offa + (k1 += nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nh);
                    idx2 = offa + (k1 -= 2);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    idx1 = offa + (j1 -= nm);
                    idx2 = offa + (k1 -= nm);
                    xr = a[idx1];
                    xi = -a[idx1 + 1];
                    yr = a[idx2];
                    yi = -a[idx2 + 1];
                    a[idx1] = yr;
                    a[idx1 + 1] = yi;
                    a[idx2] = xr;
                    a[idx2 + 1] = xi;
                    ++j;
                }
                k1 = idx0 + ip[m2 + k];
                j1 = k1 + 2;
                idx1 = offa + j1;
                idx2 = offa + (k1 += nh);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
                idx1 = offa + (j1 += nm);
                idx2 = offa + (k1 += nm);
                a[idx1 - 1] = -a[idx1 - 1];
                xr = a[idx1];
                xi = -a[idx1 + 1];
                yr = a[idx2];
                yi = -a[idx2 + 1];
                a[idx1] = yr;
                a[idx1 + 1] = yi;
                a[idx2] = xr;
                a[idx2 + 1] = xi;
                a[idx2 + 3] = -a[idx2 + 3];
                ++k;
            }
        }
    }

    private void bitrv216(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x2r = a[offa + 4];
        double x2i = a[offa + 5];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x5r = a[offa + 10];
        double x5i = a[offa + 11];
        double x7r = a[offa + 14];
        double x7i = a[offa + 15];
        double x8r = a[offa + 16];
        double x8i = a[offa + 17];
        double x10r = a[offa + 20];
        double x10i = a[offa + 21];
        double x11r = a[offa + 22];
        double x11i = a[offa + 23];
        double x12r = a[offa + 24];
        double x12i = a[offa + 25];
        double x13r = a[offa + 26];
        double x13i = a[offa + 27];
        double x14r = a[offa + 28];
        double x14i = a[offa + 29];
        a[offa + 2] = x8r;
        a[offa + 3] = x8i;
        a[offa + 4] = x4r;
        a[offa + 5] = x4i;
        a[offa + 6] = x12r;
        a[offa + 7] = x12i;
        a[offa + 8] = x2r;
        a[offa + 9] = x2i;
        a[offa + 10] = x10r;
        a[offa + 11] = x10i;
        a[offa + 14] = x14r;
        a[offa + 15] = x14i;
        a[offa + 16] = x1r;
        a[offa + 17] = x1i;
        a[offa + 20] = x5r;
        a[offa + 21] = x5i;
        a[offa + 22] = x13r;
        a[offa + 23] = x13i;
        a[offa + 24] = x3r;
        a[offa + 25] = x3i;
        a[offa + 26] = x11r;
        a[offa + 27] = x11i;
        a[offa + 28] = x7r;
        a[offa + 29] = x7i;
    }

    private void bitrv216neg(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x2r = a[offa + 4];
        double x2i = a[offa + 5];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x5r = a[offa + 10];
        double x5i = a[offa + 11];
        double x6r = a[offa + 12];
        double x6i = a[offa + 13];
        double x7r = a[offa + 14];
        double x7i = a[offa + 15];
        double x8r = a[offa + 16];
        double x8i = a[offa + 17];
        double x9r = a[offa + 18];
        double x9i = a[offa + 19];
        double x10r = a[offa + 20];
        double x10i = a[offa + 21];
        double x11r = a[offa + 22];
        double x11i = a[offa + 23];
        double x12r = a[offa + 24];
        double x12i = a[offa + 25];
        double x13r = a[offa + 26];
        double x13i = a[offa + 27];
        double x14r = a[offa + 28];
        double x14i = a[offa + 29];
        double x15r = a[offa + 30];
        double x15i = a[offa + 31];
        a[offa + 2] = x15r;
        a[offa + 3] = x15i;
        a[offa + 4] = x7r;
        a[offa + 5] = x7i;
        a[offa + 6] = x11r;
        a[offa + 7] = x11i;
        a[offa + 8] = x3r;
        a[offa + 9] = x3i;
        a[offa + 10] = x13r;
        a[offa + 11] = x13i;
        a[offa + 12] = x5r;
        a[offa + 13] = x5i;
        a[offa + 14] = x9r;
        a[offa + 15] = x9i;
        a[offa + 16] = x1r;
        a[offa + 17] = x1i;
        a[offa + 18] = x14r;
        a[offa + 19] = x14i;
        a[offa + 20] = x6r;
        a[offa + 21] = x6i;
        a[offa + 22] = x10r;
        a[offa + 23] = x10i;
        a[offa + 24] = x2r;
        a[offa + 25] = x2i;
        a[offa + 26] = x12r;
        a[offa + 27] = x12i;
        a[offa + 28] = x4r;
        a[offa + 29] = x4i;
        a[offa + 30] = x8r;
        a[offa + 31] = x8i;
    }

    private void bitrv208(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x6r = a[offa + 12];
        double x6i = a[offa + 13];
        a[offa + 2] = x4r;
        a[offa + 3] = x4i;
        a[offa + 6] = x6r;
        a[offa + 7] = x6i;
        a[offa + 8] = x1r;
        a[offa + 9] = x1i;
        a[offa + 12] = x3r;
        a[offa + 13] = x3i;
    }

    private void bitrv208neg(double[] a, int offa) {
        double x1r = a[offa + 2];
        double x1i = a[offa + 3];
        double x2r = a[offa + 4];
        double x2i = a[offa + 5];
        double x3r = a[offa + 6];
        double x3i = a[offa + 7];
        double x4r = a[offa + 8];
        double x4i = a[offa + 9];
        double x5r = a[offa + 10];
        double x5i = a[offa + 11];
        double x6r = a[offa + 12];
        double x6i = a[offa + 13];
        double x7r = a[offa + 14];
        double x7i = a[offa + 15];
        a[offa + 2] = x7r;
        a[offa + 3] = x7i;
        a[offa + 4] = x3r;
        a[offa + 5] = x3i;
        a[offa + 6] = x5r;
        a[offa + 7] = x5i;
        a[offa + 8] = x1r;
        a[offa + 9] = x1i;
        a[offa + 10] = x6r;
        a[offa + 11] = x6i;
        a[offa + 12] = x2r;
        a[offa + 13] = x2i;
        a[offa + 14] = x4r;
        a[offa + 15] = x4i;
    }

    private void cftf1st(int n2, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m2;
        int mh = n2 >> 3;
        int j1 = m2 = 2 * mh;
        int j2 = j1 + m2;
        int j3 = j2 + m2;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] + a[idx2];
        double x0i = a[offa + 1] + a[idx2 + 1];
        double x1r = a[offa] - a[idx2];
        double x1i = a[offa + 1] - a[idx2 + 1];
        double x2r = a[idx1] + a[idx3];
        double x2i = a[idx1 + 1] + a[idx3 + 1];
        double x3r = a[idx1] - a[idx3];
        double x3i = a[idx1 + 1] - a[idx3 + 1];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        a[idx2] = x1r - x3i;
        a[idx2 + 1] = x1i + x3r;
        a[idx3] = x1r + x3i;
        a[idx3 + 1] = x1i - x3r;
        double wn4r = w[startw + 1];
        double csc1 = w[startw + 2];
        double csc3 = w[startw + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k = 0;
        int j = 2;
        while (j < mh - 2) {
            int idx4 = startw + (k += 4);
            wk1r = csc1 * (wd1r + w[idx4]);
            wk1i = csc1 * (wd1i + w[idx4 + 1]);
            wk3r = csc3 * (wd3r + w[idx4 + 2]);
            wk3i = csc3 * (wd3i + w[idx4 + 3]);
            wd1r = w[idx4];
            wd1i = w[idx4 + 1];
            wd3r = w[idx4 + 2];
            wd3i = w[idx4 + 3];
            j1 = j + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j;
            x0r = a[idx5] + a[idx2];
            x0i = a[idx5 + 1] + a[idx2 + 1];
            x1r = a[idx5] - a[idx2];
            x1i = a[idx5 + 1] - a[idx2 + 1];
            double y0r = a[idx5 + 2] + a[idx2 + 2];
            double y0i = a[idx5 + 3] + a[idx2 + 3];
            double y1r = a[idx5 + 2] - a[idx2 + 2];
            double y1i = a[idx5 + 3] - a[idx2 + 3];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            double y2r = a[idx1 + 2] + a[idx3 + 2];
            double y2i = a[idx1 + 3] + a[idx3 + 3];
            double y3r = a[idx1 + 2] - a[idx3 + 2];
            double y3i = a[idx1 + 3] - a[idx3 + 3];
            a[idx5] = x0r + x2r;
            a[idx5 + 1] = x0i + x2i;
            a[idx5 + 2] = y0r + y2r;
            a[idx5 + 3] = y0i + y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            a[idx1 + 2] = y0r - y2r;
            a[idx1 + 3] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1r * x0r - wk1i * x0i;
            a[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3r * x0r + wk3i * x0i;
            a[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m2 - j;
            j1 = j0 + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] + a[idx2];
            x0i = a[idx0 + 1] + a[idx2 + 1];
            x1r = a[idx0] - a[idx2];
            x1i = a[idx0 + 1] - a[idx2 + 1];
            y0r = a[idx0 - 2] + a[idx2 - 2];
            y0i = a[idx0 - 1] + a[idx2 - 1];
            y1r = a[idx0 - 2] - a[idx2 - 2];
            y1i = a[idx0 - 1] - a[idx2 - 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            y2r = a[idx1 - 2] + a[idx3 - 2];
            y2i = a[idx1 - 1] + a[idx3 - 1];
            y3r = a[idx1 - 2] - a[idx3 - 2];
            y3i = a[idx1 - 1] - a[idx3 - 1];
            a[idx0] = x0r + x2r;
            a[idx0 + 1] = x0i + x2i;
            a[idx0 - 2] = y0r + y2r;
            a[idx0 - 1] = y0i + y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            a[idx1 - 2] = y0r - y2r;
            a[idx1 - 1] = y0i - y2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1i * x0r - wk1r * x0i;
            a[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r - y3i;
            x0i = y1i + y3r;
            a[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3i * x0r + wk3r * x0i;
            a[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r + y3i;
            x0i = y1i - y3r;
            a[offa + j3 - 2] = wd3i * x0r + wd3r * x0i;
            a[offa + j3 - 1] = wd3i * x0i - wd3r * x0r;
            j += 4;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m2;
        j2 = j1 + m2;
        j3 = j2 + m2;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0 - 2] + a[idx2 - 2];
        x0i = a[idx0 - 1] + a[idx2 - 1];
        x1r = a[idx0 - 2] - a[idx2 - 2];
        x1i = a[idx0 - 1] - a[idx2 - 1];
        x2r = a[idx1 - 2] + a[idx3 - 2];
        x2i = a[idx1 - 1] + a[idx3 - 1];
        x3r = a[idx1 - 2] - a[idx3 - 2];
        x3i = a[idx1 - 1] - a[idx3 - 1];
        a[idx0 - 2] = x0r + x2r;
        a[idx0 - 1] = x0i + x2i;
        a[idx1 - 2] = x0r - x2r;
        a[idx1 - 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a[idx0] + a[idx2];
        x0i = a[idx0 + 1] + a[idx2 + 1];
        x1r = a[idx0] - a[idx2];
        x1i = a[idx0 + 1] - a[idx2 + 1];
        x2r = a[idx1] + a[idx3];
        x2i = a[idx1 + 1] + a[idx3 + 1];
        x3r = a[idx1] - a[idx3];
        x3i = a[idx1 + 1] - a[idx3 + 1];
        a[idx0] = x0r + x2r;
        a[idx0 + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2] = wn4r * (x0r - x0i);
        a[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3] = -wn4r * (x0r + x0i);
        a[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a[idx0 + 2] + a[idx2 + 2];
        x0i = a[idx0 + 3] + a[idx2 + 3];
        x1r = a[idx0 + 2] - a[idx2 + 2];
        x1i = a[idx0 + 3] - a[idx2 + 3];
        x2r = a[idx1 + 2] + a[idx3 + 2];
        x2i = a[idx1 + 3] + a[idx3 + 3];
        x3r = a[idx1 + 2] - a[idx3 + 2];
        x3i = a[idx1 + 3] - a[idx3 + 3];
        a[idx0 + 2] = x0r + x2r;
        a[idx0 + 3] = x0i + x2i;
        a[idx1 + 2] = x0r - x2r;
        a[idx1 + 3] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    private void cftb1st(int n2, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        double wk3i;
        double wk3r;
        double wk1i;
        double wk1r;
        int m2;
        int mh = n2 >> 3;
        int j1 = m2 = 2 * mh;
        int j2 = j1 + m2;
        int j3 = j2 + m2;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] + a[idx2];
        double x0i = -a[offa + 1] - a[idx2 + 1];
        double x1r = a[offa] - a[idx2];
        double x1i = -a[offa + 1] + a[idx2 + 1];
        double x2r = a[idx1] + a[idx3];
        double x2i = a[idx1 + 1] + a[idx3 + 1];
        double x3r = a[idx1] - a[idx3];
        double x3i = a[idx1 + 1] - a[idx3 + 1];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i - x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i + x2i;
        a[idx2] = x1r + x3i;
        a[idx2 + 1] = x1i + x3r;
        a[idx3] = x1r - x3i;
        a[idx3 + 1] = x1i - x3r;
        double wn4r = w[startw + 1];
        double csc1 = w[startw + 2];
        double csc3 = w[startw + 3];
        double wd1r = 1.0;
        double wd1i = 0.0;
        double wd3r = 1.0;
        double wd3i = 0.0;
        int k = 0;
        int j = 2;
        while (j < mh - 2) {
            int idx4 = startw + (k += 4);
            wk1r = csc1 * (wd1r + w[idx4]);
            wk1i = csc1 * (wd1i + w[idx4 + 1]);
            wk3r = csc3 * (wd3r + w[idx4 + 2]);
            wk3i = csc3 * (wd3i + w[idx4 + 3]);
            wd1r = w[idx4];
            wd1i = w[idx4 + 1];
            wd3r = w[idx4 + 2];
            wd3i = w[idx4 + 3];
            j1 = j + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j;
            x0r = a[idx5] + a[idx2];
            x0i = -a[idx5 + 1] - a[idx2 + 1];
            x1r = a[idx5] - a[offa + j2];
            x1i = -a[idx5 + 1] + a[idx2 + 1];
            double y0r = a[idx5 + 2] + a[idx2 + 2];
            double y0i = -a[idx5 + 3] - a[idx2 + 3];
            double y1r = a[idx5 + 2] - a[idx2 + 2];
            double y1i = -a[idx5 + 3] + a[idx2 + 3];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            double y2r = a[idx1 + 2] + a[idx3 + 2];
            double y2i = a[idx1 + 3] + a[idx3 + 3];
            double y3r = a[idx1 + 2] - a[idx3 + 2];
            double y3i = a[idx1 + 3] - a[idx3 + 3];
            a[idx5] = x0r + x2r;
            a[idx5 + 1] = x0i - x2i;
            a[idx5 + 2] = y0r + y2r;
            a[idx5 + 3] = y0i - y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i + x2i;
            a[idx1 + 2] = y0r - y2r;
            a[idx1 + 3] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1r * x0r - wk1i * x0i;
            a[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a[idx2 + 2] = wd1r * x0r - wd1i * x0i;
            a[idx2 + 3] = wd1r * x0i + wd1i * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3r * x0r + wk3i * x0i;
            a[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a[idx3 + 2] = wd3r * x0r + wd3i * x0i;
            a[idx3 + 3] = wd3r * x0i - wd3i * x0r;
            j0 = m2 - j;
            j1 = j0 + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] + a[idx2];
            x0i = -a[idx0 + 1] - a[idx2 + 1];
            x1r = a[idx0] - a[idx2];
            x1i = -a[idx0 + 1] + a[idx2 + 1];
            y0r = a[idx0 - 2] + a[idx2 - 2];
            y0i = -a[idx0 - 1] - a[idx2 - 1];
            y1r = a[idx0 - 2] - a[idx2 - 2];
            y1i = -a[idx0 - 1] + a[idx2 - 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            y2r = a[idx1 - 2] + a[idx3 - 2];
            y2i = a[idx1 - 1] + a[idx3 - 1];
            y3r = a[idx1 - 2] - a[idx3 - 2];
            y3i = a[idx1 - 1] - a[idx3 - 1];
            a[idx0] = x0r + x2r;
            a[idx0 + 1] = x0i - x2i;
            a[idx0 - 2] = y0r + y2r;
            a[idx0 - 1] = y0i - y2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i + x2i;
            a[idx1 - 2] = y0r - y2r;
            a[idx1 - 1] = y0i + y2i;
            x0r = x1r + x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1i * x0r - wk1r * x0i;
            a[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = y1r + y3i;
            x0i = y1i + y3r;
            a[idx2 - 2] = wd1i * x0r - wd1r * x0i;
            a[idx2 - 1] = wd1i * x0i + wd1r * x0r;
            x0r = x1r - x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3i * x0r + wk3r * x0i;
            a[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            x0r = y1r - y3i;
            x0i = y1i - y3r;
            a[idx3 - 2] = wd3i * x0r + wd3r * x0i;
            a[idx3 - 1] = wd3i * x0i - wd3r * x0r;
            j += 4;
        }
        wk1r = csc1 * (wd1r + wn4r);
        wk1i = csc1 * (wd1i + wn4r);
        wk3r = csc3 * (wd3r - wn4r);
        wk3i = csc3 * (wd3i - wn4r);
        j0 = mh;
        j1 = j0 + m2;
        j2 = j1 + m2;
        j3 = j2 + m2;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0 - 2] + a[idx2 - 2];
        x0i = -a[idx0 - 1] - a[idx2 - 1];
        x1r = a[idx0 - 2] - a[idx2 - 2];
        x1i = -a[idx0 - 1] + a[idx2 - 1];
        x2r = a[idx1 - 2] + a[idx3 - 2];
        x2i = a[idx1 - 1] + a[idx3 - 1];
        x3r = a[idx1 - 2] - a[idx3 - 2];
        x3i = a[idx1 - 1] - a[idx3 - 1];
        a[idx0 - 2] = x0r + x2r;
        a[idx0 - 1] = x0i - x2i;
        a[idx1 - 2] = x0r - x2r;
        a[idx1 - 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[idx2 - 2] = wk1r * x0r - wk1i * x0i;
        a[idx2 - 1] = wk1r * x0i + wk1i * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[idx3 - 2] = wk3r * x0r + wk3i * x0i;
        a[idx3 - 1] = wk3r * x0i - wk3i * x0r;
        x0r = a[idx0] + a[idx2];
        x0i = -a[idx0 + 1] - a[idx2 + 1];
        x1r = a[idx0] - a[idx2];
        x1i = -a[idx0 + 1] + a[idx2 + 1];
        x2r = a[idx1] + a[idx3];
        x2i = a[idx1 + 1] + a[idx3 + 1];
        x3r = a[idx1] - a[idx3];
        x3i = a[idx1 + 1] - a[idx3 + 1];
        a[idx0] = x0r + x2r;
        a[idx0 + 1] = x0i - x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[idx2] = wn4r * (x0r - x0i);
        a[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[idx3] = -wn4r * (x0r + x0i);
        a[idx3 + 1] = -wn4r * (x0i - x0r);
        x0r = a[idx0 + 2] + a[idx2 + 2];
        x0i = -a[idx0 + 3] - a[idx2 + 3];
        x1r = a[idx0 + 2] - a[idx2 + 2];
        x1i = -a[idx0 + 3] + a[idx2 + 3];
        x2r = a[idx1 + 2] + a[idx3 + 2];
        x2i = a[idx1 + 3] + a[idx3 + 3];
        x3r = a[idx1 + 2] - a[idx3 + 2];
        x3i = a[idx1 + 3] - a[idx3 + 3];
        a[idx0 + 2] = x0r + x2r;
        a[idx0 + 3] = x0i - x2i;
        a[idx1 + 2] = x0r - x2r;
        a[idx1 + 3] = x0i + x2i;
        x0r = x1r + x3i;
        x0i = x1i + x3r;
        a[idx2 + 2] = wk1i * x0r - wk1r * x0i;
        a[idx2 + 3] = wk1i * x0i + wk1r * x0r;
        x0r = x1r - x3i;
        x0i = x1i - x3r;
        a[idx3 + 2] = wk3i * x0r + wk3r * x0i;
        a[idx3 + 3] = wk3i * x0i - wk3r * x0r;
    }

    private void cftrec4_th(final int n2, final double[] a, int offa, final int nw, final double[] w) {
        int idx = 0;
        int nthreads = 2;
        int idiv4 = 0;
        int m2 = n2 >> 1;
        if (n2 > ConcurrencyUtils.getThreadsBeginN_1D_FFT_4Threads()) {
            nthreads = 4;
            idiv4 = 1;
            m2 >>= 1;
        }
        Future[] futures = new Future[nthreads];
        final int mf = m2;
        int i2 = 0;
        while (i2 < nthreads) {
            final int firstIdx = offa + i2 * m2;
            futures[idx++] = i2 != idiv4 ? ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    int idx1 = firstIdx + mf;
                    int m2 = n2;
                    while (m2 > 512) {
                        DoubleFFT_1D.this.cftmdl1(m2 >>= 2, a, idx1 - m2, w, nw - (m2 >> 1));
                    }
                    DoubleFFT_1D.this.cftleaf(m2, 1, a, idx1 - m2, nw, w);
                    int k = 0;
                    int idx2 = firstIdx - m2;
                    int j = mf - m2;
                    while (j > 0) {
                        int isplt = DoubleFFT_1D.this.cfttree(m2, j, ++k, a, firstIdx, nw, w);
                        DoubleFFT_1D.this.cftleaf(m2, isplt, a, idx2 + j, nw, w);
                        j -= m2;
                    }
                }
            }) : ConcurrencyUtils.submit(new Runnable(){

                public void run() {
                    int idx1 = firstIdx + mf;
                    int k = 1;
                    int m2 = n2;
                    while (m2 > 512) {
                        k <<= 2;
                        DoubleFFT_1D.this.cftmdl2(m2 >>= 2, a, idx1 - m2, w, nw - m2);
                    }
                    DoubleFFT_1D.this.cftleaf(m2, 0, a, idx1 - m2, nw, w);
                    k >>= 1;
                    int idx2 = firstIdx - m2;
                    int j = mf - m2;
                    while (j > 0) {
                        int isplt = DoubleFFT_1D.this.cfttree(m2, j, ++k, a, firstIdx, nw, w);
                        DoubleFFT_1D.this.cftleaf(m2, isplt, a, idx2 + j, nw, w);
                        j -= m2;
                    }
                }
            });
            ++i2;
        }
        ConcurrencyUtils.waitForCompletion(futures);
    }

    private void cftrec4(int n2, double[] a, int offa, int nw, double[] w) {
        int m2 = n2;
        int idx1 = offa + n2;
        while (m2 > 512) {
            this.cftmdl1(m2 >>= 2, a, idx1 - m2, w, nw - (m2 >> 1));
        }
        this.cftleaf(m2, 1, a, idx1 - m2, nw, w);
        int k = 0;
        int idx2 = offa - m2;
        int j = n2 - m2;
        while (j > 0) {
            int isplt = this.cfttree(m2, j, ++k, a, offa, nw, w);
            this.cftleaf(m2, isplt, a, idx2 + j, nw, w);
            j -= m2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int cfttree(int n, int j, int k, double[] a, int offa, int nw, double[] w) {
        block6: {
            block5: {
                idx1 = offa - n;
                if ((k & 3) == 0) break block5;
                isplt = k & 1;
                if (isplt != 0) {
                    this.cftmdl1(n, a, idx1 + j, w, nw - (n >> 1));
                } else {
                    this.cftmdl2(n, a, idx1 + j, w, nw - n);
                }
                break block6;
            }
            m = n;
            i = k;
            while ((i & 3) == 0) {
                m <<= 2;
                i >>= 2;
            }
            isplt = i & 1;
            idx2 = offa + j;
            if (isplt == 0) ** GOTO lbl26
            while (m > 128) {
                this.cftmdl1(m, a, idx2 - m, w, nw - (m >> 1));
                m >>= 2;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                this.cftmdl2(m, a, idx2 - m, w, nw - m);
                m >>= 2;
lbl26:
                // 2 sources

                ** while (m > 128)
            }
        }
        return isplt;
    }

    private void cftleaf(int n2, int isplt, double[] a, int offa, int nw, double[] w) {
        if (n2 == 512) {
            this.cftmdl1(128, a, offa, w, nw - 64);
            this.cftf161(a, offa, w, nw - 8);
            this.cftf162(a, offa + 32, w, nw - 32);
            this.cftf161(a, offa + 64, w, nw - 8);
            this.cftf161(a, offa + 96, w, nw - 8);
            this.cftmdl2(128, a, offa + 128, w, nw - 128);
            this.cftf161(a, offa + 128, w, nw - 8);
            this.cftf162(a, offa + 160, w, nw - 32);
            this.cftf161(a, offa + 192, w, nw - 8);
            this.cftf162(a, offa + 224, w, nw - 32);
            this.cftmdl1(128, a, offa + 256, w, nw - 64);
            this.cftf161(a, offa + 256, w, nw - 8);
            this.cftf162(a, offa + 288, w, nw - 32);
            this.cftf161(a, offa + 320, w, nw - 8);
            this.cftf161(a, offa + 352, w, nw - 8);
            if (isplt != 0) {
                this.cftmdl1(128, a, offa + 384, w, nw - 64);
                this.cftf161(a, offa + 480, w, nw - 8);
            } else {
                this.cftmdl2(128, a, offa + 384, w, nw - 128);
                this.cftf162(a, offa + 480, w, nw - 32);
            }
            this.cftf161(a, offa + 384, w, nw - 8);
            this.cftf162(a, offa + 416, w, nw - 32);
            this.cftf161(a, offa + 448, w, nw - 8);
        } else {
            this.cftmdl1(64, a, offa, w, nw - 32);
            this.cftf081(a, offa, w, nw - 8);
            this.cftf082(a, offa + 16, w, nw - 8);
            this.cftf081(a, offa + 32, w, nw - 8);
            this.cftf081(a, offa + 48, w, nw - 8);
            this.cftmdl2(64, a, offa + 64, w, nw - 64);
            this.cftf081(a, offa + 64, w, nw - 8);
            this.cftf082(a, offa + 80, w, nw - 8);
            this.cftf081(a, offa + 96, w, nw - 8);
            this.cftf082(a, offa + 112, w, nw - 8);
            this.cftmdl1(64, a, offa + 128, w, nw - 32);
            this.cftf081(a, offa + 128, w, nw - 8);
            this.cftf082(a, offa + 144, w, nw - 8);
            this.cftf081(a, offa + 160, w, nw - 8);
            this.cftf081(a, offa + 176, w, nw - 8);
            if (isplt != 0) {
                this.cftmdl1(64, a, offa + 192, w, nw - 32);
                this.cftf081(a, offa + 240, w, nw - 8);
            } else {
                this.cftmdl2(64, a, offa + 192, w, nw - 64);
                this.cftf082(a, offa + 240, w, nw - 8);
            }
            this.cftf081(a, offa + 192, w, nw - 8);
            this.cftf082(a, offa + 208, w, nw - 8);
            this.cftf081(a, offa + 224, w, nw - 8);
        }
    }

    private void cftmdl1(int n2, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        int m2;
        int mh = n2 >> 3;
        int j1 = m2 = 2 * mh;
        int j2 = j1 + m2;
        int j3 = j2 + m2;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] + a[idx2];
        double x0i = a[offa + 1] + a[idx2 + 1];
        double x1r = a[offa] - a[idx2];
        double x1i = a[offa + 1] - a[idx2 + 1];
        double x2r = a[idx1] + a[idx3];
        double x2i = a[idx1 + 1] + a[idx3 + 1];
        double x3r = a[idx1] - a[idx3];
        double x3i = a[idx1 + 1] - a[idx3 + 1];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        a[idx2] = x1r - x3i;
        a[idx2 + 1] = x1i + x3r;
        a[idx3] = x1r + x3i;
        a[idx3 + 1] = x1i - x3r;
        double wn4r = w[startw + 1];
        int k = 0;
        int j = 2;
        while (j < mh) {
            int idx4 = startw + (k += 4);
            double wk1r = w[idx4];
            double wk1i = w[idx4 + 1];
            double wk3r = w[idx4 + 2];
            double wk3i = w[idx4 + 3];
            j1 = j + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx5 = offa + j;
            x0r = a[idx5] + a[idx2];
            x0i = a[idx5 + 1] + a[idx2 + 1];
            x1r = a[idx5] - a[idx2];
            x1i = a[idx5 + 1] - a[idx2 + 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            a[idx5] = x0r + x2r;
            a[idx5 + 1] = x0i + x2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1r * x0r - wk1i * x0i;
            a[idx2 + 1] = wk1r * x0i + wk1i * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3r * x0r + wk3i * x0i;
            a[idx3 + 1] = wk3r * x0i - wk3i * x0r;
            j0 = m2 - j;
            j1 = j0 + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] + a[idx2];
            x0i = a[idx0 + 1] + a[idx2 + 1];
            x1r = a[idx0] - a[idx2];
            x1i = a[idx0 + 1] - a[idx2 + 1];
            x2r = a[idx1] + a[idx3];
            x2i = a[idx1 + 1] + a[idx3 + 1];
            x3r = a[idx1] - a[idx3];
            x3i = a[idx1 + 1] - a[idx3 + 1];
            a[idx0] = x0r + x2r;
            a[idx0 + 1] = x0i + x2i;
            a[idx1] = x0r - x2r;
            a[idx1 + 1] = x0i - x2i;
            x0r = x1r - x3i;
            x0i = x1i + x3r;
            a[idx2] = wk1i * x0r - wk1r * x0i;
            a[idx2 + 1] = wk1i * x0i + wk1r * x0r;
            x0r = x1r + x3i;
            x0i = x1i - x3r;
            a[idx3] = wk3i * x0r + wk3r * x0i;
            a[idx3 + 1] = wk3i * x0i - wk3r * x0r;
            j += 2;
        }
        j0 = mh;
        j1 = j0 + m2;
        j2 = j1 + m2;
        j3 = j2 + m2;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0] + a[idx2];
        x0i = a[idx0 + 1] + a[idx2 + 1];
        x1r = a[idx0] - a[idx2];
        x1i = a[idx0 + 1] - a[idx2 + 1];
        x2r = a[idx1] + a[idx3];
        x2i = a[idx1 + 1] + a[idx3 + 1];
        x3r = a[idx1] - a[idx3];
        x3i = a[idx1 + 1] - a[idx3 + 1];
        a[idx0] = x0r + x2r;
        a[idx0 + 1] = x0i + x2i;
        a[idx1] = x0r - x2r;
        a[idx1 + 1] = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        a[idx2] = wn4r * (x0r - x0i);
        a[idx2 + 1] = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        a[idx3] = -wn4r * (x0r + x0i);
        a[idx3 + 1] = -wn4r * (x0i - x0r);
    }

    private void cftmdl2(int n2, double[] a, int offa, double[] w, int startw) {
        int idx0;
        int j0;
        double y2i;
        double y2r;
        double wk1i;
        double wk1r;
        int mh = n2 >> 3;
        int m2 = 2 * mh;
        double wn4r = w[startw + 1];
        int j1 = m2;
        int j2 = j1 + m2;
        int j3 = j2 + m2;
        int idx1 = offa + j1;
        int idx2 = offa + j2;
        int idx3 = offa + j3;
        double x0r = a[offa] - a[idx2 + 1];
        double x0i = a[offa + 1] + a[idx2];
        double x1r = a[offa] + a[idx2 + 1];
        double x1i = a[offa + 1] - a[idx2];
        double x2r = a[idx1] - a[idx3 + 1];
        double x2i = a[idx1 + 1] + a[idx3];
        double x3r = a[idx1] + a[idx3 + 1];
        double x3i = a[idx1 + 1] - a[idx3];
        double y0r = wn4r * (x2r - x2i);
        double y0i = wn4r * (x2i + x2r);
        a[offa] = x0r + y0r;
        a[offa + 1] = x0i + y0i;
        a[idx1] = x0r - y0r;
        a[idx1 + 1] = x0i - y0i;
        y0r = wn4r * (x3r - x3i);
        y0i = wn4r * (x3i + x3r);
        a[idx2] = x1r - y0i;
        a[idx2 + 1] = x1i + y0r;
        a[idx3] = x1r + y0i;
        a[idx3 + 1] = x1i - y0r;
        int k = 0;
        int kr = 2 * m2;
        int j = 2;
        while (j < mh) {
            int idx4 = startw + (k += 4);
            wk1r = w[idx4];
            wk1i = w[idx4 + 1];
            double wk3r = w[idx4 + 2];
            double wk3i = w[idx4 + 3];
            int idx5 = startw + (kr -= 4);
            double wd1i = w[idx5];
            double wd1r = w[idx5 + 1];
            double wd3i = w[idx5 + 2];
            double wd3r = w[idx5 + 3];
            j1 = j + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            int idx6 = offa + j;
            x0r = a[idx6] - a[idx2 + 1];
            x0i = a[idx6 + 1] + a[idx2];
            x1r = a[idx6] + a[idx2 + 1];
            x1i = a[idx6 + 1] - a[idx2];
            x2r = a[idx1] - a[idx3 + 1];
            x2i = a[idx1 + 1] + a[idx3];
            x3r = a[idx1] + a[idx3 + 1];
            x3i = a[idx1 + 1] - a[idx3];
            y0r = wk1r * x0r - wk1i * x0i;
            y0i = wk1r * x0i + wk1i * x0r;
            y2r = wd1r * x2r - wd1i * x2i;
            y2i = wd1r * x2i + wd1i * x2r;
            a[idx6] = y0r + y2r;
            a[idx6 + 1] = y0i + y2i;
            a[idx1] = y0r - y2r;
            a[idx1 + 1] = y0i - y2i;
            y0r = wk3r * x1r + wk3i * x1i;
            y0i = wk3r * x1i - wk3i * x1r;
            y2r = wd3r * x3r + wd3i * x3i;
            y2i = wd3r * x3i - wd3i * x3r;
            a[idx2] = y0r + y2r;
            a[idx2 + 1] = y0i + y2i;
            a[idx3] = y0r - y2r;
            a[idx3 + 1] = y0i - y2i;
            j0 = m2 - j;
            j1 = j0 + m2;
            j2 = j1 + m2;
            j3 = j2 + m2;
            idx0 = offa + j0;
            idx1 = offa + j1;
            idx2 = offa + j2;
            idx3 = offa + j3;
            x0r = a[idx0] - a[idx2 + 1];
            x0i = a[idx0 + 1] + a[idx2];
            x1r = a[idx0] + a[idx2 + 1];
            x1i = a[idx0 + 1] - a[idx2];
            x2r = a[idx1] - a[idx3 + 1];
            x2i = a[idx1 + 1] + a[idx3];
            x3r = a[idx1] + a[idx3 + 1];
            x3i = a[idx1 + 1] - a[idx3];
            y0r = wd1i * x0r - wd1r * x0i;
            y0i = wd1i * x0i + wd1r * x0r;
            y2r = wk1i * x2r - wk1r * x2i;
            y2i = wk1i * x2i + wk1r * x2r;
            a[idx0] = y0r + y2r;
            a[idx0 + 1] = y0i + y2i;
            a[idx1] = y0r - y2r;
            a[idx1 + 1] = y0i - y2i;
            y0r = wd3i * x1r + wd3r * x1i;
            y0i = wd3i * x1i - wd3r * x1r;
            y2r = wk3i * x3r + wk3r * x3i;
            y2i = wk3i * x3i - wk3r * x3r;
            a[idx2] = y0r + y2r;
            a[idx2 + 1] = y0i + y2i;
            a[idx3] = y0r - y2r;
            a[idx3 + 1] = y0i - y2i;
            j += 2;
        }
        wk1r = w[startw + m2];
        wk1i = w[startw + m2 + 1];
        j0 = mh;
        j1 = j0 + m2;
        j2 = j1 + m2;
        j3 = j2 + m2;
        idx0 = offa + j0;
        idx1 = offa + j1;
        idx2 = offa + j2;
        idx3 = offa + j3;
        x0r = a[idx0] - a[idx2 + 1];
        x0i = a[idx0 + 1] + a[idx2];
        x1r = a[idx0] + a[idx2 + 1];
        x1i = a[idx0 + 1] - a[idx2];
        x2r = a[idx1] - a[idx3 + 1];
        x2i = a[idx1 + 1] + a[idx3];
        x3r = a[idx1] + a[idx3 + 1];
        x3i = a[idx1 + 1] - a[idx3];
        y0r = wk1r * x0r - wk1i * x0i;
        y0i = wk1r * x0i + wk1i * x0r;
        y2r = wk1i * x2r - wk1r * x2i;
        y2i = wk1i * x2i + wk1r * x2r;
        a[idx0] = y0r + y2r;
        a[idx0 + 1] = y0i + y2i;
        a[idx1] = y0r - y2r;
        a[idx1 + 1] = y0i - y2i;
        y0r = wk1i * x1r - wk1r * x1i;
        y0i = wk1i * x1i + wk1r * x1r;
        y2r = wk1r * x3r - wk1i * x3i;
        y2i = wk1r * x3i + wk1i * x3r;
        a[idx2] = y0r - y2r;
        a[idx2 + 1] = y0i - y2i;
        a[idx3] = y0r + y2r;
        a[idx3 + 1] = y0i + y2i;
    }

    private void cftfx41(int n2, double[] a, int offa, int nw, double[] w) {
        if (n2 == 128) {
            this.cftf161(a, offa, w, nw - 8);
            this.cftf162(a, offa + 32, w, nw - 32);
            this.cftf161(a, offa + 64, w, nw - 8);
            this.cftf161(a, offa + 96, w, nw - 8);
        } else {
            this.cftf081(a, offa, w, nw - 8);
            this.cftf082(a, offa + 16, w, nw - 8);
            this.cftf081(a, offa + 32, w, nw - 8);
            this.cftf081(a, offa + 48, w, nw - 8);
        }
    }

    private void cftf161(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double wk1r = w[startw + 2];
        double wk1i = w[startw + 3];
        double x0r = a[offa] + a[offa + 16];
        double x0i = a[offa + 1] + a[offa + 17];
        double x1r = a[offa] - a[offa + 16];
        double x1i = a[offa + 1] - a[offa + 17];
        double x2r = a[offa + 8] + a[offa + 24];
        double x2i = a[offa + 9] + a[offa + 25];
        double x3r = a[offa + 8] - a[offa + 24];
        double x3i = a[offa + 9] - a[offa + 25];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y4r = x0r - x2r;
        double y4i = x0i - x2i;
        double y8r = x1r - x3i;
        double y8i = x1i + x3r;
        double y12r = x1r + x3i;
        double y12i = x1i - x3r;
        x0r = a[offa + 2] + a[offa + 18];
        x0i = a[offa + 3] + a[offa + 19];
        x1r = a[offa + 2] - a[offa + 18];
        x1i = a[offa + 3] - a[offa + 19];
        x2r = a[offa + 10] + a[offa + 26];
        x2i = a[offa + 11] + a[offa + 27];
        x3r = a[offa + 10] - a[offa + 26];
        x3i = a[offa + 11] - a[offa + 27];
        double y1r = x0r + x2r;
        double y1i = x0i + x2i;
        double y5r = x0r - x2r;
        double y5i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y9r = wk1r * x0r - wk1i * x0i;
        double y9i = wk1r * x0i + wk1i * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y13r = wk1i * x0r - wk1r * x0i;
        double y13i = wk1i * x0i + wk1r * x0r;
        x0r = a[offa + 4] + a[offa + 20];
        x0i = a[offa + 5] + a[offa + 21];
        x1r = a[offa + 4] - a[offa + 20];
        x1i = a[offa + 5] - a[offa + 21];
        x2r = a[offa + 12] + a[offa + 28];
        x2i = a[offa + 13] + a[offa + 29];
        x3r = a[offa + 12] - a[offa + 28];
        x3i = a[offa + 13] - a[offa + 29];
        double y2r = x0r + x2r;
        double y2i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y10r = wn4r * (x0r - x0i);
        double y10i = wn4r * (x0i + x0r);
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y14r = wn4r * (x0r + x0i);
        double y14i = wn4r * (x0i - x0r);
        x0r = a[offa + 6] + a[offa + 22];
        x0i = a[offa + 7] + a[offa + 23];
        x1r = a[offa + 6] - a[offa + 22];
        x1i = a[offa + 7] - a[offa + 23];
        x2r = a[offa + 14] + a[offa + 30];
        x2i = a[offa + 15] + a[offa + 31];
        x3r = a[offa + 14] - a[offa + 30];
        x3i = a[offa + 15] - a[offa + 31];
        double y3r = x0r + x2r;
        double y3i = x0i + x2i;
        double y7r = x0r - x2r;
        double y7i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        double y11r = wk1i * x0r - wk1r * x0i;
        double y11i = wk1i * x0i + wk1r * x0r;
        x0r = x1r + x3i;
        x0i = x1i - x3r;
        double y15r = wk1r * x0r - wk1i * x0i;
        double y15i = wk1r * x0i + wk1i * x0r;
        x0r = y12r - y14r;
        x0i = y12i - y14i;
        x1r = y12r + y14r;
        x1i = y12i + y14i;
        x2r = y13r - y15r;
        x2i = y13i - y15i;
        x3r = y13r + y15r;
        x3i = y13i + y15i;
        a[offa + 24] = x0r + x2r;
        a[offa + 25] = x0i + x2i;
        a[offa + 26] = x0r - x2r;
        a[offa + 27] = x0i - x2i;
        a[offa + 28] = x1r - x3i;
        a[offa + 29] = x1i + x3r;
        a[offa + 30] = x1r + x3i;
        a[offa + 31] = x1i - x3r;
        x0r = y8r + y10r;
        x0i = y8i + y10i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        x3r = y9r - y11r;
        x3i = y9i - y11i;
        a[offa + 16] = x0r + x2r;
        a[offa + 17] = x0i + x2i;
        a[offa + 18] = x0r - x2r;
        a[offa + 19] = x0i - x2i;
        a[offa + 20] = x1r - x3i;
        a[offa + 21] = x1i + x3r;
        a[offa + 22] = x1r + x3i;
        a[offa + 23] = x1i - x3r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x3r = wn4r * (x0r - x0i);
        x3i = wn4r * (x0i + x0r);
        x0r = y4r - y6i;
        x0i = y4i + y6r;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        a[offa + 8] = x0r + x2r;
        a[offa + 9] = x0i + x2i;
        a[offa + 10] = x0r - x2r;
        a[offa + 11] = x0i - x2i;
        a[offa + 12] = x1r - x3i;
        a[offa + 13] = x1i + x3r;
        a[offa + 14] = x1r + x3i;
        a[offa + 15] = x1i - x3r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        x3r = y1r - y3r;
        x3i = y1i - y3i;
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[offa + 2] = x0r - x2r;
        a[offa + 3] = x0i - x2i;
        a[offa + 4] = x1r - x3i;
        a[offa + 5] = x1i + x3r;
        a[offa + 6] = x1r + x3i;
        a[offa + 7] = x1i - x3r;
    }

    private void cftf162(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double wk1r = w[startw + 4];
        double wk1i = w[startw + 5];
        double wk3r = w[startw + 6];
        double wk3i = -w[startw + 7];
        double wk2r = w[startw + 8];
        double wk2i = w[startw + 9];
        double x1r = a[offa] - a[offa + 17];
        double x1i = a[offa + 1] + a[offa + 16];
        double x0r = a[offa + 8] - a[offa + 25];
        double x0i = a[offa + 9] + a[offa + 24];
        double x2r = wn4r * (x0r - x0i);
        double x2i = wn4r * (x0i + x0r);
        double y0r = x1r + x2r;
        double y0i = x1i + x2i;
        double y4r = x1r - x2r;
        double y4i = x1i - x2i;
        x1r = a[offa] + a[offa + 17];
        x1i = a[offa + 1] - a[offa + 16];
        x0r = a[offa + 8] + a[offa + 25];
        x0i = a[offa + 9] - a[offa + 24];
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        double y8r = x1r - x2i;
        double y8i = x1i + x2r;
        double y12r = x1r + x2i;
        double y12i = x1i - x2r;
        x0r = a[offa + 2] - a[offa + 19];
        x0i = a[offa + 3] + a[offa + 18];
        x1r = wk1r * x0r - wk1i * x0i;
        x1i = wk1r * x0i + wk1i * x0r;
        x0r = a[offa + 10] - a[offa + 27];
        x0i = a[offa + 11] + a[offa + 26];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y1r = x1r + x2r;
        double y1i = x1i + x2i;
        double y5r = x1r - x2r;
        double y5i = x1i - x2i;
        x0r = a[offa + 2] + a[offa + 19];
        x0i = a[offa + 3] - a[offa + 18];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a[offa + 10] + a[offa + 27];
        x0i = a[offa + 11] - a[offa + 26];
        x2r = wk1r * x0r + wk1i * x0i;
        x2i = wk1r * x0i - wk1i * x0r;
        double y9r = x1r - x2r;
        double y9i = x1i - x2i;
        double y13r = x1r + x2r;
        double y13i = x1i + x2i;
        x0r = a[offa + 4] - a[offa + 21];
        x0i = a[offa + 5] + a[offa + 20];
        x1r = wk2r * x0r - wk2i * x0i;
        x1i = wk2r * x0i + wk2i * x0r;
        x0r = a[offa + 12] - a[offa + 29];
        x0i = a[offa + 13] + a[offa + 28];
        x2r = wk2i * x0r - wk2r * x0i;
        x2i = wk2i * x0i + wk2r * x0r;
        double y2r = x1r + x2r;
        double y2i = x1i + x2i;
        double y6r = x1r - x2r;
        double y6i = x1i - x2i;
        x0r = a[offa + 4] + a[offa + 21];
        x0i = a[offa + 5] - a[offa + 20];
        x1r = wk2i * x0r - wk2r * x0i;
        x1i = wk2i * x0i + wk2r * x0r;
        x0r = a[offa + 12] + a[offa + 29];
        x0i = a[offa + 13] - a[offa + 28];
        x2r = wk2r * x0r - wk2i * x0i;
        x2i = wk2r * x0i + wk2i * x0r;
        double y10r = x1r - x2r;
        double y10i = x1i - x2i;
        double y14r = x1r + x2r;
        double y14i = x1i + x2i;
        x0r = a[offa + 6] - a[offa + 23];
        x0i = a[offa + 7] + a[offa + 22];
        x1r = wk3r * x0r - wk3i * x0i;
        x1i = wk3r * x0i + wk3i * x0r;
        x0r = a[offa + 14] - a[offa + 31];
        x0i = a[offa + 15] + a[offa + 30];
        x2r = wk1i * x0r - wk1r * x0i;
        x2i = wk1i * x0i + wk1r * x0r;
        double y3r = x1r + x2r;
        double y3i = x1i + x2i;
        double y7r = x1r - x2r;
        double y7i = x1i - x2i;
        x0r = a[offa + 6] + a[offa + 23];
        x0i = a[offa + 7] - a[offa + 22];
        x1r = wk1i * x0r + wk1r * x0i;
        x1i = wk1i * x0i - wk1r * x0r;
        x0r = a[offa + 14] + a[offa + 31];
        x0i = a[offa + 15] - a[offa + 30];
        x2r = wk3i * x0r - wk3r * x0i;
        x2i = wk3i * x0i + wk3r * x0r;
        double y11r = x1r + x2r;
        double y11i = x1i + x2i;
        double y15r = x1r - x2r;
        double y15i = x1i - x2i;
        x1r = y0r + y2r;
        x1i = y0i + y2i;
        x2r = y1r + y3r;
        x2i = y1i + y3i;
        a[offa] = x1r + x2r;
        a[offa + 1] = x1i + x2i;
        a[offa + 2] = x1r - x2r;
        a[offa + 3] = x1i - x2i;
        x1r = y0r - y2r;
        x1i = y0i - y2i;
        x2r = y1r - y3r;
        x2i = y1i - y3i;
        a[offa + 4] = x1r - x2i;
        a[offa + 5] = x1i + x2r;
        a[offa + 6] = x1r + x2i;
        a[offa + 7] = x1i - x2r;
        x1r = y4r - y6i;
        x1i = y4i + y6r;
        x0r = y5r - y7i;
        x0i = y5i + y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 8] = x1r + x2r;
        a[offa + 9] = x1i + x2i;
        a[offa + 10] = x1r - x2r;
        a[offa + 11] = x1i - x2i;
        x1r = y4r + y6i;
        x1i = y4i - y6r;
        x0r = y5r + y7i;
        x0i = y5i - y7r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 12] = x1r - x2i;
        a[offa + 13] = x1i + x2r;
        a[offa + 14] = x1r + x2i;
        a[offa + 15] = x1i - x2r;
        x1r = y8r + y10r;
        x1i = y8i + y10i;
        x2r = y9r - y11r;
        x2i = y9i - y11i;
        a[offa + 16] = x1r + x2r;
        a[offa + 17] = x1i + x2i;
        a[offa + 18] = x1r - x2r;
        a[offa + 19] = x1i - x2i;
        x1r = y8r - y10r;
        x1i = y8i - y10i;
        x2r = y9r + y11r;
        x2i = y9i + y11i;
        a[offa + 20] = x1r - x2i;
        a[offa + 21] = x1i + x2r;
        a[offa + 22] = x1r + x2i;
        a[offa + 23] = x1i - x2r;
        x1r = y12r - y14i;
        x1i = y12i + y14r;
        x0r = y13r + y15i;
        x0i = y13i - y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 24] = x1r + x2r;
        a[offa + 25] = x1i + x2i;
        a[offa + 26] = x1r - x2r;
        a[offa + 27] = x1i - x2i;
        x1r = y12r + y14i;
        x1i = y12i - y14r;
        x0r = y13r - y15i;
        x0i = y13i + y15r;
        x2r = wn4r * (x0r - x0i);
        x2i = wn4r * (x0i + x0r);
        a[offa + 28] = x1r - x2i;
        a[offa + 29] = x1i + x2r;
        a[offa + 30] = x1r + x2i;
        a[offa + 31] = x1i - x2r;
    }

    private void cftf081(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double x0r = a[offa] + a[offa + 8];
        double x0i = a[offa + 1] + a[offa + 9];
        double x1r = a[offa] - a[offa + 8];
        double x1i = a[offa + 1] - a[offa + 9];
        double x2r = a[offa + 4] + a[offa + 12];
        double x2i = a[offa + 5] + a[offa + 13];
        double x3r = a[offa + 4] - a[offa + 12];
        double x3i = a[offa + 5] - a[offa + 13];
        double y0r = x0r + x2r;
        double y0i = x0i + x2i;
        double y2r = x0r - x2r;
        double y2i = x0i - x2i;
        double y1r = x1r - x3i;
        double y1i = x1i + x3r;
        double y3r = x1r + x3i;
        double y3i = x1i - x3r;
        x0r = a[offa + 2] + a[offa + 10];
        x0i = a[offa + 3] + a[offa + 11];
        x1r = a[offa + 2] - a[offa + 10];
        x1i = a[offa + 3] - a[offa + 11];
        x2r = a[offa + 6] + a[offa + 14];
        x2i = a[offa + 7] + a[offa + 15];
        x3r = a[offa + 6] - a[offa + 14];
        x3i = a[offa + 7] - a[offa + 15];
        double y4r = x0r + x2r;
        double y4i = x0i + x2i;
        double y6r = x0r - x2r;
        double y6i = x0i - x2i;
        x0r = x1r - x3i;
        x0i = x1i + x3r;
        x2r = x1r + x3i;
        x2i = x1i - x3r;
        double y5r = wn4r * (x0r - x0i);
        double y5i = wn4r * (x0r + x0i);
        double y7r = wn4r * (x2r - x2i);
        double y7i = wn4r * (x2r + x2i);
        a[offa + 8] = y1r + y5r;
        a[offa + 9] = y1i + y5i;
        a[offa + 10] = y1r - y5r;
        a[offa + 11] = y1i - y5i;
        a[offa + 12] = y3r - y7i;
        a[offa + 13] = y3i + y7r;
        a[offa + 14] = y3r + y7i;
        a[offa + 15] = y3i - y7r;
        a[offa] = y0r + y4r;
        a[offa + 1] = y0i + y4i;
        a[offa + 2] = y0r - y4r;
        a[offa + 3] = y0i - y4i;
        a[offa + 4] = y2r - y6i;
        a[offa + 5] = y2i + y6r;
        a[offa + 6] = y2r + y6i;
        a[offa + 7] = y2i - y6r;
    }

    private void cftf082(double[] a, int offa, double[] w, int startw) {
        double wn4r = w[startw + 1];
        double wk1r = w[startw + 2];
        double wk1i = w[startw + 3];
        double y0r = a[offa] - a[offa + 9];
        double y0i = a[offa + 1] + a[offa + 8];
        double y1r = a[offa] + a[offa + 9];
        double y1i = a[offa + 1] - a[offa + 8];
        double x0r = a[offa + 4] - a[offa + 13];
        double x0i = a[offa + 5] + a[offa + 12];
        double y2r = wn4r * (x0r - x0i);
        double y2i = wn4r * (x0i + x0r);
        x0r = a[offa + 4] + a[offa + 13];
        x0i = a[offa + 5] - a[offa + 12];
        double y3r = wn4r * (x0r - x0i);
        double y3i = wn4r * (x0i + x0r);
        x0r = a[offa + 2] - a[offa + 11];
        x0i = a[offa + 3] + a[offa + 10];
        double y4r = wk1r * x0r - wk1i * x0i;
        double y4i = wk1r * x0i + wk1i * x0r;
        x0r = a[offa + 2] + a[offa + 11];
        x0i = a[offa + 3] - a[offa + 10];
        double y5r = wk1i * x0r - wk1r * x0i;
        double y5i = wk1i * x0i + wk1r * x0r;
        x0r = a[offa + 6] - a[offa + 15];
        x0i = a[offa + 7] + a[offa + 14];
        double y6r = wk1i * x0r - wk1r * x0i;
        double y6i = wk1i * x0i + wk1r * x0r;
        x0r = a[offa + 6] + a[offa + 15];
        x0i = a[offa + 7] - a[offa + 14];
        double y7r = wk1r * x0r - wk1i * x0i;
        double y7i = wk1r * x0i + wk1i * x0r;
        x0r = y0r + y2r;
        x0i = y0i + y2i;
        double x1r = y4r + y6r;
        double x1i = y4i + y6i;
        a[offa] = x0r + x1r;
        a[offa + 1] = x0i + x1i;
        a[offa + 2] = x0r - x1r;
        a[offa + 3] = x0i - x1i;
        x0r = y0r - y2r;
        x0i = y0i - y2i;
        x1r = y4r - y6r;
        x1i = y4i - y6i;
        a[offa + 4] = x0r - x1i;
        a[offa + 5] = x0i + x1r;
        a[offa + 6] = x0r + x1i;
        a[offa + 7] = x0i - x1r;
        x0r = y1r - y3i;
        x0i = y1i + y3r;
        x1r = y5r - y7r;
        x1i = y5i - y7i;
        a[offa + 8] = x0r + x1r;
        a[offa + 9] = x0i + x1i;
        a[offa + 10] = x0r - x1r;
        a[offa + 11] = x0i - x1i;
        x0r = y1r + y3i;
        x0i = y1i - y3r;
        x1r = y5r + y7r;
        x1i = y5i + y7i;
        a[offa + 12] = x0r - x1i;
        a[offa + 13] = x0i + x1r;
        a[offa + 14] = x0r + x1i;
        a[offa + 15] = x0i - x1r;
    }

    private void cftf040(double[] a, int offa) {
        double x0r = a[offa] + a[offa + 4];
        double x0i = a[offa + 1] + a[offa + 5];
        double x1r = a[offa] - a[offa + 4];
        double x1i = a[offa + 1] - a[offa + 5];
        double x2r = a[offa + 2] + a[offa + 6];
        double x2i = a[offa + 3] + a[offa + 7];
        double x3r = a[offa + 2] - a[offa + 6];
        double x3i = a[offa + 3] - a[offa + 7];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[offa + 2] = x1r - x3i;
        a[offa + 3] = x1i + x3r;
        a[offa + 4] = x0r - x2r;
        a[offa + 5] = x0i - x2i;
        a[offa + 6] = x1r + x3i;
        a[offa + 7] = x1i - x3r;
    }

    private void cftb040(double[] a, int offa) {
        double x0r = a[offa] + a[offa + 4];
        double x0i = a[offa + 1] + a[offa + 5];
        double x1r = a[offa] - a[offa + 4];
        double x1i = a[offa + 1] - a[offa + 5];
        double x2r = a[offa + 2] + a[offa + 6];
        double x2i = a[offa + 3] + a[offa + 7];
        double x3r = a[offa + 2] - a[offa + 6];
        double x3i = a[offa + 3] - a[offa + 7];
        a[offa] = x0r + x2r;
        a[offa + 1] = x0i + x2i;
        a[offa + 2] = x1r + x3i;
        a[offa + 3] = x1i - x3r;
        a[offa + 4] = x0r - x2r;
        a[offa + 5] = x0i - x2i;
        a[offa + 6] = x1r - x3i;
        a[offa + 7] = x1i + x3r;
    }

    private void cftx020(double[] a, int offa) {
        double x0r = a[offa] - a[offa + 2];
        double x0i = -a[offa + 1] + a[offa + 3];
        int n2 = offa;
        a[n2] = a[n2] + a[offa + 2];
        int n3 = offa + 1;
        a[n3] = a[n3] + a[offa + 3];
        a[offa + 2] = x0r;
        a[offa + 3] = x0i;
    }

    private void cftxb020(double[] a, int offa) {
        double x0r = a[offa] - a[offa + 2];
        double x0i = a[offa + 1] - a[offa + 3];
        int n2 = offa;
        a[n2] = a[n2] + a[offa + 2];
        int n3 = offa + 1;
        a[n3] = a[n3] + a[offa + 3];
        a[offa + 2] = x0r;
        a[offa + 3] = x0i;
    }

    private void cftxc020(double[] a, int offa) {
        double x0r = a[offa] - a[offa + 2];
        double x0i = a[offa + 1] + a[offa + 3];
        int n2 = offa;
        a[n2] = a[n2] + a[offa + 2];
        int n3 = offa + 1;
        a[n3] = a[n3] - a[offa + 3];
        a[offa + 2] = x0r;
        a[offa + 3] = x0i;
    }

    private void rftfsub(int n2, double[] a, int offa, int nc, double[] c, int startc) {
        int m2 = n2 >> 1;
        int ks = 2 * nc / m2;
        int kk = 0;
        int j = 2;
        while (j < m2) {
            int k = n2 - j;
            double wkr = 0.5 - c[startc + nc - (kk += ks)];
            double wki = c[startc + kk];
            int idx1 = offa + j;
            int idx2 = offa + k;
            double xr = a[idx1] - a[idx2];
            double xi = a[idx1 + 1] + a[idx2 + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a[n3] = a[n3] - yr;
            a[idx1 + 1] = yi - a[idx1 + 1];
            int n4 = idx2;
            a[n4] = a[n4] + yr;
            a[idx2 + 1] = yi - a[idx2 + 1];
            j += 2;
        }
        a[offa + m2 + 1] = -a[offa + m2 + 1];
    }

    private void rftbsub(int n2, double[] a, int offa, int nc, double[] c, int startc) {
        int m2 = n2 >> 1;
        int ks = 2 * nc / m2;
        int kk = 0;
        int j = 2;
        while (j < m2) {
            int k = n2 - j;
            double wkr = 0.5 - c[startc + nc - (kk += ks)];
            double wki = c[startc + kk];
            int idx1 = offa + j;
            int idx2 = offa + k;
            double xr = a[idx1] - a[idx2];
            double xi = a[idx1 + 1] + a[idx2 + 1];
            double yr = wkr * xr - wki * xi;
            double yi = wkr * xi + wki * xr;
            int n3 = idx1;
            a[n3] = a[n3] - yr;
            int n4 = idx1 + 1;
            a[n4] = a[n4] - yi;
            int n5 = idx2;
            a[n5] = a[n5] + yr;
            int n6 = idx2 + 1;
            a[n6] = a[n6] - yi;
            j += 2;
        }
    }

    private void scale(double m2, final double[] a, int offa, boolean complex) {
        final double norm2 = 1.0 / m2;
        int n2 = complex ? 2 * this.n : this.n;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D_FFT_2Threads()) {
            int k = n2 / nthreads;
            Future[] futures = new Future[nthreads];
            int i2 = 0;
            while (i2 < nthreads) {
                final int firstIdx = offa + i2 * k;
                final int lastIdx = i2 == nthreads - 1 ? offa + n2 : firstIdx + k;
                futures[i2] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int i2 = firstIdx;
                        while (i2 < lastIdx) {
                            int n2 = i2++;
                            a[n2] = a[n2] * norm2;
                        }
                    }
                });
                ++i2;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int i3 = offa;
            while (i3 < offa + n2) {
                int n3 = i3++;
                a[n3] = a[n3] * norm2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Plans {
        SPLIT_RADIX,
        MIXED_RADIX,
        BLUESTEIN;

    }
}

